/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.linkage.issues;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.issues.KotlinIrLinkerIssue;
import org.jetbrains.kotlin.backend.common.linkage.issues.KotlinIrLinkerIssuesKt;
import org.jetbrains.kotlin.backend.common.linkage.issues.UserVisibleIrModulesSupport;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IdSignatureRendererKt;
import org.jetbrains.kotlin.utils.ResolvedDependency;
import org.jetbrains.kotlin.utils.ResolvedDependencyId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/linkage/issues/SignatureIdNotFoundInModuleWithDependencies;", "Lorg/jetbrains/kotlin/backend/common/linkage/issues/KotlinIrLinkerIssue;", "idSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "problemModuleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "allModuleDeserializers", "", "userVisibleIrModulesSupport", "Lorg/jetbrains/kotlin/backend/common/linkage/issues/UserVisibleIrModulesSupport;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;Ljava/util/Collection;Lorg/jetbrains/kotlin/backend/common/linkage/issues/UserVisibleIrModulesSupport;)V", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "computeErrorMessage", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nKotlinIrLinkerIssues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinIrLinkerIssues.kt\norg/jetbrains/kotlin/backend/common/linkage/issues/SignatureIdNotFoundInModuleWithDependencies\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,629:1\n1#2:630\n*E\n"})
public final class SignatureIdNotFoundInModuleWithDependencies
extends KotlinIrLinkerIssue {
    @NotNull
    private final IdSignature idSignature;
    @NotNull
    private final IrModuleDeserializer problemModuleDeserializer;
    @NotNull
    private final Collection<IrModuleDeserializer> allModuleDeserializers;
    @NotNull
    private final UserVisibleIrModulesSupport userVisibleIrModulesSupport;
    @NotNull
    private final String errorMessage;

    /*
     * WARNING - void declaration
     */
    public SignatureIdNotFoundInModuleWithDependencies(@NotNull IdSignature idSignature, @NotNull IrModuleDeserializer problemModuleDeserializer, @NotNull Collection<? extends IrModuleDeserializer> allModuleDeserializers, @NotNull UserVisibleIrModulesSupport userVisibleIrModulesSupport) {
        String string;
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter(problemModuleDeserializer, "problemModuleDeserializer");
        Intrinsics.checkNotNullParameter(allModuleDeserializers, "allModuleDeserializers");
        Intrinsics.checkNotNullParameter(userVisibleIrModulesSupport, "userVisibleIrModulesSupport");
        this.idSignature = idSignature;
        this.problemModuleDeserializer = problemModuleDeserializer;
        this.allModuleDeserializers = allModuleDeserializers;
        this.userVisibleIrModulesSupport = userVisibleIrModulesSupport;
        SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies = this;
        try {
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies2 = signatureIdNotFoundInModuleWithDependencies;
            string = this.computeErrorMessage();
        }
        catch (Throwable throwable) {
            void $this$errorMessage_u24lambda_u240;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies3 = signatureIdNotFoundInModuleWithDependencies;
            boolean bl = false;
            $this$errorMessage_u24lambda_u240.append("Failed to compute the detailed error message. See the root cause exception.").append('\n');
            $this$errorMessage_u24lambda_u240.append('\n');
            $this$errorMessage_u24lambda_u240.append("Shortly: The required symbol " + IdSignatureRendererKt.render$default(this.idSignature, null, 1, null) + " is missing in the module or module dependencies.");
            $this$errorMessage_u24lambda_u240.append(" This could happen if the required dependency is missing in the project.");
            $this$errorMessage_u24lambda_u240.append(" Or if there is a dependency that has a different version (without the required symbol) in the project");
            $this$errorMessage_u24lambda_u240.append(" than the version (with the required symbol) that the module was initially compiled with.");
            SignatureIdNotFoundInModuleWithDependencies signatureIdNotFoundInModuleWithDependencies4 = signatureIdNotFoundInModuleWithDependencies3;
            String string2 = stringBuilder.toString();
            throw new RuntimeException(string2);
        }
        signatureIdNotFoundInModuleWithDependencies2.errorMessage = string;
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        return this.errorMessage;
    }

    private final String computeErrorMessage() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$computeErrorMessage_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        Map<ResolvedDependencyId, ResolvedDependency> allModules = this.userVisibleIrModulesSupport.getUserVisibleModules(this.allModuleDeserializers);
        ResolvedDependencyId problemModuleId = KotlinIrLinkerIssuesKt.access$getProblemModuleId(this.userVisibleIrModulesSupport, this.problemModuleDeserializer, allModules);
        String problemModuleIdWithVersion = MapsKt.getValue(allModules, problemModuleId).getModuleIdWithVersion();
        $this$computeErrorMessage_u24lambda_u240.append("Module \"" + problemModuleId + "\" has a reference to symbol " + IdSignatureRendererKt.render$default(this.idSignature, null, 1, null) + '.');
        $this$computeErrorMessage_u24lambda_u240.append(" Neither the module itself nor its dependencies contain such declaration.");
        IdSignature $this$computeErrorMessage_u24lambda_u240_u240 = this.idSignature;
        boolean bl2 = false;
        boolean fromCInteropLibrary = $this$computeErrorMessage_u24lambda_u240_u240.test(IdSignature.Flags.IS_NATIVE_INTEROP_LIBRARY);
        if (fromCInteropLibrary) {
            String packageFqName = this.idSignature.packageFqName().asString();
            String platformLibraryName = StringsKt.removePrefix(packageFqName, (CharSequence)"org.jetbrains.kotlin.native.platform.");
            if (!Intrinsics.areEqual(platformLibraryName, packageFqName)) {
                $this$computeErrorMessage_u24lambda_u240.append("\n\nThis looks like a Kotlin/Native " + platformLibraryName + " platform library issue. It could happen if");
                $this$computeErrorMessage_u24lambda_u240.append(" \"" + problemModuleId + "\" was compiled with a different version of the Kotlin/Native compiler");
                $this$computeErrorMessage_u24lambda_u240.append(" than the version currently used in the project.");
                $this$computeErrorMessage_u24lambda_u240.append(" Please check that the project configuration is correct and has consistent versions of all required dependencies.");
                stringBuilder = $this$computeErrorMessage_u24lambda_u240.append(" See https://youtrack.jetbrains.com/issue/KT-78063 for more details.");
            } else {
                $this$computeErrorMessage_u24lambda_u240.append("\n\nThis looks like a cinterop-generated library issue. It could happen if there is a transitive dependency");
                $this$computeErrorMessage_u24lambda_u240.append(" of \"" + problemModuleId + "\" which uses cinterop and the resulting libraries are not binary compatible.");
                $this$computeErrorMessage_u24lambda_u240.append(" Or there might be a cinterop dependency of \\\"" + problemModuleId + "\\\" generated by a different version of");
                $this$computeErrorMessage_u24lambda_u240.append(" the Kotlin/Native compiler than the version that \\\"" + problemModuleIdWithVersion + "\\\" was initially compiled with.");
                $this$computeErrorMessage_u24lambda_u240.append(" Please check that the project configuration is correct and has consistent versions of all required dependencies.");
                stringBuilder = $this$computeErrorMessage_u24lambda_u240.append(" See https://youtrack.jetbrains.com/issue/KT-78062 for more details.");
            }
        } else {
            $this$computeErrorMessage_u24lambda_u240.append("\n\nThis could happen if the required dependency is missing in the project.");
            $this$computeErrorMessage_u24lambda_u240.append(" Or if there is a dependency of \"" + problemModuleId + "\" that has a different version in the project");
            $this$computeErrorMessage_u24lambda_u240.append(" than the version that \"" + problemModuleIdWithVersion + "\" was initially compiled with.");
            stringBuilder = $this$computeErrorMessage_u24lambda_u240.append(" Please check that the project configuration is correct and has consistent versions of all required dependencies.");
        }
        KotlinIrLinkerIssuesKt.access$appendPotentiallyConflictingDependencies($this$computeErrorMessage_u24lambda_u240, "The list of \"" + problemModuleIdWithVersion + "\" dependencies that may lead to conflicts:", allModules, KotlinIrLinkerIssuesKt.access$findPotentiallyConflictingOutgoingDependencies(problemModuleId, allModules), this.userVisibleIrModulesSupport.getModuleIdComparator());
        KotlinIrLinkerIssuesKt.access$appendProjectDependencies($this$computeErrorMessage_u24lambda_u240, allModules, SetsKt.setOf(problemModuleId), "This module requires symbol " + IdSignatureRendererKt.render$default(this.idSignature, null, 1, null), this.userVisibleIrModulesSupport.getSourceCodeModuleId(), this.userVisibleIrModulesSupport.getModuleIdComparator());
        return stringBuilder2.toString();
    }
}

