// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`RenameObject`](crate::operation::rename_object::builders::RenameObjectFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name of the directory bucket containing the object.</p> <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_key):<br>required: **true**<br><p>Key name of the object to rename.</p><br>
    ///   - [`rename_source(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::rename_source) / [`set_rename_source(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_rename_source):<br>required: **true**<br><p>Specifies the source for the rename operation. The value must be URL encoded.</p><br>
    ///   - [`destination_if_match(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::destination_if_match) / [`set_destination_if_match(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_destination_if_match):<br>required: **false**<br><p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p> <p>Expects the ETag value as a string.</p><br>
    ///   - [`destination_if_none_match(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::destination_if_none_match) / [`set_destination_if_none_match(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_destination_if_none_match):<br>required: **false**<br><p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p> <p>Expects the <code>*</code> character (asterisk).</p><br>
    ///   - [`destination_if_modified_since(DateTime)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::destination_if_modified_since) / [`set_destination_if_modified_since(Option<DateTime>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_destination_if_modified_since):<br>required: **false**<br><p>Renames the object if the destination exists and if it has been modified since the specified time.</p><br>
    ///   - [`destination_if_unmodified_since(DateTime)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::destination_if_unmodified_since) / [`set_destination_if_unmodified_since(Option<DateTime>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_destination_if_unmodified_since):<br>required: **false**<br><p>Renames the object if it hasn't been modified since the specified time.</p><br>
    ///   - [`source_if_match(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::source_if_match) / [`set_source_if_match(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_source_if_match):<br>required: **false**<br><p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p><br>
    ///   - [`source_if_none_match(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::source_if_none_match) / [`set_source_if_none_match(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_source_if_none_match):<br>required: **false**<br><p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p><br>
    ///   - [`source_if_modified_since(DateTime)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::source_if_modified_since) / [`set_source_if_modified_since(Option<DateTime>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_source_if_modified_since):<br>required: **false**<br><p>Renames the object if the source exists and if it has been modified since the specified time.</p><br>
    ///   - [`source_if_unmodified_since(DateTime)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::source_if_unmodified_since) / [`set_source_if_unmodified_since(Option<DateTime>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_source_if_unmodified_since):<br>required: **false**<br><p>Renames the object if the source exists and hasn't been modified since the specified time.</p><br>
    ///   - [`client_token(impl Into<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::client_token) / [`set_client_token(Option<String>)`](crate::operation::rename_object::builders::RenameObjectFluentBuilder::set_client_token):<br>required: **false**<br><p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>  <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p> </note><br>
    /// - On success, responds with [`RenameObjectOutput`](crate::operation::rename_object::RenameObjectOutput)
    /// - On failure, responds with [`SdkError<RenameObjectError>`](crate::operation::rename_object::RenameObjectError)
    pub fn rename_object(&self) -> crate::operation::rename_object::builders::RenameObjectFluentBuilder {
        crate::operation::rename_object::builders::RenameObjectFluentBuilder::new(self.handle.clone())
    }
}
