// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/cognitoidentityprovider"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// An AdminCreateUser request for for a test user named John.
// This request submits a value for all possible parameters for AdminCreateUser.
func ExampleCognitoIdentityProvider_AdminCreateUser_shared00() {
	svc := cognitoidentityprovider.New(session.New())
	input := &cognitoidentityprovider.AdminCreateUserInput{
		DesiredDeliveryMediums: []*string{
			aws.String("SMS"),
		},
		MessageAction:     aws.String("SUPPRESS"),
		TemporaryPassword: aws.String("This-is-my-test-99!"),
		UserAttributes: []*cognitoidentityprovider.AttributeType{
			{
				Name:  aws.String("name"),
				Value: aws.String("John"),
			},
			{
				Name:  aws.String("phone_number"),
				Value: aws.String("+12065551212"),
			},
			{
				Name:  aws.String("email"),
				Value: aws.String("testuser@example.com"),
			},
		},
		UserPoolId: aws.String("us-east-1_EXAMPLE"),
		Username:   aws.String("testuser"),
	}

	result, err := svc.AdminCreateUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cognitoidentityprovider.ErrCodeResourceNotFoundException:
				fmt.Println(cognitoidentityprovider.ErrCodeResourceNotFoundException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidParameterException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidParameterException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUserNotFoundException:
				fmt.Println(cognitoidentityprovider.ErrCodeUserNotFoundException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUsernameExistsException:
				fmt.Println(cognitoidentityprovider.ErrCodeUsernameExistsException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidPasswordException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidPasswordException, aerr.Error())
			case cognitoidentityprovider.ErrCodeCodeDeliveryFailureException:
				fmt.Println(cognitoidentityprovider.ErrCodeCodeDeliveryFailureException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUnexpectedLambdaException:
				fmt.Println(cognitoidentityprovider.ErrCodeUnexpectedLambdaException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUserLambdaValidationException:
				fmt.Println(cognitoidentityprovider.ErrCodeUserLambdaValidationException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidLambdaResponseException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidLambdaResponseException, aerr.Error())
			case cognitoidentityprovider.ErrCodePreconditionNotMetException:
				fmt.Println(cognitoidentityprovider.ErrCodePreconditionNotMetException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidSmsRoleAccessPolicyException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidSmsRoleAccessPolicyException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidSmsRoleTrustRelationshipException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidSmsRoleTrustRelationshipException, aerr.Error())
			case cognitoidentityprovider.ErrCodeTooManyRequestsException:
				fmt.Println(cognitoidentityprovider.ErrCodeTooManyRequestsException, aerr.Error())
			case cognitoidentityprovider.ErrCodeNotAuthorizedException:
				fmt.Println(cognitoidentityprovider.ErrCodeNotAuthorizedException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUnsupportedUserStateException:
				fmt.Println(cognitoidentityprovider.ErrCodeUnsupportedUserStateException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInternalErrorException:
				fmt.Println(cognitoidentityprovider.ErrCodeInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example user pool with email and username sign-in
// The following example creates a user pool with all configurable properties set to
// an example value. The resulting user pool allows sign-in with username or email address,
// has optional MFA, and has a Lambda function assigned to each possible trigger.
func ExampleCognitoIdentityProvider_CreateUserPool_shared00() {
	svc := cognitoidentityprovider.New(session.New())
	input := &cognitoidentityprovider.CreateUserPoolInput{
		AccountRecoverySetting: &cognitoidentityprovider.AccountRecoverySettingType{
			RecoveryMechanisms: []*cognitoidentityprovider.RecoveryOptionType{
				{
					Name:     aws.String("verified_email"),
					Priority: aws.Int64(1),
				},
			},
		},
		AdminCreateUserConfig: &cognitoidentityprovider.AdminCreateUserConfigType{
			AllowAdminCreateUserOnly: aws.Bool(false),
			InviteMessageTemplate: &cognitoidentityprovider.MessageTemplateType{
				EmailMessage: aws.String("Your username is {username} and temporary password is {####}."),
				EmailSubject: aws.String("Your sign-in information"),
				SMSMessage:   aws.String("Your username is {username} and temporary password is {####}."),
			},
		},
		AliasAttributes: []*string{
			aws.String("email"),
		},
		AutoVerifiedAttributes: []*string{
			aws.String("email"),
		},
		DeletionProtection: aws.String("ACTIVE"),
		DeviceConfiguration: &cognitoidentityprovider.DeviceConfigurationType{
			ChallengeRequiredOnNewDevice:     aws.Bool(true),
			DeviceOnlyRememberedOnUserPrompt: aws.Bool(true),
		},
		EmailConfiguration: &cognitoidentityprovider.EmailConfigurationType{
			ConfigurationSet:    aws.String("my-test-ses-configuration-set"),
			EmailSendingAccount: aws.String("DEVELOPER"),
			From:                aws.String("support@example.com"),
			ReplyToEmailAddress: aws.String("support@example.com"),
			SourceArn:           aws.String("arn:aws:ses:us-east-1:123456789012:identity/support@example.com"),
		},
		EmailVerificationMessage: aws.String("Your verification code is {####}."),
		EmailVerificationSubject: aws.String("Verify your email address"),
		LambdaConfig: &cognitoidentityprovider.LambdaConfigType{
			CustomEmailSender: &cognitoidentityprovider.CustomEmailLambdaVersionConfigType{
				LambdaArn:     aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
				LambdaVersion: aws.String("V1_0"),
			},
			CustomMessage: aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			CustomSMSSender: &cognitoidentityprovider.CustomSMSLambdaVersionConfigType{
				LambdaArn:     aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
				LambdaVersion: aws.String("V1_0"),
			},
			DefineAuthChallenge:         aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			KMSKeyID:                    aws.String("arn:aws:kms:us-east-1:123456789012:key/a6c4f8e2-0c45-47db-925f-87854bc9e357"),
			PostAuthentication:          aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			PostConfirmation:            aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			PreAuthentication:           aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			PreSignUp:                   aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			PreTokenGeneration:          aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			UserMigration:               aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
			VerifyAuthChallengeResponse: aws.String("arn:aws:lambda:us-east-1:123456789012:function:MyFunction"),
		},
		MfaConfiguration: aws.String("OPTIONAL"),
		Policies: &cognitoidentityprovider.UserPoolPolicyType{
			PasswordPolicy: &cognitoidentityprovider.PasswordPolicyType{
				MinimumLength:                 aws.Int64(6),
				RequireLowercase:              aws.Bool(true),
				RequireNumbers:                aws.Bool(true),
				RequireSymbols:                aws.Bool(true),
				RequireUppercase:              aws.Bool(true),
				TemporaryPasswordValidityDays: aws.Int64(7),
			},
		},
		PoolName: aws.String("my-test-user-pool"),
		Schema: []*cognitoidentityprovider.SchemaAttributeType{
			{
				AttributeDataType:      aws.String("Number"),
				DeveloperOnlyAttribute: aws.Bool(true),
				Mutable:                aws.Bool(true),
				Name:                   aws.String("mydev"),
				NumberAttributeConstraints: &cognitoidentityprovider.NumberAttributeConstraintsType{
					MaxValue: aws.String("99"),
					MinValue: aws.String("1"),
				},
				Required: aws.Bool(false),
				StringAttributeConstraints: &cognitoidentityprovider.StringAttributeConstraintsType{
					MaxLength: aws.String("99"),
					MinLength: aws.String("1"),
				},
			},
		},
		SmsAuthenticationMessage: aws.String("Your verification code is {####}."),
		SmsConfiguration: &cognitoidentityprovider.SmsConfigurationType{
			ExternalId:   aws.String("my-role-external-id"),
			SnsCallerArn: aws.String("arn:aws:iam::123456789012:role/service-role/test-cognito-SMS-Role"),
		},
		SmsVerificationMessage: aws.String("Your verification code is {####}."),
		UserAttributeUpdateSettings: &cognitoidentityprovider.UserAttributeUpdateSettingsType{
			AttributesRequireVerificationBeforeUpdate: []*string{
				aws.String("email"),
			},
		},
		UserPoolAddOns: &cognitoidentityprovider.UserPoolAddOnsType{
			AdvancedSecurityMode: aws.String("OFF"),
		},
		UserPoolTags: map[string]*string{
			"my-test-tag-key": aws.String("my-test-tag-key"),
		},
		UsernameConfiguration: &cognitoidentityprovider.UsernameConfigurationType{
			CaseSensitive: aws.Bool(true),
		},
		VerificationMessageTemplate: &cognitoidentityprovider.VerificationMessageTemplateType{
			DefaultEmailOption: aws.String("CONFIRM_WITH_CODE"),
			EmailMessage:       aws.String("Your confirmation code is {####}"),
			EmailMessageByLink: aws.String("Choose this link to {##verify your email##}"),
			EmailSubject:       aws.String("Here is your confirmation code"),
			EmailSubjectByLink: aws.String("Here is your confirmation link"),
			SmsMessage:         aws.String("Your confirmation code is {####}"),
		},
	}

	result, err := svc.CreateUserPool(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cognitoidentityprovider.ErrCodeInvalidParameterException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidParameterException, aerr.Error())
			case cognitoidentityprovider.ErrCodeTooManyRequestsException:
				fmt.Println(cognitoidentityprovider.ErrCodeTooManyRequestsException, aerr.Error())
			case cognitoidentityprovider.ErrCodeLimitExceededException:
				fmt.Println(cognitoidentityprovider.ErrCodeLimitExceededException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidSmsRoleAccessPolicyException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidSmsRoleAccessPolicyException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidSmsRoleTrustRelationshipException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidSmsRoleTrustRelationshipException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidEmailRoleAccessPolicyException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidEmailRoleAccessPolicyException, aerr.Error())
			case cognitoidentityprovider.ErrCodeNotAuthorizedException:
				fmt.Println(cognitoidentityprovider.ErrCodeNotAuthorizedException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUserPoolTaggingException:
				fmt.Println(cognitoidentityprovider.ErrCodeUserPoolTaggingException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInternalErrorException:
				fmt.Println(cognitoidentityprovider.ErrCodeInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example user pool app client with email and username sign-in
// The following example creates an app client with all configurable properties set
// to an example value. The resulting user pool client connects to an analytics client,
// allows sign-in with username and password, and has two external identity providers
// associated with it.
func ExampleCognitoIdentityProvider_CreateUserPoolClient_shared00() {
	svc := cognitoidentityprovider.New(session.New())
	input := &cognitoidentityprovider.CreateUserPoolClientInput{
		AccessTokenValidity: aws.Int64(6),
		AllowedOAuthFlows: []*string{
			aws.String("code"),
		},
		AllowedOAuthFlowsUserPoolClient: aws.Bool(true),
		AllowedOAuthScopes: []*string{
			aws.String("aws.cognito.signin.user.admin"),
			aws.String("openid"),
		},
		AnalyticsConfiguration: &cognitoidentityprovider.AnalyticsConfigurationType{
			ApplicationId:  aws.String("d70b2ba36a8c4dc5a04a0451a31a1e12"),
			ExternalId:     aws.String("my-external-id"),
			RoleArn:        aws.String("arn:aws:iam::123456789012:role/test-cognitouserpool-role"),
			UserDataShared: aws.Bool(true),
		},
		CallbackURLs: []*string{
			aws.String("https://example.com"),
			aws.String("http://localhost"),
			aws.String("myapp://example"),
		},
		ClientName:         aws.String("my-test-app-client"),
		DefaultRedirectURI: aws.String("https://example.com"),
		ExplicitAuthFlows: []*string{
			aws.String("ALLOW_ADMIN_USER_PASSWORD_AUTH"),
			aws.String("ALLOW_USER_PASSWORD_AUTH"),
			aws.String("ALLOW_REFRESH_TOKEN_AUTH"),
		},
		GenerateSecret:  aws.Bool(true),
		IdTokenValidity: aws.Int64(6),
		LogoutURLs: []*string{
			aws.String("https://example.com/logout"),
		},
		PreventUserExistenceErrors: aws.String("ENABLED"),
		ReadAttributes: []*string{
			aws.String("email"),
			aws.String("address"),
			aws.String("preferred_username"),
		},
		RefreshTokenValidity: aws.Int64(6),
		SupportedIdentityProviders: []*string{
			aws.String("SignInWithApple"),
			aws.String("MySSO"),
		},
		TokenValidityUnits: &cognitoidentityprovider.TokenValidityUnitsType{
			AccessToken:  aws.String("hours"),
			IdToken:      aws.String("minutes"),
			RefreshToken: aws.String("days"),
		},
		UserPoolId: aws.String("us-east-1_EXAMPLE"),
		WriteAttributes: []*string{
			aws.String("family_name"),
			aws.String("email"),
		},
	}

	result, err := svc.CreateUserPoolClient(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cognitoidentityprovider.ErrCodeInvalidParameterException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidParameterException, aerr.Error())
			case cognitoidentityprovider.ErrCodeResourceNotFoundException:
				fmt.Println(cognitoidentityprovider.ErrCodeResourceNotFoundException, aerr.Error())
			case cognitoidentityprovider.ErrCodeTooManyRequestsException:
				fmt.Println(cognitoidentityprovider.ErrCodeTooManyRequestsException, aerr.Error())
			case cognitoidentityprovider.ErrCodeLimitExceededException:
				fmt.Println(cognitoidentityprovider.ErrCodeLimitExceededException, aerr.Error())
			case cognitoidentityprovider.ErrCodeNotAuthorizedException:
				fmt.Println(cognitoidentityprovider.ErrCodeNotAuthorizedException, aerr.Error())
			case cognitoidentityprovider.ErrCodeScopeDoesNotExistException:
				fmt.Println(cognitoidentityprovider.ErrCodeScopeDoesNotExistException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidOAuthFlowException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidOAuthFlowException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInternalErrorException:
				fmt.Println(cognitoidentityprovider.ErrCodeInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example username and password sign-in for a user who has TOTP MFA
// The following example signs in the user mytestuser with analytics data, client metadata,
// and user context data for advanced security.
func ExampleCognitoIdentityProvider_InitiateAuth_shared00() {
	svc := cognitoidentityprovider.New(session.New())
	input := &cognitoidentityprovider.InitiateAuthInput{
		AnalyticsMetadata: &cognitoidentityprovider.AnalyticsMetadataType{
			AnalyticsEndpointId: aws.String("d70b2ba36a8c4dc5a04a0451a31a1e12"),
		},
		AuthFlow: aws.String("USER_PASSWORD_AUTH"),
		AuthParameters: map[string]*string{
			"PASSWORD":    aws.String("This-is-my-test-99!"),
			"SECRET_HASH": aws.String("oT5ZkS8ctnrhYeeGsGTvOzPhoc/Jd1cO5fueBWFVmp8="),
			"USERNAME":    aws.String("mytestuser"),
		},
		ClientId: aws.String("1example23456789"),
		ClientMetadata: map[string]*string{
			"MyTestKey": aws.String("MyTestValue"),
		},
		UserContextData: &cognitoidentityprovider.UserContextDataType{
			EncodedData: aws.String("AmazonCognitoAdvancedSecurityData_object"),
			IpAddress:   aws.String("192.0.2.1"),
		},
	}

	result, err := svc.InitiateAuth(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cognitoidentityprovider.ErrCodeResourceNotFoundException:
				fmt.Println(cognitoidentityprovider.ErrCodeResourceNotFoundException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidParameterException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidParameterException, aerr.Error())
			case cognitoidentityprovider.ErrCodeNotAuthorizedException:
				fmt.Println(cognitoidentityprovider.ErrCodeNotAuthorizedException, aerr.Error())
			case cognitoidentityprovider.ErrCodeTooManyRequestsException:
				fmt.Println(cognitoidentityprovider.ErrCodeTooManyRequestsException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUnexpectedLambdaException:
				fmt.Println(cognitoidentityprovider.ErrCodeUnexpectedLambdaException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidUserPoolConfigurationException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidUserPoolConfigurationException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUserLambdaValidationException:
				fmt.Println(cognitoidentityprovider.ErrCodeUserLambdaValidationException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidLambdaResponseException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidLambdaResponseException, aerr.Error())
			case cognitoidentityprovider.ErrCodePasswordResetRequiredException:
				fmt.Println(cognitoidentityprovider.ErrCodePasswordResetRequiredException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUserNotFoundException:
				fmt.Println(cognitoidentityprovider.ErrCodeUserNotFoundException, aerr.Error())
			case cognitoidentityprovider.ErrCodeUserNotConfirmedException:
				fmt.Println(cognitoidentityprovider.ErrCodeUserNotConfirmedException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInternalErrorException:
				fmt.Println(cognitoidentityprovider.ErrCodeInternalErrorException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidSmsRoleAccessPolicyException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidSmsRoleAccessPolicyException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInvalidSmsRoleTrustRelationshipException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidSmsRoleTrustRelationshipException, aerr.Error())
			case cognitoidentityprovider.ErrCodeForbiddenException:
				fmt.Println(cognitoidentityprovider.ErrCodeForbiddenException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// A ListUsers request for the next 3 users whose email address starts with "testuser."
// This request submits a value for all possible parameters for ListUsers. By iterating
// the PaginationToken, you can page through and collect all users in a user pool.
func ExampleCognitoIdentityProvider_ListUsers_shared00() {
	svc := cognitoidentityprovider.New(session.New())
	input := &cognitoidentityprovider.ListUsersInput{
		AttributesToGet: []*string{
			aws.String("email"),
			aws.String("sub"),
		},
		Filter:          aws.String("\"email\"^=\"testuser\""),
		Limit:           aws.Int64(3),
		PaginationToken: aws.String("abcd1234EXAMPLE"),
		UserPoolId:      aws.String("us-east-1_EXAMPLE"),
	}

	result, err := svc.ListUsers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cognitoidentityprovider.ErrCodeInvalidParameterException:
				fmt.Println(cognitoidentityprovider.ErrCodeInvalidParameterException, aerr.Error())
			case cognitoidentityprovider.ErrCodeResourceNotFoundException:
				fmt.Println(cognitoidentityprovider.ErrCodeResourceNotFoundException, aerr.Error())
			case cognitoidentityprovider.ErrCodeTooManyRequestsException:
				fmt.Println(cognitoidentityprovider.ErrCodeTooManyRequestsException, aerr.Error())
			case cognitoidentityprovider.ErrCodeNotAuthorizedException:
				fmt.Println(cognitoidentityprovider.ErrCodeNotAuthorizedException, aerr.Error())
			case cognitoidentityprovider.ErrCodeInternalErrorException:
				fmt.Println(cognitoidentityprovider.ErrCodeInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
