// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateMember = "AssociateMember"

// AssociateMemberRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMember for more information on using the AssociateMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateMemberRequest method.
//	req, resp := client.AssociateMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember
func (c *Inspector2) AssociateMemberRequest(input *AssociateMemberInput) (req *request.Request, output *AssociateMemberOutput) {
	op := &request.Operation{
		Name:       opAssociateMember,
		HTTPMethod: "POST",
		HTTPPath:   "/members/associate",
	}

	if input == nil {
		input = &AssociateMemberInput{}
	}

	output = &AssociateMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateMember API operation for Inspector2.
//
// Associates an Amazon Web Services account with an Amazon Inspector delegated
// administrator. An HTTP 200 response indicates the association was successfully
// started, but doesn’t indicate whether it was completed. You can check if
// the association completed by using ListMembers (https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html)
// for multiple accounts or GetMembers (https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html)
// for a single account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation AssociateMember for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember
func (c *Inspector2) AssociateMember(input *AssociateMemberInput) (*AssociateMemberOutput, error) {
	req, out := c.AssociateMemberRequest(input)
	return out, req.Send()
}

// AssociateMemberWithContext is the same as AssociateMember with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) AssociateMemberWithContext(ctx aws.Context, input *AssociateMemberInput, opts ...request.Option) (*AssociateMemberOutput, error) {
	req, out := c.AssociateMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetAccountStatus = "BatchGetAccountStatus"

// BatchGetAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAccountStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAccountStatus for more information on using the BatchGetAccountStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetAccountStatusRequest method.
//	req, resp := client.BatchGetAccountStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus
func (c *Inspector2) BatchGetAccountStatusRequest(input *BatchGetAccountStatusInput) (req *request.Request, output *BatchGetAccountStatusOutput) {
	op := &request.Operation{
		Name:       opBatchGetAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/status/batch/get",
	}

	if input == nil {
		input = &BatchGetAccountStatusInput{}
	}

	output = &BatchGetAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetAccountStatus API operation for Inspector2.
//
// Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts
// within your environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation BatchGetAccountStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus
func (c *Inspector2) BatchGetAccountStatus(input *BatchGetAccountStatusInput) (*BatchGetAccountStatusOutput, error) {
	req, out := c.BatchGetAccountStatusRequest(input)
	return out, req.Send()
}

// BatchGetAccountStatusWithContext is the same as BatchGetAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) BatchGetAccountStatusWithContext(ctx aws.Context, input *BatchGetAccountStatusInput, opts ...request.Option) (*BatchGetAccountStatusOutput, error) {
	req, out := c.BatchGetAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetCodeSnippet = "BatchGetCodeSnippet"

// BatchGetCodeSnippetRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetCodeSnippet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetCodeSnippet for more information on using the BatchGetCodeSnippet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetCodeSnippetRequest method.
//	req, resp := client.BatchGetCodeSnippetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet
func (c *Inspector2) BatchGetCodeSnippetRequest(input *BatchGetCodeSnippetInput) (req *request.Request, output *BatchGetCodeSnippetOutput) {
	op := &request.Operation{
		Name:       opBatchGetCodeSnippet,
		HTTPMethod: "POST",
		HTTPPath:   "/codesnippet/batchget",
	}

	if input == nil {
		input = &BatchGetCodeSnippetInput{}
	}

	output = &BatchGetCodeSnippetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetCodeSnippet API operation for Inspector2.
//
// Retrieves code snippets from findings that Amazon Inspector detected code
// vulnerabilities in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation BatchGetCodeSnippet for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet
func (c *Inspector2) BatchGetCodeSnippet(input *BatchGetCodeSnippetInput) (*BatchGetCodeSnippetOutput, error) {
	req, out := c.BatchGetCodeSnippetRequest(input)
	return out, req.Send()
}

// BatchGetCodeSnippetWithContext is the same as BatchGetCodeSnippet with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetCodeSnippet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) BatchGetCodeSnippetWithContext(ctx aws.Context, input *BatchGetCodeSnippetInput, opts ...request.Option) (*BatchGetCodeSnippetOutput, error) {
	req, out := c.BatchGetCodeSnippetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetFindingDetails = "BatchGetFindingDetails"

// BatchGetFindingDetailsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetFindingDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetFindingDetails for more information on using the BatchGetFindingDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetFindingDetailsRequest method.
//	req, resp := client.BatchGetFindingDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails
func (c *Inspector2) BatchGetFindingDetailsRequest(input *BatchGetFindingDetailsInput) (req *request.Request, output *BatchGetFindingDetailsOutput) {
	op := &request.Operation{
		Name:       opBatchGetFindingDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/details/batch/get",
	}

	if input == nil {
		input = &BatchGetFindingDetailsInput{}
	}

	output = &BatchGetFindingDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetFindingDetails API operation for Inspector2.
//
// Gets vulnerability details for findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation BatchGetFindingDetails for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails
func (c *Inspector2) BatchGetFindingDetails(input *BatchGetFindingDetailsInput) (*BatchGetFindingDetailsOutput, error) {
	req, out := c.BatchGetFindingDetailsRequest(input)
	return out, req.Send()
}

// BatchGetFindingDetailsWithContext is the same as BatchGetFindingDetails with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetFindingDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) BatchGetFindingDetailsWithContext(ctx aws.Context, input *BatchGetFindingDetailsInput, opts ...request.Option) (*BatchGetFindingDetailsOutput, error) {
	req, out := c.BatchGetFindingDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetFreeTrialInfo = "BatchGetFreeTrialInfo"

// BatchGetFreeTrialInfoRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetFreeTrialInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetFreeTrialInfo for more information on using the BatchGetFreeTrialInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetFreeTrialInfoRequest method.
//	req, resp := client.BatchGetFreeTrialInfoRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo
func (c *Inspector2) BatchGetFreeTrialInfoRequest(input *BatchGetFreeTrialInfoInput) (req *request.Request, output *BatchGetFreeTrialInfoOutput) {
	op := &request.Operation{
		Name:       opBatchGetFreeTrialInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/freetrialinfo/batchget",
	}

	if input == nil {
		input = &BatchGetFreeTrialInfoInput{}
	}

	output = &BatchGetFreeTrialInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetFreeTrialInfo API operation for Inspector2.
//
// Gets free trial status for multiple Amazon Web Services accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation BatchGetFreeTrialInfo for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo
func (c *Inspector2) BatchGetFreeTrialInfo(input *BatchGetFreeTrialInfoInput) (*BatchGetFreeTrialInfoOutput, error) {
	req, out := c.BatchGetFreeTrialInfoRequest(input)
	return out, req.Send()
}

// BatchGetFreeTrialInfoWithContext is the same as BatchGetFreeTrialInfo with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetFreeTrialInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) BatchGetFreeTrialInfoWithContext(ctx aws.Context, input *BatchGetFreeTrialInfoInput, opts ...request.Option) (*BatchGetFreeTrialInfoOutput, error) {
	req, out := c.BatchGetFreeTrialInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetMemberEc2DeepInspectionStatus = "BatchGetMemberEc2DeepInspectionStatus"

// BatchGetMemberEc2DeepInspectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetMemberEc2DeepInspectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetMemberEc2DeepInspectionStatus for more information on using the BatchGetMemberEc2DeepInspectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetMemberEc2DeepInspectionStatusRequest method.
//	req, resp := client.BatchGetMemberEc2DeepInspectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus
func (c *Inspector2) BatchGetMemberEc2DeepInspectionStatusRequest(input *BatchGetMemberEc2DeepInspectionStatusInput) (req *request.Request, output *BatchGetMemberEc2DeepInspectionStatusOutput) {
	op := &request.Operation{
		Name:       opBatchGetMemberEc2DeepInspectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/ec2deepinspectionstatus/member/batch/get",
	}

	if input == nil {
		input = &BatchGetMemberEc2DeepInspectionStatusInput{}
	}

	output = &BatchGetMemberEc2DeepInspectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetMemberEc2DeepInspectionStatus API operation for Inspector2.
//
// Retrieves Amazon Inspector deep inspection activation status of multiple
// member accounts within your organization. You must be the delegated administrator
// of an organization in Amazon Inspector to use this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation BatchGetMemberEc2DeepInspectionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus
func (c *Inspector2) BatchGetMemberEc2DeepInspectionStatus(input *BatchGetMemberEc2DeepInspectionStatusInput) (*BatchGetMemberEc2DeepInspectionStatusOutput, error) {
	req, out := c.BatchGetMemberEc2DeepInspectionStatusRequest(input)
	return out, req.Send()
}

// BatchGetMemberEc2DeepInspectionStatusWithContext is the same as BatchGetMemberEc2DeepInspectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetMemberEc2DeepInspectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) BatchGetMemberEc2DeepInspectionStatusWithContext(ctx aws.Context, input *BatchGetMemberEc2DeepInspectionStatusInput, opts ...request.Option) (*BatchGetMemberEc2DeepInspectionStatusOutput, error) {
	req, out := c.BatchGetMemberEc2DeepInspectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateMemberEc2DeepInspectionStatus = "BatchUpdateMemberEc2DeepInspectionStatus"

// BatchUpdateMemberEc2DeepInspectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateMemberEc2DeepInspectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateMemberEc2DeepInspectionStatus for more information on using the BatchUpdateMemberEc2DeepInspectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateMemberEc2DeepInspectionStatusRequest method.
//	req, resp := client.BatchUpdateMemberEc2DeepInspectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus
func (c *Inspector2) BatchUpdateMemberEc2DeepInspectionStatusRequest(input *BatchUpdateMemberEc2DeepInspectionStatusInput) (req *request.Request, output *BatchUpdateMemberEc2DeepInspectionStatusOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateMemberEc2DeepInspectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/ec2deepinspectionstatus/member/batch/update",
	}

	if input == nil {
		input = &BatchUpdateMemberEc2DeepInspectionStatusInput{}
	}

	output = &BatchUpdateMemberEc2DeepInspectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateMemberEc2DeepInspectionStatus API operation for Inspector2.
//
// Activates or deactivates Amazon Inspector deep inspection for the provided
// member accounts in your organization. You must be the delegated administrator
// of an organization in Amazon Inspector to use this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation BatchUpdateMemberEc2DeepInspectionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus
func (c *Inspector2) BatchUpdateMemberEc2DeepInspectionStatus(input *BatchUpdateMemberEc2DeepInspectionStatusInput) (*BatchUpdateMemberEc2DeepInspectionStatusOutput, error) {
	req, out := c.BatchUpdateMemberEc2DeepInspectionStatusRequest(input)
	return out, req.Send()
}

// BatchUpdateMemberEc2DeepInspectionStatusWithContext is the same as BatchUpdateMemberEc2DeepInspectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateMemberEc2DeepInspectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) BatchUpdateMemberEc2DeepInspectionStatusWithContext(ctx aws.Context, input *BatchUpdateMemberEc2DeepInspectionStatusInput, opts ...request.Option) (*BatchUpdateMemberEc2DeepInspectionStatusOutput, error) {
	req, out := c.BatchUpdateMemberEc2DeepInspectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelFindingsReport = "CancelFindingsReport"

// CancelFindingsReportRequest generates a "aws/request.Request" representing the
// client's request for the CancelFindingsReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelFindingsReport for more information on using the CancelFindingsReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelFindingsReportRequest method.
//	req, resp := client.CancelFindingsReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport
func (c *Inspector2) CancelFindingsReportRequest(input *CancelFindingsReportInput) (req *request.Request, output *CancelFindingsReportOutput) {
	op := &request.Operation{
		Name:       opCancelFindingsReport,
		HTTPMethod: "POST",
		HTTPPath:   "/reporting/cancel",
	}

	if input == nil {
		input = &CancelFindingsReportInput{}
	}

	output = &CancelFindingsReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelFindingsReport API operation for Inspector2.
//
// Cancels the given findings report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation CancelFindingsReport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport
func (c *Inspector2) CancelFindingsReport(input *CancelFindingsReportInput) (*CancelFindingsReportOutput, error) {
	req, out := c.CancelFindingsReportRequest(input)
	return out, req.Send()
}

// CancelFindingsReportWithContext is the same as CancelFindingsReport with the addition of
// the ability to pass a context and additional request options.
//
// See CancelFindingsReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) CancelFindingsReportWithContext(ctx aws.Context, input *CancelFindingsReportInput, opts ...request.Option) (*CancelFindingsReportOutput, error) {
	req, out := c.CancelFindingsReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSbomExport = "CancelSbomExport"

// CancelSbomExportRequest generates a "aws/request.Request" representing the
// client's request for the CancelSbomExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSbomExport for more information on using the CancelSbomExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelSbomExportRequest method.
//	req, resp := client.CancelSbomExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport
func (c *Inspector2) CancelSbomExportRequest(input *CancelSbomExportInput) (req *request.Request, output *CancelSbomExportOutput) {
	op := &request.Operation{
		Name:       opCancelSbomExport,
		HTTPMethod: "POST",
		HTTPPath:   "/sbomexport/cancel",
	}

	if input == nil {
		input = &CancelSbomExportInput{}
	}

	output = &CancelSbomExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSbomExport API operation for Inspector2.
//
// Cancels a software bill of materials (SBOM) report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation CancelSbomExport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport
func (c *Inspector2) CancelSbomExport(input *CancelSbomExportInput) (*CancelSbomExportOutput, error) {
	req, out := c.CancelSbomExportRequest(input)
	return out, req.Send()
}

// CancelSbomExportWithContext is the same as CancelSbomExport with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSbomExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) CancelSbomExportWithContext(ctx aws.Context, input *CancelSbomExportInput, opts ...request.Option) (*CancelSbomExportOutput, error) {
	req, out := c.CancelSbomExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCisScanConfiguration = "CreateCisScanConfiguration"

// CreateCisScanConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateCisScanConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCisScanConfiguration for more information on using the CreateCisScanConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCisScanConfigurationRequest method.
//	req, resp := client.CreateCisScanConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCisScanConfiguration
func (c *Inspector2) CreateCisScanConfigurationRequest(input *CreateCisScanConfigurationInput) (req *request.Request, output *CreateCisScanConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateCisScanConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-configuration/create",
	}

	if input == nil {
		input = &CreateCisScanConfigurationInput{}
	}

	output = &CreateCisScanConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCisScanConfiguration API operation for Inspector2.
//
// Creates a CIS scan configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation CreateCisScanConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateCisScanConfiguration
func (c *Inspector2) CreateCisScanConfiguration(input *CreateCisScanConfigurationInput) (*CreateCisScanConfigurationOutput, error) {
	req, out := c.CreateCisScanConfigurationRequest(input)
	return out, req.Send()
}

// CreateCisScanConfigurationWithContext is the same as CreateCisScanConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCisScanConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) CreateCisScanConfigurationWithContext(ctx aws.Context, input *CreateCisScanConfigurationInput, opts ...request.Option) (*CreateCisScanConfigurationOutput, error) {
	req, out := c.CreateCisScanConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFilter = "CreateFilter"

// CreateFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFilter for more information on using the CreateFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFilterRequest method.
//	req, resp := client.CreateFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter
func (c *Inspector2) CreateFilterRequest(input *CreateFilterInput) (req *request.Request, output *CreateFilterOutput) {
	op := &request.Operation{
		Name:       opCreateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/filters/create",
	}

	if input == nil {
		input = &CreateFilterInput{}
	}

	output = &CreateFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFilter API operation for Inspector2.
//
// Creates a filter resource using specified filter criteria. When the filter
// action is set to SUPPRESS this action creates a suppression rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation CreateFilter for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota. To perform the requested action, remove
//     some of the relevant resources, or use Service Quotas to request a service
//     quota increase.
//
//   - BadRequestException
//     One or more tags submitted as part of the request is not valid.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter
func (c *Inspector2) CreateFilter(input *CreateFilterInput) (*CreateFilterOutput, error) {
	req, out := c.CreateFilterRequest(input)
	return out, req.Send()
}

// CreateFilterWithContext is the same as CreateFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) CreateFilterWithContext(ctx aws.Context, input *CreateFilterInput, opts ...request.Option) (*CreateFilterOutput, error) {
	req, out := c.CreateFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFindingsReport = "CreateFindingsReport"

// CreateFindingsReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateFindingsReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFindingsReport for more information on using the CreateFindingsReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFindingsReportRequest method.
//	req, resp := client.CreateFindingsReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport
func (c *Inspector2) CreateFindingsReportRequest(input *CreateFindingsReportInput) (req *request.Request, output *CreateFindingsReportOutput) {
	op := &request.Operation{
		Name:       opCreateFindingsReport,
		HTTPMethod: "POST",
		HTTPPath:   "/reporting/create",
	}

	if input == nil {
		input = &CreateFindingsReportInput{}
	}

	output = &CreateFindingsReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFindingsReport API operation for Inspector2.
//
// Creates a finding report. By default only ACTIVE findings are returned in
// the report. To see SUPRESSED or CLOSED findings you must specify a value
// for the findingStatus filter criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation CreateFindingsReport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport
func (c *Inspector2) CreateFindingsReport(input *CreateFindingsReportInput) (*CreateFindingsReportOutput, error) {
	req, out := c.CreateFindingsReportRequest(input)
	return out, req.Send()
}

// CreateFindingsReportWithContext is the same as CreateFindingsReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFindingsReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) CreateFindingsReportWithContext(ctx aws.Context, input *CreateFindingsReportInput, opts ...request.Option) (*CreateFindingsReportOutput, error) {
	req, out := c.CreateFindingsReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSbomExport = "CreateSbomExport"

// CreateSbomExportRequest generates a "aws/request.Request" representing the
// client's request for the CreateSbomExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSbomExport for more information on using the CreateSbomExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSbomExportRequest method.
//	req, resp := client.CreateSbomExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport
func (c *Inspector2) CreateSbomExportRequest(input *CreateSbomExportInput) (req *request.Request, output *CreateSbomExportOutput) {
	op := &request.Operation{
		Name:       opCreateSbomExport,
		HTTPMethod: "POST",
		HTTPPath:   "/sbomexport/create",
	}

	if input == nil {
		input = &CreateSbomExportInput{}
	}

	output = &CreateSbomExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSbomExport API operation for Inspector2.
//
// Creates a software bill of materials (SBOM) report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation CreateSbomExport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport
func (c *Inspector2) CreateSbomExport(input *CreateSbomExportInput) (*CreateSbomExportOutput, error) {
	req, out := c.CreateSbomExportRequest(input)
	return out, req.Send()
}

// CreateSbomExportWithContext is the same as CreateSbomExport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSbomExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) CreateSbomExportWithContext(ctx aws.Context, input *CreateSbomExportInput, opts ...request.Option) (*CreateSbomExportOutput, error) {
	req, out := c.CreateSbomExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCisScanConfiguration = "DeleteCisScanConfiguration"

// DeleteCisScanConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCisScanConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCisScanConfiguration for more information on using the DeleteCisScanConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCisScanConfigurationRequest method.
//	req, resp := client.DeleteCisScanConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCisScanConfiguration
func (c *Inspector2) DeleteCisScanConfigurationRequest(input *DeleteCisScanConfigurationInput) (req *request.Request, output *DeleteCisScanConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteCisScanConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-configuration/delete",
	}

	if input == nil {
		input = &DeleteCisScanConfigurationInput{}
	}

	output = &DeleteCisScanConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCisScanConfiguration API operation for Inspector2.
//
// Deletes a CIS scan configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation DeleteCisScanConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteCisScanConfiguration
func (c *Inspector2) DeleteCisScanConfiguration(input *DeleteCisScanConfigurationInput) (*DeleteCisScanConfigurationOutput, error) {
	req, out := c.DeleteCisScanConfigurationRequest(input)
	return out, req.Send()
}

// DeleteCisScanConfigurationWithContext is the same as DeleteCisScanConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCisScanConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) DeleteCisScanConfigurationWithContext(ctx aws.Context, input *DeleteCisScanConfigurationInput, opts ...request.Option) (*DeleteCisScanConfigurationOutput, error) {
	req, out := c.DeleteCisScanConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFilter = "DeleteFilter"

// DeleteFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFilter for more information on using the DeleteFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFilterRequest method.
//	req, resp := client.DeleteFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter
func (c *Inspector2) DeleteFilterRequest(input *DeleteFilterInput) (req *request.Request, output *DeleteFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/filters/delete",
	}

	if input == nil {
		input = &DeleteFilterInput{}
	}

	output = &DeleteFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFilter API operation for Inspector2.
//
// Deletes a filter resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation DeleteFilter for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter
func (c *Inspector2) DeleteFilter(input *DeleteFilterInput) (*DeleteFilterOutput, error) {
	req, out := c.DeleteFilterRequest(input)
	return out, req.Send()
}

// DeleteFilterWithContext is the same as DeleteFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) DeleteFilterWithContext(ctx aws.Context, input *DeleteFilterInput, opts ...request.Option) (*DeleteFilterOutput, error) {
	req, out := c.DeleteFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationConfigurationRequest method.
//	req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration
func (c *Inspector2) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/organizationconfiguration/describe",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for Inspector2.
//
// Describe Amazon Inspector configuration settings for an Amazon Web Services
// organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration
func (c *Inspector2) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisable = "Disable"

// DisableRequest generates a "aws/request.Request" representing the
// client's request for the Disable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Disable for more information on using the Disable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableRequest method.
//	req, resp := client.DisableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable
func (c *Inspector2) DisableRequest(input *DisableInput) (req *request.Request, output *DisableOutput) {
	op := &request.Operation{
		Name:       opDisable,
		HTTPMethod: "POST",
		HTTPPath:   "/disable",
	}

	if input == nil {
		input = &DisableInput{}
	}

	output = &DisableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Disable API operation for Inspector2.
//
// Disables Amazon Inspector scans for one or more Amazon Web Services accounts.
// Disabling all scan types in an account disables the Amazon Inspector service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation Disable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable
func (c *Inspector2) Disable(input *DisableInput) (*DisableOutput, error) {
	req, out := c.DisableRequest(input)
	return out, req.Send()
}

// DisableWithContext is the same as Disable with the addition of
// the ability to pass a context and additional request options.
//
// See Disable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) DisableWithContext(ctx aws.Context, input *DisableInput, opts ...request.Option) (*DisableOutput, error) {
	req, out := c.DisableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableDelegatedAdminAccount = "DisableDelegatedAdminAccount"

// DisableDelegatedAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableDelegatedAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableDelegatedAdminAccount for more information on using the DisableDelegatedAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableDelegatedAdminAccountRequest method.
//	req, resp := client.DisableDelegatedAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount
func (c *Inspector2) DisableDelegatedAdminAccountRequest(input *DisableDelegatedAdminAccountInput) (req *request.Request, output *DisableDelegatedAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableDelegatedAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/delegatedadminaccounts/disable",
	}

	if input == nil {
		input = &DisableDelegatedAdminAccountInput{}
	}

	output = &DisableDelegatedAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableDelegatedAdminAccount API operation for Inspector2.
//
// Disables the Amazon Inspector delegated administrator for your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation DisableDelegatedAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict occurred.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount
func (c *Inspector2) DisableDelegatedAdminAccount(input *DisableDelegatedAdminAccountInput) (*DisableDelegatedAdminAccountOutput, error) {
	req, out := c.DisableDelegatedAdminAccountRequest(input)
	return out, req.Send()
}

// DisableDelegatedAdminAccountWithContext is the same as DisableDelegatedAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableDelegatedAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) DisableDelegatedAdminAccountWithContext(ctx aws.Context, input *DisableDelegatedAdminAccountInput, opts ...request.Option) (*DisableDelegatedAdminAccountOutput, error) {
	req, out := c.DisableDelegatedAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMember = "DisassociateMember"

// DisassociateMemberRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMember for more information on using the DisassociateMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMemberRequest method.
//	req, resp := client.DisassociateMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember
func (c *Inspector2) DisassociateMemberRequest(input *DisassociateMemberInput) (req *request.Request, output *DisassociateMemberOutput) {
	op := &request.Operation{
		Name:       opDisassociateMember,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate",
	}

	if input == nil {
		input = &DisassociateMemberInput{}
	}

	output = &DisassociateMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateMember API operation for Inspector2.
//
// Disassociates a member account from an Amazon Inspector delegated administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation DisassociateMember for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember
func (c *Inspector2) DisassociateMember(input *DisassociateMemberInput) (*DisassociateMemberOutput, error) {
	req, out := c.DisassociateMemberRequest(input)
	return out, req.Send()
}

// DisassociateMemberWithContext is the same as DisassociateMember with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) DisassociateMemberWithContext(ctx aws.Context, input *DisassociateMemberInput, opts ...request.Option) (*DisassociateMemberOutput, error) {
	req, out := c.DisassociateMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnable = "Enable"

// EnableRequest generates a "aws/request.Request" representing the
// client's request for the Enable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Enable for more information on using the Enable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableRequest method.
//	req, resp := client.EnableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable
func (c *Inspector2) EnableRequest(input *EnableInput) (req *request.Request, output *EnableOutput) {
	op := &request.Operation{
		Name:       opEnable,
		HTTPMethod: "POST",
		HTTPPath:   "/enable",
	}

	if input == nil {
		input = &EnableInput{}
	}

	output = &EnableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Enable API operation for Inspector2.
//
// Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation Enable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable
func (c *Inspector2) Enable(input *EnableInput) (*EnableOutput, error) {
	req, out := c.EnableRequest(input)
	return out, req.Send()
}

// EnableWithContext is the same as Enable with the addition of
// the ability to pass a context and additional request options.
//
// See Enable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) EnableWithContext(ctx aws.Context, input *EnableInput, opts ...request.Option) (*EnableOutput, error) {
	req, out := c.EnableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableDelegatedAdminAccount = "EnableDelegatedAdminAccount"

// EnableDelegatedAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableDelegatedAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableDelegatedAdminAccount for more information on using the EnableDelegatedAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableDelegatedAdminAccountRequest method.
//	req, resp := client.EnableDelegatedAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount
func (c *Inspector2) EnableDelegatedAdminAccountRequest(input *EnableDelegatedAdminAccountInput) (req *request.Request, output *EnableDelegatedAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableDelegatedAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/delegatedadminaccounts/enable",
	}

	if input == nil {
		input = &EnableDelegatedAdminAccountInput{}
	}

	output = &EnableDelegatedAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableDelegatedAdminAccount API operation for Inspector2.
//
// Enables the Amazon Inspector delegated administrator for your Organizations
// organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation EnableDelegatedAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict occurred.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount
func (c *Inspector2) EnableDelegatedAdminAccount(input *EnableDelegatedAdminAccountInput) (*EnableDelegatedAdminAccountOutput, error) {
	req, out := c.EnableDelegatedAdminAccountRequest(input)
	return out, req.Send()
}

// EnableDelegatedAdminAccountWithContext is the same as EnableDelegatedAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableDelegatedAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) EnableDelegatedAdminAccountWithContext(ctx aws.Context, input *EnableDelegatedAdminAccountInput, opts ...request.Option) (*EnableDelegatedAdminAccountOutput, error) {
	req, out := c.EnableDelegatedAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCisScanReport = "GetCisScanReport"

// GetCisScanReportRequest generates a "aws/request.Request" representing the
// client's request for the GetCisScanReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCisScanReport for more information on using the GetCisScanReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCisScanReportRequest method.
//	req, resp := client.GetCisScanReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanReport
func (c *Inspector2) GetCisScanReportRequest(input *GetCisScanReportInput) (req *request.Request, output *GetCisScanReportOutput) {
	op := &request.Operation{
		Name:       opGetCisScanReport,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan/report/get",
	}

	if input == nil {
		input = &GetCisScanReportInput{}
	}

	output = &GetCisScanReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCisScanReport API operation for Inspector2.
//
// Retrieves a CIS scan report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetCisScanReport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanReport
func (c *Inspector2) GetCisScanReport(input *GetCisScanReportInput) (*GetCisScanReportOutput, error) {
	req, out := c.GetCisScanReportRequest(input)
	return out, req.Send()
}

// GetCisScanReportWithContext is the same as GetCisScanReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetCisScanReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetCisScanReportWithContext(ctx aws.Context, input *GetCisScanReportInput, opts ...request.Option) (*GetCisScanReportOutput, error) {
	req, out := c.GetCisScanReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCisScanResultDetails = "GetCisScanResultDetails"

// GetCisScanResultDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetCisScanResultDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCisScanResultDetails for more information on using the GetCisScanResultDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCisScanResultDetailsRequest method.
//	req, resp := client.GetCisScanResultDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails
func (c *Inspector2) GetCisScanResultDetailsRequest(input *GetCisScanResultDetailsInput) (req *request.Request, output *GetCisScanResultDetailsOutput) {
	op := &request.Operation{
		Name:       opGetCisScanResultDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-result/details/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCisScanResultDetailsInput{}
	}

	output = &GetCisScanResultDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCisScanResultDetails API operation for Inspector2.
//
// Retrieves CIS scan result details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetCisScanResultDetails for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetCisScanResultDetails
func (c *Inspector2) GetCisScanResultDetails(input *GetCisScanResultDetailsInput) (*GetCisScanResultDetailsOutput, error) {
	req, out := c.GetCisScanResultDetailsRequest(input)
	return out, req.Send()
}

// GetCisScanResultDetailsWithContext is the same as GetCisScanResultDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetCisScanResultDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetCisScanResultDetailsWithContext(ctx aws.Context, input *GetCisScanResultDetailsInput, opts ...request.Option) (*GetCisScanResultDetailsOutput, error) {
	req, out := c.GetCisScanResultDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCisScanResultDetailsPages iterates over the pages of a GetCisScanResultDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCisScanResultDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetCisScanResultDetails operation.
//	pageNum := 0
//	err := client.GetCisScanResultDetailsPages(params,
//	    func(page *inspector2.GetCisScanResultDetailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) GetCisScanResultDetailsPages(input *GetCisScanResultDetailsInput, fn func(*GetCisScanResultDetailsOutput, bool) bool) error {
	return c.GetCisScanResultDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCisScanResultDetailsPagesWithContext same as GetCisScanResultDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetCisScanResultDetailsPagesWithContext(ctx aws.Context, input *GetCisScanResultDetailsInput, fn func(*GetCisScanResultDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCisScanResultDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCisScanResultDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCisScanResultDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetConfiguration = "GetConfiguration"

// GetConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguration for more information on using the GetConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfigurationRequest method.
//	req, resp := client.GetConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration
func (c *Inspector2) GetConfigurationRequest(input *GetConfigurationInput) (req *request.Request, output *GetConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/configuration/get",
	}

	if input == nil {
		input = &GetConfigurationInput{}
	}

	output = &GetConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguration API operation for Inspector2.
//
// Retrieves setting configurations for Inspector scans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration
func (c *Inspector2) GetConfiguration(input *GetConfigurationInput) (*GetConfigurationOutput, error) {
	req, out := c.GetConfigurationRequest(input)
	return out, req.Send()
}

// GetConfigurationWithContext is the same as GetConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetConfigurationWithContext(ctx aws.Context, input *GetConfigurationInput, opts ...request.Option) (*GetConfigurationOutput, error) {
	req, out := c.GetConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDelegatedAdminAccount = "GetDelegatedAdminAccount"

// GetDelegatedAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetDelegatedAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDelegatedAdminAccount for more information on using the GetDelegatedAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDelegatedAdminAccountRequest method.
//	req, resp := client.GetDelegatedAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount
func (c *Inspector2) GetDelegatedAdminAccountRequest(input *GetDelegatedAdminAccountInput) (req *request.Request, output *GetDelegatedAdminAccountOutput) {
	op := &request.Operation{
		Name:       opGetDelegatedAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/delegatedadminaccounts/get",
	}

	if input == nil {
		input = &GetDelegatedAdminAccountInput{}
	}

	output = &GetDelegatedAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDelegatedAdminAccount API operation for Inspector2.
//
// Retrieves information about the Amazon Inspector delegated administrator
// for your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetDelegatedAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount
func (c *Inspector2) GetDelegatedAdminAccount(input *GetDelegatedAdminAccountInput) (*GetDelegatedAdminAccountOutput, error) {
	req, out := c.GetDelegatedAdminAccountRequest(input)
	return out, req.Send()
}

// GetDelegatedAdminAccountWithContext is the same as GetDelegatedAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetDelegatedAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetDelegatedAdminAccountWithContext(ctx aws.Context, input *GetDelegatedAdminAccountInput, opts ...request.Option) (*GetDelegatedAdminAccountOutput, error) {
	req, out := c.GetDelegatedAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEc2DeepInspectionConfiguration = "GetEc2DeepInspectionConfiguration"

// GetEc2DeepInspectionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetEc2DeepInspectionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEc2DeepInspectionConfiguration for more information on using the GetEc2DeepInspectionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEc2DeepInspectionConfigurationRequest method.
//	req, resp := client.GetEc2DeepInspectionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration
func (c *Inspector2) GetEc2DeepInspectionConfigurationRequest(input *GetEc2DeepInspectionConfigurationInput) (req *request.Request, output *GetEc2DeepInspectionConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetEc2DeepInspectionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/ec2deepinspectionconfiguration/get",
	}

	if input == nil {
		input = &GetEc2DeepInspectionConfigurationInput{}
	}

	output = &GetEc2DeepInspectionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEc2DeepInspectionConfiguration API operation for Inspector2.
//
// Retrieves the activation status of Amazon Inspector deep inspection and custom
// paths associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetEc2DeepInspectionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration
func (c *Inspector2) GetEc2DeepInspectionConfiguration(input *GetEc2DeepInspectionConfigurationInput) (*GetEc2DeepInspectionConfigurationOutput, error) {
	req, out := c.GetEc2DeepInspectionConfigurationRequest(input)
	return out, req.Send()
}

// GetEc2DeepInspectionConfigurationWithContext is the same as GetEc2DeepInspectionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEc2DeepInspectionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetEc2DeepInspectionConfigurationWithContext(ctx aws.Context, input *GetEc2DeepInspectionConfigurationInput, opts ...request.Option) (*GetEc2DeepInspectionConfigurationOutput, error) {
	req, out := c.GetEc2DeepInspectionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEncryptionKey = "GetEncryptionKey"

// GetEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEncryptionKey for more information on using the GetEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEncryptionKeyRequest method.
//	req, resp := client.GetEncryptionKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey
func (c *Inspector2) GetEncryptionKeyRequest(input *GetEncryptionKeyInput) (req *request.Request, output *GetEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opGetEncryptionKey,
		HTTPMethod: "GET",
		HTTPPath:   "/encryptionkey/get",
	}

	if input == nil {
		input = &GetEncryptionKeyInput{}
	}

	output = &GetEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEncryptionKey API operation for Inspector2.
//
// Gets an encryption key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetEncryptionKey for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey
func (c *Inspector2) GetEncryptionKey(input *GetEncryptionKeyInput) (*GetEncryptionKeyOutput, error) {
	req, out := c.GetEncryptionKeyRequest(input)
	return out, req.Send()
}

// GetEncryptionKeyWithContext is the same as GetEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetEncryptionKeyWithContext(ctx aws.Context, input *GetEncryptionKeyInput, opts ...request.Option) (*GetEncryptionKeyOutput, error) {
	req, out := c.GetEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindingsReportStatus = "GetFindingsReportStatus"

// GetFindingsReportStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingsReportStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingsReportStatus for more information on using the GetFindingsReportStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFindingsReportStatusRequest method.
//	req, resp := client.GetFindingsReportStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus
func (c *Inspector2) GetFindingsReportStatusRequest(input *GetFindingsReportStatusInput) (req *request.Request, output *GetFindingsReportStatusOutput) {
	op := &request.Operation{
		Name:       opGetFindingsReportStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/reporting/status/get",
	}

	if input == nil {
		input = &GetFindingsReportStatusInput{}
	}

	output = &GetFindingsReportStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingsReportStatus API operation for Inspector2.
//
// Gets the status of a findings report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetFindingsReportStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus
func (c *Inspector2) GetFindingsReportStatus(input *GetFindingsReportStatusInput) (*GetFindingsReportStatusOutput, error) {
	req, out := c.GetFindingsReportStatusRequest(input)
	return out, req.Send()
}

// GetFindingsReportStatusWithContext is the same as GetFindingsReportStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingsReportStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetFindingsReportStatusWithContext(ctx aws.Context, input *GetFindingsReportStatusInput, opts ...request.Option) (*GetFindingsReportStatusOutput, error) {
	req, out := c.GetFindingsReportStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMember = "GetMember"

// GetMemberRequest generates a "aws/request.Request" representing the
// client's request for the GetMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMember for more information on using the GetMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMemberRequest method.
//	req, resp := client.GetMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember
func (c *Inspector2) GetMemberRequest(input *GetMemberInput) (req *request.Request, output *GetMemberOutput) {
	op := &request.Operation{
		Name:       opGetMember,
		HTTPMethod: "POST",
		HTTPPath:   "/members/get",
	}

	if input == nil {
		input = &GetMemberInput{}
	}

	output = &GetMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMember API operation for Inspector2.
//
// Gets member information for your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetMember for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember
func (c *Inspector2) GetMember(input *GetMemberInput) (*GetMemberOutput, error) {
	req, out := c.GetMemberRequest(input)
	return out, req.Send()
}

// GetMemberWithContext is the same as GetMember with the addition of
// the ability to pass a context and additional request options.
//
// See GetMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetMemberWithContext(ctx aws.Context, input *GetMemberInput, opts ...request.Option) (*GetMemberOutput, error) {
	req, out := c.GetMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSbomExport = "GetSbomExport"

// GetSbomExportRequest generates a "aws/request.Request" representing the
// client's request for the GetSbomExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSbomExport for more information on using the GetSbomExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSbomExportRequest method.
//	req, resp := client.GetSbomExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport
func (c *Inspector2) GetSbomExportRequest(input *GetSbomExportInput) (req *request.Request, output *GetSbomExportOutput) {
	op := &request.Operation{
		Name:       opGetSbomExport,
		HTTPMethod: "POST",
		HTTPPath:   "/sbomexport/get",
	}

	if input == nil {
		input = &GetSbomExportInput{}
	}

	output = &GetSbomExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSbomExport API operation for Inspector2.
//
// Gets details of a software bill of materials (SBOM) report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation GetSbomExport for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport
func (c *Inspector2) GetSbomExport(input *GetSbomExportInput) (*GetSbomExportOutput, error) {
	req, out := c.GetSbomExportRequest(input)
	return out, req.Send()
}

// GetSbomExportWithContext is the same as GetSbomExport with the addition of
// the ability to pass a context and additional request options.
//
// See GetSbomExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) GetSbomExportWithContext(ctx aws.Context, input *GetSbomExportInput, opts ...request.Option) (*GetSbomExportOutput, error) {
	req, out := c.GetSbomExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountPermissions = "ListAccountPermissions"

// ListAccountPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountPermissions for more information on using the ListAccountPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountPermissionsRequest method.
//	req, resp := client.ListAccountPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions
func (c *Inspector2) ListAccountPermissionsRequest(input *ListAccountPermissionsInput) (req *request.Request, output *ListAccountPermissionsOutput) {
	op := &request.Operation{
		Name:       opListAccountPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accountpermissions/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountPermissionsInput{}
	}

	output = &ListAccountPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountPermissions API operation for Inspector2.
//
// Lists the permissions an account has to configure Amazon Inspector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListAccountPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions
func (c *Inspector2) ListAccountPermissions(input *ListAccountPermissionsInput) (*ListAccountPermissionsOutput, error) {
	req, out := c.ListAccountPermissionsRequest(input)
	return out, req.Send()
}

// ListAccountPermissionsWithContext is the same as ListAccountPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListAccountPermissionsWithContext(ctx aws.Context, input *ListAccountPermissionsInput, opts ...request.Option) (*ListAccountPermissionsOutput, error) {
	req, out := c.ListAccountPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountPermissionsPages iterates over the pages of a ListAccountPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountPermissions operation.
//	pageNum := 0
//	err := client.ListAccountPermissionsPages(params,
//	    func(page *inspector2.ListAccountPermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListAccountPermissionsPages(input *ListAccountPermissionsInput, fn func(*ListAccountPermissionsOutput, bool) bool) error {
	return c.ListAccountPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountPermissionsPagesWithContext same as ListAccountPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListAccountPermissionsPagesWithContext(ctx aws.Context, input *ListAccountPermissionsInput, fn func(*ListAccountPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCisScanConfigurations = "ListCisScanConfigurations"

// ListCisScanConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCisScanConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCisScanConfigurations for more information on using the ListCisScanConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCisScanConfigurationsRequest method.
//	req, resp := client.ListCisScanConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations
func (c *Inspector2) ListCisScanConfigurationsRequest(input *ListCisScanConfigurationsInput) (req *request.Request, output *ListCisScanConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListCisScanConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-configuration/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCisScanConfigurationsInput{}
	}

	output = &ListCisScanConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCisScanConfigurations API operation for Inspector2.
//
// Lists CIS scan configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListCisScanConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanConfigurations
func (c *Inspector2) ListCisScanConfigurations(input *ListCisScanConfigurationsInput) (*ListCisScanConfigurationsOutput, error) {
	req, out := c.ListCisScanConfigurationsRequest(input)
	return out, req.Send()
}

// ListCisScanConfigurationsWithContext is the same as ListCisScanConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCisScanConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScanConfigurationsWithContext(ctx aws.Context, input *ListCisScanConfigurationsInput, opts ...request.Option) (*ListCisScanConfigurationsOutput, error) {
	req, out := c.ListCisScanConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCisScanConfigurationsPages iterates over the pages of a ListCisScanConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCisScanConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCisScanConfigurations operation.
//	pageNum := 0
//	err := client.ListCisScanConfigurationsPages(params,
//	    func(page *inspector2.ListCisScanConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListCisScanConfigurationsPages(input *ListCisScanConfigurationsInput, fn func(*ListCisScanConfigurationsOutput, bool) bool) error {
	return c.ListCisScanConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCisScanConfigurationsPagesWithContext same as ListCisScanConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScanConfigurationsPagesWithContext(ctx aws.Context, input *ListCisScanConfigurationsInput, fn func(*ListCisScanConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCisScanConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCisScanConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCisScanConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCisScanResultsAggregatedByChecks = "ListCisScanResultsAggregatedByChecks"

// ListCisScanResultsAggregatedByChecksRequest generates a "aws/request.Request" representing the
// client's request for the ListCisScanResultsAggregatedByChecks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCisScanResultsAggregatedByChecks for more information on using the ListCisScanResultsAggregatedByChecks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCisScanResultsAggregatedByChecksRequest method.
//	req, resp := client.ListCisScanResultsAggregatedByChecksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks
func (c *Inspector2) ListCisScanResultsAggregatedByChecksRequest(input *ListCisScanResultsAggregatedByChecksInput) (req *request.Request, output *ListCisScanResultsAggregatedByChecksOutput) {
	op := &request.Operation{
		Name:       opListCisScanResultsAggregatedByChecks,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-result/check/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCisScanResultsAggregatedByChecksInput{}
	}

	output = &ListCisScanResultsAggregatedByChecksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCisScanResultsAggregatedByChecks API operation for Inspector2.
//
// Lists scan results aggregated by checks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListCisScanResultsAggregatedByChecks for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByChecks
func (c *Inspector2) ListCisScanResultsAggregatedByChecks(input *ListCisScanResultsAggregatedByChecksInput) (*ListCisScanResultsAggregatedByChecksOutput, error) {
	req, out := c.ListCisScanResultsAggregatedByChecksRequest(input)
	return out, req.Send()
}

// ListCisScanResultsAggregatedByChecksWithContext is the same as ListCisScanResultsAggregatedByChecks with the addition of
// the ability to pass a context and additional request options.
//
// See ListCisScanResultsAggregatedByChecks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScanResultsAggregatedByChecksWithContext(ctx aws.Context, input *ListCisScanResultsAggregatedByChecksInput, opts ...request.Option) (*ListCisScanResultsAggregatedByChecksOutput, error) {
	req, out := c.ListCisScanResultsAggregatedByChecksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCisScanResultsAggregatedByChecksPages iterates over the pages of a ListCisScanResultsAggregatedByChecks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCisScanResultsAggregatedByChecks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCisScanResultsAggregatedByChecks operation.
//	pageNum := 0
//	err := client.ListCisScanResultsAggregatedByChecksPages(params,
//	    func(page *inspector2.ListCisScanResultsAggregatedByChecksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListCisScanResultsAggregatedByChecksPages(input *ListCisScanResultsAggregatedByChecksInput, fn func(*ListCisScanResultsAggregatedByChecksOutput, bool) bool) error {
	return c.ListCisScanResultsAggregatedByChecksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCisScanResultsAggregatedByChecksPagesWithContext same as ListCisScanResultsAggregatedByChecksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScanResultsAggregatedByChecksPagesWithContext(ctx aws.Context, input *ListCisScanResultsAggregatedByChecksInput, fn func(*ListCisScanResultsAggregatedByChecksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCisScanResultsAggregatedByChecksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCisScanResultsAggregatedByChecksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCisScanResultsAggregatedByChecksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCisScanResultsAggregatedByTargetResource = "ListCisScanResultsAggregatedByTargetResource"

// ListCisScanResultsAggregatedByTargetResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListCisScanResultsAggregatedByTargetResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCisScanResultsAggregatedByTargetResource for more information on using the ListCisScanResultsAggregatedByTargetResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCisScanResultsAggregatedByTargetResourceRequest method.
//	req, resp := client.ListCisScanResultsAggregatedByTargetResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource
func (c *Inspector2) ListCisScanResultsAggregatedByTargetResourceRequest(input *ListCisScanResultsAggregatedByTargetResourceInput) (req *request.Request, output *ListCisScanResultsAggregatedByTargetResourceOutput) {
	op := &request.Operation{
		Name:       opListCisScanResultsAggregatedByTargetResource,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-result/resource/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCisScanResultsAggregatedByTargetResourceInput{}
	}

	output = &ListCisScanResultsAggregatedByTargetResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCisScanResultsAggregatedByTargetResource API operation for Inspector2.
//
// Lists scan results aggregated by a target resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListCisScanResultsAggregatedByTargetResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScanResultsAggregatedByTargetResource
func (c *Inspector2) ListCisScanResultsAggregatedByTargetResource(input *ListCisScanResultsAggregatedByTargetResourceInput) (*ListCisScanResultsAggregatedByTargetResourceOutput, error) {
	req, out := c.ListCisScanResultsAggregatedByTargetResourceRequest(input)
	return out, req.Send()
}

// ListCisScanResultsAggregatedByTargetResourceWithContext is the same as ListCisScanResultsAggregatedByTargetResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListCisScanResultsAggregatedByTargetResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScanResultsAggregatedByTargetResourceWithContext(ctx aws.Context, input *ListCisScanResultsAggregatedByTargetResourceInput, opts ...request.Option) (*ListCisScanResultsAggregatedByTargetResourceOutput, error) {
	req, out := c.ListCisScanResultsAggregatedByTargetResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCisScanResultsAggregatedByTargetResourcePages iterates over the pages of a ListCisScanResultsAggregatedByTargetResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCisScanResultsAggregatedByTargetResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCisScanResultsAggregatedByTargetResource operation.
//	pageNum := 0
//	err := client.ListCisScanResultsAggregatedByTargetResourcePages(params,
//	    func(page *inspector2.ListCisScanResultsAggregatedByTargetResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListCisScanResultsAggregatedByTargetResourcePages(input *ListCisScanResultsAggregatedByTargetResourceInput, fn func(*ListCisScanResultsAggregatedByTargetResourceOutput, bool) bool) error {
	return c.ListCisScanResultsAggregatedByTargetResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCisScanResultsAggregatedByTargetResourcePagesWithContext same as ListCisScanResultsAggregatedByTargetResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScanResultsAggregatedByTargetResourcePagesWithContext(ctx aws.Context, input *ListCisScanResultsAggregatedByTargetResourceInput, fn func(*ListCisScanResultsAggregatedByTargetResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCisScanResultsAggregatedByTargetResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCisScanResultsAggregatedByTargetResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCisScanResultsAggregatedByTargetResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCisScans = "ListCisScans"

// ListCisScansRequest generates a "aws/request.Request" representing the
// client's request for the ListCisScans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCisScans for more information on using the ListCisScans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCisScansRequest method.
//	req, resp := client.ListCisScansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans
func (c *Inspector2) ListCisScansRequest(input *ListCisScansInput) (req *request.Request, output *ListCisScansOutput) {
	op := &request.Operation{
		Name:       opListCisScans,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCisScansInput{}
	}

	output = &ListCisScansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCisScans API operation for Inspector2.
//
// Returns a CIS scan list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListCisScans for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCisScans
func (c *Inspector2) ListCisScans(input *ListCisScansInput) (*ListCisScansOutput, error) {
	req, out := c.ListCisScansRequest(input)
	return out, req.Send()
}

// ListCisScansWithContext is the same as ListCisScans with the addition of
// the ability to pass a context and additional request options.
//
// See ListCisScans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScansWithContext(ctx aws.Context, input *ListCisScansInput, opts ...request.Option) (*ListCisScansOutput, error) {
	req, out := c.ListCisScansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCisScansPages iterates over the pages of a ListCisScans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCisScans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCisScans operation.
//	pageNum := 0
//	err := client.ListCisScansPages(params,
//	    func(page *inspector2.ListCisScansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListCisScansPages(input *ListCisScansInput, fn func(*ListCisScansOutput, bool) bool) error {
	return c.ListCisScansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCisScansPagesWithContext same as ListCisScansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCisScansPagesWithContext(ctx aws.Context, input *ListCisScansInput, fn func(*ListCisScansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCisScansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCisScansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCisScansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCoverage = "ListCoverage"

// ListCoverageRequest generates a "aws/request.Request" representing the
// client's request for the ListCoverage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoverage for more information on using the ListCoverage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCoverageRequest method.
//	req, resp := client.ListCoverageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage
func (c *Inspector2) ListCoverageRequest(input *ListCoverageInput) (req *request.Request, output *ListCoverageOutput) {
	op := &request.Operation{
		Name:       opListCoverage,
		HTTPMethod: "POST",
		HTTPPath:   "/coverage/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCoverageInput{}
	}

	output = &ListCoverageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoverage API operation for Inspector2.
//
// Lists coverage details for you environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListCoverage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage
func (c *Inspector2) ListCoverage(input *ListCoverageInput) (*ListCoverageOutput, error) {
	req, out := c.ListCoverageRequest(input)
	return out, req.Send()
}

// ListCoverageWithContext is the same as ListCoverage with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoverage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCoverageWithContext(ctx aws.Context, input *ListCoverageInput, opts ...request.Option) (*ListCoverageOutput, error) {
	req, out := c.ListCoverageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCoveragePages iterates over the pages of a ListCoverage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCoverage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCoverage operation.
//	pageNum := 0
//	err := client.ListCoveragePages(params,
//	    func(page *inspector2.ListCoverageOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListCoveragePages(input *ListCoverageInput, fn func(*ListCoverageOutput, bool) bool) error {
	return c.ListCoveragePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCoveragePagesWithContext same as ListCoveragePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCoveragePagesWithContext(ctx aws.Context, input *ListCoverageInput, fn func(*ListCoverageOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCoverageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCoverageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCoverageOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCoverageStatistics = "ListCoverageStatistics"

// ListCoverageStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the ListCoverageStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoverageStatistics for more information on using the ListCoverageStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCoverageStatisticsRequest method.
//	req, resp := client.ListCoverageStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics
func (c *Inspector2) ListCoverageStatisticsRequest(input *ListCoverageStatisticsInput) (req *request.Request, output *ListCoverageStatisticsOutput) {
	op := &request.Operation{
		Name:       opListCoverageStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/coverage/statistics/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCoverageStatisticsInput{}
	}

	output = &ListCoverageStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoverageStatistics API operation for Inspector2.
//
// Lists Amazon Inspector coverage statistics for your environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListCoverageStatistics for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics
func (c *Inspector2) ListCoverageStatistics(input *ListCoverageStatisticsInput) (*ListCoverageStatisticsOutput, error) {
	req, out := c.ListCoverageStatisticsRequest(input)
	return out, req.Send()
}

// ListCoverageStatisticsWithContext is the same as ListCoverageStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoverageStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCoverageStatisticsWithContext(ctx aws.Context, input *ListCoverageStatisticsInput, opts ...request.Option) (*ListCoverageStatisticsOutput, error) {
	req, out := c.ListCoverageStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCoverageStatisticsPages iterates over the pages of a ListCoverageStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCoverageStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCoverageStatistics operation.
//	pageNum := 0
//	err := client.ListCoverageStatisticsPages(params,
//	    func(page *inspector2.ListCoverageStatisticsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListCoverageStatisticsPages(input *ListCoverageStatisticsInput, fn func(*ListCoverageStatisticsOutput, bool) bool) error {
	return c.ListCoverageStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCoverageStatisticsPagesWithContext same as ListCoverageStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListCoverageStatisticsPagesWithContext(ctx aws.Context, input *ListCoverageStatisticsInput, fn func(*ListCoverageStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCoverageStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCoverageStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCoverageStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDelegatedAdminAccounts = "ListDelegatedAdminAccounts"

// ListDelegatedAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListDelegatedAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDelegatedAdminAccounts for more information on using the ListDelegatedAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDelegatedAdminAccountsRequest method.
//	req, resp := client.ListDelegatedAdminAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts
func (c *Inspector2) ListDelegatedAdminAccountsRequest(input *ListDelegatedAdminAccountsInput) (req *request.Request, output *ListDelegatedAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListDelegatedAdminAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/delegatedadminaccounts/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDelegatedAdminAccountsInput{}
	}

	output = &ListDelegatedAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDelegatedAdminAccounts API operation for Inspector2.
//
// Lists information about the Amazon Inspector delegated administrator of your
// organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListDelegatedAdminAccounts for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts
func (c *Inspector2) ListDelegatedAdminAccounts(input *ListDelegatedAdminAccountsInput) (*ListDelegatedAdminAccountsOutput, error) {
	req, out := c.ListDelegatedAdminAccountsRequest(input)
	return out, req.Send()
}

// ListDelegatedAdminAccountsWithContext is the same as ListDelegatedAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListDelegatedAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListDelegatedAdminAccountsWithContext(ctx aws.Context, input *ListDelegatedAdminAccountsInput, opts ...request.Option) (*ListDelegatedAdminAccountsOutput, error) {
	req, out := c.ListDelegatedAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDelegatedAdminAccountsPages iterates over the pages of a ListDelegatedAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDelegatedAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDelegatedAdminAccounts operation.
//	pageNum := 0
//	err := client.ListDelegatedAdminAccountsPages(params,
//	    func(page *inspector2.ListDelegatedAdminAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListDelegatedAdminAccountsPages(input *ListDelegatedAdminAccountsInput, fn func(*ListDelegatedAdminAccountsOutput, bool) bool) error {
	return c.ListDelegatedAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDelegatedAdminAccountsPagesWithContext same as ListDelegatedAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListDelegatedAdminAccountsPagesWithContext(ctx aws.Context, input *ListDelegatedAdminAccountsInput, fn func(*ListDelegatedAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDelegatedAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDelegatedAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDelegatedAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFilters = "ListFilters"

// ListFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFilters for more information on using the ListFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFiltersRequest method.
//	req, resp := client.ListFiltersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters
func (c *Inspector2) ListFiltersRequest(input *ListFiltersInput) (req *request.Request, output *ListFiltersOutput) {
	op := &request.Operation{
		Name:       opListFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/filters/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFiltersInput{}
	}

	output = &ListFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFilters API operation for Inspector2.
//
// Lists the filters associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListFilters for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters
func (c *Inspector2) ListFilters(input *ListFiltersInput) (*ListFiltersOutput, error) {
	req, out := c.ListFiltersRequest(input)
	return out, req.Send()
}

// ListFiltersWithContext is the same as ListFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListFiltersWithContext(ctx aws.Context, input *ListFiltersInput, opts ...request.Option) (*ListFiltersOutput, error) {
	req, out := c.ListFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFiltersPages iterates over the pages of a ListFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFilters operation.
//	pageNum := 0
//	err := client.ListFiltersPages(params,
//	    func(page *inspector2.ListFiltersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListFiltersPages(input *ListFiltersInput, fn func(*ListFiltersOutput, bool) bool) error {
	return c.ListFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFiltersPagesWithContext same as ListFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListFiltersPagesWithContext(ctx aws.Context, input *ListFiltersInput, fn func(*ListFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindingAggregations = "ListFindingAggregations"

// ListFindingAggregationsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindingAggregations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindingAggregations for more information on using the ListFindingAggregations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFindingAggregationsRequest method.
//	req, resp := client.ListFindingAggregationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations
func (c *Inspector2) ListFindingAggregationsRequest(input *ListFindingAggregationsInput) (req *request.Request, output *ListFindingAggregationsOutput) {
	op := &request.Operation{
		Name:       opListFindingAggregations,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/aggregation/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingAggregationsInput{}
	}

	output = &ListFindingAggregationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindingAggregations API operation for Inspector2.
//
// Lists aggregated finding data for your environment based on specific criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListFindingAggregations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations
func (c *Inspector2) ListFindingAggregations(input *ListFindingAggregationsInput) (*ListFindingAggregationsOutput, error) {
	req, out := c.ListFindingAggregationsRequest(input)
	return out, req.Send()
}

// ListFindingAggregationsWithContext is the same as ListFindingAggregations with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindingAggregations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListFindingAggregationsWithContext(ctx aws.Context, input *ListFindingAggregationsInput, opts ...request.Option) (*ListFindingAggregationsOutput, error) {
	req, out := c.ListFindingAggregationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingAggregationsPages iterates over the pages of a ListFindingAggregations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindingAggregations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFindingAggregations operation.
//	pageNum := 0
//	err := client.ListFindingAggregationsPages(params,
//	    func(page *inspector2.ListFindingAggregationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListFindingAggregationsPages(input *ListFindingAggregationsInput, fn func(*ListFindingAggregationsOutput, bool) bool) error {
	return c.ListFindingAggregationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingAggregationsPagesWithContext same as ListFindingAggregationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListFindingAggregationsPagesWithContext(ctx aws.Context, input *ListFindingAggregationsInput, fn func(*ListFindingAggregationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingAggregationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingAggregationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingAggregationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFindingsRequest method.
//	req, resp := client.ListFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings
func (c *Inspector2) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Inspector2.
//
// Lists findings for your environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListFindings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings
func (c *Inspector2) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFindings operation.
//	pageNum := 0
//	err := client.ListFindingsPages(params,
//	    func(page *inspector2.ListFindingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMembersRequest method.
//	req, resp := client.ListMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers
func (c *Inspector2) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Inspector2.
//
// List members associated with the Amazon Inspector delegated administrator
// for your organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers
func (c *Inspector2) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMembers operation.
//	pageNum := 0
//	err := client.ListMembersPages(params,
//	    func(page *inspector2.ListMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource
func (c *Inspector2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Inspector2.
//
// Lists all tags attached to a given resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource
func (c *Inspector2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsageTotals = "ListUsageTotals"

// ListUsageTotalsRequest generates a "aws/request.Request" representing the
// client's request for the ListUsageTotals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsageTotals for more information on using the ListUsageTotals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsageTotalsRequest method.
//	req, resp := client.ListUsageTotalsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals
func (c *Inspector2) ListUsageTotalsRequest(input *ListUsageTotalsInput) (req *request.Request, output *ListUsageTotalsOutput) {
	op := &request.Operation{
		Name:       opListUsageTotals,
		HTTPMethod: "POST",
		HTTPPath:   "/usage/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsageTotalsInput{}
	}

	output = &ListUsageTotalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsageTotals API operation for Inspector2.
//
// Lists the Amazon Inspector usage totals over the last 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ListUsageTotals for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals
func (c *Inspector2) ListUsageTotals(input *ListUsageTotalsInput) (*ListUsageTotalsOutput, error) {
	req, out := c.ListUsageTotalsRequest(input)
	return out, req.Send()
}

// ListUsageTotalsWithContext is the same as ListUsageTotals with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsageTotals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListUsageTotalsWithContext(ctx aws.Context, input *ListUsageTotalsInput, opts ...request.Option) (*ListUsageTotalsOutput, error) {
	req, out := c.ListUsageTotalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsageTotalsPages iterates over the pages of a ListUsageTotals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsageTotals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUsageTotals operation.
//	pageNum := 0
//	err := client.ListUsageTotalsPages(params,
//	    func(page *inspector2.ListUsageTotalsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) ListUsageTotalsPages(input *ListUsageTotalsInput, fn func(*ListUsageTotalsOutput, bool) bool) error {
	return c.ListUsageTotalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsageTotalsPagesWithContext same as ListUsageTotalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ListUsageTotalsPagesWithContext(ctx aws.Context, input *ListUsageTotalsInput, fn func(*ListUsageTotalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsageTotalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsageTotalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsageTotalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opResetEncryptionKey = "ResetEncryptionKey"

// ResetEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the ResetEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetEncryptionKey for more information on using the ResetEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResetEncryptionKeyRequest method.
//	req, resp := client.ResetEncryptionKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey
func (c *Inspector2) ResetEncryptionKeyRequest(input *ResetEncryptionKeyInput) (req *request.Request, output *ResetEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opResetEncryptionKey,
		HTTPMethod: "PUT",
		HTTPPath:   "/encryptionkey/reset",
	}

	if input == nil {
		input = &ResetEncryptionKeyInput{}
	}

	output = &ResetEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetEncryptionKey API operation for Inspector2.
//
// Resets an encryption key. After the key is reset your resources will be encrypted
// by an Amazon Web Services owned key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation ResetEncryptionKey for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey
func (c *Inspector2) ResetEncryptionKey(input *ResetEncryptionKeyInput) (*ResetEncryptionKeyOutput, error) {
	req, out := c.ResetEncryptionKeyRequest(input)
	return out, req.Send()
}

// ResetEncryptionKeyWithContext is the same as ResetEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See ResetEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) ResetEncryptionKeyWithContext(ctx aws.Context, input *ResetEncryptionKeyInput, opts ...request.Option) (*ResetEncryptionKeyOutput, error) {
	req, out := c.ResetEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchVulnerabilities = "SearchVulnerabilities"

// SearchVulnerabilitiesRequest generates a "aws/request.Request" representing the
// client's request for the SearchVulnerabilities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchVulnerabilities for more information on using the SearchVulnerabilities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchVulnerabilitiesRequest method.
//	req, resp := client.SearchVulnerabilitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities
func (c *Inspector2) SearchVulnerabilitiesRequest(input *SearchVulnerabilitiesInput) (req *request.Request, output *SearchVulnerabilitiesOutput) {
	op := &request.Operation{
		Name:       opSearchVulnerabilities,
		HTTPMethod: "POST",
		HTTPPath:   "/vulnerabilities/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchVulnerabilitiesInput{}
	}

	output = &SearchVulnerabilitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchVulnerabilities API operation for Inspector2.
//
// Lists Amazon Inspector coverage details for a specific vulnerability.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation SearchVulnerabilities for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities
func (c *Inspector2) SearchVulnerabilities(input *SearchVulnerabilitiesInput) (*SearchVulnerabilitiesOutput, error) {
	req, out := c.SearchVulnerabilitiesRequest(input)
	return out, req.Send()
}

// SearchVulnerabilitiesWithContext is the same as SearchVulnerabilities with the addition of
// the ability to pass a context and additional request options.
//
// See SearchVulnerabilities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) SearchVulnerabilitiesWithContext(ctx aws.Context, input *SearchVulnerabilitiesInput, opts ...request.Option) (*SearchVulnerabilitiesOutput, error) {
	req, out := c.SearchVulnerabilitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchVulnerabilitiesPages iterates over the pages of a SearchVulnerabilities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchVulnerabilities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchVulnerabilities operation.
//	pageNum := 0
//	err := client.SearchVulnerabilitiesPages(params,
//	    func(page *inspector2.SearchVulnerabilitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Inspector2) SearchVulnerabilitiesPages(input *SearchVulnerabilitiesInput, fn func(*SearchVulnerabilitiesOutput, bool) bool) error {
	return c.SearchVulnerabilitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchVulnerabilitiesPagesWithContext same as SearchVulnerabilitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) SearchVulnerabilitiesPagesWithContext(ctx aws.Context, input *SearchVulnerabilitiesInput, fn func(*SearchVulnerabilitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchVulnerabilitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchVulnerabilitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchVulnerabilitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendCisSessionHealth = "SendCisSessionHealth"

// SendCisSessionHealthRequest generates a "aws/request.Request" representing the
// client's request for the SendCisSessionHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendCisSessionHealth for more information on using the SendCisSessionHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendCisSessionHealthRequest method.
//	req, resp := client.SendCisSessionHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionHealth
func (c *Inspector2) SendCisSessionHealthRequest(input *SendCisSessionHealthInput) (req *request.Request, output *SendCisSessionHealthOutput) {
	op := &request.Operation{
		Name:       opSendCisSessionHealth,
		HTTPMethod: "PUT",
		HTTPPath:   "/cissession/health/send",
	}

	if input == nil {
		input = &SendCisSessionHealthInput{}
	}

	output = &SendCisSessionHealthOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendCisSessionHealth API operation for Inspector2.
//
// Sends a CIS session health. This API is used by the Amazon Inspector SSM
// plugin to communicate with the Amazon Inspector service. The Amazon Inspector
// SSM plugin calls this API to start a CIS scan session for the scan ID supplied
// by the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation SendCisSessionHealth for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict occurred.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionHealth
func (c *Inspector2) SendCisSessionHealth(input *SendCisSessionHealthInput) (*SendCisSessionHealthOutput, error) {
	req, out := c.SendCisSessionHealthRequest(input)
	return out, req.Send()
}

// SendCisSessionHealthWithContext is the same as SendCisSessionHealth with the addition of
// the ability to pass a context and additional request options.
//
// See SendCisSessionHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) SendCisSessionHealthWithContext(ctx aws.Context, input *SendCisSessionHealthInput, opts ...request.Option) (*SendCisSessionHealthOutput, error) {
	req, out := c.SendCisSessionHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendCisSessionTelemetry = "SendCisSessionTelemetry"

// SendCisSessionTelemetryRequest generates a "aws/request.Request" representing the
// client's request for the SendCisSessionTelemetry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendCisSessionTelemetry for more information on using the SendCisSessionTelemetry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendCisSessionTelemetryRequest method.
//	req, resp := client.SendCisSessionTelemetryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionTelemetry
func (c *Inspector2) SendCisSessionTelemetryRequest(input *SendCisSessionTelemetryInput) (req *request.Request, output *SendCisSessionTelemetryOutput) {
	op := &request.Operation{
		Name:       opSendCisSessionTelemetry,
		HTTPMethod: "PUT",
		HTTPPath:   "/cissession/telemetry/send",
	}

	if input == nil {
		input = &SendCisSessionTelemetryInput{}
	}

	output = &SendCisSessionTelemetryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendCisSessionTelemetry API operation for Inspector2.
//
// Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM
// plugin to communicate with the Amazon Inspector service. The Amazon Inspector
// SSM plugin calls this API to start a CIS scan session for the scan ID supplied
// by the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation SendCisSessionTelemetry for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict occurred.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SendCisSessionTelemetry
func (c *Inspector2) SendCisSessionTelemetry(input *SendCisSessionTelemetryInput) (*SendCisSessionTelemetryOutput, error) {
	req, out := c.SendCisSessionTelemetryRequest(input)
	return out, req.Send()
}

// SendCisSessionTelemetryWithContext is the same as SendCisSessionTelemetry with the addition of
// the ability to pass a context and additional request options.
//
// See SendCisSessionTelemetry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) SendCisSessionTelemetryWithContext(ctx aws.Context, input *SendCisSessionTelemetryInput, opts ...request.Option) (*SendCisSessionTelemetryOutput, error) {
	req, out := c.SendCisSessionTelemetryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCisSession = "StartCisSession"

// StartCisSessionRequest generates a "aws/request.Request" representing the
// client's request for the StartCisSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCisSession for more information on using the StartCisSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCisSessionRequest method.
//	req, resp := client.StartCisSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCisSession
func (c *Inspector2) StartCisSessionRequest(input *StartCisSessionInput) (req *request.Request, output *StartCisSessionOutput) {
	op := &request.Operation{
		Name:       opStartCisSession,
		HTTPMethod: "PUT",
		HTTPPath:   "/cissession/start",
	}

	if input == nil {
		input = &StartCisSessionInput{}
	}

	output = &StartCisSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartCisSession API operation for Inspector2.
//
// Starts a CIS session. This API is used by the Amazon Inspector SSM plugin
// to communicate with the Amazon Inspector service. The Amazon Inspector SSM
// plugin calls this API to start a CIS scan session for the scan ID supplied
// by the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation StartCisSession for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict occurred.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StartCisSession
func (c *Inspector2) StartCisSession(input *StartCisSessionInput) (*StartCisSessionOutput, error) {
	req, out := c.StartCisSessionRequest(input)
	return out, req.Send()
}

// StartCisSessionWithContext is the same as StartCisSession with the addition of
// the ability to pass a context and additional request options.
//
// See StartCisSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) StartCisSessionWithContext(ctx aws.Context, input *StartCisSessionInput, opts ...request.Option) (*StartCisSessionOutput, error) {
	req, out := c.StartCisSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCisSession = "StopCisSession"

// StopCisSessionRequest generates a "aws/request.Request" representing the
// client's request for the StopCisSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCisSession for more information on using the StopCisSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopCisSessionRequest method.
//	req, resp := client.StopCisSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StopCisSession
func (c *Inspector2) StopCisSessionRequest(input *StopCisSessionInput) (req *request.Request, output *StopCisSessionOutput) {
	op := &request.Operation{
		Name:       opStopCisSession,
		HTTPMethod: "PUT",
		HTTPPath:   "/cissession/stop",
	}

	if input == nil {
		input = &StopCisSessionInput{}
	}

	output = &StopCisSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCisSession API operation for Inspector2.
//
// Stops a CIS session. This API is used by the Amazon Inspector SSM plugin
// to communicate with the Amazon Inspector service. The Amazon Inspector SSM
// plugin calls this API to start a CIS scan session for the scan ID supplied
// by the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation StopCisSession for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     A conflict occurred.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/StopCisSession
func (c *Inspector2) StopCisSession(input *StopCisSessionInput) (*StopCisSessionOutput, error) {
	req, out := c.StopCisSessionRequest(input)
	return out, req.Send()
}

// StopCisSessionWithContext is the same as StopCisSession with the addition of
// the ability to pass a context and additional request options.
//
// See StopCisSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) StopCisSessionWithContext(ctx aws.Context, input *StopCisSessionInput, opts ...request.Option) (*StopCisSessionOutput, error) {
	req, out := c.StopCisSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource
func (c *Inspector2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Inspector2.
//
// Adds tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     One or more tags submitted as part of the request is not valid.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource
func (c *Inspector2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource
func (c *Inspector2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Inspector2.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource
func (c *Inspector2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCisScanConfiguration = "UpdateCisScanConfiguration"

// UpdateCisScanConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCisScanConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCisScanConfiguration for more information on using the UpdateCisScanConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCisScanConfigurationRequest method.
//	req, resp := client.UpdateCisScanConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCisScanConfiguration
func (c *Inspector2) UpdateCisScanConfigurationRequest(input *UpdateCisScanConfigurationInput) (req *request.Request, output *UpdateCisScanConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateCisScanConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/cis/scan-configuration/update",
	}

	if input == nil {
		input = &UpdateCisScanConfigurationInput{}
	}

	output = &UpdateCisScanConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCisScanConfiguration API operation for Inspector2.
//
// Updates a CIS scan configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateCisScanConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateCisScanConfiguration
func (c *Inspector2) UpdateCisScanConfiguration(input *UpdateCisScanConfigurationInput) (*UpdateCisScanConfigurationOutput, error) {
	req, out := c.UpdateCisScanConfigurationRequest(input)
	return out, req.Send()
}

// UpdateCisScanConfigurationWithContext is the same as UpdateCisScanConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCisScanConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateCisScanConfigurationWithContext(ctx aws.Context, input *UpdateCisScanConfigurationInput, opts ...request.Option) (*UpdateCisScanConfigurationOutput, error) {
	req, out := c.UpdateCisScanConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguration = "UpdateConfiguration"

// UpdateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguration for more information on using the UpdateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationRequest method.
//	req, resp := client.UpdateConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration
func (c *Inspector2) UpdateConfigurationRequest(input *UpdateConfigurationInput) (req *request.Request, output *UpdateConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/configuration/update",
	}

	if input == nil {
		input = &UpdateConfigurationInput{}
	}

	output = &UpdateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfiguration API operation for Inspector2.
//
// Updates setting configurations for your Amazon Inspector account. When you
// use this API as an Amazon Inspector delegated administrator this updates
// the setting for all accounts you manage. Member accounts in an organization
// cannot update this setting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration
func (c *Inspector2) UpdateConfiguration(input *UpdateConfigurationInput) (*UpdateConfigurationOutput, error) {
	req, out := c.UpdateConfigurationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationWithContext is the same as UpdateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateConfigurationWithContext(ctx aws.Context, input *UpdateConfigurationInput, opts ...request.Option) (*UpdateConfigurationOutput, error) {
	req, out := c.UpdateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEc2DeepInspectionConfiguration = "UpdateEc2DeepInspectionConfiguration"

// UpdateEc2DeepInspectionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEc2DeepInspectionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEc2DeepInspectionConfiguration for more information on using the UpdateEc2DeepInspectionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEc2DeepInspectionConfigurationRequest method.
//	req, resp := client.UpdateEc2DeepInspectionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration
func (c *Inspector2) UpdateEc2DeepInspectionConfigurationRequest(input *UpdateEc2DeepInspectionConfigurationInput) (req *request.Request, output *UpdateEc2DeepInspectionConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateEc2DeepInspectionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/ec2deepinspectionconfiguration/update",
	}

	if input == nil {
		input = &UpdateEc2DeepInspectionConfigurationInput{}
	}

	output = &UpdateEc2DeepInspectionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEc2DeepInspectionConfiguration API operation for Inspector2.
//
// Activates, deactivates Amazon Inspector deep inspection, or updates custom
// paths for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateEc2DeepInspectionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration
func (c *Inspector2) UpdateEc2DeepInspectionConfiguration(input *UpdateEc2DeepInspectionConfigurationInput) (*UpdateEc2DeepInspectionConfigurationOutput, error) {
	req, out := c.UpdateEc2DeepInspectionConfigurationRequest(input)
	return out, req.Send()
}

// UpdateEc2DeepInspectionConfigurationWithContext is the same as UpdateEc2DeepInspectionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEc2DeepInspectionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateEc2DeepInspectionConfigurationWithContext(ctx aws.Context, input *UpdateEc2DeepInspectionConfigurationInput, opts ...request.Option) (*UpdateEc2DeepInspectionConfigurationOutput, error) {
	req, out := c.UpdateEc2DeepInspectionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEncryptionKey = "UpdateEncryptionKey"

// UpdateEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEncryptionKey for more information on using the UpdateEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEncryptionKeyRequest method.
//	req, resp := client.UpdateEncryptionKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey
func (c *Inspector2) UpdateEncryptionKeyRequest(input *UpdateEncryptionKeyInput) (req *request.Request, output *UpdateEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateEncryptionKey,
		HTTPMethod: "PUT",
		HTTPPath:   "/encryptionkey/update",
	}

	if input == nil {
		input = &UpdateEncryptionKeyInput{}
	}

	output = &UpdateEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEncryptionKey API operation for Inspector2.
//
// Updates an encryption key. A ResourceNotFoundException means that an Amazon
// Web Services owned key is being used for encryption.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateEncryptionKey for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey
func (c *Inspector2) UpdateEncryptionKey(input *UpdateEncryptionKeyInput) (*UpdateEncryptionKeyOutput, error) {
	req, out := c.UpdateEncryptionKeyRequest(input)
	return out, req.Send()
}

// UpdateEncryptionKeyWithContext is the same as UpdateEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateEncryptionKeyWithContext(ctx aws.Context, input *UpdateEncryptionKeyInput, opts ...request.Option) (*UpdateEncryptionKeyOutput, error) {
	req, out := c.UpdateEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFilter = "UpdateFilter"

// UpdateFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFilter for more information on using the UpdateFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFilterRequest method.
//	req, resp := client.UpdateFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter
func (c *Inspector2) UpdateFilterRequest(input *UpdateFilterInput) (req *request.Request, output *UpdateFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/filters/update",
	}

	if input == nil {
		input = &UpdateFilterInput{}
	}

	output = &UpdateFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFilter API operation for Inspector2.
//
// Specifies the action that is to be applied to the findings that match the
// filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateFilter for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access an invalid resource. Make sure the resource
//     is specified correctly.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter
func (c *Inspector2) UpdateFilter(input *UpdateFilterInput) (*UpdateFilterOutput, error) {
	req, out := c.UpdateFilterRequest(input)
	return out, req.Send()
}

// UpdateFilterWithContext is the same as UpdateFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateFilterWithContext(ctx aws.Context, input *UpdateFilterInput, opts ...request.Option) (*UpdateFilterOutput, error) {
	req, out := c.UpdateFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrgEc2DeepInspectionConfiguration = "UpdateOrgEc2DeepInspectionConfiguration"

// UpdateOrgEc2DeepInspectionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrgEc2DeepInspectionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrgEc2DeepInspectionConfiguration for more information on using the UpdateOrgEc2DeepInspectionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOrgEc2DeepInspectionConfigurationRequest method.
//	req, resp := client.UpdateOrgEc2DeepInspectionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration
func (c *Inspector2) UpdateOrgEc2DeepInspectionConfigurationRequest(input *UpdateOrgEc2DeepInspectionConfigurationInput) (req *request.Request, output *UpdateOrgEc2DeepInspectionConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrgEc2DeepInspectionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/ec2deepinspectionconfiguration/org/update",
	}

	if input == nil {
		input = &UpdateOrgEc2DeepInspectionConfigurationInput{}
	}

	output = &UpdateOrgEc2DeepInspectionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrgEc2DeepInspectionConfiguration API operation for Inspector2.
//
// Updates the Amazon Inspector deep inspection custom paths for your organization.
// You must be an Amazon Inspector delegated administrator to use this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateOrgEc2DeepInspectionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration
func (c *Inspector2) UpdateOrgEc2DeepInspectionConfiguration(input *UpdateOrgEc2DeepInspectionConfigurationInput) (*UpdateOrgEc2DeepInspectionConfigurationOutput, error) {
	req, out := c.UpdateOrgEc2DeepInspectionConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrgEc2DeepInspectionConfigurationWithContext is the same as UpdateOrgEc2DeepInspectionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrgEc2DeepInspectionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateOrgEc2DeepInspectionConfigurationWithContext(ctx aws.Context, input *UpdateOrgEc2DeepInspectionConfigurationInput, opts ...request.Option) (*UpdateOrgEc2DeepInspectionConfigurationOutput, error) {
	req, out := c.UpdateOrgEc2DeepInspectionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOrganizationConfigurationRequest method.
//	req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration
func (c *Inspector2) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/organizationconfiguration/update",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOrganizationConfiguration API operation for Inspector2.
//
// Updates the configurations for your Amazon Inspector organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Inspector2's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request has failed validation due to missing required fields or having
//     invalid inputs.
//
//   - ThrottlingException
//     The limit on the number of requests per second was exceeded.
//
//   - InternalServerException
//     The request has failed due to an internal failure of the Amazon Inspector
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration
func (c *Inspector2) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Inspector2) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Amazon Web Services account within your environment that Amazon Inspector
// has been enabled for.
type Account struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// Details of the status of Amazon Inspector scans by resource type.
	//
	// ResourceStatus is a required field
	ResourceStatus *ResourceStatus `locationName:"resourceStatus" type:"structure" required:"true"`

	// The status of Amazon Inspector for the account.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Account) SetAccountId(v string) *Account {
	s.AccountId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *Account) SetResourceStatus(v *ResourceStatus) *Account {
	s.ResourceStatus = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Account) SetStatus(v string) *Account {
	s.Status = &v
	return s
}

// An object that contains details about an aggregation response based on Amazon
// Web Services accounts.
type AccountAggregation struct {
	_ struct{} `type:"structure"`

	// The type of finding.
	FindingType *string `locationName:"findingType" type:"string" enum:"AggregationFindingType"`

	// The type of resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"AggregationResourceType"`

	// The value to sort by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"AccountSortBy"`

	// The sort order (ascending or descending).
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAggregation) GoString() string {
	return s.String()
}

// SetFindingType sets the FindingType field's value.
func (s *AccountAggregation) SetFindingType(v string) *AccountAggregation {
	s.FindingType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AccountAggregation) SetResourceType(v string) *AccountAggregation {
	s.ResourceType = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *AccountAggregation) SetSortBy(v string) *AccountAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *AccountAggregation) SetSortOrder(v string) *AccountAggregation {
	s.SortOrder = &v
	return s
}

// An aggregation of findings by Amazon Web Services account ID.
type AccountAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The number of findings by severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountAggregationResponse) SetAccountId(v string) *AccountAggregationResponse {
	s.AccountId = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *AccountAggregationResponse) SetSeverityCounts(v *SeverityCounts) *AccountAggregationResponse {
	s.SeverityCounts = v
	return s
}

// An object with details the status of an Amazon Web Services account within
// your Amazon Inspector environment.
type AccountState struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// An object detailing which resources Amazon Inspector is enabled to scan for
	// the account.
	//
	// ResourceState is a required field
	ResourceState *ResourceState `locationName:"resourceState" type:"structure" required:"true"`

	// An object detailing the status of Amazon Inspector for the account.
	//
	// State is a required field
	State *State `locationName:"state" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountState) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountState) SetAccountId(v string) *AccountState {
	s.AccountId = &v
	return s
}

// SetResourceState sets the ResourceState field's value.
func (s *AccountState) SetResourceState(v *ResourceState) *AccountState {
	s.ResourceState = v
	return s
}

// SetState sets the State field's value.
func (s *AccountState) SetState(v *State) *AccountState {
	s.State = v
	return s
}

// Contains details about an aggregation request.
type AggregationRequest struct {
	_ struct{} `type:"structure"`

	// An object that contains details about an aggregation request based on Amazon
	// Web Services account IDs.
	AccountAggregation *AccountAggregation `locationName:"accountAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on Amazon
	// Machine Images (AMIs).
	AmiAggregation *AmiAggregation `locationName:"amiAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on Amazon
	// ECR container images.
	AwsEcrContainerAggregation *AwsEcrContainerAggregation `locationName:"awsEcrContainerAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on Amazon
	// EC2 instances.
	Ec2InstanceAggregation *Ec2InstanceAggregation `locationName:"ec2InstanceAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on finding
	// types.
	FindingTypeAggregation *FindingTypeAggregation `locationName:"findingTypeAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on container
	// image layers.
	ImageLayerAggregation *ImageLayerAggregation `locationName:"imageLayerAggregation" type:"structure"`

	// Returns an object with findings aggregated by Amazon Web Services Lambda
	// function.
	LambdaFunctionAggregation *LambdaFunctionAggregation `locationName:"lambdaFunctionAggregation" type:"structure"`

	// Returns an object with findings aggregated by Amazon Web Services Lambda
	// layer.
	LambdaLayerAggregation *LambdaLayerAggregation `locationName:"lambdaLayerAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on operating
	// system package type.
	PackageAggregation *PackageAggregation `locationName:"packageAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on Amazon
	// ECR repositories.
	RepositoryAggregation *RepositoryAggregation `locationName:"repositoryAggregation" type:"structure"`

	// An object that contains details about an aggregation request based on finding
	// title.
	TitleAggregation *TitleAggregation `locationName:"titleAggregation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregationRequest"}
	if s.AmiAggregation != nil {
		if err := s.AmiAggregation.Validate(); err != nil {
			invalidParams.AddNested("AmiAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.AwsEcrContainerAggregation != nil {
		if err := s.AwsEcrContainerAggregation.Validate(); err != nil {
			invalidParams.AddNested("AwsEcrContainerAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.Ec2InstanceAggregation != nil {
		if err := s.Ec2InstanceAggregation.Validate(); err != nil {
			invalidParams.AddNested("Ec2InstanceAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.ImageLayerAggregation != nil {
		if err := s.ImageLayerAggregation.Validate(); err != nil {
			invalidParams.AddNested("ImageLayerAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAggregation != nil {
		if err := s.LambdaFunctionAggregation.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaLayerAggregation != nil {
		if err := s.LambdaLayerAggregation.Validate(); err != nil {
			invalidParams.AddNested("LambdaLayerAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.PackageAggregation != nil {
		if err := s.PackageAggregation.Validate(); err != nil {
			invalidParams.AddNested("PackageAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.RepositoryAggregation != nil {
		if err := s.RepositoryAggregation.Validate(); err != nil {
			invalidParams.AddNested("RepositoryAggregation", err.(request.ErrInvalidParams))
		}
	}
	if s.TitleAggregation != nil {
		if err := s.TitleAggregation.Validate(); err != nil {
			invalidParams.AddNested("TitleAggregation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAggregation sets the AccountAggregation field's value.
func (s *AggregationRequest) SetAccountAggregation(v *AccountAggregation) *AggregationRequest {
	s.AccountAggregation = v
	return s
}

// SetAmiAggregation sets the AmiAggregation field's value.
func (s *AggregationRequest) SetAmiAggregation(v *AmiAggregation) *AggregationRequest {
	s.AmiAggregation = v
	return s
}

// SetAwsEcrContainerAggregation sets the AwsEcrContainerAggregation field's value.
func (s *AggregationRequest) SetAwsEcrContainerAggregation(v *AwsEcrContainerAggregation) *AggregationRequest {
	s.AwsEcrContainerAggregation = v
	return s
}

// SetEc2InstanceAggregation sets the Ec2InstanceAggregation field's value.
func (s *AggregationRequest) SetEc2InstanceAggregation(v *Ec2InstanceAggregation) *AggregationRequest {
	s.Ec2InstanceAggregation = v
	return s
}

// SetFindingTypeAggregation sets the FindingTypeAggregation field's value.
func (s *AggregationRequest) SetFindingTypeAggregation(v *FindingTypeAggregation) *AggregationRequest {
	s.FindingTypeAggregation = v
	return s
}

// SetImageLayerAggregation sets the ImageLayerAggregation field's value.
func (s *AggregationRequest) SetImageLayerAggregation(v *ImageLayerAggregation) *AggregationRequest {
	s.ImageLayerAggregation = v
	return s
}

// SetLambdaFunctionAggregation sets the LambdaFunctionAggregation field's value.
func (s *AggregationRequest) SetLambdaFunctionAggregation(v *LambdaFunctionAggregation) *AggregationRequest {
	s.LambdaFunctionAggregation = v
	return s
}

// SetLambdaLayerAggregation sets the LambdaLayerAggregation field's value.
func (s *AggregationRequest) SetLambdaLayerAggregation(v *LambdaLayerAggregation) *AggregationRequest {
	s.LambdaLayerAggregation = v
	return s
}

// SetPackageAggregation sets the PackageAggregation field's value.
func (s *AggregationRequest) SetPackageAggregation(v *PackageAggregation) *AggregationRequest {
	s.PackageAggregation = v
	return s
}

// SetRepositoryAggregation sets the RepositoryAggregation field's value.
func (s *AggregationRequest) SetRepositoryAggregation(v *RepositoryAggregation) *AggregationRequest {
	s.RepositoryAggregation = v
	return s
}

// SetTitleAggregation sets the TitleAggregation field's value.
func (s *AggregationRequest) SetTitleAggregation(v *TitleAggregation) *AggregationRequest {
	s.TitleAggregation = v
	return s
}

// A structure that contains details about the results of an aggregation type.
type AggregationResponse struct {
	_ struct{} `type:"structure"`

	// An object that contains details about an aggregation response based on Amazon
	// Web Services account IDs.
	AccountAggregation *AccountAggregationResponse `locationName:"accountAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on Amazon
	// Machine Images (AMIs).
	AmiAggregation *AmiAggregationResponse `locationName:"amiAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on Amazon
	// ECR container images.
	AwsEcrContainerAggregation *AwsEcrContainerAggregationResponse `locationName:"awsEcrContainerAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on Amazon
	// EC2 instances.
	Ec2InstanceAggregation *Ec2InstanceAggregationResponse `locationName:"ec2InstanceAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on finding
	// types.
	FindingTypeAggregation *FindingTypeAggregationResponse `locationName:"findingTypeAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on container
	// image layers.
	ImageLayerAggregation *ImageLayerAggregationResponse `locationName:"imageLayerAggregation" type:"structure"`

	// An aggregation of findings by Amazon Web Services Lambda function.
	LambdaFunctionAggregation *LambdaFunctionAggregationResponse `locationName:"lambdaFunctionAggregation" type:"structure"`

	// An aggregation of findings by Amazon Web Services Lambda layer.
	LambdaLayerAggregation *LambdaLayerAggregationResponse `locationName:"lambdaLayerAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on operating
	// system package type.
	PackageAggregation *PackageAggregationResponse `locationName:"packageAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on Amazon
	// ECR repositories.
	RepositoryAggregation *RepositoryAggregationResponse `locationName:"repositoryAggregation" type:"structure"`

	// An object that contains details about an aggregation response based on finding
	// title.
	TitleAggregation *TitleAggregationResponse `locationName:"titleAggregation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationResponse) GoString() string {
	return s.String()
}

// SetAccountAggregation sets the AccountAggregation field's value.
func (s *AggregationResponse) SetAccountAggregation(v *AccountAggregationResponse) *AggregationResponse {
	s.AccountAggregation = v
	return s
}

// SetAmiAggregation sets the AmiAggregation field's value.
func (s *AggregationResponse) SetAmiAggregation(v *AmiAggregationResponse) *AggregationResponse {
	s.AmiAggregation = v
	return s
}

// SetAwsEcrContainerAggregation sets the AwsEcrContainerAggregation field's value.
func (s *AggregationResponse) SetAwsEcrContainerAggregation(v *AwsEcrContainerAggregationResponse) *AggregationResponse {
	s.AwsEcrContainerAggregation = v
	return s
}

// SetEc2InstanceAggregation sets the Ec2InstanceAggregation field's value.
func (s *AggregationResponse) SetEc2InstanceAggregation(v *Ec2InstanceAggregationResponse) *AggregationResponse {
	s.Ec2InstanceAggregation = v
	return s
}

// SetFindingTypeAggregation sets the FindingTypeAggregation field's value.
func (s *AggregationResponse) SetFindingTypeAggregation(v *FindingTypeAggregationResponse) *AggregationResponse {
	s.FindingTypeAggregation = v
	return s
}

// SetImageLayerAggregation sets the ImageLayerAggregation field's value.
func (s *AggregationResponse) SetImageLayerAggregation(v *ImageLayerAggregationResponse) *AggregationResponse {
	s.ImageLayerAggregation = v
	return s
}

// SetLambdaFunctionAggregation sets the LambdaFunctionAggregation field's value.
func (s *AggregationResponse) SetLambdaFunctionAggregation(v *LambdaFunctionAggregationResponse) *AggregationResponse {
	s.LambdaFunctionAggregation = v
	return s
}

// SetLambdaLayerAggregation sets the LambdaLayerAggregation field's value.
func (s *AggregationResponse) SetLambdaLayerAggregation(v *LambdaLayerAggregationResponse) *AggregationResponse {
	s.LambdaLayerAggregation = v
	return s
}

// SetPackageAggregation sets the PackageAggregation field's value.
func (s *AggregationResponse) SetPackageAggregation(v *PackageAggregationResponse) *AggregationResponse {
	s.PackageAggregation = v
	return s
}

// SetRepositoryAggregation sets the RepositoryAggregation field's value.
func (s *AggregationResponse) SetRepositoryAggregation(v *RepositoryAggregationResponse) *AggregationResponse {
	s.RepositoryAggregation = v
	return s
}

// SetTitleAggregation sets the TitleAggregation field's value.
func (s *AggregationResponse) SetTitleAggregation(v *TitleAggregationResponse) *AggregationResponse {
	s.TitleAggregation = v
	return s
}

// The details that define an aggregation based on Amazon machine images (AMIs).
type AmiAggregation struct {
	_ struct{} `type:"structure"`

	// The IDs of AMIs to aggregate findings for.
	Amis []*StringFilter `locationName:"amis" min:"1" type:"list"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"AmiSortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiAggregation"}
	if s.Amis != nil && len(s.Amis) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Amis", 1))
	}
	if s.Amis != nil {
		for i, v := range s.Amis {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Amis", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmis sets the Amis field's value.
func (s *AmiAggregation) SetAmis(v []*StringFilter) *AmiAggregation {
	s.Amis = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *AmiAggregation) SetSortBy(v string) *AmiAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *AmiAggregation) SetSortOrder(v string) *AmiAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of a finding aggregation by AMI.
type AmiAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID for the AMI.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The IDs of Amazon EC2 instances using this AMI.
	AffectedInstances *int64 `locationName:"affectedInstances" type:"long"`

	// The ID of the AMI that findings were aggregated for.
	//
	// Ami is a required field
	Ami *string `locationName:"ami" type:"string" required:"true"`

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AmiAggregationResponse) SetAccountId(v string) *AmiAggregationResponse {
	s.AccountId = &v
	return s
}

// SetAffectedInstances sets the AffectedInstances field's value.
func (s *AmiAggregationResponse) SetAffectedInstances(v int64) *AmiAggregationResponse {
	s.AffectedInstances = &v
	return s
}

// SetAmi sets the Ami field's value.
func (s *AmiAggregationResponse) SetAmi(v string) *AmiAggregationResponse {
	s.Ami = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *AmiAggregationResponse) SetSeverityCounts(v *SeverityCounts) *AmiAggregationResponse {
	s.SeverityCounts = v
	return s
}

type AssociateMemberInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the member account to be associated.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AssociateMemberInput) SetAccountId(v string) *AssociateMemberInput {
	s.AccountId = &v
	return s
}

type AssociateMemberOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the successfully associated member
	// account.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AssociateMemberOutput) SetAccountId(v string) *AssociateMemberOutput {
	s.AccountId = &v
	return s
}

// The Amazon Web Services Threat Intel Group (ATIG) details for a specific
// vulnerability.
type AtigData struct {
	_ struct{} `type:"structure"`

	// The date and time this vulnerability was first observed.
	FirstSeen *time.Time `locationName:"firstSeen" type:"timestamp"`

	// The date and time this vulnerability was last observed.
	LastSeen *time.Time `locationName:"lastSeen" type:"timestamp"`

	// The commercial sectors this vulnerability targets.
	Targets []*string `locationName:"targets" type:"list"`

	// The MITRE ATT&CK (https://attack.mitre.org/) tactics, techniques, and procedures
	// (TTPs) associated with vulnerability.
	Ttps []*string `locationName:"ttps" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AtigData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AtigData) GoString() string {
	return s.String()
}

// SetFirstSeen sets the FirstSeen field's value.
func (s *AtigData) SetFirstSeen(v time.Time) *AtigData {
	s.FirstSeen = &v
	return s
}

// SetLastSeen sets the LastSeen field's value.
func (s *AtigData) SetLastSeen(v time.Time) *AtigData {
	s.LastSeen = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AtigData) SetTargets(v []*string) *AtigData {
	s.Targets = v
	return s
}

// SetTtps sets the Ttps field's value.
func (s *AtigData) SetTtps(v []*string) *AtigData {
	s.Ttps = v
	return s
}

// Represents which scan types are automatically enabled for new members of
// your Amazon Inspector organization.
type AutoEnable struct {
	_ struct{} `type:"structure"`

	// Represents whether Amazon EC2 scans are automatically enabled for new members
	// of your Amazon Inspector organization.
	//
	// Ec2 is a required field
	Ec2 *bool `locationName:"ec2" type:"boolean" required:"true"`

	// Represents whether Amazon ECR scans are automatically enabled for new members
	// of your Amazon Inspector organization.
	//
	// Ecr is a required field
	Ecr *bool `locationName:"ecr" type:"boolean" required:"true"`

	// Represents whether Amazon Web Services Lambda standard scans are automatically
	// enabled for new members of your Amazon Inspector organization.
	Lambda *bool `locationName:"lambda" type:"boolean"`

	LambdaCode *bool `locationName:"lambdaCode" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoEnable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoEnable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoEnable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoEnable"}
	if s.Ec2 == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2"))
	}
	if s.Ecr == nil {
		invalidParams.Add(request.NewErrParamRequired("Ecr"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2 sets the Ec2 field's value.
func (s *AutoEnable) SetEc2(v bool) *AutoEnable {
	s.Ec2 = &v
	return s
}

// SetEcr sets the Ecr field's value.
func (s *AutoEnable) SetEcr(v bool) *AutoEnable {
	s.Ecr = &v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *AutoEnable) SetLambda(v bool) *AutoEnable {
	s.Lambda = &v
	return s
}

// SetLambdaCode sets the LambdaCode field's value.
func (s *AutoEnable) SetLambdaCode(v bool) *AutoEnable {
	s.LambdaCode = &v
	return s
}

// Details of the Amazon EC2 instance involved in a finding.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM instance profile ARN of the Amazon EC2 instance.
	IamInstanceProfileArn *string `locationName:"iamInstanceProfileArn" min:"1" type:"string"`

	// The image ID of the Amazon EC2 instance.
	ImageId *string `locationName:"imageId" min:"1" type:"string"`

	// The IPv4 addresses of the Amazon EC2 instance.
	IpV4Addresses []*string `locationName:"ipV4Addresses" type:"list"`

	// The IPv6 addresses of the Amazon EC2 instance.
	IpV6Addresses []*string `locationName:"ipV6Addresses" type:"list"`

	// The name of the key pair used to launch the Amazon EC2 instance.
	KeyName *string `locationName:"keyName" min:"1" type:"string"`

	// The date and time the Amazon EC2 instance was launched at.
	LaunchedAt *time.Time `locationName:"launchedAt" type:"timestamp"`

	// The platform of the Amazon EC2 instance.
	Platform *string `locationName:"platform" min:"1" type:"string"`

	// The subnet ID of the Amazon EC2 instance.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`

	// The type of the Amazon EC2 instance.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The VPC ID of the Amazon EC2 instance.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEc2InstanceDetails) GoString() string {
	return s.String()
}

// SetIamInstanceProfileArn sets the IamInstanceProfileArn field's value.
func (s *AwsEc2InstanceDetails) SetIamInstanceProfileArn(v string) *AwsEc2InstanceDetails {
	s.IamInstanceProfileArn = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2InstanceDetails) SetImageId(v string) *AwsEc2InstanceDetails {
	s.ImageId = &v
	return s
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV4Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV6Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV6Addresses = v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2InstanceDetails) SetKeyName(v string) *AwsEc2InstanceDetails {
	s.KeyName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *AwsEc2InstanceDetails) SetLaunchedAt(v time.Time) *AwsEc2InstanceDetails {
	s.LaunchedAt = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *AwsEc2InstanceDetails) SetPlatform(v string) *AwsEc2InstanceDetails {
	s.Platform = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2InstanceDetails) SetSubnetId(v string) *AwsEc2InstanceDetails {
	s.SubnetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2InstanceDetails) SetType(v string) *AwsEc2InstanceDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2InstanceDetails) SetVpcId(v string) *AwsEc2InstanceDetails {
	s.VpcId = &v
	return s
}

// An aggregation of information about Amazon ECR containers.
type AwsEcrContainerAggregation struct {
	_ struct{} `type:"structure"`

	// The architecture of the containers.
	Architectures []*StringFilter `locationName:"architectures" min:"1" type:"list"`

	// The image SHA values.
	ImageShas []*StringFilter `locationName:"imageShas" min:"1" type:"list"`

	// The image tags.
	ImageTags []*StringFilter `locationName:"imageTags" min:"1" type:"list"`

	// The container repositories.
	Repositories []*StringFilter `locationName:"repositories" min:"1" type:"list"`

	// The container resource IDs.
	ResourceIds []*StringFilter `locationName:"resourceIds" min:"1" type:"list"`

	// The value to sort by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"AwsEcrContainerSortBy"`

	// The sort order (ascending or descending).
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsEcrContainerAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsEcrContainerAggregation"}
	if s.Architectures != nil && len(s.Architectures) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Architectures", 1))
	}
	if s.ImageShas != nil && len(s.ImageShas) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageShas", 1))
	}
	if s.ImageTags != nil && len(s.ImageTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageTags", 1))
	}
	if s.Repositories != nil && len(s.Repositories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Repositories", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.Architectures != nil {
		for i, v := range s.Architectures {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Architectures", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ImageShas != nil {
		for i, v := range s.ImageShas {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ImageShas", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ImageTags != nil {
		for i, v := range s.ImageTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ImageTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Repositories != nil {
		for i, v := range s.Repositories {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Repositories", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceIds != nil {
		for i, v := range s.ResourceIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchitectures sets the Architectures field's value.
func (s *AwsEcrContainerAggregation) SetArchitectures(v []*StringFilter) *AwsEcrContainerAggregation {
	s.Architectures = v
	return s
}

// SetImageShas sets the ImageShas field's value.
func (s *AwsEcrContainerAggregation) SetImageShas(v []*StringFilter) *AwsEcrContainerAggregation {
	s.ImageShas = v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *AwsEcrContainerAggregation) SetImageTags(v []*StringFilter) *AwsEcrContainerAggregation {
	s.ImageTags = v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *AwsEcrContainerAggregation) SetRepositories(v []*StringFilter) *AwsEcrContainerAggregation {
	s.Repositories = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *AwsEcrContainerAggregation) SetResourceIds(v []*StringFilter) *AwsEcrContainerAggregation {
	s.ResourceIds = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *AwsEcrContainerAggregation) SetSortBy(v string) *AwsEcrContainerAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *AwsEcrContainerAggregation) SetSortOrder(v string) *AwsEcrContainerAggregation {
	s.SortOrder = &v
	return s
}

// An aggregation of information about Amazon ECR containers.
type AwsEcrContainerAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the account that owns the container.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The architecture of the container.
	Architecture *string `locationName:"architecture" type:"string"`

	// The SHA value of the container image.
	ImageSha *string `locationName:"imageSha" type:"string"`

	// The container image stags.
	ImageTags []*string `locationName:"imageTags" type:"list"`

	// The container repository.
	Repository *string `locationName:"repository" type:"string"`

	// The resource ID of the container.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The number of finding by severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AwsEcrContainerAggregationResponse) SetAccountId(v string) *AwsEcrContainerAggregationResponse {
	s.AccountId = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *AwsEcrContainerAggregationResponse) SetArchitecture(v string) *AwsEcrContainerAggregationResponse {
	s.Architecture = &v
	return s
}

// SetImageSha sets the ImageSha field's value.
func (s *AwsEcrContainerAggregationResponse) SetImageSha(v string) *AwsEcrContainerAggregationResponse {
	s.ImageSha = &v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *AwsEcrContainerAggregationResponse) SetImageTags(v []*string) *AwsEcrContainerAggregationResponse {
	s.ImageTags = v
	return s
}

// SetRepository sets the Repository field's value.
func (s *AwsEcrContainerAggregationResponse) SetRepository(v string) *AwsEcrContainerAggregationResponse {
	s.Repository = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AwsEcrContainerAggregationResponse) SetResourceId(v string) *AwsEcrContainerAggregationResponse {
	s.ResourceId = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *AwsEcrContainerAggregationResponse) SetSeverityCounts(v *SeverityCounts) *AwsEcrContainerAggregationResponse {
	s.SeverityCounts = v
	return s
}

// The image details of the Amazon ECR container image.
type AwsEcrContainerImageDetails struct {
	_ struct{} `type:"structure"`

	// The architecture of the Amazon ECR container image.
	Architecture *string `locationName:"architecture" min:"1" type:"string"`

	// The image author of the Amazon ECR container image.
	Author *string `locationName:"author" type:"string"`

	// The image hash of the Amazon ECR container image.
	//
	// ImageHash is a required field
	ImageHash *string `locationName:"imageHash" min:"71" type:"string" required:"true"`

	// The image tags attached to the Amazon ECR container image.
	ImageTags []*string `locationName:"imageTags" type:"list"`

	// The platform of the Amazon ECR container image.
	Platform *string `locationName:"platform" min:"1" type:"string"`

	// The date and time the Amazon ECR container image was pushed.
	PushedAt *time.Time `locationName:"pushedAt" type:"timestamp"`

	// The registry for the Amazon ECR container image.
	//
	// Registry is a required field
	Registry *string `locationName:"registry" min:"1" type:"string" required:"true"`

	// The name of the repository the Amazon ECR container image resides in.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerImageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsEcrContainerImageDetails) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *AwsEcrContainerImageDetails) SetArchitecture(v string) *AwsEcrContainerImageDetails {
	s.Architecture = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *AwsEcrContainerImageDetails) SetAuthor(v string) *AwsEcrContainerImageDetails {
	s.Author = &v
	return s
}

// SetImageHash sets the ImageHash field's value.
func (s *AwsEcrContainerImageDetails) SetImageHash(v string) *AwsEcrContainerImageDetails {
	s.ImageHash = &v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *AwsEcrContainerImageDetails) SetImageTags(v []*string) *AwsEcrContainerImageDetails {
	s.ImageTags = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *AwsEcrContainerImageDetails) SetPlatform(v string) *AwsEcrContainerImageDetails {
	s.Platform = &v
	return s
}

// SetPushedAt sets the PushedAt field's value.
func (s *AwsEcrContainerImageDetails) SetPushedAt(v time.Time) *AwsEcrContainerImageDetails {
	s.PushedAt = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *AwsEcrContainerImageDetails) SetRegistry(v string) *AwsEcrContainerImageDetails {
	s.Registry = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *AwsEcrContainerImageDetails) SetRepositoryName(v string) *AwsEcrContainerImageDetails {
	s.RepositoryName = &v
	return s
}

// A summary of information about the Amazon Web Services Lambda function.
type AwsLambdaFunctionDetails struct {
	_ struct{} `type:"structure"`

	// The instruction set architecture that the Amazon Web Services Lambda function
	// supports. Architecture is a string array with one of the valid values. The
	// default architecture value is x86_64.
	Architectures []*string `locationName:"architectures" min:"1" type:"list" enum:"Architecture"`

	// The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
	//
	// CodeSha256 is a required field
	CodeSha256 *string `locationName:"codeSha256" min:"1" type:"string" required:"true"`

	// The Amazon Web Services Lambda function's execution role.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The name of the Amazon Web Services Lambda function.
	//
	// FunctionName is a required field
	FunctionName *string `locationName:"functionName" type:"string" required:"true"`

	// The date and time that a user last updated the configuration, in ISO 8601
	// format (https://www.iso.org/iso-8601-date-and-time-format.html)
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp"`

	// The Amazon Web Services Lambda function's layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
	// A Lambda function can have up to five layers.
	Layers []*string `locationName:"layers" min:"1" type:"list"`

	// The type of deployment package. Set to Image for container image and set
	// Zip for .zip file archive.
	PackageType *string `locationName:"packageType" type:"string" enum:"PackageType"`

	// The runtime environment for the Amazon Web Services Lambda function.
	//
	// Runtime is a required field
	Runtime *string `locationName:"runtime" type:"string" required:"true" enum:"Runtime"`

	// The version of the Amazon Web Services Lambda function.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`

	// The Amazon Web Services Lambda function's networking configuration.
	VpcConfig *LambdaVpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaFunctionDetails) GoString() string {
	return s.String()
}

// SetArchitectures sets the Architectures field's value.
func (s *AwsLambdaFunctionDetails) SetArchitectures(v []*string) *AwsLambdaFunctionDetails {
	s.Architectures = v
	return s
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *AwsLambdaFunctionDetails) SetCodeSha256(v string) *AwsLambdaFunctionDetails {
	s.CodeSha256 = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *AwsLambdaFunctionDetails) SetExecutionRoleArn(v string) *AwsLambdaFunctionDetails {
	s.ExecutionRoleArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AwsLambdaFunctionDetails) SetFunctionName(v string) *AwsLambdaFunctionDetails {
	s.FunctionName = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *AwsLambdaFunctionDetails) SetLastModifiedAt(v time.Time) *AwsLambdaFunctionDetails {
	s.LastModifiedAt = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *AwsLambdaFunctionDetails) SetLayers(v []*string) *AwsLambdaFunctionDetails {
	s.Layers = v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *AwsLambdaFunctionDetails) SetPackageType(v string) *AwsLambdaFunctionDetails {
	s.PackageType = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *AwsLambdaFunctionDetails) SetRuntime(v string) *AwsLambdaFunctionDetails {
	s.Runtime = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaFunctionDetails) SetVersion(v string) *AwsLambdaFunctionDetails {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsLambdaFunctionDetails) SetVpcConfig(v *LambdaVpcConfig) *AwsLambdaFunctionDetails {
	s.VpcConfig = v
	return s
}

// One or more tags submitted as part of the request is not valid.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchGetAccountStatusInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit Amazon Web Services account IDs of the accounts to retrieve
	// Amazon Inspector status for.
	AccountIds []*string `locationName:"accountIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAccountStatusInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchGetAccountStatusInput) SetAccountIds(v []*string) *BatchGetAccountStatusInput {
	s.AccountIds = v
	return s
}

type BatchGetAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that provide details on the status of Amazon Inspector
	// for each of the requested accounts.
	//
	// Accounts is a required field
	Accounts []*AccountState `locationName:"accounts" type:"list" required:"true"`

	// An array of objects detailing any accounts that failed to enable Amazon Inspector
	// and why.
	FailedAccounts []*FailedAccount `locationName:"failedAccounts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAccountStatusOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *BatchGetAccountStatusOutput) SetAccounts(v []*AccountState) *BatchGetAccountStatusOutput {
	s.Accounts = v
	return s
}

// SetFailedAccounts sets the FailedAccounts field's value.
func (s *BatchGetAccountStatusOutput) SetFailedAccounts(v []*FailedAccount) *BatchGetAccountStatusOutput {
	s.FailedAccounts = v
	return s
}

type BatchGetCodeSnippetInput struct {
	_ struct{} `type:"structure"`

	// An array of finding ARNs for the findings you want to retrieve code snippets
	// from.
	//
	// FindingArns is a required field
	FindingArns []*string `locationName:"findingArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCodeSnippetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCodeSnippetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetCodeSnippetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetCodeSnippetInput"}
	if s.FindingArns == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingArns"))
	}
	if s.FindingArns != nil && len(s.FindingArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingArns sets the FindingArns field's value.
func (s *BatchGetCodeSnippetInput) SetFindingArns(v []*string) *BatchGetCodeSnippetInput {
	s.FindingArns = v
	return s
}

type BatchGetCodeSnippetOutput struct {
	_ struct{} `type:"structure"`

	// The retrieved code snippets associated with the provided finding ARNs.
	CodeSnippetResults []*CodeSnippetResult `locationName:"codeSnippetResults" type:"list"`

	// Any errors Amazon Inspector encountered while trying to retrieve the requested
	// code snippets.
	Errors []*CodeSnippetError `locationName:"errors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCodeSnippetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCodeSnippetOutput) GoString() string {
	return s.String()
}

// SetCodeSnippetResults sets the CodeSnippetResults field's value.
func (s *BatchGetCodeSnippetOutput) SetCodeSnippetResults(v []*CodeSnippetResult) *BatchGetCodeSnippetOutput {
	s.CodeSnippetResults = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetCodeSnippetOutput) SetErrors(v []*CodeSnippetError) *BatchGetCodeSnippetOutput {
	s.Errors = v
	return s
}

type BatchGetFindingDetailsInput struct {
	_ struct{} `type:"structure"`

	// A list of finding ARNs.
	//
	// FindingArns is a required field
	FindingArns []*string `locationName:"findingArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetFindingDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetFindingDetailsInput"}
	if s.FindingArns == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingArns"))
	}
	if s.FindingArns != nil && len(s.FindingArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingArns sets the FindingArns field's value.
func (s *BatchGetFindingDetailsInput) SetFindingArns(v []*string) *BatchGetFindingDetailsInput {
	s.FindingArns = v
	return s
}

type BatchGetFindingDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Error information for findings that details could not be returned for.
	Errors []*FindingDetailsError `locationName:"errors" type:"list"`

	// A finding's vulnerability details.
	FindingDetails []*FindingDetail `locationName:"findingDetails" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingDetailsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetFindingDetailsOutput) SetErrors(v []*FindingDetailsError) *BatchGetFindingDetailsOutput {
	s.Errors = v
	return s
}

// SetFindingDetails sets the FindingDetails field's value.
func (s *BatchGetFindingDetailsOutput) SetFindingDetails(v []*FindingDetail) *BatchGetFindingDetailsOutput {
	s.FindingDetails = v
	return s
}

type BatchGetFreeTrialInfoInput struct {
	_ struct{} `type:"structure"`

	// The account IDs to get free trial status for.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFreeTrialInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFreeTrialInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetFreeTrialInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetFreeTrialInfoInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchGetFreeTrialInfoInput) SetAccountIds(v []*string) *BatchGetFreeTrialInfoInput {
	s.AccountIds = v
	return s
}

type BatchGetFreeTrialInfoOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that provide Amazon Inspector free trial details for
	// each of the requested accounts.
	//
	// Accounts is a required field
	Accounts []*FreeTrialAccountInfo `locationName:"accounts" type:"list" required:"true"`

	// An array of objects detailing any accounts that free trial data could not
	// be returned for.
	//
	// FailedAccounts is a required field
	FailedAccounts []*FreeTrialInfoError `locationName:"failedAccounts" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFreeTrialInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFreeTrialInfoOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *BatchGetFreeTrialInfoOutput) SetAccounts(v []*FreeTrialAccountInfo) *BatchGetFreeTrialInfoOutput {
	s.Accounts = v
	return s
}

// SetFailedAccounts sets the FailedAccounts field's value.
func (s *BatchGetFreeTrialInfoOutput) SetFailedAccounts(v []*FreeTrialInfoError) *BatchGetFreeTrialInfoOutput {
	s.FailedAccounts = v
	return s
}

type BatchGetMemberEc2DeepInspectionStatusInput struct {
	_ struct{} `type:"structure"`

	AccountIds []*string `locationName:"accountIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMemberEc2DeepInspectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMemberEc2DeepInspectionStatusInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchGetMemberEc2DeepInspectionStatusInput) SetAccountIds(v []*string) *BatchGetMemberEc2DeepInspectionStatusInput {
	s.AccountIds = v
	return s
}

type BatchGetMemberEc2DeepInspectionStatusOutput struct {
	_ struct{} `type:"structure"`

	AccountIds []*MemberAccountEc2DeepInspectionStatusState `locationName:"accountIds" type:"list"`

	FailedAccountIds []*FailedMemberAccountEc2DeepInspectionStatusState `locationName:"failedAccountIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMemberEc2DeepInspectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMemberEc2DeepInspectionStatusOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchGetMemberEc2DeepInspectionStatusOutput) SetAccountIds(v []*MemberAccountEc2DeepInspectionStatusState) *BatchGetMemberEc2DeepInspectionStatusOutput {
	s.AccountIds = v
	return s
}

// SetFailedAccountIds sets the FailedAccountIds field's value.
func (s *BatchGetMemberEc2DeepInspectionStatusOutput) SetFailedAccountIds(v []*FailedMemberAccountEc2DeepInspectionStatusState) *BatchGetMemberEc2DeepInspectionStatusOutput {
	s.FailedAccountIds = v
	return s
}

type BatchUpdateMemberEc2DeepInspectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The unique identifiers for the Amazon Web Services accounts to change Amazon
	// Inspector deep inspection status for.
	//
	// AccountIds is a required field
	AccountIds []*MemberAccountEc2DeepInspectionStatus `locationName:"accountIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateMemberEc2DeepInspectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateMemberEc2DeepInspectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateMemberEc2DeepInspectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateMemberEc2DeepInspectionStatusInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil {
		for i, v := range s.AccountIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchUpdateMemberEc2DeepInspectionStatusInput) SetAccountIds(v []*MemberAccountEc2DeepInspectionStatus) *BatchUpdateMemberEc2DeepInspectionStatusInput {
	s.AccountIds = v
	return s
}

type BatchUpdateMemberEc2DeepInspectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that provide details for each of the accounts that Amazon
	// Inspector deep inspection status was successfully changed for.
	AccountIds []*MemberAccountEc2DeepInspectionStatusState `locationName:"accountIds" type:"list"`

	// An array of objects that provide details for each of the accounts that Amazon
	// Inspector deep inspection status could not be successfully changed for.
	FailedAccountIds []*FailedMemberAccountEc2DeepInspectionStatusState `locationName:"failedAccountIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateMemberEc2DeepInspectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateMemberEc2DeepInspectionStatusOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchUpdateMemberEc2DeepInspectionStatusOutput) SetAccountIds(v []*MemberAccountEc2DeepInspectionStatusState) *BatchUpdateMemberEc2DeepInspectionStatusOutput {
	s.AccountIds = v
	return s
}

// SetFailedAccountIds sets the FailedAccountIds field's value.
func (s *BatchUpdateMemberEc2DeepInspectionStatusOutput) SetFailedAccountIds(v []*FailedMemberAccountEc2DeepInspectionStatusState) *BatchUpdateMemberEc2DeepInspectionStatusOutput {
	s.FailedAccountIds = v
	return s
}

type CancelFindingsReportInput struct {
	_ struct{} `type:"structure"`

	// The ID of the report to be canceled.
	//
	// ReportId is a required field
	ReportId *string `locationName:"reportId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelFindingsReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelFindingsReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelFindingsReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelFindingsReportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *CancelFindingsReportInput) SetReportId(v string) *CancelFindingsReportInput {
	s.ReportId = &v
	return s
}

type CancelFindingsReportOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the canceled report.
	//
	// ReportId is a required field
	ReportId *string `locationName:"reportId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelFindingsReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelFindingsReportOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *CancelFindingsReportOutput) SetReportId(v string) *CancelFindingsReportOutput {
	s.ReportId = &v
	return s
}

type CancelSbomExportInput struct {
	_ struct{} `type:"structure"`

	// The report ID of the SBOM export to cancel.
	//
	// ReportId is a required field
	ReportId *string `locationName:"reportId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSbomExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSbomExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSbomExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSbomExportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *CancelSbomExportInput) SetReportId(v string) *CancelSbomExportInput {
	s.ReportId = &v
	return s
}

type CancelSbomExportOutput struct {
	_ struct{} `type:"structure"`

	// The report ID of the canceled SBOM export.
	ReportId *string `locationName:"reportId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSbomExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSbomExportOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *CancelSbomExportOutput) SetReportId(v string) *CancelSbomExportOutput {
	s.ReportId = &v
	return s
}

// A CIS check.
type CisCheckAggregation struct {
	_ struct{} `type:"structure"`

	// The account ID for the CIS check.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The description for the CIS check.
	CheckDescription *string `locationName:"checkDescription" type:"string"`

	// The check ID for the CIS check.
	CheckId *string `locationName:"checkId" type:"string"`

	// The CIS check level.
	Level *string `locationName:"level" type:"string" enum:"CisSecurityLevel"`

	// The CIS check platform.
	Platform *string `locationName:"platform" type:"string"`

	// The scan ARN for the CIS check scan ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The CIS check status counts.
	StatusCounts *StatusCounts `locationName:"statusCounts" type:"structure"`

	// The CIS check title.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisCheckAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisCheckAggregation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CisCheckAggregation) SetAccountId(v string) *CisCheckAggregation {
	s.AccountId = &v
	return s
}

// SetCheckDescription sets the CheckDescription field's value.
func (s *CisCheckAggregation) SetCheckDescription(v string) *CisCheckAggregation {
	s.CheckDescription = &v
	return s
}

// SetCheckId sets the CheckId field's value.
func (s *CisCheckAggregation) SetCheckId(v string) *CisCheckAggregation {
	s.CheckId = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *CisCheckAggregation) SetLevel(v string) *CisCheckAggregation {
	s.Level = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *CisCheckAggregation) SetPlatform(v string) *CisCheckAggregation {
	s.Platform = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *CisCheckAggregation) SetScanArn(v string) *CisCheckAggregation {
	s.ScanArn = &v
	return s
}

// SetStatusCounts sets the StatusCounts field's value.
func (s *CisCheckAggregation) SetStatusCounts(v *StatusCounts) *CisCheckAggregation {
	s.StatusCounts = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CisCheckAggregation) SetTitle(v string) *CisCheckAggregation {
	s.Title = &v
	return s
}

// The CIS date filter.
type CisDateFilter struct {
	_ struct{} `type:"structure"`

	// The CIS date filter's earliest scan start time.
	EarliestScanStartTime *time.Time `locationName:"earliestScanStartTime" type:"timestamp"`

	// The CIS date filter's latest scan start time.
	LatestScanStartTime *time.Time `locationName:"latestScanStartTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisDateFilter) GoString() string {
	return s.String()
}

// SetEarliestScanStartTime sets the EarliestScanStartTime field's value.
func (s *CisDateFilter) SetEarliestScanStartTime(v time.Time) *CisDateFilter {
	s.EarliestScanStartTime = &v
	return s
}

// SetLatestScanStartTime sets the LatestScanStartTime field's value.
func (s *CisDateFilter) SetLatestScanStartTime(v time.Time) *CisDateFilter {
	s.LatestScanStartTime = &v
	return s
}

// The CIS finding status filter.
type CisFindingStatusFilter struct {
	_ struct{} `type:"structure"`

	// The comparison value of the CIS finding status filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisFindingStatusComparison"`

	// The value of the CIS finding status filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" enum:"CisFindingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisFindingStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisFindingStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisFindingStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisFindingStatusFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisFindingStatusFilter) SetComparison(v string) *CisFindingStatusFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisFindingStatusFilter) SetValue(v string) *CisFindingStatusFilter {
	s.Value = &v
	return s
}

// The CIS number filter.
type CisNumberFilter struct {
	_ struct{} `type:"structure"`

	// The CIS number filter's lower inclusive.
	LowerInclusive *int64 `locationName:"lowerInclusive" type:"integer"`

	// The CIS number filter's upper inclusive.
	UpperInclusive *int64 `locationName:"upperInclusive" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisNumberFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisNumberFilter) GoString() string {
	return s.String()
}

// SetLowerInclusive sets the LowerInclusive field's value.
func (s *CisNumberFilter) SetLowerInclusive(v int64) *CisNumberFilter {
	s.LowerInclusive = &v
	return s
}

// SetUpperInclusive sets the UpperInclusive field's value.
func (s *CisNumberFilter) SetUpperInclusive(v int64) *CisNumberFilter {
	s.UpperInclusive = &v
	return s
}

// The CIS result status filter.
type CisResultStatusFilter struct {
	_ struct{} `type:"structure"`

	// The comparison value of the CIS result status filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisResultStatusComparison"`

	// The value of the CIS result status filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" enum:"CisResultStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisResultStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisResultStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisResultStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisResultStatusFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisResultStatusFilter) SetComparison(v string) *CisResultStatusFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisResultStatusFilter) SetValue(v string) *CisResultStatusFilter {
	s.Value = &v
	return s
}

// The CIS scan.
type CisScan struct {
	_ struct{} `type:"structure"`

	// The CIS scan's failed checks.
	FailedChecks *int64 `locationName:"failedChecks" type:"integer"`

	// The CIS scan's ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The CIS scan's configuration ARN.
	//
	// ScanConfigurationArn is a required field
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string" required:"true"`

	// The CIS scan's date.
	ScanDate *time.Time `locationName:"scanDate" type:"timestamp"`

	// The the name of the scan configuration that's associated with this scan.
	ScanName *string `locationName:"scanName" min:"1" type:"string"`

	// The account or organization that schedules the CIS scan.
	ScheduledBy *string `locationName:"scheduledBy" type:"string"`

	// The security level for the CIS scan. Security level refers to the Benchmark
	// levels that CIS assigns to a profile.
	SecurityLevel *string `locationName:"securityLevel" type:"string" enum:"CisSecurityLevel"`

	// The CIS scan's status.
	Status *string `locationName:"status" type:"string" enum:"CisScanStatus"`

	// The CIS scan's targets.
	Targets *CisTargets `locationName:"targets" type:"structure"`

	// The CIS scan's total checks.
	TotalChecks *int64 `locationName:"totalChecks" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScan) GoString() string {
	return s.String()
}

// SetFailedChecks sets the FailedChecks field's value.
func (s *CisScan) SetFailedChecks(v int64) *CisScan {
	s.FailedChecks = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *CisScan) SetScanArn(v string) *CisScan {
	s.ScanArn = &v
	return s
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *CisScan) SetScanConfigurationArn(v string) *CisScan {
	s.ScanConfigurationArn = &v
	return s
}

// SetScanDate sets the ScanDate field's value.
func (s *CisScan) SetScanDate(v time.Time) *CisScan {
	s.ScanDate = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *CisScan) SetScanName(v string) *CisScan {
	s.ScanName = &v
	return s
}

// SetScheduledBy sets the ScheduledBy field's value.
func (s *CisScan) SetScheduledBy(v string) *CisScan {
	s.ScheduledBy = &v
	return s
}

// SetSecurityLevel sets the SecurityLevel field's value.
func (s *CisScan) SetSecurityLevel(v string) *CisScan {
	s.SecurityLevel = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CisScan) SetStatus(v string) *CisScan {
	s.Status = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CisScan) SetTargets(v *CisTargets) *CisScan {
	s.Targets = v
	return s
}

// SetTotalChecks sets the TotalChecks field's value.
func (s *CisScan) SetTotalChecks(v int64) *CisScan {
	s.TotalChecks = &v
	return s
}

// The CIS scan configuration.
type CisScanConfiguration struct {
	_ struct{} `type:"structure"`

	// The CIS scan configuration's owner ID.
	OwnerId *string `locationName:"ownerId" type:"string"`

	// The CIS scan configuration's scan configuration ARN.
	//
	// ScanConfigurationArn is a required field
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string" required:"true"`

	// The name of the CIS scan configuration.
	ScanName *string `locationName:"scanName" min:"1" type:"string"`

	// The CIS scan configuration's schedule.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The CIS scan configuration's security level.
	SecurityLevel *string `locationName:"securityLevel" type:"string" enum:"CisSecurityLevel"`

	// The CIS scan configuration's tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The CIS scan configuration's targets.
	Targets *CisTargets `locationName:"targets" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanConfiguration) GoString() string {
	return s.String()
}

// SetOwnerId sets the OwnerId field's value.
func (s *CisScanConfiguration) SetOwnerId(v string) *CisScanConfiguration {
	s.OwnerId = &v
	return s
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *CisScanConfiguration) SetScanConfigurationArn(v string) *CisScanConfiguration {
	s.ScanConfigurationArn = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *CisScanConfiguration) SetScanName(v string) *CisScanConfiguration {
	s.ScanName = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CisScanConfiguration) SetSchedule(v *Schedule) *CisScanConfiguration {
	s.Schedule = v
	return s
}

// SetSecurityLevel sets the SecurityLevel field's value.
func (s *CisScanConfiguration) SetSecurityLevel(v string) *CisScanConfiguration {
	s.SecurityLevel = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CisScanConfiguration) SetTags(v map[string]*string) *CisScanConfiguration {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CisScanConfiguration) SetTargets(v *CisTargets) *CisScanConfiguration {
	s.Targets = v
	return s
}

// The CIS scan result details.
type CisScanResultDetails struct {
	_ struct{} `type:"structure"`

	// The CIS scan result details' account ID.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The account ID that's associated with the CIS scan result details.
	CheckDescription *string `locationName:"checkDescription" type:"string"`

	// The CIS scan result details' check ID.
	CheckId *string `locationName:"checkId" type:"string"`

	// The CIS scan result details' finding ARN.
	FindingArn *string `locationName:"findingArn" type:"string"`

	// The CIS scan result details' level.
	Level *string `locationName:"level" type:"string" enum:"CisSecurityLevel"`

	// The CIS scan result details' platform.
	Platform *string `locationName:"platform" type:"string"`

	// The CIS scan result details' remediation.
	Remediation *string `locationName:"remediation" type:"string"`

	// The CIS scan result details' scan ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The CIS scan result details' status.
	Status *string `locationName:"status" type:"string" enum:"CisFindingStatus"`

	// The CIS scan result details' status reason.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The CIS scan result details' target resource ID.
	TargetResourceId *string `locationName:"targetResourceId" min:"10" type:"string"`

	// The CIS scan result details' title.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultDetails) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CisScanResultDetails) SetAccountId(v string) *CisScanResultDetails {
	s.AccountId = &v
	return s
}

// SetCheckDescription sets the CheckDescription field's value.
func (s *CisScanResultDetails) SetCheckDescription(v string) *CisScanResultDetails {
	s.CheckDescription = &v
	return s
}

// SetCheckId sets the CheckId field's value.
func (s *CisScanResultDetails) SetCheckId(v string) *CisScanResultDetails {
	s.CheckId = &v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *CisScanResultDetails) SetFindingArn(v string) *CisScanResultDetails {
	s.FindingArn = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *CisScanResultDetails) SetLevel(v string) *CisScanResultDetails {
	s.Level = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *CisScanResultDetails) SetPlatform(v string) *CisScanResultDetails {
	s.Platform = &v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *CisScanResultDetails) SetRemediation(v string) *CisScanResultDetails {
	s.Remediation = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *CisScanResultDetails) SetScanArn(v string) *CisScanResultDetails {
	s.ScanArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CisScanResultDetails) SetStatus(v string) *CisScanResultDetails {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *CisScanResultDetails) SetStatusReason(v string) *CisScanResultDetails {
	s.StatusReason = &v
	return s
}

// SetTargetResourceId sets the TargetResourceId field's value.
func (s *CisScanResultDetails) SetTargetResourceId(v string) *CisScanResultDetails {
	s.TargetResourceId = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CisScanResultDetails) SetTitle(v string) *CisScanResultDetails {
	s.Title = &v
	return s
}

// The CIS scan result details filter criteria.
type CisScanResultDetailsFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The criteria's check ID filters.
	CheckIdFilters []*CisStringFilter `locationName:"checkIdFilters" min:"1" type:"list"`

	// The criteria's finding ARN filters.
	FindingArnFilters []*CisStringFilter `locationName:"findingArnFilters" min:"1" type:"list"`

	// The criteria's finding status filters.
	FindingStatusFilters []*CisFindingStatusFilter `locationName:"findingStatusFilters" min:"1" type:"list"`

	// The criteria's security level filters. . Security level refers to the Benchmark
	// levels that CIS assigns to a profile.
	SecurityLevelFilters []*CisSecurityLevelFilter `locationName:"securityLevelFilters" min:"1" type:"list"`

	// The criteria's title filters.
	TitleFilters []*CisStringFilter `locationName:"titleFilters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultDetailsFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultDetailsFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisScanResultDetailsFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisScanResultDetailsFilterCriteria"}
	if s.CheckIdFilters != nil && len(s.CheckIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CheckIdFilters", 1))
	}
	if s.FindingArnFilters != nil && len(s.FindingArnFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArnFilters", 1))
	}
	if s.FindingStatusFilters != nil && len(s.FindingStatusFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingStatusFilters", 1))
	}
	if s.SecurityLevelFilters != nil && len(s.SecurityLevelFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityLevelFilters", 1))
	}
	if s.TitleFilters != nil && len(s.TitleFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TitleFilters", 1))
	}
	if s.CheckIdFilters != nil {
		for i, v := range s.CheckIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CheckIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FindingArnFilters != nil {
		for i, v := range s.FindingArnFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingArnFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FindingStatusFilters != nil {
		for i, v := range s.FindingStatusFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingStatusFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecurityLevelFilters != nil {
		for i, v := range s.SecurityLevelFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecurityLevelFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TitleFilters != nil {
		for i, v := range s.TitleFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TitleFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckIdFilters sets the CheckIdFilters field's value.
func (s *CisScanResultDetailsFilterCriteria) SetCheckIdFilters(v []*CisStringFilter) *CisScanResultDetailsFilterCriteria {
	s.CheckIdFilters = v
	return s
}

// SetFindingArnFilters sets the FindingArnFilters field's value.
func (s *CisScanResultDetailsFilterCriteria) SetFindingArnFilters(v []*CisStringFilter) *CisScanResultDetailsFilterCriteria {
	s.FindingArnFilters = v
	return s
}

// SetFindingStatusFilters sets the FindingStatusFilters field's value.
func (s *CisScanResultDetailsFilterCriteria) SetFindingStatusFilters(v []*CisFindingStatusFilter) *CisScanResultDetailsFilterCriteria {
	s.FindingStatusFilters = v
	return s
}

// SetSecurityLevelFilters sets the SecurityLevelFilters field's value.
func (s *CisScanResultDetailsFilterCriteria) SetSecurityLevelFilters(v []*CisSecurityLevelFilter) *CisScanResultDetailsFilterCriteria {
	s.SecurityLevelFilters = v
	return s
}

// SetTitleFilters sets the TitleFilters field's value.
func (s *CisScanResultDetailsFilterCriteria) SetTitleFilters(v []*CisStringFilter) *CisScanResultDetailsFilterCriteria {
	s.TitleFilters = v
	return s
}

// The scan results aggregated by checks filter criteria.
type CisScanResultsAggregatedByChecksFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The criteria's account ID filters.
	AccountIdFilters []*CisStringFilter `locationName:"accountIdFilters" min:"1" type:"list"`

	// The criteria's check ID filters.
	CheckIdFilters []*CisStringFilter `locationName:"checkIdFilters" min:"1" type:"list"`

	// The criteria's failed resources filters.
	FailedResourcesFilters []*CisNumberFilter `locationName:"failedResourcesFilters" min:"1" type:"list"`

	// The criteria's platform filters.
	PlatformFilters []*CisStringFilter `locationName:"platformFilters" min:"1" type:"list"`

	// The criteria's security level filters.
	SecurityLevelFilters []*CisSecurityLevelFilter `locationName:"securityLevelFilters" min:"1" type:"list"`

	// The criteria's title filters.
	TitleFilters []*CisStringFilter `locationName:"titleFilters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultsAggregatedByChecksFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultsAggregatedByChecksFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisScanResultsAggregatedByChecksFilterCriteria"}
	if s.AccountIdFilters != nil && len(s.AccountIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIdFilters", 1))
	}
	if s.CheckIdFilters != nil && len(s.CheckIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CheckIdFilters", 1))
	}
	if s.FailedResourcesFilters != nil && len(s.FailedResourcesFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FailedResourcesFilters", 1))
	}
	if s.PlatformFilters != nil && len(s.PlatformFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlatformFilters", 1))
	}
	if s.SecurityLevelFilters != nil && len(s.SecurityLevelFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityLevelFilters", 1))
	}
	if s.TitleFilters != nil && len(s.TitleFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TitleFilters", 1))
	}
	if s.AccountIdFilters != nil {
		for i, v := range s.AccountIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CheckIdFilters != nil {
		for i, v := range s.CheckIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CheckIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PlatformFilters != nil {
		for i, v := range s.PlatformFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlatformFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SecurityLevelFilters != nil {
		for i, v := range s.SecurityLevelFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SecurityLevelFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TitleFilters != nil {
		for i, v := range s.TitleFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TitleFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIdFilters sets the AccountIdFilters field's value.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) SetAccountIdFilters(v []*CisStringFilter) *CisScanResultsAggregatedByChecksFilterCriteria {
	s.AccountIdFilters = v
	return s
}

// SetCheckIdFilters sets the CheckIdFilters field's value.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) SetCheckIdFilters(v []*CisStringFilter) *CisScanResultsAggregatedByChecksFilterCriteria {
	s.CheckIdFilters = v
	return s
}

// SetFailedResourcesFilters sets the FailedResourcesFilters field's value.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) SetFailedResourcesFilters(v []*CisNumberFilter) *CisScanResultsAggregatedByChecksFilterCriteria {
	s.FailedResourcesFilters = v
	return s
}

// SetPlatformFilters sets the PlatformFilters field's value.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) SetPlatformFilters(v []*CisStringFilter) *CisScanResultsAggregatedByChecksFilterCriteria {
	s.PlatformFilters = v
	return s
}

// SetSecurityLevelFilters sets the SecurityLevelFilters field's value.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) SetSecurityLevelFilters(v []*CisSecurityLevelFilter) *CisScanResultsAggregatedByChecksFilterCriteria {
	s.SecurityLevelFilters = v
	return s
}

// SetTitleFilters sets the TitleFilters field's value.
func (s *CisScanResultsAggregatedByChecksFilterCriteria) SetTitleFilters(v []*CisStringFilter) *CisScanResultsAggregatedByChecksFilterCriteria {
	s.TitleFilters = v
	return s
}

// The scan results aggregated by target resource filter criteria.
type CisScanResultsAggregatedByTargetResourceFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The criteria's account ID filters.
	AccountIdFilters []*CisStringFilter `locationName:"accountIdFilters" min:"1" type:"list"`

	// The criteria's check ID filters.
	CheckIdFilters []*CisStringFilter `locationName:"checkIdFilters" min:"1" type:"list"`

	// The criteria's failed checks filters.
	FailedChecksFilters []*CisNumberFilter `locationName:"failedChecksFilters" min:"1" type:"list"`

	// The criteria's platform filters.
	PlatformFilters []*CisStringFilter `locationName:"platformFilters" min:"1" type:"list"`

	// The criteria's status filter.
	StatusFilters []*CisResultStatusFilter `locationName:"statusFilters" min:"1" type:"list"`

	// The criteria's target resource ID filters.
	TargetResourceIdFilters []*CisStringFilter `locationName:"targetResourceIdFilters" min:"1" type:"list"`

	// The criteria's target resource tag filters.
	TargetResourceTagFilters []*TagFilter `locationName:"targetResourceTagFilters" min:"1" type:"list"`

	// The criteria's target status filters.
	TargetStatusFilters []*CisTargetStatusFilter `locationName:"targetStatusFilters" min:"1" type:"list"`

	// The criteria's target status reason filters.
	TargetStatusReasonFilters []*CisTargetStatusReasonFilter `locationName:"targetStatusReasonFilters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultsAggregatedByTargetResourceFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanResultsAggregatedByTargetResourceFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisScanResultsAggregatedByTargetResourceFilterCriteria"}
	if s.AccountIdFilters != nil && len(s.AccountIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIdFilters", 1))
	}
	if s.CheckIdFilters != nil && len(s.CheckIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CheckIdFilters", 1))
	}
	if s.FailedChecksFilters != nil && len(s.FailedChecksFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FailedChecksFilters", 1))
	}
	if s.PlatformFilters != nil && len(s.PlatformFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlatformFilters", 1))
	}
	if s.StatusFilters != nil && len(s.StatusFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilters", 1))
	}
	if s.TargetResourceIdFilters != nil && len(s.TargetResourceIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceIdFilters", 1))
	}
	if s.TargetResourceTagFilters != nil && len(s.TargetResourceTagFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceTagFilters", 1))
	}
	if s.TargetStatusFilters != nil && len(s.TargetStatusFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetStatusFilters", 1))
	}
	if s.TargetStatusReasonFilters != nil && len(s.TargetStatusReasonFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetStatusReasonFilters", 1))
	}
	if s.AccountIdFilters != nil {
		for i, v := range s.AccountIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CheckIdFilters != nil {
		for i, v := range s.CheckIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CheckIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PlatformFilters != nil {
		for i, v := range s.PlatformFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlatformFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatusFilters != nil {
		for i, v := range s.StatusFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatusFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetResourceIdFilters != nil {
		for i, v := range s.TargetResourceIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetResourceIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetResourceTagFilters != nil {
		for i, v := range s.TargetResourceTagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetResourceTagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetStatusFilters != nil {
		for i, v := range s.TargetStatusFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetStatusFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetStatusReasonFilters != nil {
		for i, v := range s.TargetStatusReasonFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetStatusReasonFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIdFilters sets the AccountIdFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetAccountIdFilters(v []*CisStringFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.AccountIdFilters = v
	return s
}

// SetCheckIdFilters sets the CheckIdFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetCheckIdFilters(v []*CisStringFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.CheckIdFilters = v
	return s
}

// SetFailedChecksFilters sets the FailedChecksFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetFailedChecksFilters(v []*CisNumberFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.FailedChecksFilters = v
	return s
}

// SetPlatformFilters sets the PlatformFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetPlatformFilters(v []*CisStringFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.PlatformFilters = v
	return s
}

// SetStatusFilters sets the StatusFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetStatusFilters(v []*CisResultStatusFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.StatusFilters = v
	return s
}

// SetTargetResourceIdFilters sets the TargetResourceIdFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetTargetResourceIdFilters(v []*CisStringFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.TargetResourceIdFilters = v
	return s
}

// SetTargetResourceTagFilters sets the TargetResourceTagFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetTargetResourceTagFilters(v []*TagFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.TargetResourceTagFilters = v
	return s
}

// SetTargetStatusFilters sets the TargetStatusFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetTargetStatusFilters(v []*CisTargetStatusFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.TargetStatusFilters = v
	return s
}

// SetTargetStatusReasonFilters sets the TargetStatusReasonFilters field's value.
func (s *CisScanResultsAggregatedByTargetResourceFilterCriteria) SetTargetStatusReasonFilters(v []*CisTargetStatusReasonFilter) *CisScanResultsAggregatedByTargetResourceFilterCriteria {
	s.TargetStatusReasonFilters = v
	return s
}

// The CIS scan status filter.
type CisScanStatusFilter struct {
	_ struct{} `type:"structure"`

	// The filter comparison value.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisScanStatusComparison"`

	// The filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" enum:"CisScanStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisScanStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisScanStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisScanStatusFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisScanStatusFilter) SetComparison(v string) *CisScanStatusFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisScanStatusFilter) SetValue(v string) *CisScanStatusFilter {
	s.Value = &v
	return s
}

// The CIS security level filter. Security level refers to the Benchmark levels
// that CIS assigns to a profile.
type CisSecurityLevelFilter struct {
	_ struct{} `type:"structure"`

	// The CIS security filter comparison value.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisSecurityLevelComparison"`

	// The CIS security filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" enum:"CisSecurityLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisSecurityLevelFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisSecurityLevelFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisSecurityLevelFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisSecurityLevelFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisSecurityLevelFilter) SetComparison(v string) *CisSecurityLevelFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisSecurityLevelFilter) SetValue(v string) *CisSecurityLevelFilter {
	s.Value = &v
	return s
}

// The CIS session message.
type CisSessionMessage struct {
	_ struct{} `type:"structure"`

	// The CIS rule details for the CIS session message.
	// CisRuleDetails is automatically base64 encoded/decoded by the SDK.
	//
	// CisRuleDetails is a required field
	CisRuleDetails []byte `locationName:"cisRuleDetails" type:"blob" required:"true"`

	// The rule ID for the CIS session message.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// The status of the CIS session message.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"CisRuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisSessionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisSessionMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisSessionMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisSessionMessage"}
	if s.CisRuleDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("CisRuleDetails"))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCisRuleDetails sets the CisRuleDetails field's value.
func (s *CisSessionMessage) SetCisRuleDetails(v []byte) *CisSessionMessage {
	s.CisRuleDetails = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *CisSessionMessage) SetRuleId(v string) *CisSessionMessage {
	s.RuleId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CisSessionMessage) SetStatus(v string) *CisSessionMessage {
	s.Status = &v
	return s
}

// The CIS string filter.
type CisStringFilter struct {
	_ struct{} `type:"structure"`

	// The comparison value of the CIS string filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisStringComparison"`

	// The value of the CIS string filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisStringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisStringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisStringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisStringFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisStringFilter) SetComparison(v string) *CisStringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisStringFilter) SetValue(v string) *CisStringFilter {
	s.Value = &v
	return s
}

// The CIS target resource aggregation.
type CisTargetResourceAggregation struct {
	_ struct{} `type:"structure"`

	// The account ID for the CIS target resource.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The platform for the CIS target resource.
	Platform *string `locationName:"platform" type:"string"`

	// The scan ARN for the CIS target resource.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The target resource status counts.
	StatusCounts *StatusCounts `locationName:"statusCounts" type:"structure"`

	// The ID of the target resource.
	TargetResourceId *string `locationName:"targetResourceId" min:"10" type:"string"`

	// The tag for the target resource.
	TargetResourceTags map[string][]*string `locationName:"targetResourceTags" min:"1" type:"map"`

	// The status of the target resource.
	TargetStatus *string `locationName:"targetStatus" type:"string" enum:"CisTargetStatus"`

	// The reason for the target resource.
	TargetStatusReason *string `locationName:"targetStatusReason" type:"string" enum:"CisTargetStatusReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargetResourceAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargetResourceAggregation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CisTargetResourceAggregation) SetAccountId(v string) *CisTargetResourceAggregation {
	s.AccountId = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *CisTargetResourceAggregation) SetPlatform(v string) *CisTargetResourceAggregation {
	s.Platform = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *CisTargetResourceAggregation) SetScanArn(v string) *CisTargetResourceAggregation {
	s.ScanArn = &v
	return s
}

// SetStatusCounts sets the StatusCounts field's value.
func (s *CisTargetResourceAggregation) SetStatusCounts(v *StatusCounts) *CisTargetResourceAggregation {
	s.StatusCounts = v
	return s
}

// SetTargetResourceId sets the TargetResourceId field's value.
func (s *CisTargetResourceAggregation) SetTargetResourceId(v string) *CisTargetResourceAggregation {
	s.TargetResourceId = &v
	return s
}

// SetTargetResourceTags sets the TargetResourceTags field's value.
func (s *CisTargetResourceAggregation) SetTargetResourceTags(v map[string][]*string) *CisTargetResourceAggregation {
	s.TargetResourceTags = v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *CisTargetResourceAggregation) SetTargetStatus(v string) *CisTargetResourceAggregation {
	s.TargetStatus = &v
	return s
}

// SetTargetStatusReason sets the TargetStatusReason field's value.
func (s *CisTargetResourceAggregation) SetTargetStatusReason(v string) *CisTargetResourceAggregation {
	s.TargetStatusReason = &v
	return s
}

// The CIS target status filter.
type CisTargetStatusFilter struct {
	_ struct{} `type:"structure"`

	// The comparison value of the CIS target status filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisTargetStatusComparison"`

	// The value of the CIS target status filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" enum:"CisTargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargetStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargetStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisTargetStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisTargetStatusFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisTargetStatusFilter) SetComparison(v string) *CisTargetStatusFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisTargetStatusFilter) SetValue(v string) *CisTargetStatusFilter {
	s.Value = &v
	return s
}

// The CIS target status reason filter.
type CisTargetStatusReasonFilter struct {
	_ struct{} `type:"structure"`

	// The comparison value of the CIS target status reason filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CisTargetStatusComparison"`

	// The value of the CIS target status reason filter.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" enum:"CisTargetStatusReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargetStatusReasonFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargetStatusReasonFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CisTargetStatusReasonFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CisTargetStatusReasonFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CisTargetStatusReasonFilter) SetComparison(v string) *CisTargetStatusReasonFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CisTargetStatusReasonFilter) SetValue(v string) *CisTargetStatusReasonFilter {
	s.Value = &v
	return s
}

// The CIS targets.
type CisTargets struct {
	_ struct{} `type:"structure"`

	// The CIS target account ids.
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list"`

	// The CIS target resource tags.
	TargetResourceTags map[string][]*string `locationName:"targetResourceTags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisTargets) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *CisTargets) SetAccountIds(v []*string) *CisTargets {
	s.AccountIds = v
	return s
}

// SetTargetResourceTags sets the TargetResourceTags field's value.
func (s *CisTargets) SetTargetResourceTags(v map[string][]*string) *CisTargets {
	s.TargetResourceTags = v
	return s
}

// The Cybersecurity and Infrastructure Security Agency (CISA) details for a
// specific vulnerability.
type CisaData struct {
	_ struct{} `type:"structure"`

	// The remediation action recommended by CISA for this vulnerability.
	Action *string `locationName:"action" type:"string"`

	// The date and time CISA added this vulnerability to their catalogue.
	DateAdded *time.Time `locationName:"dateAdded" type:"timestamp"`

	// The date and time CISA expects a fix to have been provided vulnerability.
	DateDue *time.Time `locationName:"dateDue" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisaData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CisaData) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CisaData) SetAction(v string) *CisaData {
	s.Action = &v
	return s
}

// SetDateAdded sets the DateAdded field's value.
func (s *CisaData) SetDateAdded(v time.Time) *CisaData {
	s.DateAdded = &v
	return s
}

// SetDateDue sets the DateDue field's value.
func (s *CisaData) SetDateDue(v time.Time) *CisaData {
	s.DateDue = &v
	return s
}

// Contains information on where a code vulnerability is located in your Lambda
// function.
type CodeFilePath struct {
	_ struct{} `type:"structure"`

	// The line number of the last line of code that a vulnerability was found in.
	//
	// EndLine is a required field
	EndLine *int64 `locationName:"endLine" type:"integer" required:"true"`

	// The name of the file the code vulnerability was found in.
	//
	// FileName is a required field
	FileName *string `locationName:"fileName" min:"1" type:"string" required:"true"`

	// The file path to the code that a vulnerability was found in.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" min:"1" type:"string" required:"true"`

	// The line number of the first line of code that a vulnerability was found
	// in.
	//
	// StartLine is a required field
	StartLine *int64 `locationName:"startLine" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeFilePath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeFilePath) GoString() string {
	return s.String()
}

// SetEndLine sets the EndLine field's value.
func (s *CodeFilePath) SetEndLine(v int64) *CodeFilePath {
	s.EndLine = &v
	return s
}

// SetFileName sets the FileName field's value.
func (s *CodeFilePath) SetFileName(v string) *CodeFilePath {
	s.FileName = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *CodeFilePath) SetFilePath(v string) *CodeFilePath {
	s.FilePath = &v
	return s
}

// SetStartLine sets the StartLine field's value.
func (s *CodeFilePath) SetStartLine(v int64) *CodeFilePath {
	s.StartLine = &v
	return s
}

// Contains information on the lines of code associated with a code snippet.
type CodeLine struct {
	_ struct{} `type:"structure"`

	// The content of a line of code
	//
	// Content is a required field
	Content *string `locationName:"content" type:"string" required:"true"`

	// The line number that a section of code is located at.
	//
	// LineNumber is a required field
	LineNumber *int64 `locationName:"lineNumber" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeLine) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeLine) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *CodeLine) SetContent(v string) *CodeLine {
	s.Content = &v
	return s
}

// SetLineNumber sets the LineNumber field's value.
func (s *CodeLine) SetLineNumber(v int64) *CodeLine {
	s.LineNumber = &v
	return s
}

// Contains information about any errors encountered while trying to retrieve
// a code snippet.
type CodeSnippetError struct {
	_ struct{} `type:"structure"`

	// The error code for the error that prevented a code snippet from being retrieved.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"CodeSnippetErrorCode"`

	// The error message received when Amazon Inspector failed to retrieve a code
	// snippet.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string" required:"true"`

	// The ARN of the finding that a code snippet couldn't be retrieved for.
	//
	// FindingArn is a required field
	FindingArn *string `locationName:"findingArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeSnippetError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeSnippetError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CodeSnippetError) SetErrorCode(v string) *CodeSnippetError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CodeSnippetError) SetErrorMessage(v string) *CodeSnippetError {
	s.ErrorMessage = &v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *CodeSnippetError) SetFindingArn(v string) *CodeSnippetError {
	s.FindingArn = &v
	return s
}

// Contains information on a code snippet retrieved by Amazon Inspector from
// a code vulnerability finding.
type CodeSnippetResult struct {
	_ struct{} `type:"structure"`

	// Contains information on the retrieved code snippet.
	CodeSnippet []*CodeLine `locationName:"codeSnippet" min:"1" type:"list"`

	// The line number of the last line of a code snippet.
	EndLine *int64 `locationName:"endLine" type:"integer"`

	// The ARN of a finding that the code snippet is associated with.
	FindingArn *string `locationName:"findingArn" min:"1" type:"string"`

	// The line number of the first line of a code snippet.
	StartLine *int64 `locationName:"startLine" type:"integer"`

	// Details of a suggested code fix.
	SuggestedFixes []*SuggestedFix `locationName:"suggestedFixes" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeSnippetResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeSnippetResult) GoString() string {
	return s.String()
}

// SetCodeSnippet sets the CodeSnippet field's value.
func (s *CodeSnippetResult) SetCodeSnippet(v []*CodeLine) *CodeSnippetResult {
	s.CodeSnippet = v
	return s
}

// SetEndLine sets the EndLine field's value.
func (s *CodeSnippetResult) SetEndLine(v int64) *CodeSnippetResult {
	s.EndLine = &v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *CodeSnippetResult) SetFindingArn(v string) *CodeSnippetResult {
	s.FindingArn = &v
	return s
}

// SetStartLine sets the StartLine field's value.
func (s *CodeSnippetResult) SetStartLine(v int64) *CodeSnippetResult {
	s.StartLine = &v
	return s
}

// SetSuggestedFixes sets the SuggestedFixes field's value.
func (s *CodeSnippetResult) SetSuggestedFixes(v []*SuggestedFix) *CodeSnippetResult {
	s.SuggestedFixes = v
	return s
}

// Contains information on the code vulnerability identified in your Lambda
// function.
type CodeVulnerabilityDetails struct {
	_ struct{} `type:"structure"`

	// The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
	//
	// Cwes is a required field
	Cwes []*string `locationName:"cwes" min:"1" type:"list" required:"true"`

	// The ID for the Amazon CodeGuru detector associated with the finding. For
	// more information on detectors see Amazon CodeGuru Detector Library (https://docs.aws.amazon.com/codeguru/detector-library).
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The name of the detector used to identify the code vulnerability. For more
	// information on detectors see CodeGuru Detector Library (https://docs.aws.amazon.com/codeguru/detector-library).
	//
	// DetectorName is a required field
	DetectorName *string `locationName:"detectorName" min:"1" type:"string" required:"true"`

	// The detector tag associated with the vulnerability. Detector tags group related
	// vulnerabilities by common themes or tactics. For a list of available tags
	// by programming language, see Java tags (https://docs.aws.amazon.com/codeguru/detector-library/java/tags/),
	// or Python tags (https://docs.aws.amazon.com/codeguru/detector-library/python/tags/).
	DetectorTags []*string `locationName:"detectorTags" min:"1" type:"list"`

	// Contains information on where the code vulnerability is located in your code.
	//
	// FilePath is a required field
	FilePath *CodeFilePath `locationName:"filePath" type:"structure" required:"true"`

	// A URL containing supporting documentation about the code vulnerability detected.
	ReferenceUrls []*string `locationName:"referenceUrls" min:"1" type:"list"`

	// The identifier for a rule that was used to detect the code vulnerability.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability
	// was detected in.
	SourceLambdaLayerArn *string `locationName:"sourceLambdaLayerArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeVulnerabilityDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeVulnerabilityDetails) GoString() string {
	return s.String()
}

// SetCwes sets the Cwes field's value.
func (s *CodeVulnerabilityDetails) SetCwes(v []*string) *CodeVulnerabilityDetails {
	s.Cwes = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CodeVulnerabilityDetails) SetDetectorId(v string) *CodeVulnerabilityDetails {
	s.DetectorId = &v
	return s
}

// SetDetectorName sets the DetectorName field's value.
func (s *CodeVulnerabilityDetails) SetDetectorName(v string) *CodeVulnerabilityDetails {
	s.DetectorName = &v
	return s
}

// SetDetectorTags sets the DetectorTags field's value.
func (s *CodeVulnerabilityDetails) SetDetectorTags(v []*string) *CodeVulnerabilityDetails {
	s.DetectorTags = v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *CodeVulnerabilityDetails) SetFilePath(v *CodeFilePath) *CodeVulnerabilityDetails {
	s.FilePath = v
	return s
}

// SetReferenceUrls sets the ReferenceUrls field's value.
func (s *CodeVulnerabilityDetails) SetReferenceUrls(v []*string) *CodeVulnerabilityDetails {
	s.ReferenceUrls = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *CodeVulnerabilityDetails) SetRuleId(v string) *CodeVulnerabilityDetails {
	s.RuleId = &v
	return s
}

// SetSourceLambdaLayerArn sets the SourceLambdaLayerArn field's value.
func (s *CodeVulnerabilityDetails) SetSourceLambdaLayerArn(v string) *CodeVulnerabilityDetails {
	s.SourceLambdaLayerArn = &v
	return s
}

// A compute platform.
type ComputePlatform struct {
	_ struct{} `type:"structure"`

	// The compute platform product.
	Product *string `locationName:"product" type:"string"`

	// The compute platform vendor.
	Vendor *string `locationName:"vendor" type:"string"`

	// The compute platform version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputePlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputePlatform) GoString() string {
	return s.String()
}

// SetProduct sets the Product field's value.
func (s *ComputePlatform) SetProduct(v string) *ComputePlatform {
	s.Product = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *ComputePlatform) SetVendor(v string) *ComputePlatform {
	s.Vendor = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ComputePlatform) SetVersion(v string) *ComputePlatform {
	s.Version = &v
	return s
}

// A conflict occurred.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the conflicting resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the conflicting resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// a structure that contains information on the count of resources within a
// group.
type Counts struct {
	_ struct{} `type:"structure"`

	// The number of resources.
	Count *int64 `locationName:"count" type:"long"`

	// The key associated with this group
	GroupKey *string `locationName:"groupKey" type:"string" enum:"GroupKey"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Counts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Counts) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *Counts) SetCount(v int64) *Counts {
	s.Count = &v
	return s
}

// SetGroupKey sets the GroupKey field's value.
func (s *Counts) SetGroupKey(v string) *Counts {
	s.GroupKey = &v
	return s
}

// Contains details of a coverage date filter.
type CoverageDateFilter struct {
	_ struct{} `type:"structure"`

	// A timestamp representing the end of the time period to filter results by.
	EndInclusive *time.Time `locationName:"endInclusive" type:"timestamp"`

	// A timestamp representing the start of the time period to filter results by.
	StartInclusive *time.Time `locationName:"startInclusive" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageDateFilter) GoString() string {
	return s.String()
}

// SetEndInclusive sets the EndInclusive field's value.
func (s *CoverageDateFilter) SetEndInclusive(v time.Time) *CoverageDateFilter {
	s.EndInclusive = &v
	return s
}

// SetStartInclusive sets the StartInclusive field's value.
func (s *CoverageDateFilter) SetStartInclusive(v time.Time) *CoverageDateFilter {
	s.StartInclusive = &v
	return s
}

// A structure that identifies filter criteria for GetCoverageStatistics.
type CoverageFilterCriteria struct {
	_ struct{} `type:"structure"`

	// An array of Amazon Web Services account IDs to return coverage statistics
	// for.
	AccountId []*CoverageStringFilter `locationName:"accountId" min:"1" type:"list"`

	// The Amazon EC2 instance tags to filter on.
	Ec2InstanceTags []*CoverageMapFilter `locationName:"ec2InstanceTags" min:"1" type:"list"`

	// The Amazon ECR image tags to filter on.
	EcrImageTags []*CoverageStringFilter `locationName:"ecrImageTags" min:"1" type:"list"`

	// The Amazon ECR repository name to filter on.
	EcrRepositoryName []*CoverageStringFilter `locationName:"ecrRepositoryName" min:"1" type:"list"`

	// The date an image was last pulled at.
	ImagePulledAt []*CoverageDateFilter `locationName:"imagePulledAt" min:"1" type:"list"`

	// Returns coverage statistics for Amazon Web Services Lambda functions filtered
	// by function names.
	LambdaFunctionName []*CoverageStringFilter `locationName:"lambdaFunctionName" min:"1" type:"list"`

	// Returns coverage statistics for Amazon Web Services Lambda functions filtered
	// by runtime.
	LambdaFunctionRuntime []*CoverageStringFilter `locationName:"lambdaFunctionRuntime" min:"1" type:"list"`

	// Returns coverage statistics for Amazon Web Services Lambda functions filtered
	// by tag.
	LambdaFunctionTags []*CoverageMapFilter `locationName:"lambdaFunctionTags" min:"1" type:"list"`

	// Filters Amazon Web Services resources based on whether Amazon Inspector has
	// checked them for vulnerabilities within the specified time range.
	LastScannedAt []*CoverageDateFilter `locationName:"lastScannedAt" min:"1" type:"list"`

	// An array of Amazon Web Services resource IDs to return coverage statistics
	// for.
	ResourceId []*CoverageStringFilter `locationName:"resourceId" min:"1" type:"list"`

	// An array of Amazon Web Services resource types to return coverage statistics
	// for. The values can be AWS_EC2_INSTANCE, AWS_LAMBDA_FUNCTION, AWS_ECR_CONTAINER_IMAGE,
	// AWS_ECR_REPOSITORY or AWS_ACCOUNT.
	ResourceType []*CoverageStringFilter `locationName:"resourceType" min:"1" type:"list"`

	// The filter to search for Amazon EC2 instance coverage by scan mode. Valid
	// values are EC2_SSM_AGENT_BASED and EC2_HYBRID.
	ScanMode []*CoverageStringFilter `locationName:"scanMode" min:"1" type:"list"`

	// The scan status code to filter on. Valid values are: ValidationException,
	// InternalServerException, ResourceNotFoundException, BadRequestException,
	// and ThrottlingException.
	ScanStatusCode []*CoverageStringFilter `locationName:"scanStatusCode" min:"1" type:"list"`

	// The scan status reason to filter on.
	ScanStatusReason []*CoverageStringFilter `locationName:"scanStatusReason" min:"1" type:"list"`

	// An array of Amazon Inspector scan types to return coverage statistics for.
	ScanType []*CoverageStringFilter `locationName:"scanType" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CoverageFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CoverageFilterCriteria"}
	if s.AccountId != nil && len(s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Ec2InstanceTags != nil && len(s.Ec2InstanceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ec2InstanceTags", 1))
	}
	if s.EcrImageTags != nil && len(s.EcrImageTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageTags", 1))
	}
	if s.EcrRepositoryName != nil && len(s.EcrRepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrRepositoryName", 1))
	}
	if s.ImagePulledAt != nil && len(s.ImagePulledAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImagePulledAt", 1))
	}
	if s.LambdaFunctionName != nil && len(s.LambdaFunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionName", 1))
	}
	if s.LambdaFunctionRuntime != nil && len(s.LambdaFunctionRuntime) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionRuntime", 1))
	}
	if s.LambdaFunctionTags != nil && len(s.LambdaFunctionTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionTags", 1))
	}
	if s.LastScannedAt != nil && len(s.LastScannedAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastScannedAt", 1))
	}
	if s.ResourceId != nil && len(s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.ScanMode != nil && len(s.ScanMode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanMode", 1))
	}
	if s.ScanStatusCode != nil && len(s.ScanStatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanStatusCode", 1))
	}
	if s.ScanStatusReason != nil && len(s.ScanStatusReason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanStatusReason", 1))
	}
	if s.ScanType != nil && len(s.ScanType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanType", 1))
	}
	if s.AccountId != nil {
		for i, v := range s.AccountId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ec2InstanceTags != nil {
		for i, v := range s.Ec2InstanceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2InstanceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageTags != nil {
		for i, v := range s.EcrImageTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrRepositoryName != nil {
		for i, v := range s.EcrRepositoryName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrRepositoryName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionName != nil {
		for i, v := range s.LambdaFunctionName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionRuntime != nil {
		for i, v := range s.LambdaFunctionRuntime {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionRuntime", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionTags != nil {
		for i, v := range s.LambdaFunctionTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceId != nil {
		for i, v := range s.ResourceId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceType != nil {
		for i, v := range s.ResourceType {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceType", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanMode != nil {
		for i, v := range s.ScanMode {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanMode", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanStatusCode != nil {
		for i, v := range s.ScanStatusCode {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanStatusCode", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanStatusReason != nil {
		for i, v := range s.ScanStatusReason {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanStatusReason", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanType != nil {
		for i, v := range s.ScanType {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanType", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CoverageFilterCriteria) SetAccountId(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.AccountId = v
	return s
}

// SetEc2InstanceTags sets the Ec2InstanceTags field's value.
func (s *CoverageFilterCriteria) SetEc2InstanceTags(v []*CoverageMapFilter) *CoverageFilterCriteria {
	s.Ec2InstanceTags = v
	return s
}

// SetEcrImageTags sets the EcrImageTags field's value.
func (s *CoverageFilterCriteria) SetEcrImageTags(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.EcrImageTags = v
	return s
}

// SetEcrRepositoryName sets the EcrRepositoryName field's value.
func (s *CoverageFilterCriteria) SetEcrRepositoryName(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.EcrRepositoryName = v
	return s
}

// SetImagePulledAt sets the ImagePulledAt field's value.
func (s *CoverageFilterCriteria) SetImagePulledAt(v []*CoverageDateFilter) *CoverageFilterCriteria {
	s.ImagePulledAt = v
	return s
}

// SetLambdaFunctionName sets the LambdaFunctionName field's value.
func (s *CoverageFilterCriteria) SetLambdaFunctionName(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.LambdaFunctionName = v
	return s
}

// SetLambdaFunctionRuntime sets the LambdaFunctionRuntime field's value.
func (s *CoverageFilterCriteria) SetLambdaFunctionRuntime(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.LambdaFunctionRuntime = v
	return s
}

// SetLambdaFunctionTags sets the LambdaFunctionTags field's value.
func (s *CoverageFilterCriteria) SetLambdaFunctionTags(v []*CoverageMapFilter) *CoverageFilterCriteria {
	s.LambdaFunctionTags = v
	return s
}

// SetLastScannedAt sets the LastScannedAt field's value.
func (s *CoverageFilterCriteria) SetLastScannedAt(v []*CoverageDateFilter) *CoverageFilterCriteria {
	s.LastScannedAt = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CoverageFilterCriteria) SetResourceId(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.ResourceId = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CoverageFilterCriteria) SetResourceType(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.ResourceType = v
	return s
}

// SetScanMode sets the ScanMode field's value.
func (s *CoverageFilterCriteria) SetScanMode(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.ScanMode = v
	return s
}

// SetScanStatusCode sets the ScanStatusCode field's value.
func (s *CoverageFilterCriteria) SetScanStatusCode(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.ScanStatusCode = v
	return s
}

// SetScanStatusReason sets the ScanStatusReason field's value.
func (s *CoverageFilterCriteria) SetScanStatusReason(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.ScanStatusReason = v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *CoverageFilterCriteria) SetScanType(v []*CoverageStringFilter) *CoverageFilterCriteria {
	s.ScanType = v
	return s
}

// Contains details of a coverage map filter.
type CoverageMapFilter struct {
	_ struct{} `type:"structure"`

	// The operator to compare coverage on.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CoverageMapComparison"`

	// The tag key associated with the coverage map filter.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag value associated with the coverage map filter.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageMapFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageMapFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CoverageMapFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CoverageMapFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CoverageMapFilter) SetComparison(v string) *CoverageMapFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CoverageMapFilter) SetKey(v string) *CoverageMapFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CoverageMapFilter) SetValue(v string) *CoverageMapFilter {
	s.Value = &v
	return s
}

// Contains details of a coverage string filter.
type CoverageStringFilter struct {
	_ struct{} `type:"structure"`

	// The operator to compare strings on.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"CoverageStringComparison"`

	// The value to compare strings on.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageStringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoverageStringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CoverageStringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CoverageStringFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *CoverageStringFilter) SetComparison(v string) *CoverageStringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CoverageStringFilter) SetValue(v string) *CoverageStringFilter {
	s.Value = &v
	return s
}

// An object that contains details about a resource covered by Amazon Inspector.
type CoveredResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the covered resource.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The date and time the resource was last checked for vulnerabilities.
	LastScannedAt *time.Time `locationName:"lastScannedAt" type:"timestamp"`

	// The ID of the covered resource.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"10" type:"string" required:"true"`

	// An object that contains details about the metadata.
	ResourceMetadata *ResourceScanMetadata `locationName:"resourceMetadata" type:"structure"`

	// The type of the covered resource.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"CoverageResourceType"`

	// The scan method that is applied to the instance.
	ScanMode *string `locationName:"scanMode" type:"string" enum:"ScanMode"`

	// The status of the scan covering the resource.
	ScanStatus *ScanStatus `locationName:"scanStatus" type:"structure"`

	// The Amazon Inspector scan type covering the resource.
	//
	// ScanType is a required field
	ScanType *string `locationName:"scanType" type:"string" required:"true" enum:"ScanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoveredResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoveredResource) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CoveredResource) SetAccountId(v string) *CoveredResource {
	s.AccountId = &v
	return s
}

// SetLastScannedAt sets the LastScannedAt field's value.
func (s *CoveredResource) SetLastScannedAt(v time.Time) *CoveredResource {
	s.LastScannedAt = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CoveredResource) SetResourceId(v string) *CoveredResource {
	s.ResourceId = &v
	return s
}

// SetResourceMetadata sets the ResourceMetadata field's value.
func (s *CoveredResource) SetResourceMetadata(v *ResourceScanMetadata) *CoveredResource {
	s.ResourceMetadata = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CoveredResource) SetResourceType(v string) *CoveredResource {
	s.ResourceType = &v
	return s
}

// SetScanMode sets the ScanMode field's value.
func (s *CoveredResource) SetScanMode(v string) *CoveredResource {
	s.ScanMode = &v
	return s
}

// SetScanStatus sets the ScanStatus field's value.
func (s *CoveredResource) SetScanStatus(v *ScanStatus) *CoveredResource {
	s.ScanStatus = v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *CoveredResource) SetScanType(v string) *CoveredResource {
	s.ScanType = &v
	return s
}

type CreateCisScanConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The scan name for the CIS scan configuration.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`

	// The schedule for the CIS scan configuration.
	//
	// Schedule is a required field
	Schedule *Schedule `locationName:"schedule" type:"structure" required:"true"`

	// The security level for the CIS scan configuration. Security level refers
	// to the Benchmark levels that CIS assigns to a profile.
	//
	// SecurityLevel is a required field
	SecurityLevel *string `locationName:"securityLevel" type:"string" required:"true" enum:"CisSecurityLevel"`

	// The tags for the CIS scan configuration.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The targets for the CIS scan configuration.
	//
	// Targets is a required field
	Targets *CreateCisTargets `locationName:"targets" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCisScanConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCisScanConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCisScanConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCisScanConfigurationInput"}
	if s.ScanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanName"))
	}
	if s.ScanName != nil && len(*s.ScanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanName", 1))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.SecurityLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityLevel"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}
	if s.Targets != nil {
		if err := s.Targets.Validate(); err != nil {
			invalidParams.AddNested("Targets", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanName sets the ScanName field's value.
func (s *CreateCisScanConfigurationInput) SetScanName(v string) *CreateCisScanConfigurationInput {
	s.ScanName = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateCisScanConfigurationInput) SetSchedule(v *Schedule) *CreateCisScanConfigurationInput {
	s.Schedule = v
	return s
}

// SetSecurityLevel sets the SecurityLevel field's value.
func (s *CreateCisScanConfigurationInput) SetSecurityLevel(v string) *CreateCisScanConfigurationInput {
	s.SecurityLevel = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCisScanConfigurationInput) SetTags(v map[string]*string) *CreateCisScanConfigurationInput {
	s.Tags = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateCisScanConfigurationInput) SetTargets(v *CreateCisTargets) *CreateCisScanConfigurationInput {
	s.Targets = v
	return s
}

type CreateCisScanConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The scan configuration ARN for the CIS scan configuration.
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCisScanConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCisScanConfigurationOutput) GoString() string {
	return s.String()
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *CreateCisScanConfigurationOutput) SetScanConfigurationArn(v string) *CreateCisScanConfigurationOutput {
	s.ScanConfigurationArn = &v
	return s
}

// Creates CIS targets.
type CreateCisTargets struct {
	_ struct{} `type:"structure"`

	// The CIS target account ids.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The CIS target resource tags.
	//
	// TargetResourceTags is a required field
	TargetResourceTags map[string][]*string `locationName:"targetResourceTags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCisTargets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCisTargets) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCisTargets) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCisTargets"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.TargetResourceTags == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetResourceTags"))
	}
	if s.TargetResourceTags != nil && len(s.TargetResourceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceTags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *CreateCisTargets) SetAccountIds(v []*string) *CreateCisTargets {
	s.AccountIds = v
	return s
}

// SetTargetResourceTags sets the TargetResourceTags field's value.
func (s *CreateCisTargets) SetTargetResourceTags(v map[string][]*string) *CreateCisTargets {
	s.TargetResourceTags = v
	return s
}

type CreateFilterInput struct {
	_ struct{} `type:"structure"`

	// Defines the action that is to be applied to the findings that match the filter.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"FilterAction"`

	// A description of the filter.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Defines the criteria to be used in the filter for querying findings.
	//
	// FilterCriteria is a required field
	FilterCriteria *FilterCriteria `locationName:"filterCriteria" type:"structure" required:"true"`

	// The name of the filter. Minimum length of 3. Maximum length of 64. Valid
	// characters include alphanumeric characters, dot (.), underscore (_), and
	// dash (-). Spaces are not allowed.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The reason for creating the filter.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// A list of tags for the filter.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFilterInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FilterCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterCriteria"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateFilterInput) SetAction(v string) *CreateFilterInput {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFilterInput) SetDescription(v string) *CreateFilterInput {
	s.Description = &v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *CreateFilterInput) SetFilterCriteria(v *FilterCriteria) *CreateFilterInput {
	s.FilterCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFilterInput) SetName(v string) *CreateFilterInput {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *CreateFilterInput) SetReason(v string) *CreateFilterInput {
	s.Reason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFilterInput) SetTags(v map[string]*string) *CreateFilterInput {
	s.Tags = v
	return s
}

type CreateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the successfully created filter.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFilterOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFilterOutput) SetArn(v string) *CreateFilterOutput {
	s.Arn = &v
	return s
}

type CreateFindingsReportInput struct {
	_ struct{} `type:"structure"`

	// The filter criteria to apply to the results of the finding report.
	FilterCriteria *FilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The format to generate the report in.
	//
	// ReportFormat is a required field
	ReportFormat *string `locationName:"reportFormat" type:"string" required:"true" enum:"ReportFormat"`

	// The Amazon S3 export destination for the report.
	//
	// S3Destination is a required field
	S3Destination *Destination `locationName:"s3Destination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFindingsReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFindingsReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFindingsReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFindingsReportInput"}
	if s.ReportFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportFormat"))
	}
	if s.S3Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Destination"))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *CreateFindingsReportInput) SetFilterCriteria(v *FilterCriteria) *CreateFindingsReportInput {
	s.FilterCriteria = v
	return s
}

// SetReportFormat sets the ReportFormat field's value.
func (s *CreateFindingsReportInput) SetReportFormat(v string) *CreateFindingsReportInput {
	s.ReportFormat = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *CreateFindingsReportInput) SetS3Destination(v *Destination) *CreateFindingsReportInput {
	s.S3Destination = v
	return s
}

type CreateFindingsReportOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the report.
	ReportId *string `locationName:"reportId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFindingsReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFindingsReportOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *CreateFindingsReportOutput) SetReportId(v string) *CreateFindingsReportOutput {
	s.ReportId = &v
	return s
}

type CreateSbomExportInput struct {
	_ struct{} `type:"structure"`

	// The output format for the software bill of materials (SBOM) report.
	//
	// ReportFormat is a required field
	ReportFormat *string `locationName:"reportFormat" type:"string" required:"true" enum:"SbomReportFormat"`

	// The resource filter criteria for the software bill of materials (SBOM) report.
	ResourceFilterCriteria *ResourceFilterCriteria `locationName:"resourceFilterCriteria" type:"structure"`

	// Contains details of the Amazon S3 bucket and KMS key used to export findings.
	//
	// S3Destination is a required field
	S3Destination *Destination `locationName:"s3Destination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSbomExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSbomExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSbomExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSbomExportInput"}
	if s.ReportFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportFormat"))
	}
	if s.S3Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Destination"))
	}
	if s.ResourceFilterCriteria != nil {
		if err := s.ResourceFilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("ResourceFilterCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportFormat sets the ReportFormat field's value.
func (s *CreateSbomExportInput) SetReportFormat(v string) *CreateSbomExportInput {
	s.ReportFormat = &v
	return s
}

// SetResourceFilterCriteria sets the ResourceFilterCriteria field's value.
func (s *CreateSbomExportInput) SetResourceFilterCriteria(v *ResourceFilterCriteria) *CreateSbomExportInput {
	s.ResourceFilterCriteria = v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *CreateSbomExportInput) SetS3Destination(v *Destination) *CreateSbomExportInput {
	s.S3Destination = v
	return s
}

type CreateSbomExportOutput struct {
	_ struct{} `type:"structure"`

	// The report ID for the software bill of materials (SBOM) report.
	ReportId *string `locationName:"reportId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSbomExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSbomExportOutput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *CreateSbomExportOutput) SetReportId(v string) *CreateSbomExportOutput {
	s.ReportId = &v
	return s
}

// The Common Vulnerability Scoring System (CVSS) version 2 details for the
// vulnerability.
type Cvss2 struct {
	_ struct{} `type:"structure"`

	// The CVSS v2 base score for the vulnerability.
	BaseScore *float64 `locationName:"baseScore" type:"double"`

	// The scoring vector associated with the CVSS v2 score.
	ScoringVector *string `locationName:"scoringVector" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cvss2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cvss2) GoString() string {
	return s.String()
}

// SetBaseScore sets the BaseScore field's value.
func (s *Cvss2) SetBaseScore(v float64) *Cvss2 {
	s.BaseScore = &v
	return s
}

// SetScoringVector sets the ScoringVector field's value.
func (s *Cvss2) SetScoringVector(v string) *Cvss2 {
	s.ScoringVector = &v
	return s
}

// The Common Vulnerability Scoring System (CVSS) version 3 details for the
// vulnerability.
type Cvss3 struct {
	_ struct{} `type:"structure"`

	// The CVSS v3 base score for the vulnerability.
	BaseScore *float64 `locationName:"baseScore" type:"double"`

	// The scoring vector associated with the CVSS v3 score.
	ScoringVector *string `locationName:"scoringVector" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cvss3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cvss3) GoString() string {
	return s.String()
}

// SetBaseScore sets the BaseScore field's value.
func (s *Cvss3) SetBaseScore(v float64) *Cvss3 {
	s.BaseScore = &v
	return s
}

// SetScoringVector sets the ScoringVector field's value.
func (s *Cvss3) SetScoringVector(v string) *Cvss3 {
	s.ScoringVector = &v
	return s
}

// The CVSS score for a finding.
type CvssScore struct {
	_ struct{} `type:"structure"`

	// The base CVSS score used for the finding.
	//
	// BaseScore is a required field
	BaseScore *float64 `locationName:"baseScore" type:"double" required:"true"`

	// The vector string of the CVSS score.
	//
	// ScoringVector is a required field
	ScoringVector *string `locationName:"scoringVector" min:"1" type:"string" required:"true"`

	// The source of the CVSS score.
	//
	// Source is a required field
	Source *string `locationName:"source" min:"1" type:"string" required:"true"`

	// The version of CVSS used for the score.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CvssScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CvssScore) GoString() string {
	return s.String()
}

// SetBaseScore sets the BaseScore field's value.
func (s *CvssScore) SetBaseScore(v float64) *CvssScore {
	s.BaseScore = &v
	return s
}

// SetScoringVector sets the ScoringVector field's value.
func (s *CvssScore) SetScoringVector(v string) *CvssScore {
	s.ScoringVector = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CvssScore) SetSource(v string) *CvssScore {
	s.Source = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CvssScore) SetVersion(v string) *CvssScore {
	s.Version = &v
	return s
}

// Details on adjustments Amazon Inspector made to the CVSS score for a finding.
type CvssScoreAdjustment struct {
	_ struct{} `type:"structure"`

	// The metric used to adjust the CVSS score.
	//
	// Metric is a required field
	Metric *string `locationName:"metric" min:"1" type:"string" required:"true"`

	// The reason the CVSS score has been adjustment.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CvssScoreAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CvssScoreAdjustment) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *CvssScoreAdjustment) SetMetric(v string) *CvssScoreAdjustment {
	s.Metric = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *CvssScoreAdjustment) SetReason(v string) *CvssScoreAdjustment {
	s.Reason = &v
	return s
}

// Information about the CVSS score.
type CvssScoreDetails struct {
	_ struct{} `type:"structure"`

	// An object that contains details about adjustment Amazon Inspector made to
	// the CVSS score.
	Adjustments []*CvssScoreAdjustment `locationName:"adjustments" type:"list"`

	// The source of the CVSS data.
	CvssSource *string `locationName:"cvssSource" min:"1" type:"string"`

	// The CVSS score.
	//
	// Score is a required field
	Score *float64 `locationName:"score" type:"double" required:"true"`

	// The source for the CVSS score.
	//
	// ScoreSource is a required field
	ScoreSource *string `locationName:"scoreSource" min:"1" type:"string" required:"true"`

	// The vector for the CVSS score.
	//
	// ScoringVector is a required field
	ScoringVector *string `locationName:"scoringVector" min:"1" type:"string" required:"true"`

	// The CVSS version used in scoring.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CvssScoreDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CvssScoreDetails) GoString() string {
	return s.String()
}

// SetAdjustments sets the Adjustments field's value.
func (s *CvssScoreDetails) SetAdjustments(v []*CvssScoreAdjustment) *CvssScoreDetails {
	s.Adjustments = v
	return s
}

// SetCvssSource sets the CvssSource field's value.
func (s *CvssScoreDetails) SetCvssSource(v string) *CvssScoreDetails {
	s.CvssSource = &v
	return s
}

// SetScore sets the Score field's value.
func (s *CvssScoreDetails) SetScore(v float64) *CvssScoreDetails {
	s.Score = &v
	return s
}

// SetScoreSource sets the ScoreSource field's value.
func (s *CvssScoreDetails) SetScoreSource(v string) *CvssScoreDetails {
	s.ScoreSource = &v
	return s
}

// SetScoringVector sets the ScoringVector field's value.
func (s *CvssScoreDetails) SetScoringVector(v string) *CvssScoreDetails {
	s.ScoringVector = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CvssScoreDetails) SetVersion(v string) *CvssScoreDetails {
	s.Version = &v
	return s
}

// A daily schedule.
type DailySchedule struct {
	_ struct{} `type:"structure"`

	// The schedule start time.
	//
	// StartTime is a required field
	StartTime *Time `locationName:"startTime" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DailySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DailySchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DailySchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DailySchedule"}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StartTime != nil {
		if err := s.StartTime.Validate(); err != nil {
			invalidParams.AddNested("StartTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartTime sets the StartTime field's value.
func (s *DailySchedule) SetStartTime(v *Time) *DailySchedule {
	s.StartTime = v
	return s
}

// Contains details on the time range used to filter findings.
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A timestamp representing the end of the time period filtered on.
	EndInclusive *time.Time `locationName:"endInclusive" type:"timestamp"`

	// A timestamp representing the start of the time period filtered on.
	StartInclusive *time.Time `locationName:"startInclusive" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateFilter) GoString() string {
	return s.String()
}

// SetEndInclusive sets the EndInclusive field's value.
func (s *DateFilter) SetEndInclusive(v time.Time) *DateFilter {
	s.EndInclusive = &v
	return s
}

// SetStartInclusive sets the StartInclusive field's value.
func (s *DateFilter) SetStartInclusive(v time.Time) *DateFilter {
	s.StartInclusive = &v
	return s
}

// Details of the Amazon Inspector delegated administrator for your organization.
type DelegatedAdmin struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the Amazon Inspector delegated administrator
	// for your organization.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The status of the Amazon Inspector delegated administrator.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" enum:"RelationshipStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DelegatedAdmin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DelegatedAdmin) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *DelegatedAdmin) SetAccountId(v string) *DelegatedAdmin {
	s.AccountId = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *DelegatedAdmin) SetRelationshipStatus(v string) *DelegatedAdmin {
	s.RelationshipStatus = &v
	return s
}

// Details of the Amazon Inspector delegated administrator for your organization.
type DelegatedAdminAccount struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the Amazon Inspector delegated administrator
	// for your organization.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The status of the Amazon Inspector delegated administrator.
	Status *string `locationName:"status" type:"string" enum:"DelegatedAdminStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DelegatedAdminAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DelegatedAdminAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *DelegatedAdminAccount) SetAccountId(v string) *DelegatedAdminAccount {
	s.AccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DelegatedAdminAccount) SetStatus(v string) *DelegatedAdminAccount {
	s.Status = &v
	return s
}

type DeleteCisScanConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CIS scan configuration.
	//
	// ScanConfigurationArn is a required field
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCisScanConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCisScanConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCisScanConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCisScanConfigurationInput"}
	if s.ScanConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *DeleteCisScanConfigurationInput) SetScanConfigurationArn(v string) *DeleteCisScanConfigurationInput {
	s.ScanConfigurationArn = &v
	return s
}

type DeleteCisScanConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CIS scan configuration.
	//
	// ScanConfigurationArn is a required field
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCisScanConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCisScanConfigurationOutput) GoString() string {
	return s.String()
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *DeleteCisScanConfigurationOutput) SetScanConfigurationArn(v string) *DeleteCisScanConfigurationOutput {
	s.ScanConfigurationArn = &v
	return s
}

type DeleteFilterInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the filter to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFilterInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteFilterInput) SetArn(v string) *DeleteFilterInput {
	s.Arn = &v
	return s
}

type DeleteFilterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the filter that has been deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFilterOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteFilterOutput) SetArn(v string) *DeleteFilterOutput {
	s.Arn = &v
	return s
}

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The scan types are automatically enabled for new members of your organization.
	AutoEnable *AutoEnable `locationName:"autoEnable" type:"structure"`

	// Represents whether your organization has reached the maximum Amazon Web Services
	// account limit for Amazon Inspector.
	MaxAccountLimitReached *bool `locationName:"maxAccountLimitReached" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *DescribeOrganizationConfigurationOutput) SetAutoEnable(v *AutoEnable) *DescribeOrganizationConfigurationOutput {
	s.AutoEnable = v
	return s
}

// SetMaxAccountLimitReached sets the MaxAccountLimitReached field's value.
func (s *DescribeOrganizationConfigurationOutput) SetMaxAccountLimitReached(v bool) *DescribeOrganizationConfigurationOutput {
	s.MaxAccountLimitReached = &v
	return s
}

// Contains details of the Amazon S3 bucket and KMS key used to export findings.
type Destination struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket to export findings to.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The prefix that the findings will be written under.
	KeyPrefix *string `locationName:"keyPrefix" type:"string"`

	// The ARN of the KMS key used to encrypt data when exporting findings.
	//
	// KmsKeyArn is a required field
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.KmsKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *Destination) SetBucketName(v string) *Destination {
	s.BucketName = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *Destination) SetKeyPrefix(v string) *Destination {
	s.KeyPrefix = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *Destination) SetKmsKeyArn(v string) *Destination {
	s.KmsKeyArn = &v
	return s
}

type DisableDelegatedAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the current Amazon Inspector delegated
	// administrator.
	//
	// DelegatedAdminAccountId is a required field
	DelegatedAdminAccountId *string `locationName:"delegatedAdminAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableDelegatedAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableDelegatedAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableDelegatedAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableDelegatedAdminAccountInput"}
	if s.DelegatedAdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("DelegatedAdminAccountId"))
	}
	if s.DelegatedAdminAccountId != nil && len(*s.DelegatedAdminAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DelegatedAdminAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelegatedAdminAccountId sets the DelegatedAdminAccountId field's value.
func (s *DisableDelegatedAdminAccountInput) SetDelegatedAdminAccountId(v string) *DisableDelegatedAdminAccountInput {
	s.DelegatedAdminAccountId = &v
	return s
}

type DisableDelegatedAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the successfully disabled delegated
	// administrator.
	//
	// DelegatedAdminAccountId is a required field
	DelegatedAdminAccountId *string `locationName:"delegatedAdminAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableDelegatedAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableDelegatedAdminAccountOutput) GoString() string {
	return s.String()
}

// SetDelegatedAdminAccountId sets the DelegatedAdminAccountId field's value.
func (s *DisableDelegatedAdminAccountOutput) SetDelegatedAdminAccountId(v string) *DisableDelegatedAdminAccountOutput {
	s.DelegatedAdminAccountId = &v
	return s
}

type DisableInput struct {
	_ struct{} `type:"structure"`

	// An array of account IDs you want to disable Amazon Inspector scans for.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// The resource scan types you want to disable.
	ResourceTypes []*string `locationName:"resourceTypes" type:"list" enum:"ResourceScanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisableInput) SetAccountIds(v []*string) *DisableInput {
	s.AccountIds = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *DisableInput) SetResourceTypes(v []*string) *DisableInput {
	s.ResourceTypes = v
	return s
}

type DisableOutput struct {
	_ struct{} `type:"structure"`

	// Information on the accounts that have had Amazon Inspector scans successfully
	// disabled. Details are provided for each account.
	//
	// Accounts is a required field
	Accounts []*Account `locationName:"accounts" type:"list" required:"true"`

	// Information on any accounts for which Amazon Inspector scans could not be
	// disabled. Details are provided for each account.
	FailedAccounts []*FailedAccount `locationName:"failedAccounts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *DisableOutput) SetAccounts(v []*Account) *DisableOutput {
	s.Accounts = v
	return s
}

// SetFailedAccounts sets the FailedAccounts field's value.
func (s *DisableOutput) SetFailedAccounts(v []*FailedAccount) *DisableOutput {
	s.FailedAccounts = v
	return s
}

type DisassociateMemberInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the member account to disassociate.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DisassociateMemberInput) SetAccountId(v string) *DisassociateMemberInput {
	s.AccountId = &v
	return s
}

type DisassociateMemberOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the successfully disassociated member.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *DisassociateMemberOutput) SetAccountId(v string) *DisassociateMemberOutput {
	s.AccountId = &v
	return s
}

// Enables agent-based scanning, which scans instances that are not managed
// by SSM.
type Ec2Configuration struct {
	_ struct{} `type:"structure"`

	// The scan method that is applied to the instance.
	//
	// ScanMode is a required field
	ScanMode *string `locationName:"scanMode" type:"string" required:"true" enum:"Ec2ScanMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2Configuration"}
	if s.ScanMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanMode sets the ScanMode field's value.
func (s *Ec2Configuration) SetScanMode(v string) *Ec2Configuration {
	s.ScanMode = &v
	return s
}

// Details about the state of the EC2 scan configuration for your environment.
type Ec2ConfigurationState struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the state of the Amazon EC2 scan mode.
	ScanModeState *Ec2ScanModeState `locationName:"scanModeState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ConfigurationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ConfigurationState) GoString() string {
	return s.String()
}

// SetScanModeState sets the ScanModeState field's value.
func (s *Ec2ConfigurationState) SetScanModeState(v *Ec2ScanModeState) *Ec2ConfigurationState {
	s.ScanModeState = v
	return s
}

// The details that define an aggregation based on Amazon EC2 instances.
type Ec2InstanceAggregation struct {
	_ struct{} `type:"structure"`

	// The AMI IDs associated with the Amazon EC2 instances to aggregate findings
	// for.
	Amis []*StringFilter `locationName:"amis" min:"1" type:"list"`

	// The Amazon EC2 instance IDs to aggregate findings for.
	InstanceIds []*StringFilter `locationName:"instanceIds" min:"1" type:"list"`

	// The Amazon EC2 instance tags to aggregate findings for.
	InstanceTags []*MapFilter `locationName:"instanceTags" min:"1" type:"list"`

	// The operating system types to aggregate findings for. Valid values must be
	// uppercase and underscore separated, examples are ORACLE_LINUX_7 and ALPINE_LINUX_3_8.
	OperatingSystems []*StringFilter `locationName:"operatingSystems" min:"1" type:"list"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"Ec2InstanceSortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2InstanceAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2InstanceAggregation"}
	if s.Amis != nil && len(s.Amis) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Amis", 1))
	}
	if s.InstanceIds != nil && len(s.InstanceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceIds", 1))
	}
	if s.InstanceTags != nil && len(s.InstanceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceTags", 1))
	}
	if s.OperatingSystems != nil && len(s.OperatingSystems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OperatingSystems", 1))
	}
	if s.Amis != nil {
		for i, v := range s.Amis {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Amis", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InstanceIds != nil {
		for i, v := range s.InstanceIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceIds", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InstanceTags != nil {
		for i, v := range s.InstanceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OperatingSystems != nil {
		for i, v := range s.OperatingSystems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OperatingSystems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmis sets the Amis field's value.
func (s *Ec2InstanceAggregation) SetAmis(v []*StringFilter) *Ec2InstanceAggregation {
	s.Amis = v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *Ec2InstanceAggregation) SetInstanceIds(v []*StringFilter) *Ec2InstanceAggregation {
	s.InstanceIds = v
	return s
}

// SetInstanceTags sets the InstanceTags field's value.
func (s *Ec2InstanceAggregation) SetInstanceTags(v []*MapFilter) *Ec2InstanceAggregation {
	s.InstanceTags = v
	return s
}

// SetOperatingSystems sets the OperatingSystems field's value.
func (s *Ec2InstanceAggregation) SetOperatingSystems(v []*StringFilter) *Ec2InstanceAggregation {
	s.OperatingSystems = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *Ec2InstanceAggregation) SetSortBy(v string) *Ec2InstanceAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Ec2InstanceAggregation) SetSortOrder(v string) *Ec2InstanceAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of a finding aggregation by Amazon EC2
// instance.
type Ec2InstanceAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account for the Amazon EC2 instance.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Machine Image (AMI) of the Amazon EC2 instance.
	Ami *string `locationName:"ami" type:"string"`

	// The Amazon EC2 instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" min:"1" type:"string" required:"true"`

	// The tags attached to the instance.
	InstanceTags map[string]*string `locationName:"instanceTags" type:"map"`

	// The number of network findings for the Amazon EC2 instance.
	NetworkFindings *int64 `locationName:"networkFindings" type:"long"`

	// The operating system of the Amazon EC2 instance.
	OperatingSystem *string `locationName:"operatingSystem" type:"string"`

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2InstanceAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Ec2InstanceAggregationResponse) SetAccountId(v string) *Ec2InstanceAggregationResponse {
	s.AccountId = &v
	return s
}

// SetAmi sets the Ami field's value.
func (s *Ec2InstanceAggregationResponse) SetAmi(v string) *Ec2InstanceAggregationResponse {
	s.Ami = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Ec2InstanceAggregationResponse) SetInstanceId(v string) *Ec2InstanceAggregationResponse {
	s.InstanceId = &v
	return s
}

// SetInstanceTags sets the InstanceTags field's value.
func (s *Ec2InstanceAggregationResponse) SetInstanceTags(v map[string]*string) *Ec2InstanceAggregationResponse {
	s.InstanceTags = v
	return s
}

// SetNetworkFindings sets the NetworkFindings field's value.
func (s *Ec2InstanceAggregationResponse) SetNetworkFindings(v int64) *Ec2InstanceAggregationResponse {
	s.NetworkFindings = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Ec2InstanceAggregationResponse) SetOperatingSystem(v string) *Ec2InstanceAggregationResponse {
	s.OperatingSystem = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *Ec2InstanceAggregationResponse) SetSeverityCounts(v *SeverityCounts) *Ec2InstanceAggregationResponse {
	s.SeverityCounts = v
	return s
}

// Meta data details of an Amazon EC2 instance.
type Ec2Metadata struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Machine Image (AMI) used to launch the instance.
	AmiId *string `locationName:"amiId" type:"string"`

	// The platform of the instance.
	Platform *string `locationName:"platform" type:"string" enum:"Ec2Platform"`

	// The tags attached to the instance.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Metadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2Metadata) GoString() string {
	return s.String()
}

// SetAmiId sets the AmiId field's value.
func (s *Ec2Metadata) SetAmiId(v string) *Ec2Metadata {
	s.AmiId = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Ec2Metadata) SetPlatform(v string) *Ec2Metadata {
	s.Platform = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Ec2Metadata) SetTags(v map[string]*string) *Ec2Metadata {
	s.Tags = v
	return s
}

// The state of your Amazon EC2 scan mode configuration.
type Ec2ScanModeState struct {
	_ struct{} `type:"structure"`

	// The scan method that is applied to the instance.
	ScanMode *string `locationName:"scanMode" type:"string" enum:"Ec2ScanMode"`

	// The status of the Amazon EC2 scan mode setting.
	ScanModeStatus *string `locationName:"scanModeStatus" type:"string" enum:"Ec2ScanModeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ScanModeState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2ScanModeState) GoString() string {
	return s.String()
}

// SetScanMode sets the ScanMode field's value.
func (s *Ec2ScanModeState) SetScanMode(v string) *Ec2ScanModeState {
	s.ScanMode = &v
	return s
}

// SetScanModeStatus sets the ScanModeStatus field's value.
func (s *Ec2ScanModeState) SetScanModeStatus(v string) *Ec2ScanModeState {
	s.ScanModeStatus = &v
	return s
}

// Details about the ECR automated re-scan duration setting for your environment.
type EcrConfiguration struct {
	_ struct{} `type:"structure"`

	// The rescan duration configured for image pull date.
	PullDateRescanDuration *string `locationName:"pullDateRescanDuration" type:"string" enum:"EcrPullDateRescanDuration"`

	// The rescan duration configured for image push date.
	//
	// RescanDuration is a required field
	RescanDuration *string `locationName:"rescanDuration" type:"string" required:"true" enum:"EcrRescanDuration"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcrConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcrConfiguration"}
	if s.RescanDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("RescanDuration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPullDateRescanDuration sets the PullDateRescanDuration field's value.
func (s *EcrConfiguration) SetPullDateRescanDuration(v string) *EcrConfiguration {
	s.PullDateRescanDuration = &v
	return s
}

// SetRescanDuration sets the RescanDuration field's value.
func (s *EcrConfiguration) SetRescanDuration(v string) *EcrConfiguration {
	s.RescanDuration = &v
	return s
}

// Details about the state of the ECR scans for your environment.
type EcrConfigurationState struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the state of the ECR re-scan settings.
	RescanDurationState *EcrRescanDurationState `locationName:"rescanDurationState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrConfigurationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrConfigurationState) GoString() string {
	return s.String()
}

// SetRescanDurationState sets the RescanDurationState field's value.
func (s *EcrConfigurationState) SetRescanDurationState(v *EcrRescanDurationState) *EcrConfigurationState {
	s.RescanDurationState = v
	return s
}

// Information on the Amazon ECR image metadata associated with a finding.
type EcrContainerImageMetadata struct {
	_ struct{} `type:"structure"`

	// The date an image was last pulled at.
	ImagePulledAt *time.Time `locationName:"imagePulledAt" type:"timestamp"`

	// Tags associated with the Amazon ECR image metadata.
	Tags []*string `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrContainerImageMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrContainerImageMetadata) GoString() string {
	return s.String()
}

// SetImagePulledAt sets the ImagePulledAt field's value.
func (s *EcrContainerImageMetadata) SetImagePulledAt(v time.Time) *EcrContainerImageMetadata {
	s.ImagePulledAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EcrContainerImageMetadata) SetTags(v []*string) *EcrContainerImageMetadata {
	s.Tags = v
	return s
}

// Information on the Amazon ECR repository metadata associated with a finding.
type EcrRepositoryMetadata struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon ECR repository.
	Name *string `locationName:"name" type:"string"`

	// The frequency of scans.
	ScanFrequency *string `locationName:"scanFrequency" type:"string" enum:"EcrScanFrequency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrRepositoryMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrRepositoryMetadata) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EcrRepositoryMetadata) SetName(v string) *EcrRepositoryMetadata {
	s.Name = &v
	return s
}

// SetScanFrequency sets the ScanFrequency field's value.
func (s *EcrRepositoryMetadata) SetScanFrequency(v string) *EcrRepositoryMetadata {
	s.ScanFrequency = &v
	return s
}

// Details about the state of your ECR re-scan duration settings. The ECR re-scan
// duration defines how long an ECR image will be actively scanned by Amazon
// Inspector. When the number of days since an image was last pushed exceeds
// the duration configured for image pull date, and the duration configured
// for image pull date, the monitoring state of that image becomes inactive
// and all associated findings are scheduled for closure.
type EcrRescanDurationState struct {
	_ struct{} `type:"structure"`

	// The rescan duration configured for image pull date.
	PullDateRescanDuration *string `locationName:"pullDateRescanDuration" type:"string" enum:"EcrPullDateRescanDuration"`

	RescanDuration *string `locationName:"rescanDuration" type:"string" enum:"EcrRescanDuration"`

	// The status of changes to the ECR automated re-scan duration.
	Status *string `locationName:"status" type:"string" enum:"EcrRescanDurationStatus"`

	// A timestamp representing when the last time the ECR scan duration setting
	// was changed.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrRescanDurationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcrRescanDurationState) GoString() string {
	return s.String()
}

// SetPullDateRescanDuration sets the PullDateRescanDuration field's value.
func (s *EcrRescanDurationState) SetPullDateRescanDuration(v string) *EcrRescanDurationState {
	s.PullDateRescanDuration = &v
	return s
}

// SetRescanDuration sets the RescanDuration field's value.
func (s *EcrRescanDurationState) SetRescanDuration(v string) *EcrRescanDurationState {
	s.RescanDuration = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EcrRescanDurationState) SetStatus(v string) *EcrRescanDurationState {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EcrRescanDurationState) SetUpdatedAt(v time.Time) *EcrRescanDurationState {
	s.UpdatedAt = &v
	return s
}

type EnableDelegatedAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token for the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
	//
	// DelegatedAdminAccountId is a required field
	DelegatedAdminAccountId *string `locationName:"delegatedAdminAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableDelegatedAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableDelegatedAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableDelegatedAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableDelegatedAdminAccountInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DelegatedAdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("DelegatedAdminAccountId"))
	}
	if s.DelegatedAdminAccountId != nil && len(*s.DelegatedAdminAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DelegatedAdminAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *EnableDelegatedAdminAccountInput) SetClientToken(v string) *EnableDelegatedAdminAccountInput {
	s.ClientToken = &v
	return s
}

// SetDelegatedAdminAccountId sets the DelegatedAdminAccountId field's value.
func (s *EnableDelegatedAdminAccountInput) SetDelegatedAdminAccountId(v string) *EnableDelegatedAdminAccountInput {
	s.DelegatedAdminAccountId = &v
	return s
}

type EnableDelegatedAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the successfully Amazon Inspector delegated
	// administrator.
	//
	// DelegatedAdminAccountId is a required field
	DelegatedAdminAccountId *string `locationName:"delegatedAdminAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableDelegatedAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableDelegatedAdminAccountOutput) GoString() string {
	return s.String()
}

// SetDelegatedAdminAccountId sets the DelegatedAdminAccountId field's value.
func (s *EnableDelegatedAdminAccountOutput) SetDelegatedAdminAccountId(v string) *EnableDelegatedAdminAccountOutput {
	s.DelegatedAdminAccountId = &v
	return s
}

type EnableInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs you want to enable Amazon Inspector scans for.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// The idempotency token for the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The resource scan types you want to enable.
	//
	// ResourceTypes is a required field
	ResourceTypes []*string `locationName:"resourceTypes" min:"1" type:"list" required:"true" enum:"ResourceScanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTypes"))
	}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *EnableInput) SetAccountIds(v []*string) *EnableInput {
	s.AccountIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *EnableInput) SetClientToken(v string) *EnableInput {
	s.ClientToken = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *EnableInput) SetResourceTypes(v []*string) *EnableInput {
	s.ResourceTypes = v
	return s
}

type EnableOutput struct {
	_ struct{} `type:"structure"`

	// Information on the accounts that have had Amazon Inspector scans successfully
	// enabled. Details are provided for each account.
	//
	// Accounts is a required field
	Accounts []*Account `locationName:"accounts" type:"list" required:"true"`

	// Information on any accounts for which Amazon Inspector scans could not be
	// enabled. Details are provided for each account.
	FailedAccounts []*FailedAccount `locationName:"failedAccounts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *EnableOutput) SetAccounts(v []*Account) *EnableOutput {
	s.Accounts = v
	return s
}

// SetFailedAccounts sets the FailedAccounts field's value.
func (s *EnableOutput) SetFailedAccounts(v []*FailedAccount) *EnableOutput {
	s.FailedAccounts = v
	return s
}

// Details about the Exploit Prediction Scoring System (EPSS) score.
type Epss struct {
	_ struct{} `type:"structure"`

	// The Exploit Prediction Scoring System (EPSS) score.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Epss) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Epss) GoString() string {
	return s.String()
}

// SetScore sets the Score field's value.
func (s *Epss) SetScore(v float64) *Epss {
	s.Score = &v
	return s
}

// Details about the Exploit Prediction Scoring System (EPSS) score for a finding.
type EpssDetails struct {
	_ struct{} `type:"structure"`

	// The EPSS score.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EpssDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EpssDetails) GoString() string {
	return s.String()
}

// SetScore sets the Score field's value.
func (s *EpssDetails) SetScore(v float64) *EpssDetails {
	s.Score = &v
	return s
}

// Details of the evidence for a vulnerability identified in a finding.
type Evidence struct {
	_ struct{} `type:"structure"`

	// The evidence details.
	EvidenceDetail *string `locationName:"evidenceDetail" type:"string"`

	// The evidence rule.
	EvidenceRule *string `locationName:"evidenceRule" type:"string"`

	// The evidence severity.
	Severity *string `locationName:"severity" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Evidence) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Evidence) GoString() string {
	return s.String()
}

// SetEvidenceDetail sets the EvidenceDetail field's value.
func (s *Evidence) SetEvidenceDetail(v string) *Evidence {
	s.EvidenceDetail = &v
	return s
}

// SetEvidenceRule sets the EvidenceRule field's value.
func (s *Evidence) SetEvidenceRule(v string) *Evidence {
	s.EvidenceRule = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Evidence) SetSeverity(v string) *Evidence {
	s.Severity = &v
	return s
}

// Contains information on when this exploit was observed.
type ExploitObserved struct {
	_ struct{} `type:"structure"`

	// The date an time when the exploit was first seen.
	FirstSeen *time.Time `locationName:"firstSeen" type:"timestamp"`

	// The date an time when the exploit was last seen.
	LastSeen *time.Time `locationName:"lastSeen" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExploitObserved) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExploitObserved) GoString() string {
	return s.String()
}

// SetFirstSeen sets the FirstSeen field's value.
func (s *ExploitObserved) SetFirstSeen(v time.Time) *ExploitObserved {
	s.FirstSeen = &v
	return s
}

// SetLastSeen sets the LastSeen field's value.
func (s *ExploitObserved) SetLastSeen(v time.Time) *ExploitObserved {
	s.LastSeen = &v
	return s
}

// The details of an exploit available for a finding discovered in your environment.
type ExploitabilityDetails struct {
	_ struct{} `type:"structure"`

	// The date and time of the last exploit associated with a finding discovered
	// in your environment.
	LastKnownExploitAt *time.Time `locationName:"lastKnownExploitAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExploitabilityDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExploitabilityDetails) GoString() string {
	return s.String()
}

// SetLastKnownExploitAt sets the LastKnownExploitAt field's value.
func (s *ExploitabilityDetails) SetLastKnownExploitAt(v time.Time) *ExploitabilityDetails {
	s.LastKnownExploitAt = &v
	return s
}

// An object with details on why an account failed to enable Amazon Inspector.
type FailedAccount struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The error code explaining why the account failed to enable Amazon Inspector.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"ErrorCode"`

	// The error message received when the account failed to enable Amazon Inspector.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string" required:"true"`

	// An object detailing which resources Amazon Inspector is enabled to scan for
	// the account.
	ResourceStatus *ResourceStatus `locationName:"resourceStatus" type:"structure"`

	// The status of Amazon Inspector for the account.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FailedAccount) SetAccountId(v string) *FailedAccount {
	s.AccountId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedAccount) SetErrorCode(v string) *FailedAccount {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedAccount) SetErrorMessage(v string) *FailedAccount {
	s.ErrorMessage = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *FailedAccount) SetResourceStatus(v *ResourceStatus) *FailedAccount {
	s.ResourceStatus = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FailedAccount) SetStatus(v string) *FailedAccount {
	s.Status = &v
	return s
}

// An object that contains details about a member account in your organization
// that failed to activate Amazon Inspector deep inspection.
type FailedMemberAccountEc2DeepInspectionStatusState struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Amazon Web Services account of the organization
	// member that failed to activate Amazon Inspector deep inspection.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The status of EC2 scanning in the account that failed to activate Amazon
	// Inspector deep inspection.
	Ec2ScanStatus *string `locationName:"ec2ScanStatus" type:"string" enum:"Status"`

	// The error message explaining why the account failed to activate Amazon Inspector
	// deep inspection.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedMemberAccountEc2DeepInspectionStatusState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedMemberAccountEc2DeepInspectionStatusState) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FailedMemberAccountEc2DeepInspectionStatusState) SetAccountId(v string) *FailedMemberAccountEc2DeepInspectionStatusState {
	s.AccountId = &v
	return s
}

// SetEc2ScanStatus sets the Ec2ScanStatus field's value.
func (s *FailedMemberAccountEc2DeepInspectionStatusState) SetEc2ScanStatus(v string) *FailedMemberAccountEc2DeepInspectionStatusState {
	s.Ec2ScanStatus = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedMemberAccountEc2DeepInspectionStatusState) SetErrorMessage(v string) *FailedMemberAccountEc2DeepInspectionStatusState {
	s.ErrorMessage = &v
	return s
}

// Details about a filter.
type Filter struct {
	_ struct{} `type:"structure"`

	// The action that is to be applied to the findings that match the filter.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"FilterAction"`

	// The Amazon Resource Number (ARN) associated with this filter.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date and time this filter was created at.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Details on the filter criteria associated with this filter.
	//
	// Criteria is a required field
	Criteria *FilterCriteria `locationName:"criteria" type:"structure" required:"true"`

	// A description of the filter.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Web Services account ID of the account that created the filter.
	//
	// OwnerId is a required field
	OwnerId *string `locationName:"ownerId" min:"12" type:"string" required:"true"`

	// The reason for the filter.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// The tags attached to the filter.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The date and time the filter was last updated at.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Filter) SetAction(v string) *Filter {
	s.Action = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Filter) SetArn(v string) *Filter {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Filter) SetCreatedAt(v time.Time) *Filter {
	s.CreatedAt = &v
	return s
}

// SetCriteria sets the Criteria field's value.
func (s *Filter) SetCriteria(v *FilterCriteria) *Filter {
	s.Criteria = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Filter) SetDescription(v string) *Filter {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *Filter) SetOwnerId(v string) *Filter {
	s.OwnerId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Filter) SetReason(v string) *Filter {
	s.Reason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Filter) SetTags(v map[string]*string) *Filter {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Filter) SetUpdatedAt(v time.Time) *Filter {
	s.UpdatedAt = &v
	return s
}

// Details on the criteria used to define the filter.
type FilterCriteria struct {
	_ struct{} `type:"structure"`

	// Details of the Amazon Web Services account IDs used to filter findings.
	AwsAccountId []*StringFilter `locationName:"awsAccountId" min:"1" type:"list"`

	// The name of the detector used to identify a code vulnerability in a Lambda
	// function used to filter findings.
	CodeVulnerabilityDetectorName []*StringFilter `locationName:"codeVulnerabilityDetectorName" min:"1" type:"list"`

	// The detector type tag associated with the vulnerability used to filter findings.
	// Detector tags group related vulnerabilities by common themes or tactics.
	// For a list of available tags by programming language, see Java tags (https://docs.aws.amazon.com/codeguru/detector-library/java/tags/),
	// or Python tags (https://docs.aws.amazon.com/codeguru/detector-library/python/tags/).
	CodeVulnerabilityDetectorTags []*StringFilter `locationName:"codeVulnerabilityDetectorTags" min:"1" type:"list"`

	// The file path to the file in a Lambda function that contains a code vulnerability
	// used to filter findings.
	CodeVulnerabilityFilePath []*StringFilter `locationName:"codeVulnerabilityFilePath" min:"1" type:"list"`

	// Details of the component IDs used to filter findings.
	ComponentId []*StringFilter `locationName:"componentId" min:"1" type:"list"`

	// Details of the component types used to filter findings.
	ComponentType []*StringFilter `locationName:"componentType" min:"1" type:"list"`

	// Details of the Amazon EC2 instance image IDs used to filter findings.
	Ec2InstanceImageId []*StringFilter `locationName:"ec2InstanceImageId" min:"1" type:"list"`

	// Details of the Amazon EC2 instance subnet IDs used to filter findings.
	Ec2InstanceSubnetId []*StringFilter `locationName:"ec2InstanceSubnetId" min:"1" type:"list"`

	// Details of the Amazon EC2 instance VPC IDs used to filter findings.
	Ec2InstanceVpcId []*StringFilter `locationName:"ec2InstanceVpcId" min:"1" type:"list"`

	// Details of the Amazon ECR image architecture types used to filter findings.
	EcrImageArchitecture []*StringFilter `locationName:"ecrImageArchitecture" min:"1" type:"list"`

	// Details of the Amazon ECR image hashes used to filter findings.
	EcrImageHash []*StringFilter `locationName:"ecrImageHash" min:"1" type:"list"`

	// Details on the Amazon ECR image push date and time used to filter findings.
	EcrImagePushedAt []*DateFilter `locationName:"ecrImagePushedAt" min:"1" type:"list"`

	// Details on the Amazon ECR registry used to filter findings.
	EcrImageRegistry []*StringFilter `locationName:"ecrImageRegistry" min:"1" type:"list"`

	// Details on the name of the Amazon ECR repository used to filter findings.
	EcrImageRepositoryName []*StringFilter `locationName:"ecrImageRepositoryName" min:"1" type:"list"`

	// The tags attached to the Amazon ECR container image.
	EcrImageTags []*StringFilter `locationName:"ecrImageTags" min:"1" type:"list"`

	// The EPSS score used to filter findings.
	EpssScore []*NumberFilter `locationName:"epssScore" min:"1" type:"list"`

	// Filters the list of Amazon Web Services Lambda findings by the availability
	// of exploits.
	ExploitAvailable []*StringFilter `locationName:"exploitAvailable" min:"1" type:"list"`

	// Details on the finding ARNs used to filter findings.
	FindingArn []*StringFilter `locationName:"findingArn" min:"1" type:"list"`

	// Details on the finding status types used to filter findings.
	FindingStatus []*StringFilter `locationName:"findingStatus" min:"1" type:"list"`

	// Details on the finding types used to filter findings.
	FindingType []*StringFilter `locationName:"findingType" min:"1" type:"list"`

	// Details on the date and time a finding was first seen used to filter findings.
	FirstObservedAt []*DateFilter `locationName:"firstObservedAt" min:"1" type:"list"`

	// Details on whether a fix is available through a version update. This value
	// can be YES, NO, or PARTIAL. A PARTIAL fix means that some, but not all, of
	// the packages identified in the finding have fixes available through updated
	// versions.
	FixAvailable []*StringFilter `locationName:"fixAvailable" min:"1" type:"list"`

	// The Amazon Inspector score to filter on.
	InspectorScore []*NumberFilter `locationName:"inspectorScore" min:"1" type:"list"`

	// Filters the list of Amazon Web Services Lambda functions by execution role.
	LambdaFunctionExecutionRoleArn []*StringFilter `locationName:"lambdaFunctionExecutionRoleArn" min:"1" type:"list"`

	// Filters the list of Amazon Web Services Lambda functions by the date and
	// time that a user last updated the configuration, in ISO 8601 format (https://www.iso.org/iso-8601-date-and-time-format.html)
	LambdaFunctionLastModifiedAt []*DateFilter `locationName:"lambdaFunctionLastModifiedAt" min:"1" type:"list"`

	// Filters the list of Amazon Web Services Lambda functions by the function's
	// layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
	// A Lambda function can have up to five layers.
	LambdaFunctionLayers []*StringFilter `locationName:"lambdaFunctionLayers" min:"1" type:"list"`

	// Filters the list of Amazon Web Services Lambda functions by the name of the
	// function.
	LambdaFunctionName []*StringFilter `locationName:"lambdaFunctionName" min:"1" type:"list"`

	// Filters the list of Amazon Web Services Lambda functions by the runtime environment
	// for the Lambda function.
	LambdaFunctionRuntime []*StringFilter `locationName:"lambdaFunctionRuntime" min:"1" type:"list"`

	// Details on the date and time a finding was last seen used to filter findings.
	LastObservedAt []*DateFilter `locationName:"lastObservedAt" min:"1" type:"list"`

	// Details on network protocol used to filter findings.
	NetworkProtocol []*StringFilter `locationName:"networkProtocol" min:"1" type:"list"`

	// Details on the port ranges used to filter findings.
	PortRange []*PortRangeFilter `locationName:"portRange" min:"1" type:"list"`

	// Details on the related vulnerabilities used to filter findings.
	RelatedVulnerabilities []*StringFilter `locationName:"relatedVulnerabilities" min:"1" type:"list"`

	// Details on the resource IDs used to filter findings.
	ResourceId []*StringFilter `locationName:"resourceId" min:"1" type:"list"`

	// Details on the resource tags used to filter findings.
	ResourceTags []*MapFilter `locationName:"resourceTags" min:"1" type:"list"`

	// Details on the resource types used to filter findings.
	ResourceType []*StringFilter `locationName:"resourceType" min:"1" type:"list"`

	// Details on the severity used to filter findings.
	Severity []*StringFilter `locationName:"severity" min:"1" type:"list"`

	// Details on the finding title used to filter findings.
	Title []*StringFilter `locationName:"title" min:"1" type:"list"`

	// Details on the date and time a finding was last updated at used to filter
	// findings.
	UpdatedAt []*DateFilter `locationName:"updatedAt" min:"1" type:"list"`

	// Details on the vendor severity used to filter findings.
	VendorSeverity []*StringFilter `locationName:"vendorSeverity" min:"1" type:"list"`

	// Details on the vulnerability ID used to filter findings.
	VulnerabilityId []*StringFilter `locationName:"vulnerabilityId" min:"1" type:"list"`

	// Details on the vulnerability type used to filter findings.
	VulnerabilitySource []*StringFilter `locationName:"vulnerabilitySource" min:"1" type:"list"`

	// Details on the vulnerable packages used to filter findings.
	VulnerablePackages []*PackageFilter `locationName:"vulnerablePackages" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterCriteria"}
	if s.AwsAccountId != nil && len(s.AwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 1))
	}
	if s.CodeVulnerabilityDetectorName != nil && len(s.CodeVulnerabilityDetectorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeVulnerabilityDetectorName", 1))
	}
	if s.CodeVulnerabilityDetectorTags != nil && len(s.CodeVulnerabilityDetectorTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeVulnerabilityDetectorTags", 1))
	}
	if s.CodeVulnerabilityFilePath != nil && len(s.CodeVulnerabilityFilePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeVulnerabilityFilePath", 1))
	}
	if s.ComponentId != nil && len(s.ComponentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentId", 1))
	}
	if s.ComponentType != nil && len(s.ComponentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentType", 1))
	}
	if s.Ec2InstanceImageId != nil && len(s.Ec2InstanceImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ec2InstanceImageId", 1))
	}
	if s.Ec2InstanceSubnetId != nil && len(s.Ec2InstanceSubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ec2InstanceSubnetId", 1))
	}
	if s.Ec2InstanceVpcId != nil && len(s.Ec2InstanceVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ec2InstanceVpcId", 1))
	}
	if s.EcrImageArchitecture != nil && len(s.EcrImageArchitecture) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageArchitecture", 1))
	}
	if s.EcrImageHash != nil && len(s.EcrImageHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageHash", 1))
	}
	if s.EcrImagePushedAt != nil && len(s.EcrImagePushedAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImagePushedAt", 1))
	}
	if s.EcrImageRegistry != nil && len(s.EcrImageRegistry) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageRegistry", 1))
	}
	if s.EcrImageRepositoryName != nil && len(s.EcrImageRepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageRepositoryName", 1))
	}
	if s.EcrImageTags != nil && len(s.EcrImageTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageTags", 1))
	}
	if s.EpssScore != nil && len(s.EpssScore) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EpssScore", 1))
	}
	if s.ExploitAvailable != nil && len(s.ExploitAvailable) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExploitAvailable", 1))
	}
	if s.FindingArn != nil && len(s.FindingArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingArn", 1))
	}
	if s.FindingStatus != nil && len(s.FindingStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingStatus", 1))
	}
	if s.FindingType != nil && len(s.FindingType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingType", 1))
	}
	if s.FirstObservedAt != nil && len(s.FirstObservedAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstObservedAt", 1))
	}
	if s.FixAvailable != nil && len(s.FixAvailable) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FixAvailable", 1))
	}
	if s.InspectorScore != nil && len(s.InspectorScore) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InspectorScore", 1))
	}
	if s.LambdaFunctionExecutionRoleArn != nil && len(s.LambdaFunctionExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionExecutionRoleArn", 1))
	}
	if s.LambdaFunctionLastModifiedAt != nil && len(s.LambdaFunctionLastModifiedAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionLastModifiedAt", 1))
	}
	if s.LambdaFunctionLayers != nil && len(s.LambdaFunctionLayers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionLayers", 1))
	}
	if s.LambdaFunctionName != nil && len(s.LambdaFunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionName", 1))
	}
	if s.LambdaFunctionRuntime != nil && len(s.LambdaFunctionRuntime) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionRuntime", 1))
	}
	if s.LastObservedAt != nil && len(s.LastObservedAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastObservedAt", 1))
	}
	if s.NetworkProtocol != nil && len(s.NetworkProtocol) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkProtocol", 1))
	}
	if s.PortRange != nil && len(s.PortRange) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRange", 1))
	}
	if s.RelatedVulnerabilities != nil && len(s.RelatedVulnerabilities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelatedVulnerabilities", 1))
	}
	if s.ResourceId != nil && len(s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceTags != nil && len(s.ResourceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTags", 1))
	}
	if s.ResourceType != nil && len(s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.Severity != nil && len(s.Severity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Severity", 1))
	}
	if s.Title != nil && len(s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.UpdatedAt != nil && len(s.UpdatedAt) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdatedAt", 1))
	}
	if s.VendorSeverity != nil && len(s.VendorSeverity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VendorSeverity", 1))
	}
	if s.VulnerabilityId != nil && len(s.VulnerabilityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VulnerabilityId", 1))
	}
	if s.VulnerabilitySource != nil && len(s.VulnerabilitySource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VulnerabilitySource", 1))
	}
	if s.VulnerablePackages != nil && len(s.VulnerablePackages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VulnerablePackages", 1))
	}
	if s.AwsAccountId != nil {
		for i, v := range s.AwsAccountId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AwsAccountId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CodeVulnerabilityDetectorName != nil {
		for i, v := range s.CodeVulnerabilityDetectorName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CodeVulnerabilityDetectorName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CodeVulnerabilityDetectorTags != nil {
		for i, v := range s.CodeVulnerabilityDetectorTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CodeVulnerabilityDetectorTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CodeVulnerabilityFilePath != nil {
		for i, v := range s.CodeVulnerabilityFilePath {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CodeVulnerabilityFilePath", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ComponentId != nil {
		for i, v := range s.ComponentId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComponentId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ComponentType != nil {
		for i, v := range s.ComponentType {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComponentType", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ec2InstanceImageId != nil {
		for i, v := range s.Ec2InstanceImageId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2InstanceImageId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ec2InstanceSubnetId != nil {
		for i, v := range s.Ec2InstanceSubnetId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2InstanceSubnetId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ec2InstanceVpcId != nil {
		for i, v := range s.Ec2InstanceVpcId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2InstanceVpcId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageArchitecture != nil {
		for i, v := range s.EcrImageArchitecture {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageArchitecture", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageHash != nil {
		for i, v := range s.EcrImageHash {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageHash", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageRegistry != nil {
		for i, v := range s.EcrImageRegistry {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageRegistry", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageRepositoryName != nil {
		for i, v := range s.EcrImageRepositoryName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageRepositoryName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageTags != nil {
		for i, v := range s.EcrImageTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ExploitAvailable != nil {
		for i, v := range s.ExploitAvailable {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExploitAvailable", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FindingArn != nil {
		for i, v := range s.FindingArn {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingArn", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FindingStatus != nil {
		for i, v := range s.FindingStatus {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingStatus", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FindingType != nil {
		for i, v := range s.FindingType {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingType", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FixAvailable != nil {
		for i, v := range s.FixAvailable {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FixAvailable", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionExecutionRoleArn != nil {
		for i, v := range s.LambdaFunctionExecutionRoleArn {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionExecutionRoleArn", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionLayers != nil {
		for i, v := range s.LambdaFunctionLayers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionLayers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionName != nil {
		for i, v := range s.LambdaFunctionName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionRuntime != nil {
		for i, v := range s.LambdaFunctionRuntime {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionRuntime", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkProtocol != nil {
		for i, v := range s.NetworkProtocol {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NetworkProtocol", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RelatedVulnerabilities != nil {
		for i, v := range s.RelatedVulnerabilities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedVulnerabilities", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceId != nil {
		for i, v := range s.ResourceId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceType != nil {
		for i, v := range s.ResourceType {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceType", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Severity != nil {
		for i, v := range s.Severity {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Severity", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Title != nil {
		for i, v := range s.Title {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Title", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VendorSeverity != nil {
		for i, v := range s.VendorSeverity {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VendorSeverity", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VulnerabilityId != nil {
		for i, v := range s.VulnerabilityId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VulnerabilityId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VulnerabilitySource != nil {
		for i, v := range s.VulnerabilitySource {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VulnerabilitySource", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VulnerablePackages != nil {
		for i, v := range s.VulnerablePackages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VulnerablePackages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *FilterCriteria) SetAwsAccountId(v []*StringFilter) *FilterCriteria {
	s.AwsAccountId = v
	return s
}

// SetCodeVulnerabilityDetectorName sets the CodeVulnerabilityDetectorName field's value.
func (s *FilterCriteria) SetCodeVulnerabilityDetectorName(v []*StringFilter) *FilterCriteria {
	s.CodeVulnerabilityDetectorName = v
	return s
}

// SetCodeVulnerabilityDetectorTags sets the CodeVulnerabilityDetectorTags field's value.
func (s *FilterCriteria) SetCodeVulnerabilityDetectorTags(v []*StringFilter) *FilterCriteria {
	s.CodeVulnerabilityDetectorTags = v
	return s
}

// SetCodeVulnerabilityFilePath sets the CodeVulnerabilityFilePath field's value.
func (s *FilterCriteria) SetCodeVulnerabilityFilePath(v []*StringFilter) *FilterCriteria {
	s.CodeVulnerabilityFilePath = v
	return s
}

// SetComponentId sets the ComponentId field's value.
func (s *FilterCriteria) SetComponentId(v []*StringFilter) *FilterCriteria {
	s.ComponentId = v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *FilterCriteria) SetComponentType(v []*StringFilter) *FilterCriteria {
	s.ComponentType = v
	return s
}

// SetEc2InstanceImageId sets the Ec2InstanceImageId field's value.
func (s *FilterCriteria) SetEc2InstanceImageId(v []*StringFilter) *FilterCriteria {
	s.Ec2InstanceImageId = v
	return s
}

// SetEc2InstanceSubnetId sets the Ec2InstanceSubnetId field's value.
func (s *FilterCriteria) SetEc2InstanceSubnetId(v []*StringFilter) *FilterCriteria {
	s.Ec2InstanceSubnetId = v
	return s
}

// SetEc2InstanceVpcId sets the Ec2InstanceVpcId field's value.
func (s *FilterCriteria) SetEc2InstanceVpcId(v []*StringFilter) *FilterCriteria {
	s.Ec2InstanceVpcId = v
	return s
}

// SetEcrImageArchitecture sets the EcrImageArchitecture field's value.
func (s *FilterCriteria) SetEcrImageArchitecture(v []*StringFilter) *FilterCriteria {
	s.EcrImageArchitecture = v
	return s
}

// SetEcrImageHash sets the EcrImageHash field's value.
func (s *FilterCriteria) SetEcrImageHash(v []*StringFilter) *FilterCriteria {
	s.EcrImageHash = v
	return s
}

// SetEcrImagePushedAt sets the EcrImagePushedAt field's value.
func (s *FilterCriteria) SetEcrImagePushedAt(v []*DateFilter) *FilterCriteria {
	s.EcrImagePushedAt = v
	return s
}

// SetEcrImageRegistry sets the EcrImageRegistry field's value.
func (s *FilterCriteria) SetEcrImageRegistry(v []*StringFilter) *FilterCriteria {
	s.EcrImageRegistry = v
	return s
}

// SetEcrImageRepositoryName sets the EcrImageRepositoryName field's value.
func (s *FilterCriteria) SetEcrImageRepositoryName(v []*StringFilter) *FilterCriteria {
	s.EcrImageRepositoryName = v
	return s
}

// SetEcrImageTags sets the EcrImageTags field's value.
func (s *FilterCriteria) SetEcrImageTags(v []*StringFilter) *FilterCriteria {
	s.EcrImageTags = v
	return s
}

// SetEpssScore sets the EpssScore field's value.
func (s *FilterCriteria) SetEpssScore(v []*NumberFilter) *FilterCriteria {
	s.EpssScore = v
	return s
}

// SetExploitAvailable sets the ExploitAvailable field's value.
func (s *FilterCriteria) SetExploitAvailable(v []*StringFilter) *FilterCriteria {
	s.ExploitAvailable = v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *FilterCriteria) SetFindingArn(v []*StringFilter) *FilterCriteria {
	s.FindingArn = v
	return s
}

// SetFindingStatus sets the FindingStatus field's value.
func (s *FilterCriteria) SetFindingStatus(v []*StringFilter) *FilterCriteria {
	s.FindingStatus = v
	return s
}

// SetFindingType sets the FindingType field's value.
func (s *FilterCriteria) SetFindingType(v []*StringFilter) *FilterCriteria {
	s.FindingType = v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *FilterCriteria) SetFirstObservedAt(v []*DateFilter) *FilterCriteria {
	s.FirstObservedAt = v
	return s
}

// SetFixAvailable sets the FixAvailable field's value.
func (s *FilterCriteria) SetFixAvailable(v []*StringFilter) *FilterCriteria {
	s.FixAvailable = v
	return s
}

// SetInspectorScore sets the InspectorScore field's value.
func (s *FilterCriteria) SetInspectorScore(v []*NumberFilter) *FilterCriteria {
	s.InspectorScore = v
	return s
}

// SetLambdaFunctionExecutionRoleArn sets the LambdaFunctionExecutionRoleArn field's value.
func (s *FilterCriteria) SetLambdaFunctionExecutionRoleArn(v []*StringFilter) *FilterCriteria {
	s.LambdaFunctionExecutionRoleArn = v
	return s
}

// SetLambdaFunctionLastModifiedAt sets the LambdaFunctionLastModifiedAt field's value.
func (s *FilterCriteria) SetLambdaFunctionLastModifiedAt(v []*DateFilter) *FilterCriteria {
	s.LambdaFunctionLastModifiedAt = v
	return s
}

// SetLambdaFunctionLayers sets the LambdaFunctionLayers field's value.
func (s *FilterCriteria) SetLambdaFunctionLayers(v []*StringFilter) *FilterCriteria {
	s.LambdaFunctionLayers = v
	return s
}

// SetLambdaFunctionName sets the LambdaFunctionName field's value.
func (s *FilterCriteria) SetLambdaFunctionName(v []*StringFilter) *FilterCriteria {
	s.LambdaFunctionName = v
	return s
}

// SetLambdaFunctionRuntime sets the LambdaFunctionRuntime field's value.
func (s *FilterCriteria) SetLambdaFunctionRuntime(v []*StringFilter) *FilterCriteria {
	s.LambdaFunctionRuntime = v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *FilterCriteria) SetLastObservedAt(v []*DateFilter) *FilterCriteria {
	s.LastObservedAt = v
	return s
}

// SetNetworkProtocol sets the NetworkProtocol field's value.
func (s *FilterCriteria) SetNetworkProtocol(v []*StringFilter) *FilterCriteria {
	s.NetworkProtocol = v
	return s
}

// SetPortRange sets the PortRange field's value.
func (s *FilterCriteria) SetPortRange(v []*PortRangeFilter) *FilterCriteria {
	s.PortRange = v
	return s
}

// SetRelatedVulnerabilities sets the RelatedVulnerabilities field's value.
func (s *FilterCriteria) SetRelatedVulnerabilities(v []*StringFilter) *FilterCriteria {
	s.RelatedVulnerabilities = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *FilterCriteria) SetResourceId(v []*StringFilter) *FilterCriteria {
	s.ResourceId = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *FilterCriteria) SetResourceTags(v []*MapFilter) *FilterCriteria {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *FilterCriteria) SetResourceType(v []*StringFilter) *FilterCriteria {
	s.ResourceType = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *FilterCriteria) SetSeverity(v []*StringFilter) *FilterCriteria {
	s.Severity = v
	return s
}

// SetTitle sets the Title field's value.
func (s *FilterCriteria) SetTitle(v []*StringFilter) *FilterCriteria {
	s.Title = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FilterCriteria) SetUpdatedAt(v []*DateFilter) *FilterCriteria {
	s.UpdatedAt = v
	return s
}

// SetVendorSeverity sets the VendorSeverity field's value.
func (s *FilterCriteria) SetVendorSeverity(v []*StringFilter) *FilterCriteria {
	s.VendorSeverity = v
	return s
}

// SetVulnerabilityId sets the VulnerabilityId field's value.
func (s *FilterCriteria) SetVulnerabilityId(v []*StringFilter) *FilterCriteria {
	s.VulnerabilityId = v
	return s
}

// SetVulnerabilitySource sets the VulnerabilitySource field's value.
func (s *FilterCriteria) SetVulnerabilitySource(v []*StringFilter) *FilterCriteria {
	s.VulnerabilitySource = v
	return s
}

// SetVulnerablePackages sets the VulnerablePackages field's value.
func (s *FilterCriteria) SetVulnerablePackages(v []*PackageFilter) *FilterCriteria {
	s.VulnerablePackages = v
	return s
}

// Details about an Amazon Inspector finding.
type Finding struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID associated with the finding.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `locationName:"awsAccountId" min:"12" type:"string" required:"true"`

	// Details about the code vulnerability identified in a Lambda function used
	// to filter findings.
	CodeVulnerabilityDetails *CodeVulnerabilityDetails `locationName:"codeVulnerabilityDetails" type:"structure"`

	// The description of the finding.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The finding's EPSS score.
	Epss *EpssDetails `locationName:"epss" type:"structure"`

	// If a finding discovered in your environment has an exploit available.
	ExploitAvailable *string `locationName:"exploitAvailable" type:"string" enum:"ExploitAvailable"`

	// The details of an exploit available for a finding discovered in your environment.
	ExploitabilityDetails *ExploitabilityDetails `locationName:"exploitabilityDetails" type:"structure"`

	// The Amazon Resource Number (ARN) of the finding.
	//
	// FindingArn is a required field
	FindingArn *string `locationName:"findingArn" min:"1" type:"string" required:"true"`

	// The date and time that the finding was first observed.
	//
	// FirstObservedAt is a required field
	FirstObservedAt *time.Time `locationName:"firstObservedAt" type:"timestamp" required:"true"`

	// Details on whether a fix is available through a version update. This value
	// can be YES, NO, or PARTIAL. A PARTIAL fix means that some, but not all, of
	// the packages identified in the finding have fixes available through updated
	// versions.
	FixAvailable *string `locationName:"fixAvailable" type:"string" enum:"FixAvailable"`

	// The Amazon Inspector score given to the finding.
	InspectorScore *float64 `locationName:"inspectorScore" type:"double"`

	// An object that contains details of the Amazon Inspector score.
	InspectorScoreDetails *InspectorScoreDetails `locationName:"inspectorScoreDetails" type:"structure"`

	// The date and time the finding was last observed. This timestamp for this
	// field remains unchanged until a finding is updated.
	//
	// LastObservedAt is a required field
	LastObservedAt *time.Time `locationName:"lastObservedAt" type:"timestamp" required:"true"`

	// An object that contains the details of a network reachability finding.
	NetworkReachabilityDetails *NetworkReachabilityDetails `locationName:"networkReachabilityDetails" type:"structure"`

	// An object that contains the details of a package vulnerability finding.
	PackageVulnerabilityDetails *PackageVulnerabilityDetails `locationName:"packageVulnerabilityDetails" type:"structure"`

	// An object that contains the details about how to remediate a finding.
	//
	// Remediation is a required field
	Remediation *Remediation `locationName:"remediation" type:"structure" required:"true"`

	// Contains information on the resources involved in a finding. The resource
	// value determines the valid values for type in your request. For more information,
	// see Finding types (https://docs.aws.amazon.com/inspector/latest/user/findings-types.html)
	// in the Amazon Inspector user guide.
	//
	// Resources is a required field
	Resources []*Resource `locationName:"resources" min:"1" type:"list" required:"true"`

	// The severity of the finding. UNTRIAGED applies to PACKAGE_VULNERABILITY type
	// findings that the vendor has not assigned a severity yet. For more information,
	// see Severity levels for findings (https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html)
	// in the Amazon Inspector user guide.
	//
	// Severity is a required field
	Severity *string `locationName:"severity" type:"string" required:"true" enum:"Severity"`

	// The status of the finding.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FindingStatus"`

	// The title of the finding.
	Title *string `locationName:"title" min:"1" type:"string"`

	// The type of the finding. The type value determines the valid values for resource
	// in your request. For more information, see Finding types (https://docs.aws.amazon.com/inspector/latest/user/findings-types.html)
	// in the Amazon Inspector user guide.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FindingType"`

	// The date and time the finding was last updated at.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *Finding) SetAwsAccountId(v string) *Finding {
	s.AwsAccountId = &v
	return s
}

// SetCodeVulnerabilityDetails sets the CodeVulnerabilityDetails field's value.
func (s *Finding) SetCodeVulnerabilityDetails(v *CodeVulnerabilityDetails) *Finding {
	s.CodeVulnerabilityDetails = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Finding) SetDescription(v string) *Finding {
	s.Description = &v
	return s
}

// SetEpss sets the Epss field's value.
func (s *Finding) SetEpss(v *EpssDetails) *Finding {
	s.Epss = v
	return s
}

// SetExploitAvailable sets the ExploitAvailable field's value.
func (s *Finding) SetExploitAvailable(v string) *Finding {
	s.ExploitAvailable = &v
	return s
}

// SetExploitabilityDetails sets the ExploitabilityDetails field's value.
func (s *Finding) SetExploitabilityDetails(v *ExploitabilityDetails) *Finding {
	s.ExploitabilityDetails = v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *Finding) SetFindingArn(v string) *Finding {
	s.FindingArn = &v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *Finding) SetFirstObservedAt(v time.Time) *Finding {
	s.FirstObservedAt = &v
	return s
}

// SetFixAvailable sets the FixAvailable field's value.
func (s *Finding) SetFixAvailable(v string) *Finding {
	s.FixAvailable = &v
	return s
}

// SetInspectorScore sets the InspectorScore field's value.
func (s *Finding) SetInspectorScore(v float64) *Finding {
	s.InspectorScore = &v
	return s
}

// SetInspectorScoreDetails sets the InspectorScoreDetails field's value.
func (s *Finding) SetInspectorScoreDetails(v *InspectorScoreDetails) *Finding {
	s.InspectorScoreDetails = v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *Finding) SetLastObservedAt(v time.Time) *Finding {
	s.LastObservedAt = &v
	return s
}

// SetNetworkReachabilityDetails sets the NetworkReachabilityDetails field's value.
func (s *Finding) SetNetworkReachabilityDetails(v *NetworkReachabilityDetails) *Finding {
	s.NetworkReachabilityDetails = v
	return s
}

// SetPackageVulnerabilityDetails sets the PackageVulnerabilityDetails field's value.
func (s *Finding) SetPackageVulnerabilityDetails(v *PackageVulnerabilityDetails) *Finding {
	s.PackageVulnerabilityDetails = v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *Finding) SetRemediation(v *Remediation) *Finding {
	s.Remediation = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Finding) SetResources(v []*Resource) *Finding {
	s.Resources = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Finding) SetSeverity(v string) *Finding {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Finding) SetStatus(v string) *Finding {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Finding) SetTitle(v string) *Finding {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *Finding) SetType(v string) *Finding {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v time.Time) *Finding {
	s.UpdatedAt = &v
	return s
}

// Details of the vulnerability identified in a finding.
type FindingDetail struct {
	_ struct{} `type:"structure"`

	// The Cybersecurity and Infrastructure Security Agency (CISA) details for a
	// specific vulnerability.
	CisaData *CisaData `locationName:"cisaData" type:"structure"`

	// The Common Weakness Enumerations (CWEs) associated with the vulnerability.
	Cwes []*string `locationName:"cwes" type:"list"`

	// The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
	EpssScore *float64 `locationName:"epssScore" type:"double"`

	// Information on the evidence of the vulnerability.
	Evidences []*Evidence `locationName:"evidences" type:"list"`

	// Contains information on when this exploit was observed.
	ExploitObserved *ExploitObserved `locationName:"exploitObserved" type:"structure"`

	// The finding ARN that the vulnerability details are associated with.
	FindingArn *string `locationName:"findingArn" min:"1" type:"string"`

	// The reference URLs for the vulnerability data.
	ReferenceUrls []*string `locationName:"referenceUrls" type:"list"`

	// The risk score of the vulnerability.
	RiskScore *int64 `locationName:"riskScore" type:"integer"`

	// The known malware tools or kits that can exploit the vulnerability.
	Tools []*string `locationName:"tools" type:"list"`

	// The MITRE adversary tactics, techniques, or procedures (TTPs) associated
	// with the vulnerability.
	Ttps []*string `locationName:"ttps" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingDetail) GoString() string {
	return s.String()
}

// SetCisaData sets the CisaData field's value.
func (s *FindingDetail) SetCisaData(v *CisaData) *FindingDetail {
	s.CisaData = v
	return s
}

// SetCwes sets the Cwes field's value.
func (s *FindingDetail) SetCwes(v []*string) *FindingDetail {
	s.Cwes = v
	return s
}

// SetEpssScore sets the EpssScore field's value.
func (s *FindingDetail) SetEpssScore(v float64) *FindingDetail {
	s.EpssScore = &v
	return s
}

// SetEvidences sets the Evidences field's value.
func (s *FindingDetail) SetEvidences(v []*Evidence) *FindingDetail {
	s.Evidences = v
	return s
}

// SetExploitObserved sets the ExploitObserved field's value.
func (s *FindingDetail) SetExploitObserved(v *ExploitObserved) *FindingDetail {
	s.ExploitObserved = v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *FindingDetail) SetFindingArn(v string) *FindingDetail {
	s.FindingArn = &v
	return s
}

// SetReferenceUrls sets the ReferenceUrls field's value.
func (s *FindingDetail) SetReferenceUrls(v []*string) *FindingDetail {
	s.ReferenceUrls = v
	return s
}

// SetRiskScore sets the RiskScore field's value.
func (s *FindingDetail) SetRiskScore(v int64) *FindingDetail {
	s.RiskScore = &v
	return s
}

// SetTools sets the Tools field's value.
func (s *FindingDetail) SetTools(v []*string) *FindingDetail {
	s.Tools = v
	return s
}

// SetTtps sets the Ttps field's value.
func (s *FindingDetail) SetTtps(v []*string) *FindingDetail {
	s.Ttps = v
	return s
}

// Details about an error encountered when trying to return vulnerability data
// for a finding.
type FindingDetailsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"FindingDetailsErrorCode"`

	// The error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string" required:"true"`

	// The finding ARN that returned an error.
	//
	// FindingArn is a required field
	FindingArn *string `locationName:"findingArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingDetailsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingDetailsError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FindingDetailsError) SetErrorCode(v string) *FindingDetailsError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FindingDetailsError) SetErrorMessage(v string) *FindingDetailsError {
	s.ErrorMessage = &v
	return s
}

// SetFindingArn sets the FindingArn field's value.
func (s *FindingDetailsError) SetFindingArn(v string) *FindingDetailsError {
	s.FindingArn = &v
	return s
}

// The details that define an aggregation based on finding type.
type FindingTypeAggregation struct {
	_ struct{} `type:"structure"`

	// The finding type to aggregate.
	FindingType *string `locationName:"findingType" type:"string" enum:"AggregationFindingType"`

	// The resource type to aggregate.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"AggregationResourceType"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"FindingTypeSortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingTypeAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingTypeAggregation) GoString() string {
	return s.String()
}

// SetFindingType sets the FindingType field's value.
func (s *FindingTypeAggregation) SetFindingType(v string) *FindingTypeAggregation {
	s.FindingType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *FindingTypeAggregation) SetResourceType(v string) *FindingTypeAggregation {
	s.ResourceType = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *FindingTypeAggregation) SetSortBy(v string) *FindingTypeAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *FindingTypeAggregation) SetSortOrder(v string) *FindingTypeAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of a finding type aggregation.
type FindingTypeAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The value to sort results by.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingTypeAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingTypeAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FindingTypeAggregationResponse) SetAccountId(v string) *FindingTypeAggregationResponse {
	s.AccountId = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *FindingTypeAggregationResponse) SetSeverityCounts(v *SeverityCounts) *FindingTypeAggregationResponse {
	s.SeverityCounts = v
	return s
}

// Information about the Amazon Inspector free trial for an account.
type FreeTrialAccountInfo struct {
	_ struct{} `type:"structure"`

	// The account associated with the Amazon Inspector free trial information.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// Contains information about the Amazon Inspector free trial for an account.
	//
	// FreeTrialInfo is a required field
	FreeTrialInfo []*FreeTrialInfo `locationName:"freeTrialInfo" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialAccountInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialAccountInfo) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FreeTrialAccountInfo) SetAccountId(v string) *FreeTrialAccountInfo {
	s.AccountId = &v
	return s
}

// SetFreeTrialInfo sets the FreeTrialInfo field's value.
func (s *FreeTrialAccountInfo) SetFreeTrialInfo(v []*FreeTrialInfo) *FreeTrialAccountInfo {
	s.FreeTrialInfo = v
	return s
}

// An object that contains information about the Amazon Inspector free trial
// for an account.
type FreeTrialInfo struct {
	_ struct{} `type:"structure"`

	// The date and time that the Amazon Inspector free trail ends for a given account.
	//
	// End is a required field
	End *time.Time `locationName:"end" type:"timestamp" required:"true"`

	// The date and time that the Amazon Inspector free trail started for a given
	// account.
	//
	// Start is a required field
	Start *time.Time `locationName:"start" type:"timestamp" required:"true"`

	// The order to sort results by.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FreeTrialStatus"`

	// The type of scan covered by the Amazon Inspector free trail.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FreeTrialType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialInfo) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *FreeTrialInfo) SetEnd(v time.Time) *FreeTrialInfo {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *FreeTrialInfo) SetStart(v time.Time) *FreeTrialInfo {
	s.Start = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FreeTrialInfo) SetStatus(v string) *FreeTrialInfo {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *FreeTrialInfo) SetType(v string) *FreeTrialInfo {
	s.Type = &v
	return s
}

// Information about an error received while accessing free trail data for an
// account.
type FreeTrialInfoError struct {
	_ struct{} `type:"structure"`

	// The account associated with the Amazon Inspector free trial information.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"FreeTrialInfoErrorCode"`

	// The error message returned.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialInfoError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialInfoError) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FreeTrialInfoError) SetAccountId(v string) *FreeTrialInfoError {
	s.AccountId = &v
	return s
}

// SetCode sets the Code field's value.
func (s *FreeTrialInfoError) SetCode(v string) *FreeTrialInfoError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FreeTrialInfoError) SetMessage(v string) *FreeTrialInfoError {
	s.Message = &v
	return s
}

type GetCisScanReportInput struct {
	_ struct{} `type:"structure"`

	// The format of the report. Valid values are PDF and CSV. If no value is specified,
	// the report format defaults to PDF.
	ReportFormat *string `locationName:"reportFormat" type:"string" enum:"CisReportFormat"`

	// The scan ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The target accounts.
	TargetAccounts []*string `locationName:"targetAccounts" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCisScanReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCisScanReportInput"}
	if s.ScanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportFormat sets the ReportFormat field's value.
func (s *GetCisScanReportInput) SetReportFormat(v string) *GetCisScanReportInput {
	s.ReportFormat = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *GetCisScanReportInput) SetScanArn(v string) *GetCisScanReportInput {
	s.ScanArn = &v
	return s
}

// SetTargetAccounts sets the TargetAccounts field's value.
func (s *GetCisScanReportInput) SetTargetAccounts(v []*string) *GetCisScanReportInput {
	s.TargetAccounts = v
	return s
}

type GetCisScanReportOutput struct {
	_ struct{} `type:"structure"`

	// The status.
	Status *string `locationName:"status" type:"string" enum:"CisReportStatus"`

	// The URL where a PDF or CSV of the CIS scan report can be downloaded.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanReportOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetCisScanReportOutput) SetStatus(v string) *GetCisScanReportOutput {
	s.Status = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetCisScanReportOutput) SetUrl(v string) *GetCisScanReportOutput {
	s.Url = &v
	return s
}

type GetCisScanResultDetailsInput struct {
	_ struct{} `type:"structure"`

	// The account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The filter criteria.
	FilterCriteria *CisScanResultDetailsFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of CIS scan result details to be returned in a single
	// page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The scan ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The sort by order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"CisScanResultDetailsSortBy"`

	// The sort order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"CisSortOrder"`

	// The target resource ID.
	//
	// TargetResourceId is a required field
	TargetResourceId *string `locationName:"targetResourceId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanResultDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanResultDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCisScanResultDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCisScanResultDetailsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ScanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanArn"))
	}
	if s.TargetResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetResourceId"))
	}
	if s.TargetResourceId != nil && len(*s.TargetResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceId", 10))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetCisScanResultDetailsInput) SetAccountId(v string) *GetCisScanResultDetailsInput {
	s.AccountId = &v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *GetCisScanResultDetailsInput) SetFilterCriteria(v *CisScanResultDetailsFilterCriteria) *GetCisScanResultDetailsInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCisScanResultDetailsInput) SetMaxResults(v int64) *GetCisScanResultDetailsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCisScanResultDetailsInput) SetNextToken(v string) *GetCisScanResultDetailsInput {
	s.NextToken = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *GetCisScanResultDetailsInput) SetScanArn(v string) *GetCisScanResultDetailsInput {
	s.ScanArn = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetCisScanResultDetailsInput) SetSortBy(v string) *GetCisScanResultDetailsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *GetCisScanResultDetailsInput) SetSortOrder(v string) *GetCisScanResultDetailsInput {
	s.SortOrder = &v
	return s
}

// SetTargetResourceId sets the TargetResourceId field's value.
func (s *GetCisScanResultDetailsInput) SetTargetResourceId(v string) *GetCisScanResultDetailsInput {
	s.TargetResourceId = &v
	return s
}

type GetCisScanResultDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The scan result details.
	ScanResultDetails []*CisScanResultDetails `locationName:"scanResultDetails" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanResultDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCisScanResultDetailsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetCisScanResultDetailsOutput) SetNextToken(v string) *GetCisScanResultDetailsOutput {
	s.NextToken = &v
	return s
}

// SetScanResultDetails sets the ScanResultDetails field's value.
func (s *GetCisScanResultDetailsOutput) SetScanResultDetails(v []*CisScanResultDetails) *GetCisScanResultDetailsOutput {
	s.ScanResultDetails = v
	return s
}

type GetConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationInput) GoString() string {
	return s.String()
}

type GetConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies how the Amazon EC2 automated scan mode is currently configured
	// for your environment.
	Ec2Configuration *Ec2ConfigurationState `locationName:"ec2Configuration" type:"structure"`

	// Specifies how the ECR automated re-scan duration is currently configured
	// for your environment.
	EcrConfiguration *EcrConfigurationState `locationName:"ecrConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfigurationOutput) GoString() string {
	return s.String()
}

// SetEc2Configuration sets the Ec2Configuration field's value.
func (s *GetConfigurationOutput) SetEc2Configuration(v *Ec2ConfigurationState) *GetConfigurationOutput {
	s.Ec2Configuration = v
	return s
}

// SetEcrConfiguration sets the EcrConfiguration field's value.
func (s *GetConfigurationOutput) SetEcrConfiguration(v *EcrConfigurationState) *GetConfigurationOutput {
	s.EcrConfiguration = v
	return s
}

type GetDelegatedAdminAccountInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDelegatedAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDelegatedAdminAccountInput) GoString() string {
	return s.String()
}

type GetDelegatedAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the Amazon Inspector delegated administrator.
	DelegatedAdmin *DelegatedAdmin `locationName:"delegatedAdmin" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDelegatedAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDelegatedAdminAccountOutput) GoString() string {
	return s.String()
}

// SetDelegatedAdmin sets the DelegatedAdmin field's value.
func (s *GetDelegatedAdminAccountOutput) SetDelegatedAdmin(v *DelegatedAdmin) *GetDelegatedAdminAccountOutput {
	s.DelegatedAdmin = v
	return s
}

type GetEc2DeepInspectionConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEc2DeepInspectionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEc2DeepInspectionConfigurationInput) GoString() string {
	return s.String()
}

type GetEc2DeepInspectionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An error message explaining why Amazon Inspector deep inspection configurations
	// could not be retrieved for your account.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// The Amazon Inspector deep inspection custom paths for your organization.
	OrgPackagePaths []*string `locationName:"orgPackagePaths" type:"list"`

	// The Amazon Inspector deep inspection custom paths for your account.
	PackagePaths []*string `locationName:"packagePaths" type:"list"`

	// The activation status of Amazon Inspector deep inspection in your account.
	Status *string `locationName:"status" type:"string" enum:"Ec2DeepInspectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEc2DeepInspectionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEc2DeepInspectionConfigurationOutput) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetEc2DeepInspectionConfigurationOutput) SetErrorMessage(v string) *GetEc2DeepInspectionConfigurationOutput {
	s.ErrorMessage = &v
	return s
}

// SetOrgPackagePaths sets the OrgPackagePaths field's value.
func (s *GetEc2DeepInspectionConfigurationOutput) SetOrgPackagePaths(v []*string) *GetEc2DeepInspectionConfigurationOutput {
	s.OrgPackagePaths = v
	return s
}

// SetPackagePaths sets the PackagePaths field's value.
func (s *GetEc2DeepInspectionConfigurationOutput) SetPackagePaths(v []*string) *GetEc2DeepInspectionConfigurationOutput {
	s.PackagePaths = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEc2DeepInspectionConfigurationOutput) SetStatus(v string) *GetEc2DeepInspectionConfigurationOutput {
	s.Status = &v
	return s
}

type GetEncryptionKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource type the key encrypts.
	//
	// ResourceType is a required field
	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The scan type the key encrypts.
	//
	// ScanType is a required field
	ScanType *string `location:"querystring" locationName:"scanType" type:"string" required:"true" enum:"ScanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEncryptionKeyInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ScanType == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *GetEncryptionKeyInput) SetResourceType(v string) *GetEncryptionKeyInput {
	s.ResourceType = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *GetEncryptionKeyInput) SetScanType(v string) *GetEncryptionKeyInput {
	s.ScanType = &v
	return s
}

type GetEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// A kms key ID.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncryptionKeyOutput) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *GetEncryptionKeyOutput) SetKmsKeyId(v string) *GetEncryptionKeyOutput {
	s.KmsKeyId = &v
	return s
}

type GetFindingsReportStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the report to retrieve the status of.
	ReportId *string `locationName:"reportId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsReportStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsReportStatusInput) GoString() string {
	return s.String()
}

// SetReportId sets the ReportId field's value.
func (s *GetFindingsReportStatusInput) SetReportId(v string) *GetFindingsReportStatusInput {
	s.ReportId = &v
	return s
}

type GetFindingsReportStatusOutput struct {
	_ struct{} `type:"structure"`

	// The destination of the report.
	Destination *Destination `locationName:"destination" type:"structure"`

	// The error code of the report.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ReportingErrorCode"`

	// The error message of the report.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The filter criteria associated with the report.
	FilterCriteria *FilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The ID of the report.
	ReportId *string `locationName:"reportId" type:"string"`

	// The status of the report.
	Status *string `locationName:"status" type:"string" enum:"ExternalReportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsReportStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsReportStatusOutput) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *GetFindingsReportStatusOutput) SetDestination(v *Destination) *GetFindingsReportStatusOutput {
	s.Destination = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *GetFindingsReportStatusOutput) SetErrorCode(v string) *GetFindingsReportStatusOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetFindingsReportStatusOutput) SetErrorMessage(v string) *GetFindingsReportStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *GetFindingsReportStatusOutput) SetFilterCriteria(v *FilterCriteria) *GetFindingsReportStatusOutput {
	s.FilterCriteria = v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *GetFindingsReportStatusOutput) SetReportId(v string) *GetFindingsReportStatusOutput {
	s.ReportId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetFindingsReportStatusOutput) SetStatus(v string) *GetFindingsReportStatusOutput {
	s.Status = &v
	return s
}

type GetMemberInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the member account to retrieve information
	// on.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMemberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetMemberInput) SetAccountId(v string) *GetMemberInput {
	s.AccountId = &v
	return s
}

type GetMemberOutput struct {
	_ struct{} `type:"structure"`

	// Details of the retrieved member account.
	Member *Member `locationName:"member" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMemberOutput) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *GetMemberOutput) SetMember(v *Member) *GetMemberOutput {
	s.Member = v
	return s
}

type GetSbomExportInput struct {
	_ struct{} `type:"structure"`

	// The report ID of the SBOM export to get details for.
	//
	// ReportId is a required field
	ReportId *string `locationName:"reportId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSbomExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSbomExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSbomExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSbomExportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetSbomExportInput) SetReportId(v string) *GetSbomExportInput {
	s.ReportId = &v
	return s
}

type GetSbomExportOutput struct {
	_ struct{} `type:"structure"`

	// An error code.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ReportingErrorCode"`

	// An error message.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// Contains details about the resource filter criteria used for the software
	// bill of materials (SBOM) report.
	FilterCriteria *ResourceFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The format of the software bill of materials (SBOM) report.
	Format *string `locationName:"format" type:"string" enum:"SbomReportFormat"`

	// The report ID of the software bill of materials (SBOM) report.
	ReportId *string `locationName:"reportId" type:"string"`

	// Contains details of the Amazon S3 bucket and KMS key used to export findings.
	S3Destination *Destination `locationName:"s3Destination" type:"structure"`

	// The status of the software bill of materials (SBOM) report.
	Status *string `locationName:"status" type:"string" enum:"ExternalReportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSbomExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSbomExportOutput) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *GetSbomExportOutput) SetErrorCode(v string) *GetSbomExportOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetSbomExportOutput) SetErrorMessage(v string) *GetSbomExportOutput {
	s.ErrorMessage = &v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *GetSbomExportOutput) SetFilterCriteria(v *ResourceFilterCriteria) *GetSbomExportOutput {
	s.FilterCriteria = v
	return s
}

// SetFormat sets the Format field's value.
func (s *GetSbomExportOutput) SetFormat(v string) *GetSbomExportOutput {
	s.Format = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *GetSbomExportOutput) SetReportId(v string) *GetSbomExportOutput {
	s.ReportId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *GetSbomExportOutput) SetS3Destination(v *Destination) *GetSbomExportOutput {
	s.S3Destination = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSbomExportOutput) SetStatus(v string) *GetSbomExportOutput {
	s.Status = &v
	return s
}

// The details that define an aggregation based on container image layers.
type ImageLayerAggregation struct {
	_ struct{} `type:"structure"`

	// The hashes associated with the layers.
	LayerHashes []*StringFilter `locationName:"layerHashes" min:"1" type:"list"`

	// The repository associated with the container image hosting the layers.
	Repositories []*StringFilter `locationName:"repositories" min:"1" type:"list"`

	// The ID of the container image layer.
	ResourceIds []*StringFilter `locationName:"resourceIds" min:"1" type:"list"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ImageLayerSortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageLayerAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageLayerAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageLayerAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageLayerAggregation"}
	if s.LayerHashes != nil && len(s.LayerHashes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerHashes", 1))
	}
	if s.Repositories != nil && len(s.Repositories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Repositories", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.LayerHashes != nil {
		for i, v := range s.LayerHashes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LayerHashes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Repositories != nil {
		for i, v := range s.Repositories {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Repositories", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceIds != nil {
		for i, v := range s.ResourceIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerHashes sets the LayerHashes field's value.
func (s *ImageLayerAggregation) SetLayerHashes(v []*StringFilter) *ImageLayerAggregation {
	s.LayerHashes = v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *ImageLayerAggregation) SetRepositories(v []*StringFilter) *ImageLayerAggregation {
	s.Repositories = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ImageLayerAggregation) SetResourceIds(v []*StringFilter) *ImageLayerAggregation {
	s.ResourceIds = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ImageLayerAggregation) SetSortBy(v string) *ImageLayerAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ImageLayerAggregation) SetSortOrder(v string) *ImageLayerAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of a finding aggregation by image layer.
type ImageLayerAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the container image hosting
	// the layer image.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The layer hash.
	//
	// LayerHash is a required field
	LayerHash *string `locationName:"layerHash" min:"1" type:"string" required:"true"`

	// The repository the layer resides in.
	//
	// Repository is a required field
	Repository *string `locationName:"repository" min:"1" type:"string" required:"true"`

	// The resource ID of the container image layer.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// An object that represents the count of matched findings per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageLayerAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageLayerAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ImageLayerAggregationResponse) SetAccountId(v string) *ImageLayerAggregationResponse {
	s.AccountId = &v
	return s
}

// SetLayerHash sets the LayerHash field's value.
func (s *ImageLayerAggregationResponse) SetLayerHash(v string) *ImageLayerAggregationResponse {
	s.LayerHash = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ImageLayerAggregationResponse) SetRepository(v string) *ImageLayerAggregationResponse {
	s.Repository = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ImageLayerAggregationResponse) SetResourceId(v string) *ImageLayerAggregationResponse {
	s.ResourceId = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *ImageLayerAggregationResponse) SetSeverityCounts(v *SeverityCounts) *ImageLayerAggregationResponse {
	s.SeverityCounts = v
	return s
}

// Information about the Amazon Inspector score given to a finding.
type InspectorScoreDetails struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the CVSS score given to a finding.
	AdjustedCvss *CvssScoreDetails `locationName:"adjustedCvss" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InspectorScoreDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InspectorScoreDetails) GoString() string {
	return s.String()
}

// SetAdjustedCvss sets the AdjustedCvss field's value.
func (s *InspectorScoreDetails) SetAdjustedCvss(v *CvssScoreDetails) *InspectorScoreDetails {
	s.AdjustedCvss = v
	return s
}

// The request has failed due to an internal failure of the Amazon Inspector
// service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details that define a findings aggregation based on Amazon Web Services
// Lambda functions.
type LambdaFunctionAggregation struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services Lambda function names to include in the aggregation
	// results.
	FunctionNames []*StringFilter `locationName:"functionNames" min:"1" type:"list"`

	// The tags to include in the aggregation results.
	FunctionTags []*MapFilter `locationName:"functionTags" min:"1" type:"list"`

	// The resource IDs to include in the aggregation results.
	ResourceIds []*StringFilter `locationName:"resourceIds" min:"1" type:"list"`

	// Returns findings aggregated by Amazon Web Services Lambda function runtime
	// environments.
	Runtimes []*StringFilter `locationName:"runtimes" min:"1" type:"list"`

	// The finding severity to use for sorting the results.
	SortBy *string `locationName:"sortBy" type:"string" enum:"LambdaFunctionSortBy"`

	// The order to use for sorting the results.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionAggregation"}
	if s.FunctionNames != nil && len(s.FunctionNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionNames", 1))
	}
	if s.FunctionTags != nil && len(s.FunctionTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionTags", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.Runtimes != nil && len(s.Runtimes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Runtimes", 1))
	}
	if s.FunctionNames != nil {
		for i, v := range s.FunctionNames {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FunctionNames", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FunctionTags != nil {
		for i, v := range s.FunctionTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FunctionTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceIds != nil {
		for i, v := range s.ResourceIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceIds", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Runtimes != nil {
		for i, v := range s.Runtimes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Runtimes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionNames sets the FunctionNames field's value.
func (s *LambdaFunctionAggregation) SetFunctionNames(v []*StringFilter) *LambdaFunctionAggregation {
	s.FunctionNames = v
	return s
}

// SetFunctionTags sets the FunctionTags field's value.
func (s *LambdaFunctionAggregation) SetFunctionTags(v []*MapFilter) *LambdaFunctionAggregation {
	s.FunctionTags = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *LambdaFunctionAggregation) SetResourceIds(v []*StringFilter) *LambdaFunctionAggregation {
	s.ResourceIds = v
	return s
}

// SetRuntimes sets the Runtimes field's value.
func (s *LambdaFunctionAggregation) SetRuntimes(v []*StringFilter) *LambdaFunctionAggregation {
	s.Runtimes = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *LambdaFunctionAggregation) SetSortBy(v string) *LambdaFunctionAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *LambdaFunctionAggregation) SetSortOrder(v string) *LambdaFunctionAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of an Amazon Web Services Lambda function
// finding aggregation.
type LambdaFunctionAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that owns the Amazon Web Services
	// Lambda function.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The Amazon Web Services Lambda function names included in the aggregation
	// results.
	FunctionName *string `locationName:"functionName" type:"string"`

	// The tags included in the aggregation results.
	LambdaTags map[string]*string `locationName:"lambdaTags" type:"map"`

	// The date that the Amazon Web Services Lambda function included in the aggregation
	// results was last changed.
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp"`

	// The resource IDs included in the aggregation results.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The runtimes included in the aggregation results.
	Runtime *string `locationName:"runtime" type:"string"`

	// An object that contains the counts of aggregated finding per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *LambdaFunctionAggregationResponse) SetAccountId(v string) *LambdaFunctionAggregationResponse {
	s.AccountId = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *LambdaFunctionAggregationResponse) SetFunctionName(v string) *LambdaFunctionAggregationResponse {
	s.FunctionName = &v
	return s
}

// SetLambdaTags sets the LambdaTags field's value.
func (s *LambdaFunctionAggregationResponse) SetLambdaTags(v map[string]*string) *LambdaFunctionAggregationResponse {
	s.LambdaTags = v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *LambdaFunctionAggregationResponse) SetLastModifiedAt(v time.Time) *LambdaFunctionAggregationResponse {
	s.LastModifiedAt = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *LambdaFunctionAggregationResponse) SetResourceId(v string) *LambdaFunctionAggregationResponse {
	s.ResourceId = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *LambdaFunctionAggregationResponse) SetRuntime(v string) *LambdaFunctionAggregationResponse {
	s.Runtime = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *LambdaFunctionAggregationResponse) SetSeverityCounts(v *SeverityCounts) *LambdaFunctionAggregationResponse {
	s.SeverityCounts = v
	return s
}

// The Amazon Web Services Lambda function metadata.
type LambdaFunctionMetadata struct {
	_ struct{} `type:"structure"`

	// The name of a function.
	FunctionName *string `locationName:"functionName" type:"string"`

	// The resource tags on an Amazon Web Services Lambda function.
	FunctionTags map[string]*string `locationName:"functionTags" type:"map"`

	// The layers for an Amazon Web Services Lambda function. A Lambda function
	// can have up to five layers.
	Layers []*string `locationName:"layers" type:"list"`

	// An Amazon Web Services Lambda function's runtime.
	Runtime *string `locationName:"runtime" type:"string" enum:"Runtime"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionMetadata) GoString() string {
	return s.String()
}

// SetFunctionName sets the FunctionName field's value.
func (s *LambdaFunctionMetadata) SetFunctionName(v string) *LambdaFunctionMetadata {
	s.FunctionName = &v
	return s
}

// SetFunctionTags sets the FunctionTags field's value.
func (s *LambdaFunctionMetadata) SetFunctionTags(v map[string]*string) *LambdaFunctionMetadata {
	s.FunctionTags = v
	return s
}

// SetLayers sets the Layers field's value.
func (s *LambdaFunctionMetadata) SetLayers(v []*string) *LambdaFunctionMetadata {
	s.Layers = v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *LambdaFunctionMetadata) SetRuntime(v string) *LambdaFunctionMetadata {
	s.Runtime = &v
	return s
}

// The details that define a findings aggregation based on an Amazon Web Services
// Lambda function's layers.
type LambdaLayerAggregation struct {
	_ struct{} `type:"structure"`

	// The names of the Amazon Web Services Lambda functions associated with the
	// layers.
	FunctionNames []*StringFilter `locationName:"functionNames" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function
	// layer.
	LayerArns []*StringFilter `locationName:"layerArns" min:"1" type:"list"`

	// The resource IDs for the Amazon Web Services Lambda function layers.
	ResourceIds []*StringFilter `locationName:"resourceIds" min:"1" type:"list"`

	// The finding severity to use for sorting the results.
	SortBy *string `locationName:"sortBy" type:"string" enum:"LambdaLayerSortBy"`

	// The order to use for sorting the results.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaLayerAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaLayerAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaLayerAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaLayerAggregation"}
	if s.FunctionNames != nil && len(s.FunctionNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionNames", 1))
	}
	if s.LayerArns != nil && len(s.LayerArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerArns", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.FunctionNames != nil {
		for i, v := range s.FunctionNames {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FunctionNames", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LayerArns != nil {
		for i, v := range s.LayerArns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LayerArns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceIds != nil {
		for i, v := range s.ResourceIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionNames sets the FunctionNames field's value.
func (s *LambdaLayerAggregation) SetFunctionNames(v []*StringFilter) *LambdaLayerAggregation {
	s.FunctionNames = v
	return s
}

// SetLayerArns sets the LayerArns field's value.
func (s *LambdaLayerAggregation) SetLayerArns(v []*StringFilter) *LambdaLayerAggregation {
	s.LayerArns = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *LambdaLayerAggregation) SetResourceIds(v []*StringFilter) *LambdaLayerAggregation {
	s.ResourceIds = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *LambdaLayerAggregation) SetSortBy(v string) *LambdaLayerAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *LambdaLayerAggregation) SetSortOrder(v string) *LambdaLayerAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of an Amazon Web Services Lambda function
// layer finding aggregation.
type LambdaLayerAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The account ID of the Amazon Web Services Lambda function layer.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The names of the Amazon Web Services Lambda functions associated with the
	// layers.
	//
	// FunctionName is a required field
	FunctionName *string `locationName:"functionName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function
	// layer.
	//
	// LayerArn is a required field
	LayerArn *string `locationName:"layerArn" min:"1" type:"string" required:"true"`

	// The Resource ID of the Amazon Web Services Lambda function layer.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// An object that contains the counts of aggregated finding per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaLayerAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaLayerAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *LambdaLayerAggregationResponse) SetAccountId(v string) *LambdaLayerAggregationResponse {
	s.AccountId = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *LambdaLayerAggregationResponse) SetFunctionName(v string) *LambdaLayerAggregationResponse {
	s.FunctionName = &v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *LambdaLayerAggregationResponse) SetLayerArn(v string) *LambdaLayerAggregationResponse {
	s.LayerArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *LambdaLayerAggregationResponse) SetResourceId(v string) *LambdaLayerAggregationResponse {
	s.ResourceId = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *LambdaLayerAggregationResponse) SetSeverityCounts(v *SeverityCounts) *LambdaLayerAggregationResponse {
	s.SeverityCounts = v
	return s
}

// The VPC security groups and subnets that are attached to an Amazon Web Services
// Lambda function. For more information, see VPC Settings (https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
type LambdaVpcConfig struct {
	_ struct{} `type:"structure"`

	// The VPC security groups and subnets that are attached to an Amazon Web Services
	// Lambda function. For more information, see VPC Settings (https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The ID of the VPC.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *LambdaVpcConfig) SetSecurityGroupIds(v []*string) *LambdaVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *LambdaVpcConfig) SetSubnetIds(v []*string) *LambdaVpcConfig {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *LambdaVpcConfig) SetVpcId(v string) *LambdaVpcConfig {
	s.VpcId = &v
	return s
}

type ListAccountPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the NextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The service scan type to check permissions for.
	Service *string `locationName:"service" type:"string" enum:"Service"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountPermissionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountPermissionsInput) SetMaxResults(v int64) *ListAccountPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountPermissionsInput) SetNextToken(v string) *ListAccountPermissionsInput {
	s.NextToken = &v
	return s
}

// SetService sets the Service field's value.
func (s *ListAccountPermissionsInput) SetService(v string) *ListAccountPermissionsInput {
	s.Service = &v
	return s
}

type ListAccountPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Contains details on the permissions an account has to configure Amazon Inspector.
	//
	// Permissions is a required field
	Permissions []*Permission `locationName:"permissions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountPermissionsOutput) SetNextToken(v string) *ListAccountPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListAccountPermissionsOutput) SetPermissions(v []*Permission) *ListAccountPermissionsOutput {
	s.Permissions = v
	return s
}

// A list of CIS scan configurations filter criteria.
type ListCisScanConfigurationsFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The list of scan configuration ARN filters.
	ScanConfigurationArnFilters []*CisStringFilter `locationName:"scanConfigurationArnFilters" min:"1" type:"list"`

	// The list of scan name filters.
	ScanNameFilters []*CisStringFilter `locationName:"scanNameFilters" min:"1" type:"list"`

	// The list of target resource tag filters.
	TargetResourceTagFilters []*TagFilter `locationName:"targetResourceTagFilters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanConfigurationsFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanConfigurationsFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCisScanConfigurationsFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCisScanConfigurationsFilterCriteria"}
	if s.ScanConfigurationArnFilters != nil && len(s.ScanConfigurationArnFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanConfigurationArnFilters", 1))
	}
	if s.ScanNameFilters != nil && len(s.ScanNameFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanNameFilters", 1))
	}
	if s.TargetResourceTagFilters != nil && len(s.TargetResourceTagFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceTagFilters", 1))
	}
	if s.ScanConfigurationArnFilters != nil {
		for i, v := range s.ScanConfigurationArnFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanConfigurationArnFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanNameFilters != nil {
		for i, v := range s.ScanNameFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanNameFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetResourceTagFilters != nil {
		for i, v := range s.TargetResourceTagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetResourceTagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanConfigurationArnFilters sets the ScanConfigurationArnFilters field's value.
func (s *ListCisScanConfigurationsFilterCriteria) SetScanConfigurationArnFilters(v []*CisStringFilter) *ListCisScanConfigurationsFilterCriteria {
	s.ScanConfigurationArnFilters = v
	return s
}

// SetScanNameFilters sets the ScanNameFilters field's value.
func (s *ListCisScanConfigurationsFilterCriteria) SetScanNameFilters(v []*CisStringFilter) *ListCisScanConfigurationsFilterCriteria {
	s.ScanNameFilters = v
	return s
}

// SetTargetResourceTagFilters sets the TargetResourceTagFilters field's value.
func (s *ListCisScanConfigurationsFilterCriteria) SetTargetResourceTagFilters(v []*TagFilter) *ListCisScanConfigurationsFilterCriteria {
	s.TargetResourceTagFilters = v
	return s
}

type ListCisScanConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The CIS scan configuration filter criteria.
	FilterCriteria *ListCisScanConfigurationsFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of CIS scan configurations to be returned in a single
	// page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The CIS scan configuration sort by order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"CisScanConfigurationsSortBy"`

	// The CIS scan configuration sort order order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"CisSortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCisScanConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCisScanConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListCisScanConfigurationsInput) SetFilterCriteria(v *ListCisScanConfigurationsFilterCriteria) *ListCisScanConfigurationsInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCisScanConfigurationsInput) SetMaxResults(v int64) *ListCisScanConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScanConfigurationsInput) SetNextToken(v string) *ListCisScanConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListCisScanConfigurationsInput) SetSortBy(v string) *ListCisScanConfigurationsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListCisScanConfigurationsInput) SetSortOrder(v string) *ListCisScanConfigurationsInput {
	s.SortOrder = &v
	return s
}

type ListCisScanConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The CIS scan configuration scan configurations.
	ScanConfigurations []*CisScanConfiguration `locationName:"scanConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScanConfigurationsOutput) SetNextToken(v string) *ListCisScanConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetScanConfigurations sets the ScanConfigurations field's value.
func (s *ListCisScanConfigurationsOutput) SetScanConfigurations(v []*CisScanConfiguration) *ListCisScanConfigurationsOutput {
	s.ScanConfigurations = v
	return s
}

type ListCisScanResultsAggregatedByChecksInput struct {
	_ struct{} `type:"structure"`

	// The filter criteria.
	FilterCriteria *CisScanResultsAggregatedByChecksFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of scan results aggregated by checks to be returned in
	// a single page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The scan ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The sort by order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"CisScanResultsAggregatedByChecksSortBy"`

	// The sort order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"CisSortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByChecksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCisScanResultsAggregatedByChecksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCisScanResultsAggregatedByChecksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ScanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanArn"))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListCisScanResultsAggregatedByChecksInput) SetFilterCriteria(v *CisScanResultsAggregatedByChecksFilterCriteria) *ListCisScanResultsAggregatedByChecksInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCisScanResultsAggregatedByChecksInput) SetMaxResults(v int64) *ListCisScanResultsAggregatedByChecksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScanResultsAggregatedByChecksInput) SetNextToken(v string) *ListCisScanResultsAggregatedByChecksInput {
	s.NextToken = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *ListCisScanResultsAggregatedByChecksInput) SetScanArn(v string) *ListCisScanResultsAggregatedByChecksInput {
	s.ScanArn = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListCisScanResultsAggregatedByChecksInput) SetSortBy(v string) *ListCisScanResultsAggregatedByChecksInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListCisScanResultsAggregatedByChecksInput) SetSortOrder(v string) *ListCisScanResultsAggregatedByChecksInput {
	s.SortOrder = &v
	return s
}

type ListCisScanResultsAggregatedByChecksOutput struct {
	_ struct{} `type:"structure"`

	// The check aggregations.
	CheckAggregations []*CisCheckAggregation `locationName:"checkAggregations" min:"1" type:"list"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByChecksOutput) GoString() string {
	return s.String()
}

// SetCheckAggregations sets the CheckAggregations field's value.
func (s *ListCisScanResultsAggregatedByChecksOutput) SetCheckAggregations(v []*CisCheckAggregation) *ListCisScanResultsAggregatedByChecksOutput {
	s.CheckAggregations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScanResultsAggregatedByChecksOutput) SetNextToken(v string) *ListCisScanResultsAggregatedByChecksOutput {
	s.NextToken = &v
	return s
}

type ListCisScanResultsAggregatedByTargetResourceInput struct {
	_ struct{} `type:"structure"`

	// The filter criteria.
	FilterCriteria *CisScanResultsAggregatedByTargetResourceFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of scan results aggregated by a target resource to be
	// returned in a single page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The scan ARN.
	//
	// ScanArn is a required field
	ScanArn *string `locationName:"scanArn" type:"string" required:"true"`

	// The sort by order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"CisScanResultsAggregatedByTargetResourceSortBy"`

	// The sort order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"CisSortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByTargetResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByTargetResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCisScanResultsAggregatedByTargetResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ScanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanArn"))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) SetFilterCriteria(v *CisScanResultsAggregatedByTargetResourceFilterCriteria) *ListCisScanResultsAggregatedByTargetResourceInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) SetMaxResults(v int64) *ListCisScanResultsAggregatedByTargetResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) SetNextToken(v string) *ListCisScanResultsAggregatedByTargetResourceInput {
	s.NextToken = &v
	return s
}

// SetScanArn sets the ScanArn field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) SetScanArn(v string) *ListCisScanResultsAggregatedByTargetResourceInput {
	s.ScanArn = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) SetSortBy(v string) *ListCisScanResultsAggregatedByTargetResourceInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceInput) SetSortOrder(v string) *ListCisScanResultsAggregatedByTargetResourceInput {
	s.SortOrder = &v
	return s
}

type ListCisScanResultsAggregatedByTargetResourceOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The resource aggregations.
	TargetResourceAggregations []*CisTargetResourceAggregation `locationName:"targetResourceAggregations" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByTargetResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScanResultsAggregatedByTargetResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceOutput) SetNextToken(v string) *ListCisScanResultsAggregatedByTargetResourceOutput {
	s.NextToken = &v
	return s
}

// SetTargetResourceAggregations sets the TargetResourceAggregations field's value.
func (s *ListCisScanResultsAggregatedByTargetResourceOutput) SetTargetResourceAggregations(v []*CisTargetResourceAggregation) *ListCisScanResultsAggregatedByTargetResourceOutput {
	s.TargetResourceAggregations = v
	return s
}

// A list of CIS scans filter criteria.
type ListCisScansFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The list of failed checks filters.
	FailedChecksFilters []*CisNumberFilter `locationName:"failedChecksFilters" min:"1" type:"list"`

	// The list of scan ARN filters.
	ScanArnFilters []*CisStringFilter `locationName:"scanArnFilters" min:"1" type:"list"`

	// The list of scan at filters.
	ScanAtFilters []*CisDateFilter `locationName:"scanAtFilters" min:"1" type:"list"`

	// The list of scan configuration ARN filters.
	ScanConfigurationArnFilters []*CisStringFilter `locationName:"scanConfigurationArnFilters" min:"1" type:"list"`

	// The list of scan name filters.
	ScanNameFilters []*CisStringFilter `locationName:"scanNameFilters" min:"1" type:"list"`

	// The list of scan status filters.
	ScanStatusFilters []*CisScanStatusFilter `locationName:"scanStatusFilters" min:"1" type:"list"`

	// The list of scheduled by filters.
	ScheduledByFilters []*CisStringFilter `locationName:"scheduledByFilters" min:"1" type:"list"`

	// The list of target account ID filters.
	TargetAccountIdFilters []*CisStringFilter `locationName:"targetAccountIdFilters" min:"1" type:"list"`

	// The list of target resource ID filters.
	TargetResourceIdFilters []*CisStringFilter `locationName:"targetResourceIdFilters" min:"1" type:"list"`

	// The list of target resource tag filters.
	TargetResourceTagFilters []*TagFilter `locationName:"targetResourceTagFilters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScansFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScansFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCisScansFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCisScansFilterCriteria"}
	if s.FailedChecksFilters != nil && len(s.FailedChecksFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FailedChecksFilters", 1))
	}
	if s.ScanArnFilters != nil && len(s.ScanArnFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanArnFilters", 1))
	}
	if s.ScanAtFilters != nil && len(s.ScanAtFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanAtFilters", 1))
	}
	if s.ScanConfigurationArnFilters != nil && len(s.ScanConfigurationArnFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanConfigurationArnFilters", 1))
	}
	if s.ScanNameFilters != nil && len(s.ScanNameFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanNameFilters", 1))
	}
	if s.ScanStatusFilters != nil && len(s.ScanStatusFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanStatusFilters", 1))
	}
	if s.ScheduledByFilters != nil && len(s.ScheduledByFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledByFilters", 1))
	}
	if s.TargetAccountIdFilters != nil && len(s.TargetAccountIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAccountIdFilters", 1))
	}
	if s.TargetResourceIdFilters != nil && len(s.TargetResourceIdFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceIdFilters", 1))
	}
	if s.TargetResourceTagFilters != nil && len(s.TargetResourceTagFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceTagFilters", 1))
	}
	if s.ScanArnFilters != nil {
		for i, v := range s.ScanArnFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanArnFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanConfigurationArnFilters != nil {
		for i, v := range s.ScanConfigurationArnFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanConfigurationArnFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanNameFilters != nil {
		for i, v := range s.ScanNameFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanNameFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScanStatusFilters != nil {
		for i, v := range s.ScanStatusFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanStatusFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScheduledByFilters != nil {
		for i, v := range s.ScheduledByFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScheduledByFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetAccountIdFilters != nil {
		for i, v := range s.TargetAccountIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetAccountIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetResourceIdFilters != nil {
		for i, v := range s.TargetResourceIdFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetResourceIdFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetResourceTagFilters != nil {
		for i, v := range s.TargetResourceTagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetResourceTagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailedChecksFilters sets the FailedChecksFilters field's value.
func (s *ListCisScansFilterCriteria) SetFailedChecksFilters(v []*CisNumberFilter) *ListCisScansFilterCriteria {
	s.FailedChecksFilters = v
	return s
}

// SetScanArnFilters sets the ScanArnFilters field's value.
func (s *ListCisScansFilterCriteria) SetScanArnFilters(v []*CisStringFilter) *ListCisScansFilterCriteria {
	s.ScanArnFilters = v
	return s
}

// SetScanAtFilters sets the ScanAtFilters field's value.
func (s *ListCisScansFilterCriteria) SetScanAtFilters(v []*CisDateFilter) *ListCisScansFilterCriteria {
	s.ScanAtFilters = v
	return s
}

// SetScanConfigurationArnFilters sets the ScanConfigurationArnFilters field's value.
func (s *ListCisScansFilterCriteria) SetScanConfigurationArnFilters(v []*CisStringFilter) *ListCisScansFilterCriteria {
	s.ScanConfigurationArnFilters = v
	return s
}

// SetScanNameFilters sets the ScanNameFilters field's value.
func (s *ListCisScansFilterCriteria) SetScanNameFilters(v []*CisStringFilter) *ListCisScansFilterCriteria {
	s.ScanNameFilters = v
	return s
}

// SetScanStatusFilters sets the ScanStatusFilters field's value.
func (s *ListCisScansFilterCriteria) SetScanStatusFilters(v []*CisScanStatusFilter) *ListCisScansFilterCriteria {
	s.ScanStatusFilters = v
	return s
}

// SetScheduledByFilters sets the ScheduledByFilters field's value.
func (s *ListCisScansFilterCriteria) SetScheduledByFilters(v []*CisStringFilter) *ListCisScansFilterCriteria {
	s.ScheduledByFilters = v
	return s
}

// SetTargetAccountIdFilters sets the TargetAccountIdFilters field's value.
func (s *ListCisScansFilterCriteria) SetTargetAccountIdFilters(v []*CisStringFilter) *ListCisScansFilterCriteria {
	s.TargetAccountIdFilters = v
	return s
}

// SetTargetResourceIdFilters sets the TargetResourceIdFilters field's value.
func (s *ListCisScansFilterCriteria) SetTargetResourceIdFilters(v []*CisStringFilter) *ListCisScansFilterCriteria {
	s.TargetResourceIdFilters = v
	return s
}

// SetTargetResourceTagFilters sets the TargetResourceTagFilters field's value.
func (s *ListCisScansFilterCriteria) SetTargetResourceTagFilters(v []*TagFilter) *ListCisScansFilterCriteria {
	s.TargetResourceTagFilters = v
	return s
}

type ListCisScansInput struct {
	_ struct{} `type:"structure"`

	// The detail applied to the CIS scan.
	DetailLevel *string `locationName:"detailLevel" type:"string" enum:"ListCisScansDetailLevel"`

	// The CIS scan filter criteria.
	FilterCriteria *ListCisScansFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of results to be returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The CIS scans sort by order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ListCisScansSortBy"`

	// The CIS scans sort order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"CisSortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCisScansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCisScansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetailLevel sets the DetailLevel field's value.
func (s *ListCisScansInput) SetDetailLevel(v string) *ListCisScansInput {
	s.DetailLevel = &v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListCisScansInput) SetFilterCriteria(v *ListCisScansFilterCriteria) *ListCisScansInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCisScansInput) SetMaxResults(v int64) *ListCisScansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScansInput) SetNextToken(v string) *ListCisScansInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListCisScansInput) SetSortBy(v string) *ListCisScansInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListCisScansInput) SetSortOrder(v string) *ListCisScansInput {
	s.SortOrder = &v
	return s
}

type ListCisScansOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from a previous request that's used to retrieve the
	// next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The CIS scans.
	Scans []*CisScan `locationName:"scans" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCisScansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCisScansOutput) SetNextToken(v string) *ListCisScansOutput {
	s.NextToken = &v
	return s
}

// SetScans sets the Scans field's value.
func (s *ListCisScansOutput) SetScans(v []*CisScan) *ListCisScansOutput {
	s.Scans = v
	return s
}

type ListCoverageInput struct {
	_ struct{} `type:"structure"`

	// An object that contains details on the filters to apply to the coverage data
	// for your environment.
	FilterCriteria *CoverageFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCoverageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCoverageInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListCoverageInput) SetFilterCriteria(v *CoverageFilterCriteria) *ListCoverageInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCoverageInput) SetMaxResults(v int64) *ListCoverageInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoverageInput) SetNextToken(v string) *ListCoverageInput {
	s.NextToken = &v
	return s
}

type ListCoverageOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains details on the covered resources in your environment.
	CoveredResources []*CoveredResource `locationName:"coveredResources" type:"list"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageOutput) GoString() string {
	return s.String()
}

// SetCoveredResources sets the CoveredResources field's value.
func (s *ListCoverageOutput) SetCoveredResources(v []*CoveredResource) *ListCoverageOutput {
	s.CoveredResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoverageOutput) SetNextToken(v string) *ListCoverageOutput {
	s.NextToken = &v
	return s
}

type ListCoverageStatisticsInput struct {
	_ struct{} `type:"structure"`

	// An object that contains details on the filters to apply to the coverage data
	// for your environment.
	FilterCriteria *CoverageFilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The value to group the results by.
	GroupBy *string `locationName:"groupBy" type:"string" enum:"GroupKey"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCoverageStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCoverageStatisticsInput"}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListCoverageStatisticsInput) SetFilterCriteria(v *CoverageFilterCriteria) *ListCoverageStatisticsInput {
	s.FilterCriteria = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *ListCoverageStatisticsInput) SetGroupBy(v string) *ListCoverageStatisticsInput {
	s.GroupBy = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoverageStatisticsInput) SetNextToken(v string) *ListCoverageStatisticsInput {
	s.NextToken = &v
	return s
}

type ListCoverageStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An array with the number for each group.
	CountsByGroup []*Counts `locationName:"countsByGroup" min:"1" type:"list"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The total number for all groups.
	//
	// TotalCounts is a required field
	TotalCounts *int64 `locationName:"totalCounts" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCoverageStatisticsOutput) GoString() string {
	return s.String()
}

// SetCountsByGroup sets the CountsByGroup field's value.
func (s *ListCoverageStatisticsOutput) SetCountsByGroup(v []*Counts) *ListCoverageStatisticsOutput {
	s.CountsByGroup = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoverageStatisticsOutput) SetNextToken(v string) *ListCoverageStatisticsOutput {
	s.NextToken = &v
	return s
}

// SetTotalCounts sets the TotalCounts field's value.
func (s *ListCoverageStatisticsOutput) SetTotalCounts(v int64) *ListCoverageStatisticsOutput {
	s.TotalCounts = &v
	return s
}

type ListDelegatedAdminAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDelegatedAdminAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDelegatedAdminAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDelegatedAdminAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDelegatedAdminAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDelegatedAdminAccountsInput) SetMaxResults(v int64) *ListDelegatedAdminAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDelegatedAdminAccountsInput) SetNextToken(v string) *ListDelegatedAdminAccountsInput {
	s.NextToken = &v
	return s
}

type ListDelegatedAdminAccountsOutput struct {
	_ struct{} `type:"structure"`

	// Details of the Amazon Inspector delegated administrator of your organization.
	DelegatedAdminAccounts []*DelegatedAdminAccount `locationName:"delegatedAdminAccounts" type:"list"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDelegatedAdminAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDelegatedAdminAccountsOutput) GoString() string {
	return s.String()
}

// SetDelegatedAdminAccounts sets the DelegatedAdminAccounts field's value.
func (s *ListDelegatedAdminAccountsOutput) SetDelegatedAdminAccounts(v []*DelegatedAdminAccount) *ListDelegatedAdminAccountsOutput {
	s.DelegatedAdminAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDelegatedAdminAccountsOutput) SetNextToken(v string) *ListDelegatedAdminAccountsOutput {
	s.NextToken = &v
	return s
}

type ListFiltersInput struct {
	_ struct{} `type:"structure"`

	// The action the filter applies to matched findings.
	Action *string `locationName:"action" type:"string" enum:"FilterAction"`

	// The Amazon resource number (ARN) of the filter.
	Arns []*string `locationName:"arns" type:"list"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ListFiltersInput) SetAction(v string) *ListFiltersInput {
	s.Action = &v
	return s
}

// SetArns sets the Arns field's value.
func (s *ListFiltersInput) SetArns(v []*string) *ListFiltersInput {
	s.Arns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFiltersInput) SetMaxResults(v int64) *ListFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFiltersInput) SetNextToken(v string) *ListFiltersInput {
	s.NextToken = &v
	return s
}

type ListFiltersOutput struct {
	_ struct{} `type:"structure"`

	// Contains details on the filters associated with your account.
	//
	// Filters is a required field
	Filters []*Filter `locationName:"filters" type:"list" required:"true"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFiltersOutput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ListFiltersOutput) SetFilters(v []*Filter) *ListFiltersOutput {
	s.Filters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFiltersOutput) SetNextToken(v string) *ListFiltersOutput {
	s.NextToken = &v
	return s
}

type ListFindingAggregationsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account IDs to retrieve finding aggregation data
	// for.
	AccountIds []*StringFilter `locationName:"accountIds" min:"1" type:"list"`

	// Details of the aggregation request that is used to filter your aggregation
	// results.
	AggregationRequest *AggregationRequest `locationName:"aggregationRequest" type:"structure"`

	// The type of the aggregation request.
	//
	// AggregationType is a required field
	AggregationType *string `locationName:"aggregationType" type:"string" required:"true" enum:"AggregationType"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingAggregationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingAggregationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingAggregationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingAggregationsInput"}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.AggregationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregationType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.AccountIds != nil {
		for i, v := range s.AccountIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountIds", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AggregationRequest != nil {
		if err := s.AggregationRequest.Validate(); err != nil {
			invalidParams.AddNested("AggregationRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListFindingAggregationsInput) SetAccountIds(v []*StringFilter) *ListFindingAggregationsInput {
	s.AccountIds = v
	return s
}

// SetAggregationRequest sets the AggregationRequest field's value.
func (s *ListFindingAggregationsInput) SetAggregationRequest(v *AggregationRequest) *ListFindingAggregationsInput {
	s.AggregationRequest = v
	return s
}

// SetAggregationType sets the AggregationType field's value.
func (s *ListFindingAggregationsInput) SetAggregationType(v string) *ListFindingAggregationsInput {
	s.AggregationType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingAggregationsInput) SetMaxResults(v int64) *ListFindingAggregationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingAggregationsInput) SetNextToken(v string) *ListFindingAggregationsInput {
	s.NextToken = &v
	return s
}

type ListFindingAggregationsOutput struct {
	_ struct{} `type:"structure"`

	// The type of aggregation to perform.
	//
	// AggregationType is a required field
	AggregationType *string `locationName:"aggregationType" type:"string" required:"true" enum:"AggregationType"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Objects that contain the results of an aggregation operation.
	Responses []*AggregationResponse `locationName:"responses" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingAggregationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingAggregationsOutput) GoString() string {
	return s.String()
}

// SetAggregationType sets the AggregationType field's value.
func (s *ListFindingAggregationsOutput) SetAggregationType(v string) *ListFindingAggregationsOutput {
	s.AggregationType = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingAggregationsOutput) SetNextToken(v string) *ListFindingAggregationsOutput {
	s.NextToken = &v
	return s
}

// SetResponses sets the Responses field's value.
func (s *ListFindingAggregationsOutput) SetResponses(v []*AggregationResponse) *ListFindingAggregationsOutput {
	s.Responses = v
	return s
}

type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// Details on the filters to apply to your finding results.
	FilterCriteria *FilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details on the sort criteria to apply to your finding results.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.SortCriteria != nil {
		if err := s.SortCriteria.Validate(); err != nil {
			invalidParams.AddNested("SortCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListFindingsInput) SetFilterCriteria(v *FilterCriteria) *ListFindingsInput {
	s.FilterCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *ListFindingsInput) SetSortCriteria(v *SortCriteria) *ListFindingsInput {
	s.SortCriteria = v
	return s
}

type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	// Contains details on the findings in your environment.
	Findings []*Finding `locationName:"findings" type:"list"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *ListFindingsOutput) SetFindings(v []*Finding) *ListFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies whether to list only currently associated members if True or to
	// list all members within the organization if False.
	OnlyAssociated *bool `locationName:"onlyAssociated" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v bool) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains details for each member account.
	Members []*Member `locationName:"members" type:"list"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon resource number (ARN) of the resource to list tags of.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsageTotalsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account IDs to retrieve usage totals for.
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list"`

	// The maximum number of results the response can return. If your request would
	// return more than the maximum the response will return a nextToken value,
	// use this value when you call the action again to get the remaining results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// If your response returns more than the maxResults maximum value it will also
	// return a nextToken value. For subsequent calls, use the nextToken value returned
	// from the previous request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageTotalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageTotalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsageTotalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsageTotalsInput"}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListUsageTotalsInput) SetAccountIds(v []*string) *ListUsageTotalsInput {
	s.AccountIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsageTotalsInput) SetMaxResults(v int64) *ListUsageTotalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsageTotalsInput) SetNextToken(v string) *ListUsageTotalsInput {
	s.NextToken = &v
	return s
}

type ListUsageTotalsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An object with details on the total usage for the requested account.
	Totals []*UsageTotal `locationName:"totals" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageTotalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageTotalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsageTotalsOutput) SetNextToken(v string) *ListUsageTotalsOutput {
	s.NextToken = &v
	return s
}

// SetTotals sets the Totals field's value.
func (s *ListUsageTotalsOutput) SetTotals(v []*UsageTotal) *ListUsageTotalsOutput {
	s.Totals = v
	return s
}

// An object that describes details of a map filter.
type MapFilter struct {
	_ struct{} `type:"structure"`

	// The operator to use when comparing values in the filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"MapComparison"`

	// The tag key used in the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag value used in the filter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MapFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MapFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MapFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *MapFilter) SetComparison(v string) *MapFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MapFilter) SetKey(v string) *MapFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MapFilter) SetValue(v string) *MapFilter {
	s.Value = &v
	return s
}

// Details on a member account in your organization.
type Member struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the member account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The Amazon Web Services account ID of the Amazon Inspector delegated administrator
	// for this member account.
	DelegatedAdminAccountId *string `locationName:"delegatedAdminAccountId" min:"12" type:"string"`

	// The status of the member account.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" enum:"RelationshipStatus"`

	// A timestamp showing when the status of this member was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetDelegatedAdminAccountId sets the DelegatedAdminAccountId field's value.
func (s *Member) SetDelegatedAdminAccountId(v string) *Member {
	s.DelegatedAdminAccountId = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Member) SetRelationshipStatus(v string) *Member {
	s.RelationshipStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v time.Time) *Member {
	s.UpdatedAt = &v
	return s
}

// An object that contains details about the status of Amazon Inspector deep
// inspection for a member account in your organization.
type MemberAccountEc2DeepInspectionStatus struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Amazon Web Services account of the organization
	// member.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// Whether Amazon Inspector deep inspection is active in the account. If TRUE
	// Amazon Inspector deep inspection is active, if FALSE it is not active.
	//
	// ActivateDeepInspection is a required field
	ActivateDeepInspection *bool `locationName:"activateDeepInspection" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccountEc2DeepInspectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccountEc2DeepInspectionStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberAccountEc2DeepInspectionStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberAccountEc2DeepInspectionStatus"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.ActivateDeepInspection == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivateDeepInspection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *MemberAccountEc2DeepInspectionStatus) SetAccountId(v string) *MemberAccountEc2DeepInspectionStatus {
	s.AccountId = &v
	return s
}

// SetActivateDeepInspection sets the ActivateDeepInspection field's value.
func (s *MemberAccountEc2DeepInspectionStatus) SetActivateDeepInspection(v bool) *MemberAccountEc2DeepInspectionStatus {
	s.ActivateDeepInspection = &v
	return s
}

// An object that contains details about the state of Amazon Inspector deep
// inspection for a member account.
type MemberAccountEc2DeepInspectionStatusState struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Amazon Web Services account of the organization
	// member
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The error message explaining why the account failed to activate Amazon Inspector
	// deep inspection.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// The state of Amazon Inspector deep inspection in the member account.
	Status *string `locationName:"status" type:"string" enum:"Ec2DeepInspectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccountEc2DeepInspectionStatusState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccountEc2DeepInspectionStatusState) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberAccountEc2DeepInspectionStatusState) SetAccountId(v string) *MemberAccountEc2DeepInspectionStatusState {
	s.AccountId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *MemberAccountEc2DeepInspectionStatusState) SetErrorMessage(v string) *MemberAccountEc2DeepInspectionStatusState {
	s.ErrorMessage = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MemberAccountEc2DeepInspectionStatusState) SetStatus(v string) *MemberAccountEc2DeepInspectionStatusState {
	s.Status = &v
	return s
}

// A monthly schedule.
type MonthlySchedule struct {
	_ struct{} `type:"structure"`

	// The monthly schedule's day.
	//
	// Day is a required field
	Day *string `locationName:"day" type:"string" required:"true" enum:"Day"`

	// The monthly schedule's start time.
	//
	// StartTime is a required field
	StartTime *Time `locationName:"startTime" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonthlySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonthlySchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonthlySchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MonthlySchedule"}
	if s.Day == nil {
		invalidParams.Add(request.NewErrParamRequired("Day"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StartTime != nil {
		if err := s.StartTime.Validate(); err != nil {
			invalidParams.AddNested("StartTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDay sets the Day field's value.
func (s *MonthlySchedule) SetDay(v string) *MonthlySchedule {
	s.Day = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MonthlySchedule) SetStartTime(v *Time) *MonthlySchedule {
	s.StartTime = v
	return s
}

// Information on the network path associated with a finding.
type NetworkPath struct {
	_ struct{} `type:"structure"`

	// The details on the steps in the network path.
	Steps []*Step `locationName:"steps" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkPath) GoString() string {
	return s.String()
}

// SetSteps sets the Steps field's value.
func (s *NetworkPath) SetSteps(v []*Step) *NetworkPath {
	s.Steps = v
	return s
}

// Contains the details of a network reachability finding.
type NetworkReachabilityDetails struct {
	_ struct{} `type:"structure"`

	// An object that contains details about a network path associated with a finding.
	//
	// NetworkPath is a required field
	NetworkPath *NetworkPath `locationName:"networkPath" type:"structure" required:"true"`

	// An object that contains details about the open port range associated with
	// a finding.
	//
	// OpenPortRange is a required field
	OpenPortRange *PortRange `locationName:"openPortRange" type:"structure" required:"true"`

	// The protocol associated with a finding.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"NetworkProtocol"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkReachabilityDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkReachabilityDetails) GoString() string {
	return s.String()
}

// SetNetworkPath sets the NetworkPath field's value.
func (s *NetworkReachabilityDetails) SetNetworkPath(v *NetworkPath) *NetworkReachabilityDetails {
	s.NetworkPath = v
	return s
}

// SetOpenPortRange sets the OpenPortRange field's value.
func (s *NetworkReachabilityDetails) SetOpenPortRange(v *PortRange) *NetworkReachabilityDetails {
	s.OpenPortRange = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *NetworkReachabilityDetails) SetProtocol(v string) *NetworkReachabilityDetails {
	s.Protocol = &v
	return s
}

// An object that describes the details of a number filter.
type NumberFilter struct {
	_ struct{} `type:"structure"`

	// The lowest number to be included in the filter.
	LowerInclusive *float64 `locationName:"lowerInclusive" type:"double"`

	// The highest number to be included in the filter.
	UpperInclusive *float64 `locationName:"upperInclusive" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NumberFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NumberFilter) GoString() string {
	return s.String()
}

// SetLowerInclusive sets the LowerInclusive field's value.
func (s *NumberFilter) SetLowerInclusive(v float64) *NumberFilter {
	s.LowerInclusive = &v
	return s
}

// SetUpperInclusive sets the UpperInclusive field's value.
func (s *NumberFilter) SetUpperInclusive(v float64) *NumberFilter {
	s.UpperInclusive = &v
	return s
}

// A one time schedule.
type OneTimeSchedule struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OneTimeSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OneTimeSchedule) GoString() string {
	return s.String()
}

// The details that define an aggregation based on operating system package
// type.
type PackageAggregation struct {
	_ struct{} `type:"structure"`

	// The names of packages to aggregate findings on.
	PackageNames []*StringFilter `locationName:"packageNames" min:"1" type:"list"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"PackageSortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageAggregation"}
	if s.PackageNames != nil && len(s.PackageNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageNames", 1))
	}
	if s.PackageNames != nil {
		for i, v := range s.PackageNames {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PackageNames", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageNames sets the PackageNames field's value.
func (s *PackageAggregation) SetPackageNames(v []*StringFilter) *PackageAggregation {
	s.PackageNames = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *PackageAggregation) SetSortBy(v string) *PackageAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *PackageAggregation) SetSortOrder(v string) *PackageAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains the results of a finding aggregation by image layer.
type PackageAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The name of the operating system package.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`

	// An object that contains the count of matched findings per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *PackageAggregationResponse) SetAccountId(v string) *PackageAggregationResponse {
	s.AccountId = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageAggregationResponse) SetPackageName(v string) *PackageAggregationResponse {
	s.PackageName = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *PackageAggregationResponse) SetSeverityCounts(v *SeverityCounts) *PackageAggregationResponse {
	s.SeverityCounts = v
	return s
}

// Contains information on the details of a package filter.
type PackageFilter struct {
	_ struct{} `type:"structure"`

	// An object that contains details on the package architecture type to filter
	// on.
	Architecture *StringFilter `locationName:"architecture" type:"structure"`

	// An object that contains details on the package epoch to filter on.
	Epoch *NumberFilter `locationName:"epoch" type:"structure"`

	// An object that contains details on the name of the package to filter on.
	Name *StringFilter `locationName:"name" type:"structure"`

	// An object that contains details on the package release to filter on.
	Release *StringFilter `locationName:"release" type:"structure"`

	// An object that describes the details of a string filter.
	SourceLambdaLayerArn *StringFilter `locationName:"sourceLambdaLayerArn" type:"structure"`

	// An object that contains details on the source layer hash to filter on.
	SourceLayerHash *StringFilter `locationName:"sourceLayerHash" type:"structure"`

	// The package version to filter on.
	Version *StringFilter `locationName:"version" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageFilter"}
	if s.Architecture != nil {
		if err := s.Architecture.Validate(); err != nil {
			invalidParams.AddNested("Architecture", err.(request.ErrInvalidParams))
		}
	}
	if s.Name != nil {
		if err := s.Name.Validate(); err != nil {
			invalidParams.AddNested("Name", err.(request.ErrInvalidParams))
		}
	}
	if s.Release != nil {
		if err := s.Release.Validate(); err != nil {
			invalidParams.AddNested("Release", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceLambdaLayerArn != nil {
		if err := s.SourceLambdaLayerArn.Validate(); err != nil {
			invalidParams.AddNested("SourceLambdaLayerArn", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceLayerHash != nil {
		if err := s.SourceLayerHash.Validate(); err != nil {
			invalidParams.AddNested("SourceLayerHash", err.(request.ErrInvalidParams))
		}
	}
	if s.Version != nil {
		if err := s.Version.Validate(); err != nil {
			invalidParams.AddNested("Version", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchitecture sets the Architecture field's value.
func (s *PackageFilter) SetArchitecture(v *StringFilter) *PackageFilter {
	s.Architecture = v
	return s
}

// SetEpoch sets the Epoch field's value.
func (s *PackageFilter) SetEpoch(v *NumberFilter) *PackageFilter {
	s.Epoch = v
	return s
}

// SetName sets the Name field's value.
func (s *PackageFilter) SetName(v *StringFilter) *PackageFilter {
	s.Name = v
	return s
}

// SetRelease sets the Release field's value.
func (s *PackageFilter) SetRelease(v *StringFilter) *PackageFilter {
	s.Release = v
	return s
}

// SetSourceLambdaLayerArn sets the SourceLambdaLayerArn field's value.
func (s *PackageFilter) SetSourceLambdaLayerArn(v *StringFilter) *PackageFilter {
	s.SourceLambdaLayerArn = v
	return s
}

// SetSourceLayerHash sets the SourceLayerHash field's value.
func (s *PackageFilter) SetSourceLayerHash(v *StringFilter) *PackageFilter {
	s.SourceLayerHash = v
	return s
}

// SetVersion sets the Version field's value.
func (s *PackageFilter) SetVersion(v *StringFilter) *PackageFilter {
	s.Version = v
	return s
}

// Information about a package vulnerability finding.
type PackageVulnerabilityDetails struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the CVSS score of a finding.
	Cvss []*CvssScore `locationName:"cvss" type:"list"`

	// One or more URLs that contain details about this vulnerability type.
	ReferenceUrls []*string `locationName:"referenceUrls" type:"list"`

	// One or more vulnerabilities related to the one identified in this finding.
	RelatedVulnerabilities []*string `locationName:"relatedVulnerabilities" type:"list"`

	// The source of the vulnerability information.
	//
	// Source is a required field
	Source *string `locationName:"source" min:"1" type:"string" required:"true"`

	// A URL to the source of the vulnerability information.
	SourceUrl *string `locationName:"sourceUrl" min:"1" type:"string"`

	// The date and time that this vulnerability was first added to the vendor's
	// database.
	VendorCreatedAt *time.Time `locationName:"vendorCreatedAt" type:"timestamp"`

	// The severity the vendor has given to this vulnerability type.
	VendorSeverity *string `locationName:"vendorSeverity" min:"1" type:"string"`

	// The date and time the vendor last updated this vulnerability in their database.
	VendorUpdatedAt *time.Time `locationName:"vendorUpdatedAt" type:"timestamp"`

	// The ID given to this vulnerability.
	//
	// VulnerabilityId is a required field
	VulnerabilityId *string `locationName:"vulnerabilityId" min:"1" type:"string" required:"true"`

	// The packages impacted by this vulnerability.
	VulnerablePackages []*VulnerablePackage `locationName:"vulnerablePackages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVulnerabilityDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVulnerabilityDetails) GoString() string {
	return s.String()
}

// SetCvss sets the Cvss field's value.
func (s *PackageVulnerabilityDetails) SetCvss(v []*CvssScore) *PackageVulnerabilityDetails {
	s.Cvss = v
	return s
}

// SetReferenceUrls sets the ReferenceUrls field's value.
func (s *PackageVulnerabilityDetails) SetReferenceUrls(v []*string) *PackageVulnerabilityDetails {
	s.ReferenceUrls = v
	return s
}

// SetRelatedVulnerabilities sets the RelatedVulnerabilities field's value.
func (s *PackageVulnerabilityDetails) SetRelatedVulnerabilities(v []*string) *PackageVulnerabilityDetails {
	s.RelatedVulnerabilities = v
	return s
}

// SetSource sets the Source field's value.
func (s *PackageVulnerabilityDetails) SetSource(v string) *PackageVulnerabilityDetails {
	s.Source = &v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *PackageVulnerabilityDetails) SetSourceUrl(v string) *PackageVulnerabilityDetails {
	s.SourceUrl = &v
	return s
}

// SetVendorCreatedAt sets the VendorCreatedAt field's value.
func (s *PackageVulnerabilityDetails) SetVendorCreatedAt(v time.Time) *PackageVulnerabilityDetails {
	s.VendorCreatedAt = &v
	return s
}

// SetVendorSeverity sets the VendorSeverity field's value.
func (s *PackageVulnerabilityDetails) SetVendorSeverity(v string) *PackageVulnerabilityDetails {
	s.VendorSeverity = &v
	return s
}

// SetVendorUpdatedAt sets the VendorUpdatedAt field's value.
func (s *PackageVulnerabilityDetails) SetVendorUpdatedAt(v time.Time) *PackageVulnerabilityDetails {
	s.VendorUpdatedAt = &v
	return s
}

// SetVulnerabilityId sets the VulnerabilityId field's value.
func (s *PackageVulnerabilityDetails) SetVulnerabilityId(v string) *PackageVulnerabilityDetails {
	s.VulnerabilityId = &v
	return s
}

// SetVulnerablePackages sets the VulnerablePackages field's value.
func (s *PackageVulnerabilityDetails) SetVulnerablePackages(v []*VulnerablePackage) *PackageVulnerabilityDetails {
	s.VulnerablePackages = v
	return s
}

// Contains information on the permissions an account has within Amazon Inspector.
type Permission struct {
	_ struct{} `type:"structure"`

	// The operations that can be performed with the given permissions.
	//
	// Operation is a required field
	Operation *string `locationName:"operation" type:"string" required:"true" enum:"Operation"`

	// The services that the permissions allow an account to perform the given operations
	// for.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true" enum:"Service"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Permission) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *Permission) SetOperation(v string) *Permission {
	s.Operation = &v
	return s
}

// SetService sets the Service field's value.
func (s *Permission) SetService(v string) *Permission {
	s.Service = &v
	return s
}

// Details about the port range associated with a finding.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The beginning port in a port range.
	//
	// Begin is a required field
	Begin *int64 `locationName:"begin" type:"integer" required:"true"`

	// The ending port in a port range.
	//
	// End is a required field
	End *int64 `locationName:"end" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) GoString() string {
	return s.String()
}

// SetBegin sets the Begin field's value.
func (s *PortRange) SetBegin(v int64) *PortRange {
	s.Begin = &v
	return s
}

// SetEnd sets the End field's value.
func (s *PortRange) SetEnd(v int64) *PortRange {
	s.End = &v
	return s
}

// An object that describes the details of a port range filter.
type PortRangeFilter struct {
	_ struct{} `type:"structure"`

	// The port number the port range begins at.
	BeginInclusive *int64 `locationName:"beginInclusive" type:"integer"`

	// The port number the port range ends at.
	EndInclusive *int64 `locationName:"endInclusive" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRangeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRangeFilter) GoString() string {
	return s.String()
}

// SetBeginInclusive sets the BeginInclusive field's value.
func (s *PortRangeFilter) SetBeginInclusive(v int64) *PortRangeFilter {
	s.BeginInclusive = &v
	return s
}

// SetEndInclusive sets the EndInclusive field's value.
func (s *PortRangeFilter) SetEndInclusive(v int64) *PortRangeFilter {
	s.EndInclusive = &v
	return s
}

// Details about the recommended course of action to remediate the finding.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The recommended course of action to remediate the finding.
	Text *string `locationName:"text" min:"1" type:"string"`

	// The URL address to the CVE remediation recommendations.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Recommendation) SetText(v string) *Recommendation {
	s.Text = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Recommendation) SetUrl(v string) *Recommendation {
	s.Url = &v
	return s
}

// Information on how to remediate a finding.
type Remediation struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the recommended course of action
	// to remediate the finding.
	Recommendation *Recommendation `locationName:"recommendation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Remediation) GoString() string {
	return s.String()
}

// SetRecommendation sets the Recommendation field's value.
func (s *Remediation) SetRecommendation(v *Recommendation) *Remediation {
	s.Recommendation = v
	return s
}

// The details that define an aggregation based on repository.
type RepositoryAggregation struct {
	_ struct{} `type:"structure"`

	// The names of repositories to aggregate findings on.
	Repositories []*StringFilter `locationName:"repositories" min:"1" type:"list"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"RepositorySortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryAggregation"}
	if s.Repositories != nil && len(s.Repositories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Repositories", 1))
	}
	if s.Repositories != nil {
		for i, v := range s.Repositories {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Repositories", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositories sets the Repositories field's value.
func (s *RepositoryAggregation) SetRepositories(v []*StringFilter) *RepositoryAggregation {
	s.Repositories = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *RepositoryAggregation) SetSortBy(v string) *RepositoryAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *RepositoryAggregation) SetSortOrder(v string) *RepositoryAggregation {
	s.SortOrder = &v
	return s
}

// A response that contains details on the results of a finding aggregation
// by repository.
type RepositoryAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The number of container images impacted by the findings.
	AffectedImages *int64 `locationName:"affectedImages" type:"long"`

	// The name of the repository associated with the findings.
	//
	// Repository is a required field
	Repository *string `locationName:"repository" min:"1" type:"string" required:"true"`

	// An object that represent the count of matched findings per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RepositoryAggregationResponse) SetAccountId(v string) *RepositoryAggregationResponse {
	s.AccountId = &v
	return s
}

// SetAffectedImages sets the AffectedImages field's value.
func (s *RepositoryAggregationResponse) SetAffectedImages(v int64) *RepositoryAggregationResponse {
	s.AffectedImages = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *RepositoryAggregationResponse) SetRepository(v string) *RepositoryAggregationResponse {
	s.Repository = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *RepositoryAggregationResponse) SetSeverityCounts(v *SeverityCounts) *RepositoryAggregationResponse {
	s.SeverityCounts = v
	return s
}

type ResetEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The resource type the key encrypts.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The scan type the key encrypts.
	//
	// ScanType is a required field
	ScanType *string `locationName:"scanType" type:"string" required:"true" enum:"ScanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetEncryptionKeyInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ScanType == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *ResetEncryptionKeyInput) SetResourceType(v string) *ResetEncryptionKeyInput {
	s.ResourceType = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *ResetEncryptionKeyInput) SetScanType(v string) *ResetEncryptionKeyInput {
	s.ScanType = &v
	return s
}

type ResetEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetEncryptionKeyOutput) GoString() string {
	return s.String()
}

// Details about the resource involved in a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the resource involved in a finding.
	Details *ResourceDetails `locationName:"details" type:"structure"`

	// The ID of the resource.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The partition of the resource.
	Partition *string `locationName:"partition" min:"1" type:"string"`

	// The Amazon Web Services Region the impacted resource is located in.
	Region *string `locationName:"region" min:"1" type:"string"`

	// The tags attached to the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of resource.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *Resource) SetDetails(v *ResourceDetails) *Resource {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Resource) SetPartition(v string) *Resource {
	s.Partition = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Resource) SetRegion(v string) *Resource {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Resource) SetTags(v map[string]*string) *Resource {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// Contains details about the resource involved in the finding.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the Amazon EC2 instance involved in
	// the finding.
	AwsEc2Instance *AwsEc2InstanceDetails `locationName:"awsEc2Instance" type:"structure"`

	// An object that contains details about the Amazon ECR container image involved
	// in the finding.
	AwsEcrContainerImage *AwsEcrContainerImageDetails `locationName:"awsEcrContainerImage" type:"structure"`

	// A summary of the information about an Amazon Web Services Lambda function
	// affected by a finding.
	AwsLambdaFunction *AwsLambdaFunctionDetails `locationName:"awsLambdaFunction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDetails) GoString() string {
	return s.String()
}

// SetAwsEc2Instance sets the AwsEc2Instance field's value.
func (s *ResourceDetails) SetAwsEc2Instance(v *AwsEc2InstanceDetails) *ResourceDetails {
	s.AwsEc2Instance = v
	return s
}

// SetAwsEcrContainerImage sets the AwsEcrContainerImage field's value.
func (s *ResourceDetails) SetAwsEcrContainerImage(v *AwsEcrContainerImageDetails) *ResourceDetails {
	s.AwsEcrContainerImage = v
	return s
}

// SetAwsLambdaFunction sets the AwsLambdaFunction field's value.
func (s *ResourceDetails) SetAwsLambdaFunction(v *AwsLambdaFunctionDetails) *ResourceDetails {
	s.AwsLambdaFunction = v
	return s
}

// The resource filter criteria for a Software bill of materials (SBOM) report.
type ResourceFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The account IDs used as resource filter criteria.
	AccountId []*ResourceStringFilter `locationName:"accountId" min:"1" type:"list"`

	// The EC2 instance tags used as resource filter criteria.
	Ec2InstanceTags []*ResourceMapFilter `locationName:"ec2InstanceTags" min:"1" type:"list"`

	// The ECR image tags used as resource filter criteria.
	EcrImageTags []*ResourceStringFilter `locationName:"ecrImageTags" min:"1" type:"list"`

	// The ECR repository names used as resource filter criteria.
	EcrRepositoryName []*ResourceStringFilter `locationName:"ecrRepositoryName" min:"1" type:"list"`

	// The Amazon Web Services Lambda function name used as resource filter criteria.
	LambdaFunctionName []*ResourceStringFilter `locationName:"lambdaFunctionName" min:"1" type:"list"`

	// The Amazon Web Services Lambda function tags used as resource filter criteria.
	LambdaFunctionTags []*ResourceMapFilter `locationName:"lambdaFunctionTags" min:"1" type:"list"`

	// The resource IDs used as resource filter criteria.
	ResourceId []*ResourceStringFilter `locationName:"resourceId" min:"1" type:"list"`

	// The resource types used as resource filter criteria.
	ResourceType []*ResourceStringFilter `locationName:"resourceType" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceFilterCriteria"}
	if s.AccountId != nil && len(s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Ec2InstanceTags != nil && len(s.Ec2InstanceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ec2InstanceTags", 1))
	}
	if s.EcrImageTags != nil && len(s.EcrImageTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrImageTags", 1))
	}
	if s.EcrRepositoryName != nil && len(s.EcrRepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EcrRepositoryName", 1))
	}
	if s.LambdaFunctionName != nil && len(s.LambdaFunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionName", 1))
	}
	if s.LambdaFunctionTags != nil && len(s.LambdaFunctionTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionTags", 1))
	}
	if s.ResourceId != nil && len(s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.AccountId != nil {
		for i, v := range s.AccountId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ec2InstanceTags != nil {
		for i, v := range s.Ec2InstanceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2InstanceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrImageTags != nil {
		for i, v := range s.EcrImageTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrImageTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EcrRepositoryName != nil {
		for i, v := range s.EcrRepositoryName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EcrRepositoryName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionName != nil {
		for i, v := range s.LambdaFunctionName {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionName", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LambdaFunctionTags != nil {
		for i, v := range s.LambdaFunctionTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceId != nil {
		for i, v := range s.ResourceId {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceId", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceType != nil {
		for i, v := range s.ResourceType {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceType", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ResourceFilterCriteria) SetAccountId(v []*ResourceStringFilter) *ResourceFilterCriteria {
	s.AccountId = v
	return s
}

// SetEc2InstanceTags sets the Ec2InstanceTags field's value.
func (s *ResourceFilterCriteria) SetEc2InstanceTags(v []*ResourceMapFilter) *ResourceFilterCriteria {
	s.Ec2InstanceTags = v
	return s
}

// SetEcrImageTags sets the EcrImageTags field's value.
func (s *ResourceFilterCriteria) SetEcrImageTags(v []*ResourceStringFilter) *ResourceFilterCriteria {
	s.EcrImageTags = v
	return s
}

// SetEcrRepositoryName sets the EcrRepositoryName field's value.
func (s *ResourceFilterCriteria) SetEcrRepositoryName(v []*ResourceStringFilter) *ResourceFilterCriteria {
	s.EcrRepositoryName = v
	return s
}

// SetLambdaFunctionName sets the LambdaFunctionName field's value.
func (s *ResourceFilterCriteria) SetLambdaFunctionName(v []*ResourceStringFilter) *ResourceFilterCriteria {
	s.LambdaFunctionName = v
	return s
}

// SetLambdaFunctionTags sets the LambdaFunctionTags field's value.
func (s *ResourceFilterCriteria) SetLambdaFunctionTags(v []*ResourceMapFilter) *ResourceFilterCriteria {
	s.LambdaFunctionTags = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceFilterCriteria) SetResourceId(v []*ResourceStringFilter) *ResourceFilterCriteria {
	s.ResourceId = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceFilterCriteria) SetResourceType(v []*ResourceStringFilter) *ResourceFilterCriteria {
	s.ResourceType = v
	return s
}

// A resource map filter for a software bill of material report.
type ResourceMapFilter struct {
	_ struct{} `type:"structure"`

	// The filter's comparison.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"ResourceMapComparison"`

	// The filter's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The filter's value.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMapFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceMapFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceMapFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceMapFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *ResourceMapFilter) SetComparison(v string) *ResourceMapFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ResourceMapFilter) SetKey(v string) *ResourceMapFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceMapFilter) SetValue(v string) *ResourceMapFilter {
	s.Value = &v
	return s
}

// The operation tried to access an invalid resource. Make sure the resource
// is specified correctly.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains details about the metadata for an Amazon ECR resource.
type ResourceScanMetadata struct {
	_ struct{} `type:"structure"`

	// An object that contains metadata details for an Amazon EC2 instance.
	Ec2 *Ec2Metadata `locationName:"ec2" type:"structure"`

	// An object that contains details about the container metadata for an Amazon
	// ECR image.
	EcrImage *EcrContainerImageMetadata `locationName:"ecrImage" type:"structure"`

	// An object that contains details about the repository an Amazon ECR image
	// resides in.
	EcrRepository *EcrRepositoryMetadata `locationName:"ecrRepository" type:"structure"`

	// An object that contains metadata details for an Amazon Web Services Lambda
	// function.
	LambdaFunction *LambdaFunctionMetadata `locationName:"lambdaFunction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceScanMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceScanMetadata) GoString() string {
	return s.String()
}

// SetEc2 sets the Ec2 field's value.
func (s *ResourceScanMetadata) SetEc2(v *Ec2Metadata) *ResourceScanMetadata {
	s.Ec2 = v
	return s
}

// SetEcrImage sets the EcrImage field's value.
func (s *ResourceScanMetadata) SetEcrImage(v *EcrContainerImageMetadata) *ResourceScanMetadata {
	s.EcrImage = v
	return s
}

// SetEcrRepository sets the EcrRepository field's value.
func (s *ResourceScanMetadata) SetEcrRepository(v *EcrRepositoryMetadata) *ResourceScanMetadata {
	s.EcrRepository = v
	return s
}

// SetLambdaFunction sets the LambdaFunction field's value.
func (s *ResourceScanMetadata) SetLambdaFunction(v *LambdaFunctionMetadata) *ResourceScanMetadata {
	s.LambdaFunction = v
	return s
}

// Details the state of Amazon Inspector for each resource type Amazon Inspector
// scans.
type ResourceState struct {
	_ struct{} `type:"structure"`

	// An object detailing the state of Amazon Inspector scanning for Amazon EC2
	// resources.
	//
	// Ec2 is a required field
	Ec2 *State `locationName:"ec2" type:"structure" required:"true"`

	// An object detailing the state of Amazon Inspector scanning for Amazon ECR
	// resources.
	//
	// Ecr is a required field
	Ecr *State `locationName:"ecr" type:"structure" required:"true"`

	// An object that described the state of Amazon Inspector scans for an account.
	Lambda *State `locationName:"lambda" type:"structure"`

	// An object that described the state of Amazon Inspector scans for an account.
	LambdaCode *State `locationName:"lambdaCode" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceState) GoString() string {
	return s.String()
}

// SetEc2 sets the Ec2 field's value.
func (s *ResourceState) SetEc2(v *State) *ResourceState {
	s.Ec2 = v
	return s
}

// SetEcr sets the Ecr field's value.
func (s *ResourceState) SetEcr(v *State) *ResourceState {
	s.Ecr = v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *ResourceState) SetLambda(v *State) *ResourceState {
	s.Lambda = v
	return s
}

// SetLambdaCode sets the LambdaCode field's value.
func (s *ResourceState) SetLambdaCode(v *State) *ResourceState {
	s.LambdaCode = v
	return s
}

// Details the status of Amazon Inspector for each resource type Amazon Inspector
// scans.
type ResourceStatus struct {
	_ struct{} `type:"structure"`

	// The status of Amazon Inspector scanning for Amazon EC2 resources.
	//
	// Ec2 is a required field
	Ec2 *string `locationName:"ec2" type:"string" required:"true" enum:"Status"`

	// The status of Amazon Inspector scanning for Amazon ECR resources.
	//
	// Ecr is a required field
	Ecr *string `locationName:"ecr" type:"string" required:"true" enum:"Status"`

	// The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
	Lambda *string `locationName:"lambda" type:"string" enum:"Status"`

	// The status of Amazon Inspector scanning for custom application code for Amazon
	// Web Services Lambda functions.
	LambdaCode *string `locationName:"lambdaCode" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceStatus) GoString() string {
	return s.String()
}

// SetEc2 sets the Ec2 field's value.
func (s *ResourceStatus) SetEc2(v string) *ResourceStatus {
	s.Ec2 = &v
	return s
}

// SetEcr sets the Ecr field's value.
func (s *ResourceStatus) SetEcr(v string) *ResourceStatus {
	s.Ecr = &v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *ResourceStatus) SetLambda(v string) *ResourceStatus {
	s.Lambda = &v
	return s
}

// SetLambdaCode sets the LambdaCode field's value.
func (s *ResourceStatus) SetLambdaCode(v string) *ResourceStatus {
	s.LambdaCode = &v
	return s
}

// A resource string filter for a software bill of materials report.
type ResourceStringFilter struct {
	_ struct{} `type:"structure"`

	// The filter's comparison.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"ResourceStringComparison"`

	// The filter's value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceStringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceStringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceStringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceStringFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *ResourceStringFilter) SetComparison(v string) *ResourceStringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceStringFilter) SetValue(v string) *ResourceStringFilter {
	s.Value = &v
	return s
}

// The status of the scan.
type ScanStatus struct {
	_ struct{} `type:"structure"`

	// The scan status. Possible return values and descriptions are:
	//
	// PENDING_INITIAL_SCAN - This resource has been identified for scanning, results
	// will be available soon.
	//
	// ACCESS_DENIED - Resource access policy restricting Amazon Inspector access.
	// Please update the IAM policy.
	//
	// INTERNAL_ERROR - Amazon Inspector has encountered an internal error for this
	// resource. Amazon Inspector service will automatically resolve the issue and
	// resume the scanning. No action required from the user.
	//
	// UNMANAGED_EC2_INSTANCE - The EC2 instance is not managed by SSM, please use
	// the following SSM automation to remediate the issue: https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html
	// (https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html).
	// Once the instance becomes managed by SSM, Inspector will automatically begin
	// scanning this instance.
	//
	// UNSUPPORTED_OS - Amazon Inspector does not support this OS, architecture,
	// or image manifest type at this time. To see a complete list of supported
	// operating systems see: https://docs.aws.amazon.com/inspector/latest/user/supported.html
	// (https://docs.aws.amazon.com/inspector/latest/user/supported.html).
	//
	// SCAN_ELIGIBILITY_EXPIRED - The configured scan duration has lapsed for this
	// image.
	//
	// RESOURCE_TERMINATED - This resource has been terminated. The findings and
	// coverage associated with this resource are in the process of being cleaned
	// up.
	//
	// SUCCESSFUL - The scan was successful.
	//
	// NO_RESOURCES_FOUND - Reserved for future use.
	//
	// IMAGE_SIZE_EXCEEDED - Reserved for future use.
	//
	// SCAN_FREQUENCY_MANUAL - This image will not be covered by Amazon Inspector
	// due to the repository scan frequency configuration.
	//
	// SCAN_FREQUENCY_SCAN_ON_PUSH - This image will be scanned one time and will
	// not new findings because of the scan frequency configuration.
	//
	// EC2_INSTANCE_STOPPED - This EC2 instance is in a stopped state, therefore,
	// Amazon Inspector will pause scanning. The existing findings will continue
	// to exist until the instance is terminated. Once the instance is re-started,
	// Inspector will automatically start scanning the instance again. Please note
	// that you will not be charged for this instance while it’s in a stopped
	// state.
	//
	// PENDING_DISABLE - This resource is pending cleanup during disablement. The
	// customer will not be billed while a resource is in the pending disable status.
	//
	// NO INVENTORY - Amazon Inspector couldn’t find software application inventory
	// to scan for vulnerabilities. This might be caused due to required Amazon
	// Inspector associations being deleted or failing to run on your resource.
	// Please verify the status of InspectorInventoryCollection-do-not-delete association
	// in the SSM console for the resource. Additionally, you can verify the instance’s
	// inventory in the SSM Fleet Manager console.
	//
	// STALE_INVENTORY - Amazon Inspector wasn’t able to collect an updated software
	// application inventory in the last 7 days. Please confirm the required Amazon
	// Inspector associations still exist and you can still see an updated inventory
	// in the SSM console.
	//
	// EXCLUDED_BY_TAG - This resource was not scanned because it has been excluded
	// by a tag.
	//
	// UNSUPPORTED_RUNTIME - The function was not scanned because it has an unsupported
	// runtime. To see a complete list of supported runtimes see: https://docs.aws.amazon.com/inspector/latest/user/supported.html
	// (https://docs.aws.amazon.com/inspector/latest/user/supported.html).
	//
	// UNSUPPORTED_MEDIA_TYPE - The ECR image has an unsupported media type.
	//
	// UNSUPPORTED_CONFIG_FILE - Reserved for future use.
	//
	// DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED - The instance has exceeded
	// the 5000 package limit for Amazon Inspector Deep inspection. To resume Deep
	// inspection for this instance you can try to adjust the custom paths associated
	// with the account.
	//
	// DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED - The SSM agent couldn't
	// send inventory to Amazon Inspector because the SSM quota for Inventory data
	// collected per instance per day has already been reached for this instance.
	//
	// DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED - Amazon Inspector failed
	// to extract the package inventory because the package collection time exceeding
	// the maximum threshold of 15 minutes.
	//
	// DEEP_INSPECTION_NO_INVENTORY The Amazon Inspector plugin hasn't yet been
	// able to collect an inventory of packages for this instance. This is usually
	// the result of a pending scan, however, if this status persists after 6 hours,
	// use SSM to ensure that the required Amazon Inspector associations exist and
	// are running for the instance.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ScanStatusReason"`

	// The status code of the scan.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"ScanStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScanStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScanStatus) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ScanStatus) SetReason(v string) *ScanStatus {
	s.Reason = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ScanStatus) SetStatusCode(v string) *ScanStatus {
	s.StatusCode = &v
	return s
}

// A schedule.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The schedule's daily.
	Daily *DailySchedule `locationName:"daily" type:"structure"`

	// The schedule's monthly.
	Monthly *MonthlySchedule `locationName:"monthly" type:"structure"`

	// The schedule's one time.
	OneTime *OneTimeSchedule `locationName:"oneTime" type:"structure"`

	// The schedule's weekly.
	Weekly *WeeklySchedule `locationName:"weekly" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Schedule"}
	if s.Daily != nil {
		if err := s.Daily.Validate(); err != nil {
			invalidParams.AddNested("Daily", err.(request.ErrInvalidParams))
		}
	}
	if s.Monthly != nil {
		if err := s.Monthly.Validate(); err != nil {
			invalidParams.AddNested("Monthly", err.(request.ErrInvalidParams))
		}
	}
	if s.Weekly != nil {
		if err := s.Weekly.Validate(); err != nil {
			invalidParams.AddNested("Weekly", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDaily sets the Daily field's value.
func (s *Schedule) SetDaily(v *DailySchedule) *Schedule {
	s.Daily = v
	return s
}

// SetMonthly sets the Monthly field's value.
func (s *Schedule) SetMonthly(v *MonthlySchedule) *Schedule {
	s.Monthly = v
	return s
}

// SetOneTime sets the OneTime field's value.
func (s *Schedule) SetOneTime(v *OneTimeSchedule) *Schedule {
	s.OneTime = v
	return s
}

// SetWeekly sets the Weekly field's value.
func (s *Schedule) SetWeekly(v *WeeklySchedule) *Schedule {
	s.Weekly = v
	return s
}

// Details on the criteria used to define the filter for a vulnerability search.
type SearchVulnerabilitiesFilterCriteria struct {
	_ struct{} `type:"structure"`

	// The IDs for specific vulnerabilities.
	//
	// VulnerabilityIds is a required field
	VulnerabilityIds []*string `locationName:"vulnerabilityIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchVulnerabilitiesFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchVulnerabilitiesFilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchVulnerabilitiesFilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchVulnerabilitiesFilterCriteria"}
	if s.VulnerabilityIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VulnerabilityIds"))
	}
	if s.VulnerabilityIds != nil && len(s.VulnerabilityIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VulnerabilityIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVulnerabilityIds sets the VulnerabilityIds field's value.
func (s *SearchVulnerabilitiesFilterCriteria) SetVulnerabilityIds(v []*string) *SearchVulnerabilitiesFilterCriteria {
	s.VulnerabilityIds = v
	return s
}

type SearchVulnerabilitiesInput struct {
	_ struct{} `type:"structure"`

	// The criteria used to filter the results of a vulnerability search.
	//
	// FilterCriteria is a required field
	FilterCriteria *SearchVulnerabilitiesFilterCriteria `locationName:"filterCriteria" type:"structure" required:"true"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchVulnerabilitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchVulnerabilitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchVulnerabilitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchVulnerabilitiesInput"}
	if s.FilterCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterCriteria"))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *SearchVulnerabilitiesInput) SetFilterCriteria(v *SearchVulnerabilitiesFilterCriteria) *SearchVulnerabilitiesInput {
	s.FilterCriteria = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchVulnerabilitiesInput) SetNextToken(v string) *SearchVulnerabilitiesInput {
	s.NextToken = &v
	return s
}

type SearchVulnerabilitiesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details about the listed vulnerability.
	//
	// Vulnerabilities is a required field
	Vulnerabilities []*Vulnerability `locationName:"vulnerabilities" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchVulnerabilitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchVulnerabilitiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchVulnerabilitiesOutput) SetNextToken(v string) *SearchVulnerabilitiesOutput {
	s.NextToken = &v
	return s
}

// SetVulnerabilities sets the Vulnerabilities field's value.
func (s *SearchVulnerabilitiesOutput) SetVulnerabilities(v []*Vulnerability) *SearchVulnerabilitiesOutput {
	s.Vulnerabilities = v
	return s
}

type SendCisSessionHealthInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the scan job.
	//
	// ScanJobId is a required field
	ScanJobId *string `locationName:"scanJobId" type:"string" required:"true"`

	// The unique token that identifies the CIS session.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendCisSessionHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendCisSessionHealthInput"}
	if s.ScanJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanJobId"))
	}
	if s.SessionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanJobId sets the ScanJobId field's value.
func (s *SendCisSessionHealthInput) SetScanJobId(v string) *SendCisSessionHealthInput {
	s.ScanJobId = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *SendCisSessionHealthInput) SetSessionToken(v string) *SendCisSessionHealthInput {
	s.SessionToken = &v
	return s
}

type SendCisSessionHealthOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionHealthOutput) GoString() string {
	return s.String()
}

type SendCisSessionTelemetryInput struct {
	_ struct{} `type:"structure"`

	// The CIS session telemetry messages.
	//
	// Messages is a required field
	Messages []*CisSessionMessage `locationName:"messages" min:"1" type:"list" required:"true"`

	// A unique identifier for the scan job.
	//
	// ScanJobId is a required field
	ScanJobId *string `locationName:"scanJobId" type:"string" required:"true"`

	// The unique token that identifies the CIS session.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionTelemetryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionTelemetryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendCisSessionTelemetryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendCisSessionTelemetryInput"}
	if s.Messages == nil {
		invalidParams.Add(request.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Messages", 1))
	}
	if s.ScanJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanJobId"))
	}
	if s.SessionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionToken"))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessages sets the Messages field's value.
func (s *SendCisSessionTelemetryInput) SetMessages(v []*CisSessionMessage) *SendCisSessionTelemetryInput {
	s.Messages = v
	return s
}

// SetScanJobId sets the ScanJobId field's value.
func (s *SendCisSessionTelemetryInput) SetScanJobId(v string) *SendCisSessionTelemetryInput {
	s.ScanJobId = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *SendCisSessionTelemetryInput) SetSessionToken(v string) *SendCisSessionTelemetryInput {
	s.SessionToken = &v
	return s
}

type SendCisSessionTelemetryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionTelemetryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCisSessionTelemetryOutput) GoString() string {
	return s.String()
}

// You have exceeded your service quota. To perform the requested action, remove
// some of the relevant resources, or use Service Quotas to request a service
// quota increase.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that exceeds a service quota.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains the counts of aggregated finding per severity.
type SeverityCounts struct {
	_ struct{} `type:"structure"`

	// The total count of findings from all severities.
	All *int64 `locationName:"all" type:"long"`

	// The total count of critical severity findings.
	Critical *int64 `locationName:"critical" type:"long"`

	// The total count of high severity findings.
	High *int64 `locationName:"high" type:"long"`

	// The total count of medium severity findings.
	Medium *int64 `locationName:"medium" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SeverityCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SeverityCounts) GoString() string {
	return s.String()
}

// SetAll sets the All field's value.
func (s *SeverityCounts) SetAll(v int64) *SeverityCounts {
	s.All = &v
	return s
}

// SetCritical sets the Critical field's value.
func (s *SeverityCounts) SetCritical(v int64) *SeverityCounts {
	s.Critical = &v
	return s
}

// SetHigh sets the High field's value.
func (s *SeverityCounts) SetHigh(v int64) *SeverityCounts {
	s.High = &v
	return s
}

// SetMedium sets the Medium field's value.
func (s *SeverityCounts) SetMedium(v int64) *SeverityCounts {
	s.Medium = &v
	return s
}

// Details about the criteria used to sort finding results.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// The finding detail field by which results are sorted.
	//
	// Field is a required field
	Field *string `locationName:"field" type:"string" required:"true" enum:"SortField"`

	// The order by which findings are sorted.
	//
	// SortOrder is a required field
	SortOrder *string `locationName:"sortOrder" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SortCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SortCriteria"}
	if s.Field == nil {
		invalidParams.Add(request.NewErrParamRequired("Field"))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetField sets the Field field's value.
func (s *SortCriteria) SetField(v string) *SortCriteria {
	s.Field = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortCriteria) SetSortOrder(v string) *SortCriteria {
	s.SortOrder = &v
	return s
}

type StartCisSessionInput struct {
	_ struct{} `type:"structure"`

	// The start CIS session message.
	//
	// Message is a required field
	Message *StartCisSessionMessage `locationName:"message" type:"structure" required:"true"`

	// A unique identifier for the scan job.
	//
	// ScanJobId is a required field
	ScanJobId *string `locationName:"scanJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCisSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCisSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCisSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCisSessionInput"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.ScanJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanJobId"))
	}
	if s.Message != nil {
		if err := s.Message.Validate(); err != nil {
			invalidParams.AddNested("Message", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *StartCisSessionInput) SetMessage(v *StartCisSessionMessage) *StartCisSessionInput {
	s.Message = v
	return s
}

// SetScanJobId sets the ScanJobId field's value.
func (s *StartCisSessionInput) SetScanJobId(v string) *StartCisSessionInput {
	s.ScanJobId = &v
	return s
}

// The start CIS session message.
type StartCisSessionMessage struct {
	_ struct{} `type:"structure"`

	// The unique token that identifies the CIS session.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCisSessionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCisSessionMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCisSessionMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCisSessionMessage"}
	if s.SessionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionToken sets the SessionToken field's value.
func (s *StartCisSessionMessage) SetSessionToken(v string) *StartCisSessionMessage {
	s.SessionToken = &v
	return s
}

type StartCisSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCisSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCisSessionOutput) GoString() string {
	return s.String()
}

// An object that described the state of Amazon Inspector scans for an account.
type State struct {
	_ struct{} `type:"structure"`

	// The error code explaining why the account failed to enable Amazon Inspector.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"ErrorCode"`

	// The error message received when the account failed to enable Amazon Inspector.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string" required:"true"`

	// The status of Amazon Inspector for the account.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s State) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s State) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *State) SetErrorCode(v string) *State {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *State) SetErrorMessage(v string) *State {
	s.ErrorMessage = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *State) SetStatus(v string) *State {
	s.Status = &v
	return s
}

// The status counts.
type StatusCounts struct {
	_ struct{} `type:"structure"`

	// The number of checks that failed.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The number of checks that passed.
	Passed *int64 `locationName:"passed" type:"integer"`

	// The number of checks that were skipped.
	Skipped *int64 `locationName:"skipped" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatusCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatusCounts) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *StatusCounts) SetFailed(v int64) *StatusCounts {
	s.Failed = &v
	return s
}

// SetPassed sets the Passed field's value.
func (s *StatusCounts) SetPassed(v int64) *StatusCounts {
	s.Passed = &v
	return s
}

// SetSkipped sets the Skipped field's value.
func (s *StatusCounts) SetSkipped(v int64) *StatusCounts {
	s.Skipped = &v
	return s
}

// Details about the step associated with a finding.
type Step struct {
	_ struct{} `type:"structure"`

	// The component ID.
	//
	// ComponentId is a required field
	ComponentId *string `locationName:"componentId" type:"string" required:"true"`

	// The component type.
	//
	// ComponentType is a required field
	ComponentType *string `locationName:"componentType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Step) GoString() string {
	return s.String()
}

// SetComponentId sets the ComponentId field's value.
func (s *Step) SetComponentId(v string) *Step {
	s.ComponentId = &v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *Step) SetComponentType(v string) *Step {
	s.ComponentType = &v
	return s
}

// The stop CIS message progress.
type StopCisMessageProgress struct {
	_ struct{} `type:"structure"`

	// The progress' error checks.
	ErrorChecks *int64 `locationName:"errorChecks" type:"integer"`

	// The progress' failed checks.
	FailedChecks *int64 `locationName:"failedChecks" type:"integer"`

	// The progress' informational checks.
	InformationalChecks *int64 `locationName:"informationalChecks" type:"integer"`

	// The progress' not applicable checks.
	NotApplicableChecks *int64 `locationName:"notApplicableChecks" type:"integer"`

	// The progress' not evaluated checks.
	NotEvaluatedChecks *int64 `locationName:"notEvaluatedChecks" type:"integer"`

	// The progress' successful checks.
	SuccessfulChecks *int64 `locationName:"successfulChecks" type:"integer"`

	// The progress' total checks.
	TotalChecks *int64 `locationName:"totalChecks" type:"integer"`

	// The progress' unknown checks.
	UnknownChecks *int64 `locationName:"unknownChecks" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisMessageProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisMessageProgress) GoString() string {
	return s.String()
}

// SetErrorChecks sets the ErrorChecks field's value.
func (s *StopCisMessageProgress) SetErrorChecks(v int64) *StopCisMessageProgress {
	s.ErrorChecks = &v
	return s
}

// SetFailedChecks sets the FailedChecks field's value.
func (s *StopCisMessageProgress) SetFailedChecks(v int64) *StopCisMessageProgress {
	s.FailedChecks = &v
	return s
}

// SetInformationalChecks sets the InformationalChecks field's value.
func (s *StopCisMessageProgress) SetInformationalChecks(v int64) *StopCisMessageProgress {
	s.InformationalChecks = &v
	return s
}

// SetNotApplicableChecks sets the NotApplicableChecks field's value.
func (s *StopCisMessageProgress) SetNotApplicableChecks(v int64) *StopCisMessageProgress {
	s.NotApplicableChecks = &v
	return s
}

// SetNotEvaluatedChecks sets the NotEvaluatedChecks field's value.
func (s *StopCisMessageProgress) SetNotEvaluatedChecks(v int64) *StopCisMessageProgress {
	s.NotEvaluatedChecks = &v
	return s
}

// SetSuccessfulChecks sets the SuccessfulChecks field's value.
func (s *StopCisMessageProgress) SetSuccessfulChecks(v int64) *StopCisMessageProgress {
	s.SuccessfulChecks = &v
	return s
}

// SetTotalChecks sets the TotalChecks field's value.
func (s *StopCisMessageProgress) SetTotalChecks(v int64) *StopCisMessageProgress {
	s.TotalChecks = &v
	return s
}

// SetUnknownChecks sets the UnknownChecks field's value.
func (s *StopCisMessageProgress) SetUnknownChecks(v int64) *StopCisMessageProgress {
	s.UnknownChecks = &v
	return s
}

type StopCisSessionInput struct {
	_ struct{} `type:"structure"`

	// The stop CIS session message.
	//
	// Message is a required field
	Message *StopCisSessionMessage `locationName:"message" type:"structure" required:"true"`

	// A unique identifier for the scan job.
	//
	// ScanJobId is a required field
	ScanJobId *string `locationName:"scanJobId" type:"string" required:"true"`

	// The unique token that identifies the CIS session.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCisSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCisSessionInput"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.ScanJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanJobId"))
	}
	if s.SessionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionToken"))
	}
	if s.Message != nil {
		if err := s.Message.Validate(); err != nil {
			invalidParams.AddNested("Message", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *StopCisSessionInput) SetMessage(v *StopCisSessionMessage) *StopCisSessionInput {
	s.Message = v
	return s
}

// SetScanJobId sets the ScanJobId field's value.
func (s *StopCisSessionInput) SetScanJobId(v string) *StopCisSessionInput {
	s.ScanJobId = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *StopCisSessionInput) SetSessionToken(v string) *StopCisSessionInput {
	s.SessionToken = &v
	return s
}

// The stop CIS session message.
type StopCisSessionMessage struct {
	_ struct{} `type:"structure"`

	// The message benchmark profile.
	BenchmarkProfile *string `locationName:"benchmarkProfile" type:"string"`

	// The message benchmark version.
	BenchmarkVersion *string `locationName:"benchmarkVersion" type:"string"`

	// The message compute platform.
	ComputePlatform *ComputePlatform `locationName:"computePlatform" type:"structure"`

	// The progress of the message.
	//
	// Progress is a required field
	Progress *StopCisMessageProgress `locationName:"progress" type:"structure" required:"true"`

	// The reason for the message.
	Reason *string `locationName:"reason" type:"string"`

	// The status of the message.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StopCisSessionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisSessionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisSessionMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCisSessionMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCisSessionMessage"}
	if s.Progress == nil {
		invalidParams.Add(request.NewErrParamRequired("Progress"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBenchmarkProfile sets the BenchmarkProfile field's value.
func (s *StopCisSessionMessage) SetBenchmarkProfile(v string) *StopCisSessionMessage {
	s.BenchmarkProfile = &v
	return s
}

// SetBenchmarkVersion sets the BenchmarkVersion field's value.
func (s *StopCisSessionMessage) SetBenchmarkVersion(v string) *StopCisSessionMessage {
	s.BenchmarkVersion = &v
	return s
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *StopCisSessionMessage) SetComputePlatform(v *ComputePlatform) *StopCisSessionMessage {
	s.ComputePlatform = v
	return s
}

// SetProgress sets the Progress field's value.
func (s *StopCisSessionMessage) SetProgress(v *StopCisMessageProgress) *StopCisSessionMessage {
	s.Progress = v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopCisSessionMessage) SetReason(v string) *StopCisSessionMessage {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopCisSessionMessage) SetStatus(v string) *StopCisSessionMessage {
	s.Status = &v
	return s
}

type StopCisSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCisSessionOutput) GoString() string {
	return s.String()
}

// An object that describes the details of a string filter.
type StringFilter struct {
	_ struct{} `type:"structure"`

	// The operator to use when comparing values in the filter.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"StringComparison"`

	// The value to filter on.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StringFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *StringFilter) SetComparison(v string) *StringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *StringFilter) SetValue(v string) *StringFilter {
	s.Value = &v
	return s
}

// A suggested fix for a vulnerability in your Lambda function code.
type SuggestedFix struct {
	_ struct{} `type:"structure"`

	// The fix's code.
	Code *string `locationName:"code" min:"1" type:"string"`

	// The fix's description.
	Description *string `locationName:"description" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestedFix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestedFix) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *SuggestedFix) SetCode(v string) *SuggestedFix {
	s.Code = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SuggestedFix) SetDescription(v string) *SuggestedFix {
	s.Description = &v
	return s
}

// The tag filter.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag filter comparison value.
	//
	// Comparison is a required field
	Comparison *string `locationName:"comparison" type:"string" required:"true" enum:"TagComparison"`

	// The tag filter key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Comparison == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparison"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparison sets the Comparison field's value.
func (s *TagFilter) SetComparison(v string) *TagFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TagFilter) SetKey(v string) *TagFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagFilter) SetValue(v string) *TagFilter {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to apply a tag to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags to be added to a resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The limit on the number of requests per second was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The time.
type Time struct {
	_ struct{} `type:"structure"`

	// The time of day in 24-hour format (00:00).
	//
	// TimeOfDay is a required field
	TimeOfDay *string `locationName:"timeOfDay" type:"string" required:"true"`

	// The timezone.
	//
	// Timezone is a required field
	Timezone *string `locationName:"timezone" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Time) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Time) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Time) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Time"}
	if s.TimeOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeOfDay"))
	}
	if s.Timezone == nil {
		invalidParams.Add(request.NewErrParamRequired("Timezone"))
	}
	if s.Timezone != nil && len(*s.Timezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimeOfDay sets the TimeOfDay field's value.
func (s *Time) SetTimeOfDay(v string) *Time {
	s.TimeOfDay = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Time) SetTimezone(v string) *Time {
	s.Timezone = &v
	return s
}

// The details that define an aggregation based on finding title.
type TitleAggregation struct {
	_ struct{} `type:"structure"`

	// The type of finding to aggregate on.
	FindingType *string `locationName:"findingType" type:"string" enum:"AggregationFindingType"`

	// The resource type to aggregate on.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"AggregationResourceType"`

	// The value to sort results by.
	SortBy *string `locationName:"sortBy" type:"string" enum:"TitleSortBy"`

	// The order to sort results by.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`

	// The finding titles to aggregate on.
	Titles []*StringFilter `locationName:"titles" min:"1" type:"list"`

	// The vulnerability IDs of the findings.
	VulnerabilityIds []*StringFilter `locationName:"vulnerabilityIds" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TitleAggregation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TitleAggregation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TitleAggregation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TitleAggregation"}
	if s.Titles != nil && len(s.Titles) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Titles", 1))
	}
	if s.VulnerabilityIds != nil && len(s.VulnerabilityIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VulnerabilityIds", 1))
	}
	if s.Titles != nil {
		for i, v := range s.Titles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Titles", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VulnerabilityIds != nil {
		for i, v := range s.VulnerabilityIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VulnerabilityIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingType sets the FindingType field's value.
func (s *TitleAggregation) SetFindingType(v string) *TitleAggregation {
	s.FindingType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TitleAggregation) SetResourceType(v string) *TitleAggregation {
	s.ResourceType = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *TitleAggregation) SetSortBy(v string) *TitleAggregation {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *TitleAggregation) SetSortOrder(v string) *TitleAggregation {
	s.SortOrder = &v
	return s
}

// SetTitles sets the Titles field's value.
func (s *TitleAggregation) SetTitles(v []*StringFilter) *TitleAggregation {
	s.Titles = v
	return s
}

// SetVulnerabilityIds sets the VulnerabilityIds field's value.
func (s *TitleAggregation) SetVulnerabilityIds(v []*StringFilter) *TitleAggregation {
	s.VulnerabilityIds = v
	return s
}

// A response that contains details on the results of a finding aggregation
// by title.
type TitleAggregationResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account associated with the findings.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// An object that represent the count of matched findings per severity.
	SeverityCounts *SeverityCounts `locationName:"severityCounts" type:"structure"`

	// The title that the findings were aggregated on.
	//
	// Title is a required field
	Title *string `locationName:"title" min:"1" type:"string" required:"true"`

	// The vulnerability ID of the finding.
	VulnerabilityId *string `locationName:"vulnerabilityId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TitleAggregationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TitleAggregationResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *TitleAggregationResponse) SetAccountId(v string) *TitleAggregationResponse {
	s.AccountId = &v
	return s
}

// SetSeverityCounts sets the SeverityCounts field's value.
func (s *TitleAggregationResponse) SetSeverityCounts(v *SeverityCounts) *TitleAggregationResponse {
	s.SeverityCounts = v
	return s
}

// SetTitle sets the Title field's value.
func (s *TitleAggregationResponse) SetTitle(v string) *TitleAggregationResponse {
	s.Title = &v
	return s
}

// SetVulnerabilityId sets the VulnerabilityId field's value.
func (s *TitleAggregationResponse) SetVulnerabilityId(v string) *TitleAggregationResponse {
	s.VulnerabilityId = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for the resource to remove tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCisScanConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The CIS scan configuration ARN.
	//
	// ScanConfigurationArn is a required field
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string" required:"true"`

	// The scan name for the CIS scan configuration.
	ScanName *string `locationName:"scanName" min:"1" type:"string"`

	// The schedule for the CIS scan configuration.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The security level for the CIS scan configuration. Security level refers
	// to the Benchmark levels that CIS assigns to a profile.
	SecurityLevel *string `locationName:"securityLevel" type:"string" enum:"CisSecurityLevel"`

	// The targets for the CIS scan configuration.
	Targets *UpdateCisTargets `locationName:"targets" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCisScanConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCisScanConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCisScanConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCisScanConfigurationInput"}
	if s.ScanConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanConfigurationArn"))
	}
	if s.ScanName != nil && len(*s.ScanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanName", 1))
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}
	if s.Targets != nil {
		if err := s.Targets.Validate(); err != nil {
			invalidParams.AddNested("Targets", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *UpdateCisScanConfigurationInput) SetScanConfigurationArn(v string) *UpdateCisScanConfigurationInput {
	s.ScanConfigurationArn = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *UpdateCisScanConfigurationInput) SetScanName(v string) *UpdateCisScanConfigurationInput {
	s.ScanName = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateCisScanConfigurationInput) SetSchedule(v *Schedule) *UpdateCisScanConfigurationInput {
	s.Schedule = v
	return s
}

// SetSecurityLevel sets the SecurityLevel field's value.
func (s *UpdateCisScanConfigurationInput) SetSecurityLevel(v string) *UpdateCisScanConfigurationInput {
	s.SecurityLevel = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateCisScanConfigurationInput) SetTargets(v *UpdateCisTargets) *UpdateCisScanConfigurationInput {
	s.Targets = v
	return s
}

type UpdateCisScanConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The CIS scan configuration ARN.
	//
	// ScanConfigurationArn is a required field
	ScanConfigurationArn *string `locationName:"scanConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCisScanConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCisScanConfigurationOutput) GoString() string {
	return s.String()
}

// SetScanConfigurationArn sets the ScanConfigurationArn field's value.
func (s *UpdateCisScanConfigurationOutput) SetScanConfigurationArn(v string) *UpdateCisScanConfigurationOutput {
	s.ScanConfigurationArn = &v
	return s
}

// Updates CIS targets.
type UpdateCisTargets struct {
	_ struct{} `type:"structure"`

	// The target account ids.
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list"`

	// The target resource tags.
	TargetResourceTags map[string][]*string `locationName:"targetResourceTags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCisTargets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCisTargets) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCisTargets) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCisTargets"}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.TargetResourceTags != nil && len(s.TargetResourceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResourceTags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *UpdateCisTargets) SetAccountIds(v []*string) *UpdateCisTargets {
	s.AccountIds = v
	return s
}

// SetTargetResourceTags sets the TargetResourceTags field's value.
func (s *UpdateCisTargets) SetTargetResourceTags(v map[string][]*string) *UpdateCisTargets {
	s.TargetResourceTags = v
	return s
}

type UpdateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specifies how the Amazon EC2 automated scan will be updated for your environment.
	Ec2Configuration *Ec2Configuration `locationName:"ec2Configuration" type:"structure"`

	// Specifies how the ECR automated re-scan will be updated for your environment.
	EcrConfiguration *EcrConfiguration `locationName:"ecrConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationInput"}
	if s.Ec2Configuration != nil {
		if err := s.Ec2Configuration.Validate(); err != nil {
			invalidParams.AddNested("Ec2Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.EcrConfiguration != nil {
		if err := s.EcrConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EcrConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2Configuration sets the Ec2Configuration field's value.
func (s *UpdateConfigurationInput) SetEc2Configuration(v *Ec2Configuration) *UpdateConfigurationInput {
	s.Ec2Configuration = v
	return s
}

// SetEcrConfiguration sets the EcrConfiguration field's value.
func (s *UpdateConfigurationInput) SetEcrConfiguration(v *EcrConfiguration) *UpdateConfigurationInput {
	s.EcrConfiguration = v
	return s
}

type UpdateConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateEc2DeepInspectionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specify TRUE to activate Amazon Inspector deep inspection in your account,
	// or FALSE to deactivate. Member accounts in an organization cannot deactivate
	// deep inspection, instead the delegated administrator for the organization
	// can deactivate a member account using BatchUpdateMemberEc2DeepInspectionStatus
	// (https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchUpdateMemberEc2DeepInspectionStatus.html).
	ActivateDeepInspection *bool `locationName:"activateDeepInspection" type:"boolean"`

	// The Amazon Inspector deep inspection custom paths you are adding for your
	// account.
	PackagePaths []*string `locationName:"packagePaths" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEc2DeepInspectionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEc2DeepInspectionConfigurationInput) GoString() string {
	return s.String()
}

// SetActivateDeepInspection sets the ActivateDeepInspection field's value.
func (s *UpdateEc2DeepInspectionConfigurationInput) SetActivateDeepInspection(v bool) *UpdateEc2DeepInspectionConfigurationInput {
	s.ActivateDeepInspection = &v
	return s
}

// SetPackagePaths sets the PackagePaths field's value.
func (s *UpdateEc2DeepInspectionConfigurationInput) SetPackagePaths(v []*string) *UpdateEc2DeepInspectionConfigurationInput {
	s.PackagePaths = v
	return s
}

type UpdateEc2DeepInspectionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An error message explaining why new Amazon Inspector deep inspection custom
	// paths could not be added.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	// The current Amazon Inspector deep inspection custom paths for the organization.
	OrgPackagePaths []*string `locationName:"orgPackagePaths" type:"list"`

	// The current Amazon Inspector deep inspection custom paths for your account.
	PackagePaths []*string `locationName:"packagePaths" type:"list"`

	// The status of Amazon Inspector deep inspection in your account.
	Status *string `locationName:"status" type:"string" enum:"Ec2DeepInspectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEc2DeepInspectionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEc2DeepInspectionConfigurationOutput) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UpdateEc2DeepInspectionConfigurationOutput) SetErrorMessage(v string) *UpdateEc2DeepInspectionConfigurationOutput {
	s.ErrorMessage = &v
	return s
}

// SetOrgPackagePaths sets the OrgPackagePaths field's value.
func (s *UpdateEc2DeepInspectionConfigurationOutput) SetOrgPackagePaths(v []*string) *UpdateEc2DeepInspectionConfigurationOutput {
	s.OrgPackagePaths = v
	return s
}

// SetPackagePaths sets the PackagePaths field's value.
func (s *UpdateEc2DeepInspectionConfigurationOutput) SetPackagePaths(v []*string) *UpdateEc2DeepInspectionConfigurationOutput {
	s.PackagePaths = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateEc2DeepInspectionConfigurationOutput) SetStatus(v string) *UpdateEc2DeepInspectionConfigurationOutput {
	s.Status = &v
	return s
}

type UpdateEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// A KMS key ID for the encryption key.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" type:"string" required:"true"`

	// The resource type for the encryption key.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The scan type for the encryption key.
	//
	// ScanType is a required field
	ScanType *string `locationName:"scanType" type:"string" required:"true" enum:"ScanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEncryptionKeyInput"}
	if s.KmsKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ScanType == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateEncryptionKeyInput) SetKmsKeyId(v string) *UpdateEncryptionKeyInput {
	s.KmsKeyId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UpdateEncryptionKeyInput) SetResourceType(v string) *UpdateEncryptionKeyInput {
	s.ResourceType = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *UpdateEncryptionKeyInput) SetScanType(v string) *UpdateEncryptionKeyInput {
	s.ScanType = &v
	return s
}

type UpdateEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEncryptionKeyOutput) GoString() string {
	return s.String()
}

type UpdateFilterInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	Action *string `locationName:"action" type:"string" enum:"FilterAction"`

	// A description of the filter.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Number (ARN) of the filter to update.
	//
	// FilterArn is a required field
	FilterArn *string `locationName:"filterArn" min:"1" type:"string" required:"true"`

	// Defines the criteria to be update in the filter.
	FilterCriteria *FilterCriteria `locationName:"filterCriteria" type:"structure"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The reason the filter was updated.
	Reason *string `locationName:"reason" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFilterInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FilterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterArn"))
	}
	if s.FilterArn != nil && len(*s.FilterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterArn", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateFilterInput) SetAction(v string) *UpdateFilterInput {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFilterInput) SetDescription(v string) *UpdateFilterInput {
	s.Description = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *UpdateFilterInput) SetFilterArn(v string) *UpdateFilterInput {
	s.FilterArn = &v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *UpdateFilterInput) SetFilterCriteria(v *FilterCriteria) *UpdateFilterInput {
	s.FilterCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFilterInput) SetName(v string) *UpdateFilterInput {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UpdateFilterInput) SetReason(v string) *UpdateFilterInput {
	s.Reason = &v
	return s
}

type UpdateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the successfully updated filter.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFilterOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateFilterOutput) SetArn(v string) *UpdateFilterOutput {
	s.Arn = &v
	return s
}

type UpdateOrgEc2DeepInspectionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Inspector deep inspection custom paths you are adding for your
	// organization.
	//
	// OrgPackagePaths is a required field
	OrgPackagePaths []*string `locationName:"orgPackagePaths" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrgEc2DeepInspectionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrgEc2DeepInspectionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrgEc2DeepInspectionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrgEc2DeepInspectionConfigurationInput"}
	if s.OrgPackagePaths == nil {
		invalidParams.Add(request.NewErrParamRequired("OrgPackagePaths"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrgPackagePaths sets the OrgPackagePaths field's value.
func (s *UpdateOrgEc2DeepInspectionConfigurationInput) SetOrgPackagePaths(v []*string) *UpdateOrgEc2DeepInspectionConfigurationInput {
	s.OrgPackagePaths = v
	return s
}

type UpdateOrgEc2DeepInspectionConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrgEc2DeepInspectionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrgEc2DeepInspectionConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Defines which scan types are enabled automatically for new members of your
	// Amazon Inspector organization.
	//
	// AutoEnable is a required field
	AutoEnable *AutoEnable `locationName:"autoEnable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationConfigurationInput"}
	if s.AutoEnable == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoEnable"))
	}
	if s.AutoEnable != nil {
		if err := s.AutoEnable.Validate(); err != nil {
			invalidParams.AddNested("AutoEnable", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *UpdateOrganizationConfigurationInput) SetAutoEnable(v *AutoEnable) *UpdateOrganizationConfigurationInput {
	s.AutoEnable = v
	return s
}

type UpdateOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The updated status of scan types automatically enabled for new members of
	// your Amazon Inspector organization.
	//
	// AutoEnable is a required field
	AutoEnable *AutoEnable `locationName:"autoEnable" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *UpdateOrganizationConfigurationOutput) SetAutoEnable(v *AutoEnable) *UpdateOrganizationConfigurationOutput {
	s.AutoEnable = v
	return s
}

// Contains usage information about the cost of Amazon Inspector operation.
type Usage struct {
	_ struct{} `type:"structure"`

	// The currency type used when calculating usage data.
	Currency *string `locationName:"currency" type:"string" enum:"Currency"`

	// The estimated monthly cost of Amazon Inspector.
	EstimatedMonthlyCost *float64 `locationName:"estimatedMonthlyCost" type:"double"`

	// The total of usage.
	Total *float64 `locationName:"total" type:"double"`

	// The type scan.
	Type *string `locationName:"type" type:"string" enum:"UsageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Usage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Usage) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *Usage) SetCurrency(v string) *Usage {
	s.Currency = &v
	return s
}

// SetEstimatedMonthlyCost sets the EstimatedMonthlyCost field's value.
func (s *Usage) SetEstimatedMonthlyCost(v float64) *Usage {
	s.EstimatedMonthlyCost = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *Usage) SetTotal(v float64) *Usage {
	s.Total = &v
	return s
}

// SetType sets the Type field's value.
func (s *Usage) SetType(v string) *Usage {
	s.Type = &v
	return s
}

// The total of usage for an account ID.
type UsageTotal struct {
	_ struct{} `type:"structure"`

	// The account ID of the account that usage data was retrieved for.
	AccountId *string `locationName:"accountId" type:"string"`

	// An object representing the total usage for an account.
	Usage []*Usage `locationName:"usage" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageTotal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageTotal) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UsageTotal) SetAccountId(v string) *UsageTotal {
	s.AccountId = &v
	return s
}

// SetUsage sets the Usage field's value.
func (s *UsageTotal) SetUsage(v []*Usage) *UsageTotal {
	s.Usage = v
	return s
}

// The request has failed validation due to missing required fields or having
// invalid inputs.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that failed validation.
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the validation failure.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that describes a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The validation exception message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the validation exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Contains details about a specific vulnerability Amazon Inspector can detect.
type Vulnerability struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the Amazon Web Services Threat
	// Intel Group (ATIG) details for the vulnerability.
	AtigData *AtigData `locationName:"atigData" type:"structure"`

	// An object that contains the Cybersecurity and Infrastructure Security Agency
	// (CISA) details for the vulnerability.
	CisaData *CisaData `locationName:"cisaData" type:"structure"`

	// An object that contains the Common Vulnerability Scoring System (CVSS) Version
	// 2 details for the vulnerability.
	Cvss2 *Cvss2 `locationName:"cvss2" type:"structure"`

	// An object that contains the Common Vulnerability Scoring System (CVSS) Version
	// 3 details for the vulnerability.
	Cvss3 *Cvss3 `locationName:"cvss3" type:"structure"`

	// The Common Weakness Enumeration (CWE) associated with the vulnerability.
	Cwes []*string `locationName:"cwes" type:"list"`

	// A description of the vulnerability.
	Description *string `locationName:"description" type:"string"`

	// Platforms that the vulnerability can be detected on.
	DetectionPlatforms []*string `locationName:"detectionPlatforms" type:"list"`

	// An object that contains the Exploit Prediction Scoring System (EPSS) score
	// for a vulnerability.
	Epss *Epss `locationName:"epss" type:"structure"`

	// An object that contains details on when the exploit was observed.
	ExploitObserved *ExploitObserved `locationName:"exploitObserved" type:"structure"`

	// The ID for the specific vulnerability.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Links to various resources with more information on this vulnerability.
	ReferenceUrls []*string `locationName:"referenceUrls" type:"list"`

	// A list of related vulnerabilities.
	RelatedVulnerabilities []*string `locationName:"relatedVulnerabilities" type:"list"`

	// The source of the vulnerability information. Possible results are RHEL, AMAZON_CVE,
	// DEBIAN or NVD.
	Source *string `locationName:"source" type:"string" enum:"VulnerabilitySource"`

	// A link to the official source material for this vulnerability.
	SourceUrl *string `locationName:"sourceUrl" type:"string"`

	// The date and time when the vendor created this vulnerability.
	VendorCreatedAt *time.Time `locationName:"vendorCreatedAt" type:"timestamp"`

	// The severity assigned by the vendor.
	VendorSeverity *string `locationName:"vendorSeverity" min:"1" type:"string"`

	// The date and time when the vendor last updated this vulnerability.
	VendorUpdatedAt *time.Time `locationName:"vendorUpdatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Vulnerability) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Vulnerability) GoString() string {
	return s.String()
}

// SetAtigData sets the AtigData field's value.
func (s *Vulnerability) SetAtigData(v *AtigData) *Vulnerability {
	s.AtigData = v
	return s
}

// SetCisaData sets the CisaData field's value.
func (s *Vulnerability) SetCisaData(v *CisaData) *Vulnerability {
	s.CisaData = v
	return s
}

// SetCvss2 sets the Cvss2 field's value.
func (s *Vulnerability) SetCvss2(v *Cvss2) *Vulnerability {
	s.Cvss2 = v
	return s
}

// SetCvss3 sets the Cvss3 field's value.
func (s *Vulnerability) SetCvss3(v *Cvss3) *Vulnerability {
	s.Cvss3 = v
	return s
}

// SetCwes sets the Cwes field's value.
func (s *Vulnerability) SetCwes(v []*string) *Vulnerability {
	s.Cwes = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Vulnerability) SetDescription(v string) *Vulnerability {
	s.Description = &v
	return s
}

// SetDetectionPlatforms sets the DetectionPlatforms field's value.
func (s *Vulnerability) SetDetectionPlatforms(v []*string) *Vulnerability {
	s.DetectionPlatforms = v
	return s
}

// SetEpss sets the Epss field's value.
func (s *Vulnerability) SetEpss(v *Epss) *Vulnerability {
	s.Epss = v
	return s
}

// SetExploitObserved sets the ExploitObserved field's value.
func (s *Vulnerability) SetExploitObserved(v *ExploitObserved) *Vulnerability {
	s.ExploitObserved = v
	return s
}

// SetId sets the Id field's value.
func (s *Vulnerability) SetId(v string) *Vulnerability {
	s.Id = &v
	return s
}

// SetReferenceUrls sets the ReferenceUrls field's value.
func (s *Vulnerability) SetReferenceUrls(v []*string) *Vulnerability {
	s.ReferenceUrls = v
	return s
}

// SetRelatedVulnerabilities sets the RelatedVulnerabilities field's value.
func (s *Vulnerability) SetRelatedVulnerabilities(v []*string) *Vulnerability {
	s.RelatedVulnerabilities = v
	return s
}

// SetSource sets the Source field's value.
func (s *Vulnerability) SetSource(v string) *Vulnerability {
	s.Source = &v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *Vulnerability) SetSourceUrl(v string) *Vulnerability {
	s.SourceUrl = &v
	return s
}

// SetVendorCreatedAt sets the VendorCreatedAt field's value.
func (s *Vulnerability) SetVendorCreatedAt(v time.Time) *Vulnerability {
	s.VendorCreatedAt = &v
	return s
}

// SetVendorSeverity sets the VendorSeverity field's value.
func (s *Vulnerability) SetVendorSeverity(v string) *Vulnerability {
	s.VendorSeverity = &v
	return s
}

// SetVendorUpdatedAt sets the VendorUpdatedAt field's value.
func (s *Vulnerability) SetVendorUpdatedAt(v time.Time) *Vulnerability {
	s.VendorUpdatedAt = &v
	return s
}

// Information on the vulnerable package identified by a finding.
type VulnerablePackage struct {
	_ struct{} `type:"structure"`

	// The architecture of the vulnerable package.
	Arch *string `locationName:"arch" min:"1" type:"string"`

	// The epoch of the vulnerable package.
	Epoch *int64 `locationName:"epoch" type:"integer"`

	// The file path of the vulnerable package.
	FilePath *string `locationName:"filePath" min:"1" type:"string"`

	// The version of the package that contains the vulnerability fix.
	FixedInVersion *string `locationName:"fixedInVersion" min:"1" type:"string"`

	// The name of the vulnerable package.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The package manager of the vulnerable package.
	PackageManager *string `locationName:"packageManager" type:"string" enum:"PackageManager"`

	// The release of the vulnerable package.
	Release *string `locationName:"release" min:"1" type:"string"`

	// The code to run in your environment to update packages with a fix available.
	Remediation *string `locationName:"remediation" min:"1" type:"string"`

	// The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function
	// affected by a finding.
	SourceLambdaLayerArn *string `locationName:"sourceLambdaLayerArn" type:"string"`

	// The source layer hash of the vulnerable package.
	SourceLayerHash *string `locationName:"sourceLayerHash" min:"71" type:"string"`

	// The version of the vulnerable package.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VulnerablePackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VulnerablePackage) GoString() string {
	return s.String()
}

// SetArch sets the Arch field's value.
func (s *VulnerablePackage) SetArch(v string) *VulnerablePackage {
	s.Arch = &v
	return s
}

// SetEpoch sets the Epoch field's value.
func (s *VulnerablePackage) SetEpoch(v int64) *VulnerablePackage {
	s.Epoch = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *VulnerablePackage) SetFilePath(v string) *VulnerablePackage {
	s.FilePath = &v
	return s
}

// SetFixedInVersion sets the FixedInVersion field's value.
func (s *VulnerablePackage) SetFixedInVersion(v string) *VulnerablePackage {
	s.FixedInVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *VulnerablePackage) SetName(v string) *VulnerablePackage {
	s.Name = &v
	return s
}

// SetPackageManager sets the PackageManager field's value.
func (s *VulnerablePackage) SetPackageManager(v string) *VulnerablePackage {
	s.PackageManager = &v
	return s
}

// SetRelease sets the Release field's value.
func (s *VulnerablePackage) SetRelease(v string) *VulnerablePackage {
	s.Release = &v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *VulnerablePackage) SetRemediation(v string) *VulnerablePackage {
	s.Remediation = &v
	return s
}

// SetSourceLambdaLayerArn sets the SourceLambdaLayerArn field's value.
func (s *VulnerablePackage) SetSourceLambdaLayerArn(v string) *VulnerablePackage {
	s.SourceLambdaLayerArn = &v
	return s
}

// SetSourceLayerHash sets the SourceLayerHash field's value.
func (s *VulnerablePackage) SetSourceLayerHash(v string) *VulnerablePackage {
	s.SourceLayerHash = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VulnerablePackage) SetVersion(v string) *VulnerablePackage {
	s.Version = &v
	return s
}

// A weekly schedule.
type WeeklySchedule struct {
	_ struct{} `type:"structure"`

	// The weekly schedule's days.
	//
	// Days is a required field
	Days []*string `locationName:"days" min:"1" type:"list" required:"true" enum:"Day"`

	// The weekly schedule's start time.
	//
	// StartTime is a required field
	StartTime *Time `locationName:"startTime" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeeklySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WeeklySchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeeklySchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WeeklySchedule"}
	if s.Days == nil {
		invalidParams.Add(request.NewErrParamRequired("Days"))
	}
	if s.Days != nil && len(s.Days) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Days", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StartTime != nil {
		if err := s.StartTime.Validate(); err != nil {
			invalidParams.AddNested("StartTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *WeeklySchedule) SetDays(v []*string) *WeeklySchedule {
	s.Days = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *WeeklySchedule) SetStartTime(v *Time) *WeeklySchedule {
	s.StartTime = v
	return s
}

const (
	// AccountSortByCritical is a AccountSortBy enum value
	AccountSortByCritical = "CRITICAL"

	// AccountSortByHigh is a AccountSortBy enum value
	AccountSortByHigh = "HIGH"

	// AccountSortByAll is a AccountSortBy enum value
	AccountSortByAll = "ALL"
)

// AccountSortBy_Values returns all elements of the AccountSortBy enum
func AccountSortBy_Values() []string {
	return []string{
		AccountSortByCritical,
		AccountSortByHigh,
		AccountSortByAll,
	}
}

const (
	// AggregationFindingTypeNetworkReachability is a AggregationFindingType enum value
	AggregationFindingTypeNetworkReachability = "NETWORK_REACHABILITY"

	// AggregationFindingTypePackageVulnerability is a AggregationFindingType enum value
	AggregationFindingTypePackageVulnerability = "PACKAGE_VULNERABILITY"

	// AggregationFindingTypeCodeVulnerability is a AggregationFindingType enum value
	AggregationFindingTypeCodeVulnerability = "CODE_VULNERABILITY"
)

// AggregationFindingType_Values returns all elements of the AggregationFindingType enum
func AggregationFindingType_Values() []string {
	return []string{
		AggregationFindingTypeNetworkReachability,
		AggregationFindingTypePackageVulnerability,
		AggregationFindingTypeCodeVulnerability,
	}
}

const (
	// AggregationResourceTypeAwsEc2Instance is a AggregationResourceType enum value
	AggregationResourceTypeAwsEc2Instance = "AWS_EC2_INSTANCE"

	// AggregationResourceTypeAwsEcrContainerImage is a AggregationResourceType enum value
	AggregationResourceTypeAwsEcrContainerImage = "AWS_ECR_CONTAINER_IMAGE"

	// AggregationResourceTypeAwsLambdaFunction is a AggregationResourceType enum value
	AggregationResourceTypeAwsLambdaFunction = "AWS_LAMBDA_FUNCTION"
)

// AggregationResourceType_Values returns all elements of the AggregationResourceType enum
func AggregationResourceType_Values() []string {
	return []string{
		AggregationResourceTypeAwsEc2Instance,
		AggregationResourceTypeAwsEcrContainerImage,
		AggregationResourceTypeAwsLambdaFunction,
	}
}

const (
	// AggregationTypeFindingType is a AggregationType enum value
	AggregationTypeFindingType = "FINDING_TYPE"

	// AggregationTypePackage is a AggregationType enum value
	AggregationTypePackage = "PACKAGE"

	// AggregationTypeTitle is a AggregationType enum value
	AggregationTypeTitle = "TITLE"

	// AggregationTypeRepository is a AggregationType enum value
	AggregationTypeRepository = "REPOSITORY"

	// AggregationTypeAmi is a AggregationType enum value
	AggregationTypeAmi = "AMI"

	// AggregationTypeAwsEc2Instance is a AggregationType enum value
	AggregationTypeAwsEc2Instance = "AWS_EC2_INSTANCE"

	// AggregationTypeAwsEcrContainer is a AggregationType enum value
	AggregationTypeAwsEcrContainer = "AWS_ECR_CONTAINER"

	// AggregationTypeImageLayer is a AggregationType enum value
	AggregationTypeImageLayer = "IMAGE_LAYER"

	// AggregationTypeAccount is a AggregationType enum value
	AggregationTypeAccount = "ACCOUNT"

	// AggregationTypeAwsLambdaFunction is a AggregationType enum value
	AggregationTypeAwsLambdaFunction = "AWS_LAMBDA_FUNCTION"

	// AggregationTypeLambdaLayer is a AggregationType enum value
	AggregationTypeLambdaLayer = "LAMBDA_LAYER"
)

// AggregationType_Values returns all elements of the AggregationType enum
func AggregationType_Values() []string {
	return []string{
		AggregationTypeFindingType,
		AggregationTypePackage,
		AggregationTypeTitle,
		AggregationTypeRepository,
		AggregationTypeAmi,
		AggregationTypeAwsEc2Instance,
		AggregationTypeAwsEcrContainer,
		AggregationTypeImageLayer,
		AggregationTypeAccount,
		AggregationTypeAwsLambdaFunction,
		AggregationTypeLambdaLayer,
	}
}

const (
	// AmiSortByCritical is a AmiSortBy enum value
	AmiSortByCritical = "CRITICAL"

	// AmiSortByHigh is a AmiSortBy enum value
	AmiSortByHigh = "HIGH"

	// AmiSortByAll is a AmiSortBy enum value
	AmiSortByAll = "ALL"

	// AmiSortByAffectedInstances is a AmiSortBy enum value
	AmiSortByAffectedInstances = "AFFECTED_INSTANCES"
)

// AmiSortBy_Values returns all elements of the AmiSortBy enum
func AmiSortBy_Values() []string {
	return []string{
		AmiSortByCritical,
		AmiSortByHigh,
		AmiSortByAll,
		AmiSortByAffectedInstances,
	}
}

const (
	// ArchitectureX8664 is a Architecture enum value
	ArchitectureX8664 = "X86_64"

	// ArchitectureArm64 is a Architecture enum value
	ArchitectureArm64 = "ARM64"
)

// Architecture_Values returns all elements of the Architecture enum
func Architecture_Values() []string {
	return []string{
		ArchitectureX8664,
		ArchitectureArm64,
	}
}

const (
	// AwsEcrContainerSortByCritical is a AwsEcrContainerSortBy enum value
	AwsEcrContainerSortByCritical = "CRITICAL"

	// AwsEcrContainerSortByHigh is a AwsEcrContainerSortBy enum value
	AwsEcrContainerSortByHigh = "HIGH"

	// AwsEcrContainerSortByAll is a AwsEcrContainerSortBy enum value
	AwsEcrContainerSortByAll = "ALL"
)

// AwsEcrContainerSortBy_Values returns all elements of the AwsEcrContainerSortBy enum
func AwsEcrContainerSortBy_Values() []string {
	return []string{
		AwsEcrContainerSortByCritical,
		AwsEcrContainerSortByHigh,
		AwsEcrContainerSortByAll,
	}
}

const (
	// CisFindingStatusPassed is a CisFindingStatus enum value
	CisFindingStatusPassed = "PASSED"

	// CisFindingStatusFailed is a CisFindingStatus enum value
	CisFindingStatusFailed = "FAILED"

	// CisFindingStatusSkipped is a CisFindingStatus enum value
	CisFindingStatusSkipped = "SKIPPED"
)

// CisFindingStatus_Values returns all elements of the CisFindingStatus enum
func CisFindingStatus_Values() []string {
	return []string{
		CisFindingStatusPassed,
		CisFindingStatusFailed,
		CisFindingStatusSkipped,
	}
}

const (
	// CisFindingStatusComparisonEquals is a CisFindingStatusComparison enum value
	CisFindingStatusComparisonEquals = "EQUALS"
)

// CisFindingStatusComparison_Values returns all elements of the CisFindingStatusComparison enum
func CisFindingStatusComparison_Values() []string {
	return []string{
		CisFindingStatusComparisonEquals,
	}
}

const (
	// CisReportFormatPdf is a CisReportFormat enum value
	CisReportFormatPdf = "PDF"

	// CisReportFormatCsv is a CisReportFormat enum value
	CisReportFormatCsv = "CSV"
)

// CisReportFormat_Values returns all elements of the CisReportFormat enum
func CisReportFormat_Values() []string {
	return []string{
		CisReportFormatPdf,
		CisReportFormatCsv,
	}
}

const (
	// CisReportStatusSucceeded is a CisReportStatus enum value
	CisReportStatusSucceeded = "SUCCEEDED"

	// CisReportStatusFailed is a CisReportStatus enum value
	CisReportStatusFailed = "FAILED"

	// CisReportStatusInProgress is a CisReportStatus enum value
	CisReportStatusInProgress = "IN_PROGRESS"
)

// CisReportStatus_Values returns all elements of the CisReportStatus enum
func CisReportStatus_Values() []string {
	return []string{
		CisReportStatusSucceeded,
		CisReportStatusFailed,
		CisReportStatusInProgress,
	}
}

const (
	// CisResultStatusPassed is a CisResultStatus enum value
	CisResultStatusPassed = "PASSED"

	// CisResultStatusFailed is a CisResultStatus enum value
	CisResultStatusFailed = "FAILED"

	// CisResultStatusSkipped is a CisResultStatus enum value
	CisResultStatusSkipped = "SKIPPED"
)

// CisResultStatus_Values returns all elements of the CisResultStatus enum
func CisResultStatus_Values() []string {
	return []string{
		CisResultStatusPassed,
		CisResultStatusFailed,
		CisResultStatusSkipped,
	}
}

const (
	// CisResultStatusComparisonEquals is a CisResultStatusComparison enum value
	CisResultStatusComparisonEquals = "EQUALS"
)

// CisResultStatusComparison_Values returns all elements of the CisResultStatusComparison enum
func CisResultStatusComparison_Values() []string {
	return []string{
		CisResultStatusComparisonEquals,
	}
}

const (
	// CisRuleStatusFailed is a CisRuleStatus enum value
	CisRuleStatusFailed = "FAILED"

	// CisRuleStatusPassed is a CisRuleStatus enum value
	CisRuleStatusPassed = "PASSED"

	// CisRuleStatusNotEvaluated is a CisRuleStatus enum value
	CisRuleStatusNotEvaluated = "NOT_EVALUATED"

	// CisRuleStatusInformational is a CisRuleStatus enum value
	CisRuleStatusInformational = "INFORMATIONAL"

	// CisRuleStatusUnknown is a CisRuleStatus enum value
	CisRuleStatusUnknown = "UNKNOWN"

	// CisRuleStatusNotApplicable is a CisRuleStatus enum value
	CisRuleStatusNotApplicable = "NOT_APPLICABLE"

	// CisRuleStatusError is a CisRuleStatus enum value
	CisRuleStatusError = "ERROR"
)

// CisRuleStatus_Values returns all elements of the CisRuleStatus enum
func CisRuleStatus_Values() []string {
	return []string{
		CisRuleStatusFailed,
		CisRuleStatusPassed,
		CisRuleStatusNotEvaluated,
		CisRuleStatusInformational,
		CisRuleStatusUnknown,
		CisRuleStatusNotApplicable,
		CisRuleStatusError,
	}
}

const (
	// CisScanConfigurationsSortByScanName is a CisScanConfigurationsSortBy enum value
	CisScanConfigurationsSortByScanName = "SCAN_NAME"

	// CisScanConfigurationsSortByScanConfigurationArn is a CisScanConfigurationsSortBy enum value
	CisScanConfigurationsSortByScanConfigurationArn = "SCAN_CONFIGURATION_ARN"
)

// CisScanConfigurationsSortBy_Values returns all elements of the CisScanConfigurationsSortBy enum
func CisScanConfigurationsSortBy_Values() []string {
	return []string{
		CisScanConfigurationsSortByScanName,
		CisScanConfigurationsSortByScanConfigurationArn,
	}
}

const (
	// CisScanResultDetailsSortByCheckId is a CisScanResultDetailsSortBy enum value
	CisScanResultDetailsSortByCheckId = "CHECK_ID"

	// CisScanResultDetailsSortByStatus is a CisScanResultDetailsSortBy enum value
	CisScanResultDetailsSortByStatus = "STATUS"
)

// CisScanResultDetailsSortBy_Values returns all elements of the CisScanResultDetailsSortBy enum
func CisScanResultDetailsSortBy_Values() []string {
	return []string{
		CisScanResultDetailsSortByCheckId,
		CisScanResultDetailsSortByStatus,
	}
}

const (
	// CisScanResultsAggregatedByChecksSortByCheckId is a CisScanResultsAggregatedByChecksSortBy enum value
	CisScanResultsAggregatedByChecksSortByCheckId = "CHECK_ID"

	// CisScanResultsAggregatedByChecksSortByTitle is a CisScanResultsAggregatedByChecksSortBy enum value
	CisScanResultsAggregatedByChecksSortByTitle = "TITLE"

	// CisScanResultsAggregatedByChecksSortByPlatform is a CisScanResultsAggregatedByChecksSortBy enum value
	CisScanResultsAggregatedByChecksSortByPlatform = "PLATFORM"

	// CisScanResultsAggregatedByChecksSortByFailedCounts is a CisScanResultsAggregatedByChecksSortBy enum value
	CisScanResultsAggregatedByChecksSortByFailedCounts = "FAILED_COUNTS"

	// CisScanResultsAggregatedByChecksSortBySecurityLevel is a CisScanResultsAggregatedByChecksSortBy enum value
	CisScanResultsAggregatedByChecksSortBySecurityLevel = "SECURITY_LEVEL"
)

// CisScanResultsAggregatedByChecksSortBy_Values returns all elements of the CisScanResultsAggregatedByChecksSortBy enum
func CisScanResultsAggregatedByChecksSortBy_Values() []string {
	return []string{
		CisScanResultsAggregatedByChecksSortByCheckId,
		CisScanResultsAggregatedByChecksSortByTitle,
		CisScanResultsAggregatedByChecksSortByPlatform,
		CisScanResultsAggregatedByChecksSortByFailedCounts,
		CisScanResultsAggregatedByChecksSortBySecurityLevel,
	}
}

const (
	// CisScanResultsAggregatedByTargetResourceSortByResourceId is a CisScanResultsAggregatedByTargetResourceSortBy enum value
	CisScanResultsAggregatedByTargetResourceSortByResourceId = "RESOURCE_ID"

	// CisScanResultsAggregatedByTargetResourceSortByFailedCounts is a CisScanResultsAggregatedByTargetResourceSortBy enum value
	CisScanResultsAggregatedByTargetResourceSortByFailedCounts = "FAILED_COUNTS"

	// CisScanResultsAggregatedByTargetResourceSortByAccountId is a CisScanResultsAggregatedByTargetResourceSortBy enum value
	CisScanResultsAggregatedByTargetResourceSortByAccountId = "ACCOUNT_ID"

	// CisScanResultsAggregatedByTargetResourceSortByPlatform is a CisScanResultsAggregatedByTargetResourceSortBy enum value
	CisScanResultsAggregatedByTargetResourceSortByPlatform = "PLATFORM"

	// CisScanResultsAggregatedByTargetResourceSortByTargetStatus is a CisScanResultsAggregatedByTargetResourceSortBy enum value
	CisScanResultsAggregatedByTargetResourceSortByTargetStatus = "TARGET_STATUS"

	// CisScanResultsAggregatedByTargetResourceSortByTargetStatusReason is a CisScanResultsAggregatedByTargetResourceSortBy enum value
	CisScanResultsAggregatedByTargetResourceSortByTargetStatusReason = "TARGET_STATUS_REASON"
)

// CisScanResultsAggregatedByTargetResourceSortBy_Values returns all elements of the CisScanResultsAggregatedByTargetResourceSortBy enum
func CisScanResultsAggregatedByTargetResourceSortBy_Values() []string {
	return []string{
		CisScanResultsAggregatedByTargetResourceSortByResourceId,
		CisScanResultsAggregatedByTargetResourceSortByFailedCounts,
		CisScanResultsAggregatedByTargetResourceSortByAccountId,
		CisScanResultsAggregatedByTargetResourceSortByPlatform,
		CisScanResultsAggregatedByTargetResourceSortByTargetStatus,
		CisScanResultsAggregatedByTargetResourceSortByTargetStatusReason,
	}
}

const (
	// CisScanStatusFailed is a CisScanStatus enum value
	CisScanStatusFailed = "FAILED"

	// CisScanStatusCompleted is a CisScanStatus enum value
	CisScanStatusCompleted = "COMPLETED"

	// CisScanStatusCancelled is a CisScanStatus enum value
	CisScanStatusCancelled = "CANCELLED"

	// CisScanStatusInProgress is a CisScanStatus enum value
	CisScanStatusInProgress = "IN_PROGRESS"
)

// CisScanStatus_Values returns all elements of the CisScanStatus enum
func CisScanStatus_Values() []string {
	return []string{
		CisScanStatusFailed,
		CisScanStatusCompleted,
		CisScanStatusCancelled,
		CisScanStatusInProgress,
	}
}

const (
	// CisScanStatusComparisonEquals is a CisScanStatusComparison enum value
	CisScanStatusComparisonEquals = "EQUALS"
)

// CisScanStatusComparison_Values returns all elements of the CisScanStatusComparison enum
func CisScanStatusComparison_Values() []string {
	return []string{
		CisScanStatusComparisonEquals,
	}
}

const (
	// CisSecurityLevelLevel1 is a CisSecurityLevel enum value
	CisSecurityLevelLevel1 = "LEVEL_1"

	// CisSecurityLevelLevel2 is a CisSecurityLevel enum value
	CisSecurityLevelLevel2 = "LEVEL_2"
)

// CisSecurityLevel_Values returns all elements of the CisSecurityLevel enum
func CisSecurityLevel_Values() []string {
	return []string{
		CisSecurityLevelLevel1,
		CisSecurityLevelLevel2,
	}
}

const (
	// CisSecurityLevelComparisonEquals is a CisSecurityLevelComparison enum value
	CisSecurityLevelComparisonEquals = "EQUALS"
)

// CisSecurityLevelComparison_Values returns all elements of the CisSecurityLevelComparison enum
func CisSecurityLevelComparison_Values() []string {
	return []string{
		CisSecurityLevelComparisonEquals,
	}
}

const (
	// CisSortOrderAsc is a CisSortOrder enum value
	CisSortOrderAsc = "ASC"

	// CisSortOrderDesc is a CisSortOrder enum value
	CisSortOrderDesc = "DESC"
)

// CisSortOrder_Values returns all elements of the CisSortOrder enum
func CisSortOrder_Values() []string {
	return []string{
		CisSortOrderAsc,
		CisSortOrderDesc,
	}
}

const (
	// CisStringComparisonEquals is a CisStringComparison enum value
	CisStringComparisonEquals = "EQUALS"

	// CisStringComparisonPrefix is a CisStringComparison enum value
	CisStringComparisonPrefix = "PREFIX"

	// CisStringComparisonNotEquals is a CisStringComparison enum value
	CisStringComparisonNotEquals = "NOT_EQUALS"
)

// CisStringComparison_Values returns all elements of the CisStringComparison enum
func CisStringComparison_Values() []string {
	return []string{
		CisStringComparisonEquals,
		CisStringComparisonPrefix,
		CisStringComparisonNotEquals,
	}
}

const (
	// CisTargetStatusTimedOut is a CisTargetStatus enum value
	CisTargetStatusTimedOut = "TIMED_OUT"

	// CisTargetStatusCancelled is a CisTargetStatus enum value
	CisTargetStatusCancelled = "CANCELLED"

	// CisTargetStatusCompleted is a CisTargetStatus enum value
	CisTargetStatusCompleted = "COMPLETED"
)

// CisTargetStatus_Values returns all elements of the CisTargetStatus enum
func CisTargetStatus_Values() []string {
	return []string{
		CisTargetStatusTimedOut,
		CisTargetStatusCancelled,
		CisTargetStatusCompleted,
	}
}

const (
	// CisTargetStatusComparisonEquals is a CisTargetStatusComparison enum value
	CisTargetStatusComparisonEquals = "EQUALS"
)

// CisTargetStatusComparison_Values returns all elements of the CisTargetStatusComparison enum
func CisTargetStatusComparison_Values() []string {
	return []string{
		CisTargetStatusComparisonEquals,
	}
}

const (
	// CisTargetStatusReasonScanInProgress is a CisTargetStatusReason enum value
	CisTargetStatusReasonScanInProgress = "SCAN_IN_PROGRESS"

	// CisTargetStatusReasonUnsupportedOs is a CisTargetStatusReason enum value
	CisTargetStatusReasonUnsupportedOs = "UNSUPPORTED_OS"

	// CisTargetStatusReasonSsmUnmanaged is a CisTargetStatusReason enum value
	CisTargetStatusReasonSsmUnmanaged = "SSM_UNMANAGED"
)

// CisTargetStatusReason_Values returns all elements of the CisTargetStatusReason enum
func CisTargetStatusReason_Values() []string {
	return []string{
		CisTargetStatusReasonScanInProgress,
		CisTargetStatusReasonUnsupportedOs,
		CisTargetStatusReasonSsmUnmanaged,
	}
}

const (
	// CodeSnippetErrorCodeInternalError is a CodeSnippetErrorCode enum value
	CodeSnippetErrorCodeInternalError = "INTERNAL_ERROR"

	// CodeSnippetErrorCodeAccessDenied is a CodeSnippetErrorCode enum value
	CodeSnippetErrorCodeAccessDenied = "ACCESS_DENIED"

	// CodeSnippetErrorCodeCodeSnippetNotFound is a CodeSnippetErrorCode enum value
	CodeSnippetErrorCodeCodeSnippetNotFound = "CODE_SNIPPET_NOT_FOUND"

	// CodeSnippetErrorCodeInvalidInput is a CodeSnippetErrorCode enum value
	CodeSnippetErrorCodeInvalidInput = "INVALID_INPUT"
)

// CodeSnippetErrorCode_Values returns all elements of the CodeSnippetErrorCode enum
func CodeSnippetErrorCode_Values() []string {
	return []string{
		CodeSnippetErrorCodeInternalError,
		CodeSnippetErrorCodeAccessDenied,
		CodeSnippetErrorCodeCodeSnippetNotFound,
		CodeSnippetErrorCodeInvalidInput,
	}
}

const (
	// CoverageMapComparisonEquals is a CoverageMapComparison enum value
	CoverageMapComparisonEquals = "EQUALS"
)

// CoverageMapComparison_Values returns all elements of the CoverageMapComparison enum
func CoverageMapComparison_Values() []string {
	return []string{
		CoverageMapComparisonEquals,
	}
}

const (
	// CoverageResourceTypeAwsEc2Instance is a CoverageResourceType enum value
	CoverageResourceTypeAwsEc2Instance = "AWS_EC2_INSTANCE"

	// CoverageResourceTypeAwsEcrContainerImage is a CoverageResourceType enum value
	CoverageResourceTypeAwsEcrContainerImage = "AWS_ECR_CONTAINER_IMAGE"

	// CoverageResourceTypeAwsEcrRepository is a CoverageResourceType enum value
	CoverageResourceTypeAwsEcrRepository = "AWS_ECR_REPOSITORY"

	// CoverageResourceTypeAwsLambdaFunction is a CoverageResourceType enum value
	CoverageResourceTypeAwsLambdaFunction = "AWS_LAMBDA_FUNCTION"
)

// CoverageResourceType_Values returns all elements of the CoverageResourceType enum
func CoverageResourceType_Values() []string {
	return []string{
		CoverageResourceTypeAwsEc2Instance,
		CoverageResourceTypeAwsEcrContainerImage,
		CoverageResourceTypeAwsEcrRepository,
		CoverageResourceTypeAwsLambdaFunction,
	}
}

const (
	// CoverageStringComparisonEquals is a CoverageStringComparison enum value
	CoverageStringComparisonEquals = "EQUALS"

	// CoverageStringComparisonNotEquals is a CoverageStringComparison enum value
	CoverageStringComparisonNotEquals = "NOT_EQUALS"
)

// CoverageStringComparison_Values returns all elements of the CoverageStringComparison enum
func CoverageStringComparison_Values() []string {
	return []string{
		CoverageStringComparisonEquals,
		CoverageStringComparisonNotEquals,
	}
}

const (
	// CurrencyUsd is a Currency enum value
	CurrencyUsd = "USD"
)

// Currency_Values returns all elements of the Currency enum
func Currency_Values() []string {
	return []string{
		CurrencyUsd,
	}
}

const (
	// DaySun is a Day enum value
	DaySun = "SUN"

	// DayMon is a Day enum value
	DayMon = "MON"

	// DayTue is a Day enum value
	DayTue = "TUE"

	// DayWed is a Day enum value
	DayWed = "WED"

	// DayThu is a Day enum value
	DayThu = "THU"

	// DayFri is a Day enum value
	DayFri = "FRI"

	// DaySat is a Day enum value
	DaySat = "SAT"
)

// Day_Values returns all elements of the Day enum
func Day_Values() []string {
	return []string{
		DaySun,
		DayMon,
		DayTue,
		DayWed,
		DayThu,
		DayFri,
		DaySat,
	}
}

const (
	// DelegatedAdminStatusEnabled is a DelegatedAdminStatus enum value
	DelegatedAdminStatusEnabled = "ENABLED"

	// DelegatedAdminStatusDisableInProgress is a DelegatedAdminStatus enum value
	DelegatedAdminStatusDisableInProgress = "DISABLE_IN_PROGRESS"
)

// DelegatedAdminStatus_Values returns all elements of the DelegatedAdminStatus enum
func DelegatedAdminStatus_Values() []string {
	return []string{
		DelegatedAdminStatusEnabled,
		DelegatedAdminStatusDisableInProgress,
	}
}

const (
	// Ec2DeepInspectionStatusActivated is a Ec2DeepInspectionStatus enum value
	Ec2DeepInspectionStatusActivated = "ACTIVATED"

	// Ec2DeepInspectionStatusDeactivated is a Ec2DeepInspectionStatus enum value
	Ec2DeepInspectionStatusDeactivated = "DEACTIVATED"

	// Ec2DeepInspectionStatusPending is a Ec2DeepInspectionStatus enum value
	Ec2DeepInspectionStatusPending = "PENDING"

	// Ec2DeepInspectionStatusFailed is a Ec2DeepInspectionStatus enum value
	Ec2DeepInspectionStatusFailed = "FAILED"
)

// Ec2DeepInspectionStatus_Values returns all elements of the Ec2DeepInspectionStatus enum
func Ec2DeepInspectionStatus_Values() []string {
	return []string{
		Ec2DeepInspectionStatusActivated,
		Ec2DeepInspectionStatusDeactivated,
		Ec2DeepInspectionStatusPending,
		Ec2DeepInspectionStatusFailed,
	}
}

const (
	// Ec2InstanceSortByNetworkFindings is a Ec2InstanceSortBy enum value
	Ec2InstanceSortByNetworkFindings = "NETWORK_FINDINGS"

	// Ec2InstanceSortByCritical is a Ec2InstanceSortBy enum value
	Ec2InstanceSortByCritical = "CRITICAL"

	// Ec2InstanceSortByHigh is a Ec2InstanceSortBy enum value
	Ec2InstanceSortByHigh = "HIGH"

	// Ec2InstanceSortByAll is a Ec2InstanceSortBy enum value
	Ec2InstanceSortByAll = "ALL"
)

// Ec2InstanceSortBy_Values returns all elements of the Ec2InstanceSortBy enum
func Ec2InstanceSortBy_Values() []string {
	return []string{
		Ec2InstanceSortByNetworkFindings,
		Ec2InstanceSortByCritical,
		Ec2InstanceSortByHigh,
		Ec2InstanceSortByAll,
	}
}

const (
	// Ec2PlatformWindows is a Ec2Platform enum value
	Ec2PlatformWindows = "WINDOWS"

	// Ec2PlatformLinux is a Ec2Platform enum value
	Ec2PlatformLinux = "LINUX"

	// Ec2PlatformUnknown is a Ec2Platform enum value
	Ec2PlatformUnknown = "UNKNOWN"

	// Ec2PlatformMacos is a Ec2Platform enum value
	Ec2PlatformMacos = "MACOS"
)

// Ec2Platform_Values returns all elements of the Ec2Platform enum
func Ec2Platform_Values() []string {
	return []string{
		Ec2PlatformWindows,
		Ec2PlatformLinux,
		Ec2PlatformUnknown,
		Ec2PlatformMacos,
	}
}

const (
	// Ec2ScanModeEc2SsmAgentBased is a Ec2ScanMode enum value
	Ec2ScanModeEc2SsmAgentBased = "EC2_SSM_AGENT_BASED"

	// Ec2ScanModeEc2Hybrid is a Ec2ScanMode enum value
	Ec2ScanModeEc2Hybrid = "EC2_HYBRID"
)

// Ec2ScanMode_Values returns all elements of the Ec2ScanMode enum
func Ec2ScanMode_Values() []string {
	return []string{
		Ec2ScanModeEc2SsmAgentBased,
		Ec2ScanModeEc2Hybrid,
	}
}

const (
	// Ec2ScanModeStatusSuccess is a Ec2ScanModeStatus enum value
	Ec2ScanModeStatusSuccess = "SUCCESS"

	// Ec2ScanModeStatusPending is a Ec2ScanModeStatus enum value
	Ec2ScanModeStatusPending = "PENDING"
)

// Ec2ScanModeStatus_Values returns all elements of the Ec2ScanModeStatus enum
func Ec2ScanModeStatus_Values() []string {
	return []string{
		Ec2ScanModeStatusSuccess,
		Ec2ScanModeStatusPending,
	}
}

const (
	// EcrPullDateRescanDurationDays14 is a EcrPullDateRescanDuration enum value
	EcrPullDateRescanDurationDays14 = "DAYS_14"

	// EcrPullDateRescanDurationDays30 is a EcrPullDateRescanDuration enum value
	EcrPullDateRescanDurationDays30 = "DAYS_30"

	// EcrPullDateRescanDurationDays60 is a EcrPullDateRescanDuration enum value
	EcrPullDateRescanDurationDays60 = "DAYS_60"

	// EcrPullDateRescanDurationDays90 is a EcrPullDateRescanDuration enum value
	EcrPullDateRescanDurationDays90 = "DAYS_90"

	// EcrPullDateRescanDurationDays180 is a EcrPullDateRescanDuration enum value
	EcrPullDateRescanDurationDays180 = "DAYS_180"
)

// EcrPullDateRescanDuration_Values returns all elements of the EcrPullDateRescanDuration enum
func EcrPullDateRescanDuration_Values() []string {
	return []string{
		EcrPullDateRescanDurationDays14,
		EcrPullDateRescanDurationDays30,
		EcrPullDateRescanDurationDays60,
		EcrPullDateRescanDurationDays90,
		EcrPullDateRescanDurationDays180,
	}
}

const (
	// EcrRescanDurationLifetime is a EcrRescanDuration enum value
	EcrRescanDurationLifetime = "LIFETIME"

	// EcrRescanDurationDays30 is a EcrRescanDuration enum value
	EcrRescanDurationDays30 = "DAYS_30"

	// EcrRescanDurationDays180 is a EcrRescanDuration enum value
	EcrRescanDurationDays180 = "DAYS_180"

	// EcrRescanDurationDays14 is a EcrRescanDuration enum value
	EcrRescanDurationDays14 = "DAYS_14"

	// EcrRescanDurationDays60 is a EcrRescanDuration enum value
	EcrRescanDurationDays60 = "DAYS_60"

	// EcrRescanDurationDays90 is a EcrRescanDuration enum value
	EcrRescanDurationDays90 = "DAYS_90"
)

// EcrRescanDuration_Values returns all elements of the EcrRescanDuration enum
func EcrRescanDuration_Values() []string {
	return []string{
		EcrRescanDurationLifetime,
		EcrRescanDurationDays30,
		EcrRescanDurationDays180,
		EcrRescanDurationDays14,
		EcrRescanDurationDays60,
		EcrRescanDurationDays90,
	}
}

const (
	// EcrRescanDurationStatusSuccess is a EcrRescanDurationStatus enum value
	EcrRescanDurationStatusSuccess = "SUCCESS"

	// EcrRescanDurationStatusPending is a EcrRescanDurationStatus enum value
	EcrRescanDurationStatusPending = "PENDING"

	// EcrRescanDurationStatusFailed is a EcrRescanDurationStatus enum value
	EcrRescanDurationStatusFailed = "FAILED"
)

// EcrRescanDurationStatus_Values returns all elements of the EcrRescanDurationStatus enum
func EcrRescanDurationStatus_Values() []string {
	return []string{
		EcrRescanDurationStatusSuccess,
		EcrRescanDurationStatusPending,
		EcrRescanDurationStatusFailed,
	}
}

const (
	// EcrScanFrequencyManual is a EcrScanFrequency enum value
	EcrScanFrequencyManual = "MANUAL"

	// EcrScanFrequencyScanOnPush is a EcrScanFrequency enum value
	EcrScanFrequencyScanOnPush = "SCAN_ON_PUSH"

	// EcrScanFrequencyContinuousScan is a EcrScanFrequency enum value
	EcrScanFrequencyContinuousScan = "CONTINUOUS_SCAN"
)

// EcrScanFrequency_Values returns all elements of the EcrScanFrequency enum
func EcrScanFrequency_Values() []string {
	return []string{
		EcrScanFrequencyManual,
		EcrScanFrequencyScanOnPush,
		EcrScanFrequencyContinuousScan,
	}
}

const (
	// ErrorCodeAlreadyEnabled is a ErrorCode enum value
	ErrorCodeAlreadyEnabled = "ALREADY_ENABLED"

	// ErrorCodeEnableInProgress is a ErrorCode enum value
	ErrorCodeEnableInProgress = "ENABLE_IN_PROGRESS"

	// ErrorCodeDisableInProgress is a ErrorCode enum value
	ErrorCodeDisableInProgress = "DISABLE_IN_PROGRESS"

	// ErrorCodeSuspendInProgress is a ErrorCode enum value
	ErrorCodeSuspendInProgress = "SUSPEND_IN_PROGRESS"

	// ErrorCodeResourceNotFound is a ErrorCode enum value
	ErrorCodeResourceNotFound = "RESOURCE_NOT_FOUND"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "ACCESS_DENIED"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "INTERNAL_ERROR"

	// ErrorCodeSsmUnavailable is a ErrorCode enum value
	ErrorCodeSsmUnavailable = "SSM_UNAVAILABLE"

	// ErrorCodeSsmThrottled is a ErrorCode enum value
	ErrorCodeSsmThrottled = "SSM_THROTTLED"

	// ErrorCodeEventbridgeUnavailable is a ErrorCode enum value
	ErrorCodeEventbridgeUnavailable = "EVENTBRIDGE_UNAVAILABLE"

	// ErrorCodeEventbridgeThrottled is a ErrorCode enum value
	ErrorCodeEventbridgeThrottled = "EVENTBRIDGE_THROTTLED"

	// ErrorCodeResourceScanNotDisabled is a ErrorCode enum value
	ErrorCodeResourceScanNotDisabled = "RESOURCE_SCAN_NOT_DISABLED"

	// ErrorCodeDisassociateAllMembers is a ErrorCode enum value
	ErrorCodeDisassociateAllMembers = "DISASSOCIATE_ALL_MEMBERS"

	// ErrorCodeAccountIsIsolated is a ErrorCode enum value
	ErrorCodeAccountIsIsolated = "ACCOUNT_IS_ISOLATED"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeAlreadyEnabled,
		ErrorCodeEnableInProgress,
		ErrorCodeDisableInProgress,
		ErrorCodeSuspendInProgress,
		ErrorCodeResourceNotFound,
		ErrorCodeAccessDenied,
		ErrorCodeInternalError,
		ErrorCodeSsmUnavailable,
		ErrorCodeSsmThrottled,
		ErrorCodeEventbridgeUnavailable,
		ErrorCodeEventbridgeThrottled,
		ErrorCodeResourceScanNotDisabled,
		ErrorCodeDisassociateAllMembers,
		ErrorCodeAccountIsIsolated,
	}
}

const (
	// ExploitAvailableYes is a ExploitAvailable enum value
	ExploitAvailableYes = "YES"

	// ExploitAvailableNo is a ExploitAvailable enum value
	ExploitAvailableNo = "NO"
)

// ExploitAvailable_Values returns all elements of the ExploitAvailable enum
func ExploitAvailable_Values() []string {
	return []string{
		ExploitAvailableYes,
		ExploitAvailableNo,
	}
}

const (
	// ExternalReportStatusSucceeded is a ExternalReportStatus enum value
	ExternalReportStatusSucceeded = "SUCCEEDED"

	// ExternalReportStatusInProgress is a ExternalReportStatus enum value
	ExternalReportStatusInProgress = "IN_PROGRESS"

	// ExternalReportStatusCancelled is a ExternalReportStatus enum value
	ExternalReportStatusCancelled = "CANCELLED"

	// ExternalReportStatusFailed is a ExternalReportStatus enum value
	ExternalReportStatusFailed = "FAILED"
)

// ExternalReportStatus_Values returns all elements of the ExternalReportStatus enum
func ExternalReportStatus_Values() []string {
	return []string{
		ExternalReportStatusSucceeded,
		ExternalReportStatusInProgress,
		ExternalReportStatusCancelled,
		ExternalReportStatusFailed,
	}
}

const (
	// FilterActionNone is a FilterAction enum value
	FilterActionNone = "NONE"

	// FilterActionSuppress is a FilterAction enum value
	FilterActionSuppress = "SUPPRESS"
)

// FilterAction_Values returns all elements of the FilterAction enum
func FilterAction_Values() []string {
	return []string{
		FilterActionNone,
		FilterActionSuppress,
	}
}

const (
	// FindingDetailsErrorCodeInternalError is a FindingDetailsErrorCode enum value
	FindingDetailsErrorCodeInternalError = "INTERNAL_ERROR"

	// FindingDetailsErrorCodeAccessDenied is a FindingDetailsErrorCode enum value
	FindingDetailsErrorCodeAccessDenied = "ACCESS_DENIED"

	// FindingDetailsErrorCodeFindingDetailsNotFound is a FindingDetailsErrorCode enum value
	FindingDetailsErrorCodeFindingDetailsNotFound = "FINDING_DETAILS_NOT_FOUND"

	// FindingDetailsErrorCodeInvalidInput is a FindingDetailsErrorCode enum value
	FindingDetailsErrorCodeInvalidInput = "INVALID_INPUT"
)

// FindingDetailsErrorCode_Values returns all elements of the FindingDetailsErrorCode enum
func FindingDetailsErrorCode_Values() []string {
	return []string{
		FindingDetailsErrorCodeInternalError,
		FindingDetailsErrorCodeAccessDenied,
		FindingDetailsErrorCodeFindingDetailsNotFound,
		FindingDetailsErrorCodeInvalidInput,
	}
}

const (
	// FindingStatusActive is a FindingStatus enum value
	FindingStatusActive = "ACTIVE"

	// FindingStatusSuppressed is a FindingStatus enum value
	FindingStatusSuppressed = "SUPPRESSED"

	// FindingStatusClosed is a FindingStatus enum value
	FindingStatusClosed = "CLOSED"
)

// FindingStatus_Values returns all elements of the FindingStatus enum
func FindingStatus_Values() []string {
	return []string{
		FindingStatusActive,
		FindingStatusSuppressed,
		FindingStatusClosed,
	}
}

const (
	// FindingTypeNetworkReachability is a FindingType enum value
	FindingTypeNetworkReachability = "NETWORK_REACHABILITY"

	// FindingTypePackageVulnerability is a FindingType enum value
	FindingTypePackageVulnerability = "PACKAGE_VULNERABILITY"

	// FindingTypeCodeVulnerability is a FindingType enum value
	FindingTypeCodeVulnerability = "CODE_VULNERABILITY"
)

// FindingType_Values returns all elements of the FindingType enum
func FindingType_Values() []string {
	return []string{
		FindingTypeNetworkReachability,
		FindingTypePackageVulnerability,
		FindingTypeCodeVulnerability,
	}
}

const (
	// FindingTypeSortByCritical is a FindingTypeSortBy enum value
	FindingTypeSortByCritical = "CRITICAL"

	// FindingTypeSortByHigh is a FindingTypeSortBy enum value
	FindingTypeSortByHigh = "HIGH"

	// FindingTypeSortByAll is a FindingTypeSortBy enum value
	FindingTypeSortByAll = "ALL"
)

// FindingTypeSortBy_Values returns all elements of the FindingTypeSortBy enum
func FindingTypeSortBy_Values() []string {
	return []string{
		FindingTypeSortByCritical,
		FindingTypeSortByHigh,
		FindingTypeSortByAll,
	}
}

const (
	// FixAvailableYes is a FixAvailable enum value
	FixAvailableYes = "YES"

	// FixAvailableNo is a FixAvailable enum value
	FixAvailableNo = "NO"

	// FixAvailablePartial is a FixAvailable enum value
	FixAvailablePartial = "PARTIAL"
)

// FixAvailable_Values returns all elements of the FixAvailable enum
func FixAvailable_Values() []string {
	return []string{
		FixAvailableYes,
		FixAvailableNo,
		FixAvailablePartial,
	}
}

const (
	// FreeTrialInfoErrorCodeAccessDenied is a FreeTrialInfoErrorCode enum value
	FreeTrialInfoErrorCodeAccessDenied = "ACCESS_DENIED"

	// FreeTrialInfoErrorCodeInternalError is a FreeTrialInfoErrorCode enum value
	FreeTrialInfoErrorCodeInternalError = "INTERNAL_ERROR"
)

// FreeTrialInfoErrorCode_Values returns all elements of the FreeTrialInfoErrorCode enum
func FreeTrialInfoErrorCode_Values() []string {
	return []string{
		FreeTrialInfoErrorCodeAccessDenied,
		FreeTrialInfoErrorCodeInternalError,
	}
}

const (
	// FreeTrialStatusActive is a FreeTrialStatus enum value
	FreeTrialStatusActive = "ACTIVE"

	// FreeTrialStatusInactive is a FreeTrialStatus enum value
	FreeTrialStatusInactive = "INACTIVE"
)

// FreeTrialStatus_Values returns all elements of the FreeTrialStatus enum
func FreeTrialStatus_Values() []string {
	return []string{
		FreeTrialStatusActive,
		FreeTrialStatusInactive,
	}
}

const (
	// FreeTrialTypeEc2 is a FreeTrialType enum value
	FreeTrialTypeEc2 = "EC2"

	// FreeTrialTypeEcr is a FreeTrialType enum value
	FreeTrialTypeEcr = "ECR"

	// FreeTrialTypeLambda is a FreeTrialType enum value
	FreeTrialTypeLambda = "LAMBDA"

	// FreeTrialTypeLambdaCode is a FreeTrialType enum value
	FreeTrialTypeLambdaCode = "LAMBDA_CODE"
)

// FreeTrialType_Values returns all elements of the FreeTrialType enum
func FreeTrialType_Values() []string {
	return []string{
		FreeTrialTypeEc2,
		FreeTrialTypeEcr,
		FreeTrialTypeLambda,
		FreeTrialTypeLambdaCode,
	}
}

const (
	// GroupKeyScanStatusCode is a GroupKey enum value
	GroupKeyScanStatusCode = "SCAN_STATUS_CODE"

	// GroupKeyScanStatusReason is a GroupKey enum value
	GroupKeyScanStatusReason = "SCAN_STATUS_REASON"

	// GroupKeyAccountId is a GroupKey enum value
	GroupKeyAccountId = "ACCOUNT_ID"

	// GroupKeyResourceType is a GroupKey enum value
	GroupKeyResourceType = "RESOURCE_TYPE"

	// GroupKeyEcrRepositoryName is a GroupKey enum value
	GroupKeyEcrRepositoryName = "ECR_REPOSITORY_NAME"
)

// GroupKey_Values returns all elements of the GroupKey enum
func GroupKey_Values() []string {
	return []string{
		GroupKeyScanStatusCode,
		GroupKeyScanStatusReason,
		GroupKeyAccountId,
		GroupKeyResourceType,
		GroupKeyEcrRepositoryName,
	}
}

const (
	// ImageLayerSortByCritical is a ImageLayerSortBy enum value
	ImageLayerSortByCritical = "CRITICAL"

	// ImageLayerSortByHigh is a ImageLayerSortBy enum value
	ImageLayerSortByHigh = "HIGH"

	// ImageLayerSortByAll is a ImageLayerSortBy enum value
	ImageLayerSortByAll = "ALL"
)

// ImageLayerSortBy_Values returns all elements of the ImageLayerSortBy enum
func ImageLayerSortBy_Values() []string {
	return []string{
		ImageLayerSortByCritical,
		ImageLayerSortByHigh,
		ImageLayerSortByAll,
	}
}

const (
	// LambdaFunctionSortByCritical is a LambdaFunctionSortBy enum value
	LambdaFunctionSortByCritical = "CRITICAL"

	// LambdaFunctionSortByHigh is a LambdaFunctionSortBy enum value
	LambdaFunctionSortByHigh = "HIGH"

	// LambdaFunctionSortByAll is a LambdaFunctionSortBy enum value
	LambdaFunctionSortByAll = "ALL"
)

// LambdaFunctionSortBy_Values returns all elements of the LambdaFunctionSortBy enum
func LambdaFunctionSortBy_Values() []string {
	return []string{
		LambdaFunctionSortByCritical,
		LambdaFunctionSortByHigh,
		LambdaFunctionSortByAll,
	}
}

const (
	// LambdaLayerSortByCritical is a LambdaLayerSortBy enum value
	LambdaLayerSortByCritical = "CRITICAL"

	// LambdaLayerSortByHigh is a LambdaLayerSortBy enum value
	LambdaLayerSortByHigh = "HIGH"

	// LambdaLayerSortByAll is a LambdaLayerSortBy enum value
	LambdaLayerSortByAll = "ALL"
)

// LambdaLayerSortBy_Values returns all elements of the LambdaLayerSortBy enum
func LambdaLayerSortBy_Values() []string {
	return []string{
		LambdaLayerSortByCritical,
		LambdaLayerSortByHigh,
		LambdaLayerSortByAll,
	}
}

const (
	// ListCisScansDetailLevelOrganization is a ListCisScansDetailLevel enum value
	ListCisScansDetailLevelOrganization = "ORGANIZATION"

	// ListCisScansDetailLevelMember is a ListCisScansDetailLevel enum value
	ListCisScansDetailLevelMember = "MEMBER"
)

// ListCisScansDetailLevel_Values returns all elements of the ListCisScansDetailLevel enum
func ListCisScansDetailLevel_Values() []string {
	return []string{
		ListCisScansDetailLevelOrganization,
		ListCisScansDetailLevelMember,
	}
}

const (
	// ListCisScansSortByStatus is a ListCisScansSortBy enum value
	ListCisScansSortByStatus = "STATUS"

	// ListCisScansSortByScheduledBy is a ListCisScansSortBy enum value
	ListCisScansSortByScheduledBy = "SCHEDULED_BY"

	// ListCisScansSortByScanStartDate is a ListCisScansSortBy enum value
	ListCisScansSortByScanStartDate = "SCAN_START_DATE"

	// ListCisScansSortByFailedChecks is a ListCisScansSortBy enum value
	ListCisScansSortByFailedChecks = "FAILED_CHECKS"
)

// ListCisScansSortBy_Values returns all elements of the ListCisScansSortBy enum
func ListCisScansSortBy_Values() []string {
	return []string{
		ListCisScansSortByStatus,
		ListCisScansSortByScheduledBy,
		ListCisScansSortByScanStartDate,
		ListCisScansSortByFailedChecks,
	}
}

const (
	// MapComparisonEquals is a MapComparison enum value
	MapComparisonEquals = "EQUALS"
)

// MapComparison_Values returns all elements of the MapComparison enum
func MapComparison_Values() []string {
	return []string{
		MapComparisonEquals,
	}
}

const (
	// NetworkProtocolTcp is a NetworkProtocol enum value
	NetworkProtocolTcp = "TCP"

	// NetworkProtocolUdp is a NetworkProtocol enum value
	NetworkProtocolUdp = "UDP"
)

// NetworkProtocol_Values returns all elements of the NetworkProtocol enum
func NetworkProtocol_Values() []string {
	return []string{
		NetworkProtocolTcp,
		NetworkProtocolUdp,
	}
}

const (
	// OperationEnableScanning is a Operation enum value
	OperationEnableScanning = "ENABLE_SCANNING"

	// OperationDisableScanning is a Operation enum value
	OperationDisableScanning = "DISABLE_SCANNING"

	// OperationEnableRepository is a Operation enum value
	OperationEnableRepository = "ENABLE_REPOSITORY"

	// OperationDisableRepository is a Operation enum value
	OperationDisableRepository = "DISABLE_REPOSITORY"
)

// Operation_Values returns all elements of the Operation enum
func Operation_Values() []string {
	return []string{
		OperationEnableScanning,
		OperationDisableScanning,
		OperationEnableRepository,
		OperationDisableRepository,
	}
}

const (
	// PackageManagerBundler is a PackageManager enum value
	PackageManagerBundler = "BUNDLER"

	// PackageManagerCargo is a PackageManager enum value
	PackageManagerCargo = "CARGO"

	// PackageManagerComposer is a PackageManager enum value
	PackageManagerComposer = "COMPOSER"

	// PackageManagerNpm is a PackageManager enum value
	PackageManagerNpm = "NPM"

	// PackageManagerNuget is a PackageManager enum value
	PackageManagerNuget = "NUGET"

	// PackageManagerPipenv is a PackageManager enum value
	PackageManagerPipenv = "PIPENV"

	// PackageManagerPoetry is a PackageManager enum value
	PackageManagerPoetry = "POETRY"

	// PackageManagerYarn is a PackageManager enum value
	PackageManagerYarn = "YARN"

	// PackageManagerGobinary is a PackageManager enum value
	PackageManagerGobinary = "GOBINARY"

	// PackageManagerGomod is a PackageManager enum value
	PackageManagerGomod = "GOMOD"

	// PackageManagerJar is a PackageManager enum value
	PackageManagerJar = "JAR"

	// PackageManagerOs is a PackageManager enum value
	PackageManagerOs = "OS"

	// PackageManagerPip is a PackageManager enum value
	PackageManagerPip = "PIP"

	// PackageManagerPythonpkg is a PackageManager enum value
	PackageManagerPythonpkg = "PYTHONPKG"

	// PackageManagerNodepkg is a PackageManager enum value
	PackageManagerNodepkg = "NODEPKG"

	// PackageManagerPom is a PackageManager enum value
	PackageManagerPom = "POM"

	// PackageManagerGemspec is a PackageManager enum value
	PackageManagerGemspec = "GEMSPEC"
)

// PackageManager_Values returns all elements of the PackageManager enum
func PackageManager_Values() []string {
	return []string{
		PackageManagerBundler,
		PackageManagerCargo,
		PackageManagerComposer,
		PackageManagerNpm,
		PackageManagerNuget,
		PackageManagerPipenv,
		PackageManagerPoetry,
		PackageManagerYarn,
		PackageManagerGobinary,
		PackageManagerGomod,
		PackageManagerJar,
		PackageManagerOs,
		PackageManagerPip,
		PackageManagerPythonpkg,
		PackageManagerNodepkg,
		PackageManagerPom,
		PackageManagerGemspec,
	}
}

const (
	// PackageSortByCritical is a PackageSortBy enum value
	PackageSortByCritical = "CRITICAL"

	// PackageSortByHigh is a PackageSortBy enum value
	PackageSortByHigh = "HIGH"

	// PackageSortByAll is a PackageSortBy enum value
	PackageSortByAll = "ALL"
)

// PackageSortBy_Values returns all elements of the PackageSortBy enum
func PackageSortBy_Values() []string {
	return []string{
		PackageSortByCritical,
		PackageSortByHigh,
		PackageSortByAll,
	}
}

const (
	// PackageTypeImage is a PackageType enum value
	PackageTypeImage = "IMAGE"

	// PackageTypeZip is a PackageType enum value
	PackageTypeZip = "ZIP"
)

// PackageType_Values returns all elements of the PackageType enum
func PackageType_Values() []string {
	return []string{
		PackageTypeImage,
		PackageTypeZip,
	}
}

const (
	// RelationshipStatusCreated is a RelationshipStatus enum value
	RelationshipStatusCreated = "CREATED"

	// RelationshipStatusInvited is a RelationshipStatus enum value
	RelationshipStatusInvited = "INVITED"

	// RelationshipStatusDisabled is a RelationshipStatus enum value
	RelationshipStatusDisabled = "DISABLED"

	// RelationshipStatusEnabled is a RelationshipStatus enum value
	RelationshipStatusEnabled = "ENABLED"

	// RelationshipStatusRemoved is a RelationshipStatus enum value
	RelationshipStatusRemoved = "REMOVED"

	// RelationshipStatusResigned is a RelationshipStatus enum value
	RelationshipStatusResigned = "RESIGNED"

	// RelationshipStatusDeleted is a RelationshipStatus enum value
	RelationshipStatusDeleted = "DELETED"

	// RelationshipStatusEmailVerificationInProgress is a RelationshipStatus enum value
	RelationshipStatusEmailVerificationInProgress = "EMAIL_VERIFICATION_IN_PROGRESS"

	// RelationshipStatusEmailVerificationFailed is a RelationshipStatus enum value
	RelationshipStatusEmailVerificationFailed = "EMAIL_VERIFICATION_FAILED"

	// RelationshipStatusRegionDisabled is a RelationshipStatus enum value
	RelationshipStatusRegionDisabled = "REGION_DISABLED"

	// RelationshipStatusAccountSuspended is a RelationshipStatus enum value
	RelationshipStatusAccountSuspended = "ACCOUNT_SUSPENDED"

	// RelationshipStatusCannotCreateDetectorInOrgMaster is a RelationshipStatus enum value
	RelationshipStatusCannotCreateDetectorInOrgMaster = "CANNOT_CREATE_DETECTOR_IN_ORG_MASTER"
)

// RelationshipStatus_Values returns all elements of the RelationshipStatus enum
func RelationshipStatus_Values() []string {
	return []string{
		RelationshipStatusCreated,
		RelationshipStatusInvited,
		RelationshipStatusDisabled,
		RelationshipStatusEnabled,
		RelationshipStatusRemoved,
		RelationshipStatusResigned,
		RelationshipStatusDeleted,
		RelationshipStatusEmailVerificationInProgress,
		RelationshipStatusEmailVerificationFailed,
		RelationshipStatusRegionDisabled,
		RelationshipStatusAccountSuspended,
		RelationshipStatusCannotCreateDetectorInOrgMaster,
	}
}

const (
	// ReportFormatCsv is a ReportFormat enum value
	ReportFormatCsv = "CSV"

	// ReportFormatJson is a ReportFormat enum value
	ReportFormatJson = "JSON"
)

// ReportFormat_Values returns all elements of the ReportFormat enum
func ReportFormat_Values() []string {
	return []string{
		ReportFormatCsv,
		ReportFormatJson,
	}
}

const (
	// ReportingErrorCodeInternalError is a ReportingErrorCode enum value
	ReportingErrorCodeInternalError = "INTERNAL_ERROR"

	// ReportingErrorCodeInvalidPermissions is a ReportingErrorCode enum value
	ReportingErrorCodeInvalidPermissions = "INVALID_PERMISSIONS"

	// ReportingErrorCodeNoFindingsFound is a ReportingErrorCode enum value
	ReportingErrorCodeNoFindingsFound = "NO_FINDINGS_FOUND"

	// ReportingErrorCodeBucketNotFound is a ReportingErrorCode enum value
	ReportingErrorCodeBucketNotFound = "BUCKET_NOT_FOUND"

	// ReportingErrorCodeIncompatibleBucketRegion is a ReportingErrorCode enum value
	ReportingErrorCodeIncompatibleBucketRegion = "INCOMPATIBLE_BUCKET_REGION"

	// ReportingErrorCodeMalformedKmsKey is a ReportingErrorCode enum value
	ReportingErrorCodeMalformedKmsKey = "MALFORMED_KMS_KEY"
)

// ReportingErrorCode_Values returns all elements of the ReportingErrorCode enum
func ReportingErrorCode_Values() []string {
	return []string{
		ReportingErrorCodeInternalError,
		ReportingErrorCodeInvalidPermissions,
		ReportingErrorCodeNoFindingsFound,
		ReportingErrorCodeBucketNotFound,
		ReportingErrorCodeIncompatibleBucketRegion,
		ReportingErrorCodeMalformedKmsKey,
	}
}

const (
	// RepositorySortByCritical is a RepositorySortBy enum value
	RepositorySortByCritical = "CRITICAL"

	// RepositorySortByHigh is a RepositorySortBy enum value
	RepositorySortByHigh = "HIGH"

	// RepositorySortByAll is a RepositorySortBy enum value
	RepositorySortByAll = "ALL"

	// RepositorySortByAffectedImages is a RepositorySortBy enum value
	RepositorySortByAffectedImages = "AFFECTED_IMAGES"
)

// RepositorySortBy_Values returns all elements of the RepositorySortBy enum
func RepositorySortBy_Values() []string {
	return []string{
		RepositorySortByCritical,
		RepositorySortByHigh,
		RepositorySortByAll,
		RepositorySortByAffectedImages,
	}
}

const (
	// ResourceMapComparisonEquals is a ResourceMapComparison enum value
	ResourceMapComparisonEquals = "EQUALS"
)

// ResourceMapComparison_Values returns all elements of the ResourceMapComparison enum
func ResourceMapComparison_Values() []string {
	return []string{
		ResourceMapComparisonEquals,
	}
}

const (
	// ResourceScanTypeEc2 is a ResourceScanType enum value
	ResourceScanTypeEc2 = "EC2"

	// ResourceScanTypeEcr is a ResourceScanType enum value
	ResourceScanTypeEcr = "ECR"

	// ResourceScanTypeLambda is a ResourceScanType enum value
	ResourceScanTypeLambda = "LAMBDA"

	// ResourceScanTypeLambdaCode is a ResourceScanType enum value
	ResourceScanTypeLambdaCode = "LAMBDA_CODE"
)

// ResourceScanType_Values returns all elements of the ResourceScanType enum
func ResourceScanType_Values() []string {
	return []string{
		ResourceScanTypeEc2,
		ResourceScanTypeEcr,
		ResourceScanTypeLambda,
		ResourceScanTypeLambdaCode,
	}
}

const (
	// ResourceStringComparisonEquals is a ResourceStringComparison enum value
	ResourceStringComparisonEquals = "EQUALS"

	// ResourceStringComparisonNotEquals is a ResourceStringComparison enum value
	ResourceStringComparisonNotEquals = "NOT_EQUALS"
)

// ResourceStringComparison_Values returns all elements of the ResourceStringComparison enum
func ResourceStringComparison_Values() []string {
	return []string{
		ResourceStringComparisonEquals,
		ResourceStringComparisonNotEquals,
	}
}

const (
	// ResourceTypeAwsEc2Instance is a ResourceType enum value
	ResourceTypeAwsEc2Instance = "AWS_EC2_INSTANCE"

	// ResourceTypeAwsEcrContainerImage is a ResourceType enum value
	ResourceTypeAwsEcrContainerImage = "AWS_ECR_CONTAINER_IMAGE"

	// ResourceTypeAwsEcrRepository is a ResourceType enum value
	ResourceTypeAwsEcrRepository = "AWS_ECR_REPOSITORY"

	// ResourceTypeAwsLambdaFunction is a ResourceType enum value
	ResourceTypeAwsLambdaFunction = "AWS_LAMBDA_FUNCTION"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAwsEc2Instance,
		ResourceTypeAwsEcrContainerImage,
		ResourceTypeAwsEcrRepository,
		ResourceTypeAwsLambdaFunction,
	}
}

const (
	// RuntimeNodejs is a Runtime enum value
	RuntimeNodejs = "NODEJS"

	// RuntimeNodejs12X is a Runtime enum value
	RuntimeNodejs12X = "NODEJS_12_X"

	// RuntimeNodejs14X is a Runtime enum value
	RuntimeNodejs14X = "NODEJS_14_X"

	// RuntimeNodejs16X is a Runtime enum value
	RuntimeNodejs16X = "NODEJS_16_X"

	// RuntimeJava8 is a Runtime enum value
	RuntimeJava8 = "JAVA_8"

	// RuntimeJava8Al2 is a Runtime enum value
	RuntimeJava8Al2 = "JAVA_8_AL2"

	// RuntimeJava11 is a Runtime enum value
	RuntimeJava11 = "JAVA_11"

	// RuntimePython37 is a Runtime enum value
	RuntimePython37 = "PYTHON_3_7"

	// RuntimePython38 is a Runtime enum value
	RuntimePython38 = "PYTHON_3_8"

	// RuntimePython39 is a Runtime enum value
	RuntimePython39 = "PYTHON_3_9"

	// RuntimeUnsupported is a Runtime enum value
	RuntimeUnsupported = "UNSUPPORTED"

	// RuntimeNodejs18X is a Runtime enum value
	RuntimeNodejs18X = "NODEJS_18_X"

	// RuntimeGo1X is a Runtime enum value
	RuntimeGo1X = "GO_1_X"

	// RuntimeJava17 is a Runtime enum value
	RuntimeJava17 = "JAVA_17"

	// RuntimePython310 is a Runtime enum value
	RuntimePython310 = "PYTHON_3_10"
)

// Runtime_Values returns all elements of the Runtime enum
func Runtime_Values() []string {
	return []string{
		RuntimeNodejs,
		RuntimeNodejs12X,
		RuntimeNodejs14X,
		RuntimeNodejs16X,
		RuntimeJava8,
		RuntimeJava8Al2,
		RuntimeJava11,
		RuntimePython37,
		RuntimePython38,
		RuntimePython39,
		RuntimeUnsupported,
		RuntimeNodejs18X,
		RuntimeGo1X,
		RuntimeJava17,
		RuntimePython310,
	}
}

const (
	// SbomReportFormatCyclonedx14 is a SbomReportFormat enum value
	SbomReportFormatCyclonedx14 = "CYCLONEDX_1_4"

	// SbomReportFormatSpdx23 is a SbomReportFormat enum value
	SbomReportFormatSpdx23 = "SPDX_2_3"
)

// SbomReportFormat_Values returns all elements of the SbomReportFormat enum
func SbomReportFormat_Values() []string {
	return []string{
		SbomReportFormatCyclonedx14,
		SbomReportFormatSpdx23,
	}
}

const (
	// ScanModeEc2SsmAgentBased is a ScanMode enum value
	ScanModeEc2SsmAgentBased = "EC2_SSM_AGENT_BASED"

	// ScanModeEc2Agentless is a ScanMode enum value
	ScanModeEc2Agentless = "EC2_AGENTLESS"
)

// ScanMode_Values returns all elements of the ScanMode enum
func ScanMode_Values() []string {
	return []string{
		ScanModeEc2SsmAgentBased,
		ScanModeEc2Agentless,
	}
}

const (
	// ScanStatusCodeActive is a ScanStatusCode enum value
	ScanStatusCodeActive = "ACTIVE"

	// ScanStatusCodeInactive is a ScanStatusCode enum value
	ScanStatusCodeInactive = "INACTIVE"
)

// ScanStatusCode_Values returns all elements of the ScanStatusCode enum
func ScanStatusCode_Values() []string {
	return []string{
		ScanStatusCodeActive,
		ScanStatusCodeInactive,
	}
}

const (
	// ScanStatusReasonPendingInitialScan is a ScanStatusReason enum value
	ScanStatusReasonPendingInitialScan = "PENDING_INITIAL_SCAN"

	// ScanStatusReasonAccessDenied is a ScanStatusReason enum value
	ScanStatusReasonAccessDenied = "ACCESS_DENIED"

	// ScanStatusReasonInternalError is a ScanStatusReason enum value
	ScanStatusReasonInternalError = "INTERNAL_ERROR"

	// ScanStatusReasonUnmanagedEc2Instance is a ScanStatusReason enum value
	ScanStatusReasonUnmanagedEc2Instance = "UNMANAGED_EC2_INSTANCE"

	// ScanStatusReasonUnsupportedOs is a ScanStatusReason enum value
	ScanStatusReasonUnsupportedOs = "UNSUPPORTED_OS"

	// ScanStatusReasonScanEligibilityExpired is a ScanStatusReason enum value
	ScanStatusReasonScanEligibilityExpired = "SCAN_ELIGIBILITY_EXPIRED"

	// ScanStatusReasonResourceTerminated is a ScanStatusReason enum value
	ScanStatusReasonResourceTerminated = "RESOURCE_TERMINATED"

	// ScanStatusReasonSuccessful is a ScanStatusReason enum value
	ScanStatusReasonSuccessful = "SUCCESSFUL"

	// ScanStatusReasonNoResourcesFound is a ScanStatusReason enum value
	ScanStatusReasonNoResourcesFound = "NO_RESOURCES_FOUND"

	// ScanStatusReasonImageSizeExceeded is a ScanStatusReason enum value
	ScanStatusReasonImageSizeExceeded = "IMAGE_SIZE_EXCEEDED"

	// ScanStatusReasonScanFrequencyManual is a ScanStatusReason enum value
	ScanStatusReasonScanFrequencyManual = "SCAN_FREQUENCY_MANUAL"

	// ScanStatusReasonScanFrequencyScanOnPush is a ScanStatusReason enum value
	ScanStatusReasonScanFrequencyScanOnPush = "SCAN_FREQUENCY_SCAN_ON_PUSH"

	// ScanStatusReasonEc2InstanceStopped is a ScanStatusReason enum value
	ScanStatusReasonEc2InstanceStopped = "EC2_INSTANCE_STOPPED"

	// ScanStatusReasonPendingDisable is a ScanStatusReason enum value
	ScanStatusReasonPendingDisable = "PENDING_DISABLE"

	// ScanStatusReasonNoInventory is a ScanStatusReason enum value
	ScanStatusReasonNoInventory = "NO_INVENTORY"

	// ScanStatusReasonStaleInventory is a ScanStatusReason enum value
	ScanStatusReasonStaleInventory = "STALE_INVENTORY"

	// ScanStatusReasonExcludedByTag is a ScanStatusReason enum value
	ScanStatusReasonExcludedByTag = "EXCLUDED_BY_TAG"

	// ScanStatusReasonUnsupportedRuntime is a ScanStatusReason enum value
	ScanStatusReasonUnsupportedRuntime = "UNSUPPORTED_RUNTIME"

	// ScanStatusReasonUnsupportedMediaType is a ScanStatusReason enum value
	ScanStatusReasonUnsupportedMediaType = "UNSUPPORTED_MEDIA_TYPE"

	// ScanStatusReasonUnsupportedConfigFile is a ScanStatusReason enum value
	ScanStatusReasonUnsupportedConfigFile = "UNSUPPORTED_CONFIG_FILE"

	// ScanStatusReasonDeepInspectionPackageCollectionLimitExceeded is a ScanStatusReason enum value
	ScanStatusReasonDeepInspectionPackageCollectionLimitExceeded = "DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED"

	// ScanStatusReasonDeepInspectionDailySsmInventoryLimitExceeded is a ScanStatusReason enum value
	ScanStatusReasonDeepInspectionDailySsmInventoryLimitExceeded = "DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED"

	// ScanStatusReasonDeepInspectionCollectionTimeLimitExceeded is a ScanStatusReason enum value
	ScanStatusReasonDeepInspectionCollectionTimeLimitExceeded = "DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED"

	// ScanStatusReasonDeepInspectionNoInventory is a ScanStatusReason enum value
	ScanStatusReasonDeepInspectionNoInventory = "DEEP_INSPECTION_NO_INVENTORY"
)

// ScanStatusReason_Values returns all elements of the ScanStatusReason enum
func ScanStatusReason_Values() []string {
	return []string{
		ScanStatusReasonPendingInitialScan,
		ScanStatusReasonAccessDenied,
		ScanStatusReasonInternalError,
		ScanStatusReasonUnmanagedEc2Instance,
		ScanStatusReasonUnsupportedOs,
		ScanStatusReasonScanEligibilityExpired,
		ScanStatusReasonResourceTerminated,
		ScanStatusReasonSuccessful,
		ScanStatusReasonNoResourcesFound,
		ScanStatusReasonImageSizeExceeded,
		ScanStatusReasonScanFrequencyManual,
		ScanStatusReasonScanFrequencyScanOnPush,
		ScanStatusReasonEc2InstanceStopped,
		ScanStatusReasonPendingDisable,
		ScanStatusReasonNoInventory,
		ScanStatusReasonStaleInventory,
		ScanStatusReasonExcludedByTag,
		ScanStatusReasonUnsupportedRuntime,
		ScanStatusReasonUnsupportedMediaType,
		ScanStatusReasonUnsupportedConfigFile,
		ScanStatusReasonDeepInspectionPackageCollectionLimitExceeded,
		ScanStatusReasonDeepInspectionDailySsmInventoryLimitExceeded,
		ScanStatusReasonDeepInspectionCollectionTimeLimitExceeded,
		ScanStatusReasonDeepInspectionNoInventory,
	}
}

const (
	// ScanTypeNetwork is a ScanType enum value
	ScanTypeNetwork = "NETWORK"

	// ScanTypePackage is a ScanType enum value
	ScanTypePackage = "PACKAGE"

	// ScanTypeCode is a ScanType enum value
	ScanTypeCode = "CODE"
)

// ScanType_Values returns all elements of the ScanType enum
func ScanType_Values() []string {
	return []string{
		ScanTypeNetwork,
		ScanTypePackage,
		ScanTypeCode,
	}
}

const (
	// ServiceEc2 is a Service enum value
	ServiceEc2 = "EC2"

	// ServiceEcr is a Service enum value
	ServiceEcr = "ECR"

	// ServiceLambda is a Service enum value
	ServiceLambda = "LAMBDA"
)

// Service_Values returns all elements of the Service enum
func Service_Values() []string {
	return []string{
		ServiceEc2,
		ServiceEcr,
		ServiceLambda,
	}
}

const (
	// SeverityInformational is a Severity enum value
	SeverityInformational = "INFORMATIONAL"

	// SeverityLow is a Severity enum value
	SeverityLow = "LOW"

	// SeverityMedium is a Severity enum value
	SeverityMedium = "MEDIUM"

	// SeverityHigh is a Severity enum value
	SeverityHigh = "HIGH"

	// SeverityCritical is a Severity enum value
	SeverityCritical = "CRITICAL"

	// SeverityUntriaged is a Severity enum value
	SeverityUntriaged = "UNTRIAGED"
)

// Severity_Values returns all elements of the Severity enum
func Severity_Values() []string {
	return []string{
		SeverityInformational,
		SeverityLow,
		SeverityMedium,
		SeverityHigh,
		SeverityCritical,
		SeverityUntriaged,
	}
}

const (
	// SortFieldAwsAccountId is a SortField enum value
	SortFieldAwsAccountId = "AWS_ACCOUNT_ID"

	// SortFieldFindingType is a SortField enum value
	SortFieldFindingType = "FINDING_TYPE"

	// SortFieldSeverity is a SortField enum value
	SortFieldSeverity = "SEVERITY"

	// SortFieldFirstObservedAt is a SortField enum value
	SortFieldFirstObservedAt = "FIRST_OBSERVED_AT"

	// SortFieldLastObservedAt is a SortField enum value
	SortFieldLastObservedAt = "LAST_OBSERVED_AT"

	// SortFieldFindingStatus is a SortField enum value
	SortFieldFindingStatus = "FINDING_STATUS"

	// SortFieldResourceType is a SortField enum value
	SortFieldResourceType = "RESOURCE_TYPE"

	// SortFieldEcrImagePushedAt is a SortField enum value
	SortFieldEcrImagePushedAt = "ECR_IMAGE_PUSHED_AT"

	// SortFieldEcrImageRepositoryName is a SortField enum value
	SortFieldEcrImageRepositoryName = "ECR_IMAGE_REPOSITORY_NAME"

	// SortFieldEcrImageRegistry is a SortField enum value
	SortFieldEcrImageRegistry = "ECR_IMAGE_REGISTRY"

	// SortFieldNetworkProtocol is a SortField enum value
	SortFieldNetworkProtocol = "NETWORK_PROTOCOL"

	// SortFieldComponentType is a SortField enum value
	SortFieldComponentType = "COMPONENT_TYPE"

	// SortFieldVulnerabilityId is a SortField enum value
	SortFieldVulnerabilityId = "VULNERABILITY_ID"

	// SortFieldVulnerabilitySource is a SortField enum value
	SortFieldVulnerabilitySource = "VULNERABILITY_SOURCE"

	// SortFieldInspectorScore is a SortField enum value
	SortFieldInspectorScore = "INSPECTOR_SCORE"

	// SortFieldVendorSeverity is a SortField enum value
	SortFieldVendorSeverity = "VENDOR_SEVERITY"

	// SortFieldEpssScore is a SortField enum value
	SortFieldEpssScore = "EPSS_SCORE"
)

// SortField_Values returns all elements of the SortField enum
func SortField_Values() []string {
	return []string{
		SortFieldAwsAccountId,
		SortFieldFindingType,
		SortFieldSeverity,
		SortFieldFirstObservedAt,
		SortFieldLastObservedAt,
		SortFieldFindingStatus,
		SortFieldResourceType,
		SortFieldEcrImagePushedAt,
		SortFieldEcrImageRepositoryName,
		SortFieldEcrImageRegistry,
		SortFieldNetworkProtocol,
		SortFieldComponentType,
		SortFieldVulnerabilityId,
		SortFieldVulnerabilitySource,
		SortFieldInspectorScore,
		SortFieldVendorSeverity,
		SortFieldEpssScore,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}

const (
	// StatusEnabling is a Status enum value
	StatusEnabling = "ENABLING"

	// StatusEnabled is a Status enum value
	StatusEnabled = "ENABLED"

	// StatusDisabling is a Status enum value
	StatusDisabling = "DISABLING"

	// StatusDisabled is a Status enum value
	StatusDisabled = "DISABLED"

	// StatusSuspending is a Status enum value
	StatusSuspending = "SUSPENDING"

	// StatusSuspended is a Status enum value
	StatusSuspended = "SUSPENDED"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusEnabling,
		StatusEnabled,
		StatusDisabling,
		StatusDisabled,
		StatusSuspending,
		StatusSuspended,
	}
}

const (
	// StopCisSessionStatusSuccess is a StopCisSessionStatus enum value
	StopCisSessionStatusSuccess = "SUCCESS"

	// StopCisSessionStatusFailed is a StopCisSessionStatus enum value
	StopCisSessionStatusFailed = "FAILED"

	// StopCisSessionStatusInterrupted is a StopCisSessionStatus enum value
	StopCisSessionStatusInterrupted = "INTERRUPTED"

	// StopCisSessionStatusUnsupportedOs is a StopCisSessionStatus enum value
	StopCisSessionStatusUnsupportedOs = "UNSUPPORTED_OS"
)

// StopCisSessionStatus_Values returns all elements of the StopCisSessionStatus enum
func StopCisSessionStatus_Values() []string {
	return []string{
		StopCisSessionStatusSuccess,
		StopCisSessionStatusFailed,
		StopCisSessionStatusInterrupted,
		StopCisSessionStatusUnsupportedOs,
	}
}

const (
	// StringComparisonEquals is a StringComparison enum value
	StringComparisonEquals = "EQUALS"

	// StringComparisonPrefix is a StringComparison enum value
	StringComparisonPrefix = "PREFIX"

	// StringComparisonNotEquals is a StringComparison enum value
	StringComparisonNotEquals = "NOT_EQUALS"
)

// StringComparison_Values returns all elements of the StringComparison enum
func StringComparison_Values() []string {
	return []string{
		StringComparisonEquals,
		StringComparisonPrefix,
		StringComparisonNotEquals,
	}
}

const (
	// TagComparisonEquals is a TagComparison enum value
	TagComparisonEquals = "EQUALS"
)

// TagComparison_Values returns all elements of the TagComparison enum
func TagComparison_Values() []string {
	return []string{
		TagComparisonEquals,
	}
}

const (
	// TitleSortByCritical is a TitleSortBy enum value
	TitleSortByCritical = "CRITICAL"

	// TitleSortByHigh is a TitleSortBy enum value
	TitleSortByHigh = "HIGH"

	// TitleSortByAll is a TitleSortBy enum value
	TitleSortByAll = "ALL"
)

// TitleSortBy_Values returns all elements of the TitleSortBy enum
func TitleSortBy_Values() []string {
	return []string{
		TitleSortByCritical,
		TitleSortByHigh,
		TitleSortByAll,
	}
}

const (
	// UsageTypeEc2InstanceHours is a UsageType enum value
	UsageTypeEc2InstanceHours = "EC2_INSTANCE_HOURS"

	// UsageTypeEcrInitialScan is a UsageType enum value
	UsageTypeEcrInitialScan = "ECR_INITIAL_SCAN"

	// UsageTypeEcrRescan is a UsageType enum value
	UsageTypeEcrRescan = "ECR_RESCAN"

	// UsageTypeLambdaFunctionHours is a UsageType enum value
	UsageTypeLambdaFunctionHours = "LAMBDA_FUNCTION_HOURS"

	// UsageTypeLambdaFunctionCodeHours is a UsageType enum value
	UsageTypeLambdaFunctionCodeHours = "LAMBDA_FUNCTION_CODE_HOURS"
)

// UsageType_Values returns all elements of the UsageType enum
func UsageType_Values() []string {
	return []string{
		UsageTypeEc2InstanceHours,
		UsageTypeEcrInitialScan,
		UsageTypeEcrRescan,
		UsageTypeLambdaFunctionHours,
		UsageTypeLambdaFunctionCodeHours,
	}
}

const (
	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// VulnerabilitySourceNvd is a VulnerabilitySource enum value
	VulnerabilitySourceNvd = "NVD"
)

// VulnerabilitySource_Values returns all elements of the VulnerabilitySource enum
func VulnerabilitySource_Values() []string {
	return []string{
		VulnerabilitySourceNvd,
	}
}
