/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.filter;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.persistence.filter.PersistenceFilter;

@NonNullByDefault
public class PersistenceTimeFilter
extends PersistenceFilter {
    private final int value;
    private final String unit;
    private transient @Nullable Duration duration;
    private final transient Map<String, ZonedDateTime> nextPersistenceTimes = new HashMap<String, ZonedDateTime>();

    public PersistenceTimeFilter(String name, int value, @Nullable String unit) {
        super(name);
        this.value = value;
        this.unit = unit == null ? "s" : unit;
    }

    public int getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    @Override
    public boolean apply(Item item) {
        String itemName = item.getName();
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime nextPersistenceTime = this.nextPersistenceTimes.get(itemName);
        return nextPersistenceTime == null || !now.isBefore(nextPersistenceTime);
    }

    @Override
    public void persisted(Item item) {
        Duration duration;
        block13: {
            duration = this.duration;
            if (duration != null) break block13;
            this.duration = duration = (switch (this.unit) {
                case "m" -> Duration.of(this.value, ChronoUnit.MINUTES);
                case "h" -> Duration.of(this.value, ChronoUnit.HOURS);
                case "d" -> Duration.of(this.value, ChronoUnit.DAYS);
                default -> Duration.of(this.value, ChronoUnit.SECONDS);
            });
        }
        this.nextPersistenceTimes.put(item.getName(), ZonedDateTime.now().plus(duration));
    }

    @Override
    public String toString() {
        return String.format("%s [name=%s, value=%s, unit=%s]", this.getClass().getSimpleName(), this.getName(), this.value, this.unit);
    }
}

