/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteConsoleProcessSupport<T, V>
extends RemoteProcessSupport<T, V, ConsoleRunConfiguration>
implements Disposable {
    public static final Key<AsyncTask.Frame> BEFORE_RUN_CONTEXT = Key.create((String)"BEFORE_RUN_CONTEXT");
    private static final Key<Set<Object>> REMOTE_CONSOLE_TARGETS = Key.create((String)"REMOTE_CONSOLE_TARGETS");

    public RemoteConsoleProcessSupport(@NotNull Class<V> valueClass) {
        if (valueClass == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(0);
        }
        super(valueClass);
    }

    protected abstract ConsoleRunConfiguration.RunContext createRunContext(@NotNull T var1);

    protected RunProfileState getRunProfileState(@NotNull T target, @NotNull ConsoleRunConfiguration configuration, @NotNull Executor executor) throws ExecutionException {
        RunProfileState state;
        if (target == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(3);
        }
        ConsoleRunConfiguration clone = configuration.clone();
        clone.setName(this.getName(target) + ":" + configuration.getName());
        DataContext context = SimpleDataContext.getProjectContext((Project)configuration.getProject());
        ExecutionEnvironment environment = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)clone).runnerSettings((RunnerSettings)this.createRunContext(target)).dataContext(context).build();
        if (!configuration.getBeforeRunTasks().isEmpty()) {
            AsyncTask.frame((String)DatabaseBundle.message((String)"progress.title.run.before.tasks", (Object[])new Object[0])).sync(() -> {
                this.runBeforeTasks(target, configuration, environment);
                return null;
            });
        }
        return (state = environment.getState()) == null ? null : new NotifierProfileState(state, configuration, environment);
    }

    public V acquire(@NotNull T t, @NotNull ConsoleRunConfiguration configuration, @Nullable ProgressIndicator indicator) throws Exception {
        if (t == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(5);
        }
        RemoteConsoleProcessSupport.preventBeforeConnectCycle(configuration.getProject(), configuration.getName(), t);
        return (V)super.acquire(t, (Object)configuration, indicator);
    }

    public static void preventBeforeConnectCycle(@NotNull Project project, @NlsContexts.NotificationTitle @NotNull String name2, @NotNull Object t) {
        if (project == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(7);
        }
        if (t == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(8);
        }
        if (RemoteConsoleProcessSupport.isPerformingBeforeConnect(t)) {
            ConnDatabaseNotifications.GENERAL_BALLOON_GROUP().createNotification(name2, DatabaseBundle.message((String)"notification.content.attempt.to.connect.to.same.data.source.during.before.connection.task", (Object[])new Object[0]), NotificationType.ERROR).setDisplayId("RemoteConsoleProcessSupport.before.task.cycle.prevented").notify(project);
            throw new ProcessCanceledException();
        }
    }

    public static boolean isPerformingBeforeConnect(@NotNull Object t) {
        AsyncTask.Frame frame;
        Set targets;
        if (t == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(9);
        }
        return (targets = (Set)(frame = AsyncTask.currentFrame()).getInherited(REMOTE_CONSOLE_TARGETS)) != null && targets.contains(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBeforeTasks(@NotNull T target, @NotNull ConsoleRunConfiguration configuration, ExecutionEnvironment environment) throws ExecutionException {
        AsyncTask.Frame frame;
        Set<T> targets;
        if (target == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(11);
        }
        if ((targets = (Set<T>)(frame = AsyncTask.currentFrame()).getInherited(REMOTE_CONSOLE_TARGETS)) == null) {
            targets = Collections.synchronizedSet(new LinkedHashSet());
            frame.putUserData(REMOTE_CONSOLE_TARGETS, targets);
        }
        if (!targets.add(target)) {
            RemoteConsoleProcessSupport.preventBeforeConnectCycle(configuration.getProject(), configuration.getName(), target);
        }
        try {
            BEFORE_RUN_CONTEXT.set((UserDataHolder)environment, (Object)frame);
            for (BeforeRunTask task : configuration.getBeforeRunTasks()) {
                RemoteConsoleProcessSupport.performTask(configuration, environment, environment.getDataContext(), task);
            }
            BEFORE_RUN_CONTEXT.set((UserDataHolder)environment, null);
        }
        finally {
            targets.remove(target);
        }
    }

    private static <U extends BeforeRunTask<U>> void performTask(@NotNull ConsoleRunConfiguration configuration, ExecutionEnvironment environment, DataContext context, U task) throws ExecutionException {
        if (configuration == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(12);
        }
        long id = environment.getExecutionId();
        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)configuration.getProject(), (Key)task.getProviderId());
        if (provider == null || !provider.canExecuteTask((RunConfiguration)configuration, task)) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2(DatabaseBundle.message((String)"before.connection.task", (Object[])new Object[]{provider.getDescription(task)}));
        }
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(environment).contentToReuse(null);
        Executor taskExecutor = DefaultRunExecutor.getRunExecutorInstance();
        if (taskExecutor != null) {
            builder.executor(taskExecutor);
        }
        ExecutionEnvironment taskEnvironment = builder.build();
        taskEnvironment.setExecutionId(id);
        ExecutionManager.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)taskEnvironment, (Object)id);
        environment.copyUserDataTo((UserDataHolderBase)taskEnvironment);
        if (!provider.executeTask(context, (RunConfiguration)configuration, taskEnvironment, task)) {
            throw new ExecutionException(DatabaseBundle.message((String)"dialog.message.failed.to.perform.before.task", (Object[])new Object[]{provider.getDescription(task)}));
        }
    }

    public void dispose() {
        this.stopAll(ApplicationManager.getApplication().isUnitTestMode());
    }

    protected @NotNull ThrowableComputable<@Nullable V, Exception> acquireInProcessFactory(T target, ConsoleRunConfiguration configuration) throws Exception {
        SimpleJavaParameters params = new SimpleJavaParameters();
        ConsoleRunConfiguration.RunContext context = this.createRunContext(target);
        ReadAction.run(() -> {
            context.collectClassPath(params.getClassPath());
            context.tuneParams(configuration.getProject(), params);
            params.setMainClass(context.getMainClassName());
        });
        String[] args2 = params.getProgramParametersList().getArray();
        ArrayList<Path> files2 = new ArrayList<Path>();
        for (String s : params.getClassPath().getPathList()) {
            files2.add(Paths.get(s, new String[0]));
        }
        UrlClassLoader loader = UrlClassLoader.build().parent(((Object)((Object)this)).getClass().getClassLoader()).files(files2).allowLock(false).get();
        ThrowableComputable throwableComputable = (ThrowableComputable)ClassLoaderUtil.computeWithClassLoader((ClassLoader)loader, () -> {
            Method method = null;
            boolean addArgs = false;
            try {
                Class<?> aClass = Class.forName(params.getMainClass(), true, (ClassLoader)loader);
                method = ReflectionUtil.getMethod(aClass, (String)"entryPoint", (Class[])new Class[0]);
                if (method == null) {
                    addArgs = true;
                    method = ReflectionUtil.getMethod(aClass, (String)"entryPoint", (Class[])new Class[]{String[].class});
                }
            }
            catch (ClassNotFoundException aClass) {
                // empty catch block
            }
            Method finalMethod = method;
            boolean finalAddArgs = addArgs;
            return method == null ? () -> null : () -> {
                Object result = ClassLoaderUtil.computeWithClassLoader((ClassLoader)loader, () -> {
                    Object[] objectArray;
                    if (finalAddArgs) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = args2;
                    } else {
                        objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                    }
                    return finalMethod.invoke(null, objectArray);
                });
                return result;
            };
        });
        if (throwableComputable == null) {
            RemoteConsoleProcessSupport.$$$reportNull$$$0(13);
        }
        return throwableComputable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/RemoteConsoleProcessSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/RemoteConsoleProcessSupport";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireInProcessFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfileState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preventBeforeConnectCycle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPerformingBeforeConnect";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runBeforeTasks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performTask";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private static class NotifierProfileState
    implements RunProfileState {
        private final RunProfileState myState;
        private final ConsoleRunConfiguration myConfiguration;
        private final ExecutionEnvironment myEnvironment;
        private final AtomicBoolean started = new AtomicBoolean();
        private final AtomicBoolean terminated = new AtomicBoolean();
        private String myExecutorId;
        private ProcessHandler myHandler;

        private NotifierProfileState(RunProfileState state, ConsoleRunConfiguration configuration, ExecutionEnvironment environment) {
            this.myState = state;
            this.myConfiguration = configuration;
            this.myEnvironment = environment;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
            if (runner == null) {
                NotifierProfileState.$$$reportNull$$$0(0);
            }
            this.myExecutorId = executor.getId();
            this.getPublisher().processStartScheduled(this.myExecutorId, this.myEnvironment);
            try {
                ExecutionResult result = this.myState.execute(executor, runner);
                if (result == null) {
                    this.getPublisher().processNotStarted(this.myExecutorId, this.myEnvironment);
                    return null;
                }
                this.myHandler = result.getProcessHandler();
                this.myHandler.addProcessListener(new ProcessListener(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.notifyStarted();
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.notifyTerminated();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "event";
                        objectArray2[1] = "com/intellij/database/console/RemoteConsoleProcessSupport$NotifierProfileState$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startNotified";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                this.notifyStarted();
                if (this.myHandler.isProcessTerminated()) {
                    this.notifyTerminated();
                }
                return result;
            }
            catch (Throwable th) {
                this.getPublisher().processNotStarted(this.myExecutorId, this.myEnvironment);
                throw th;
            }
        }

        public void notifyStarted() {
            if (this.started.compareAndSet(false, true)) {
                if (this.isDisposed()) {
                    return;
                }
                this.getPublisher().processStarted(this.myExecutorId, this.myEnvironment, this.myHandler);
            }
        }

        public void notifyTerminated() {
            if (this.terminated.compareAndSet(false, true)) {
                if (this.isDisposed()) {
                    return;
                }
                this.getPublisher().processTerminated(this.myExecutorId, this.myEnvironment, this.myHandler, ((Integer)ObjectUtils.notNull((Object)this.myHandler.getExitCode(), (Object)0)).intValue());
            }
        }

        public boolean isDisposed() {
            Project project = this.myConfiguration.getProject();
            return project.isDisposed() || project.getMessageBus().isDisposed();
        }

        private ExecutionListener getPublisher() {
            return (ExecutionListener)this.myConfiguration.getProject().getMessageBus().syncPublisher(ExecutionManager.EXECUTION_TOPIC);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/database/console/RemoteConsoleProcessSupport$NotifierProfileState", "execute"));
        }
    }
}

