/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.gemini;

import com.intellij.aiplayground.gemini.Candidate;
import com.intellij.aiplayground.gemini.Content;
import com.intellij.aiplayground.gemini.GeminiClientAPI;
import com.intellij.aiplayground.gemini.GeminiClientAPIImpl;
import com.intellij.aiplayground.gemini.GeminiClientAPIImplKt;
import com.intellij.aiplayground.gemini.GeminiGenerateContentRequest;
import com.intellij.aiplayground.gemini.GeminiGenerateContentResponse;
import com.intellij.aiplayground.gemini.GeminiMessage;
import com.intellij.aiplayground.gemini.GeminiModel;
import com.intellij.aiplayground.gemini.GeminiModelInfo;
import com.intellij.aiplayground.gemini.GeminiModelListResponse;
import com.intellij.aiplayground.gemini.GeminiStreamChunk;
import com.intellij.aiplayground.gemini.GenerationConfig;
import com.intellij.aiplayground.gemini.Part;
import com.intellij.aiplayground.models.LlmModelId;
import com.intellij.aiplayground.models.chat.ChatResponseEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.PlatformHttpClient;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0001)B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u0012JN\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096@\u00a2\u0006\u0002\u0010\u001dJ@\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150%2\b\b\u0002\u0010&\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u0003H\u0082@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/aiplayground/gemini/GeminiClientAPIImpl;", "Lcom/intellij/aiplayground/gemini/GeminiClientAPI;", "httpTimeoutMs", "", "<init>", "(J)V", "listModelsUrl", "", "apiKey", "generateUrl", "model", "Lcom/intellij/aiplayground/gemini/GeminiModel;", "streamUrl", "listModels", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chatCompletion", "prompt", "(Ljava/lang/String;Lcom/intellij/aiplayground/gemini/GeminiModel;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "streamingChatCompletion", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/aiplayground/models/chat/ChatResponseEvent;", "messages", "Lcom/intellij/aiplayground/gemini/GeminiMessage;", "temperature", "", "topP", "maxTokens", "", "(Ljava/lang/String;Lcom/intellij/aiplayground/gemini/GeminiModel;Ljava/util/List;Ljava/lang/Double;DLjava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processStreamWithRetries", "", "client", "Ljava/net/http/HttpClient;", "request", "Ljava/net/http/HttpRequest;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "maxRetries", "initialDelayMs", "(Ljava/net/http/HttpClient;Ljava/net/http/HttpRequest;Lkotlinx/coroutines/channels/SendChannel;IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.aiplayground.gemini"})
@SourceDebugExtension(value={"SMAP\nGeminiClientAPIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiClientAPIImpl.kt\ncom/intellij/aiplayground/gemini/GeminiClientAPIImpl\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Channel.kt\nkotlinx/coroutines/channels/ChannelKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,191:1\n116#2,11:192\n116#2,11:207\n1563#3:203\n1634#3,3:204\n1563#3:218\n1634#3,3:219\n57#4:222\n1#5:223\n1029#6:224\n1030#6:226\n14#7:225\n14#7:227\n14#7:228\n*S KotlinDebug\n*F\n+ 1 GeminiClientAPIImpl.kt\ncom/intellij/aiplayground/gemini/GeminiClientAPIImpl\n*L\n93#1:192,11\n102#1:207,11\n101#1:203\n101#1:204,3\n136#1:218\n136#1:219,3\n163#1:222\n163#1:223\n171#1:224\n171#1:226\n172#1:225\n183#1:227\n188#1:228\n*E\n"})
public final class GeminiClientAPIImpl
implements GeminiClientAPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long httpTimeoutMs;
    @NotNull
    private static final String BASE_URL = "https://generativelanguage.googleapis.com";
    @NotNull
    private static final String API_VERSION = "v1beta";
    @Nullable
    private static List<GeminiModel> cachedModels;
    private static long cacheTimestamp;
    private static final long cacheDuration;
    @NotNull
    private static final Mutex cacheMutex;

    public GeminiClientAPIImpl(long httpTimeoutMs) {
        this.httpTimeoutMs = httpTimeoutMs;
    }

    public /* synthetic */ GeminiClientAPIImpl(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 300000L;
        }
        this(l);
    }

    private final String listModelsUrl(String apiKey) {
        return "https://generativelanguage.googleapis.com/v1beta/models?key=" + apiKey;
    }

    private final String generateUrl(GeminiModel model, String apiKey) {
        return "https://generativelanguage.googleapis.com/v1beta/models/" + model.getId-jY8-qq0() + ":generateContent?key=" + apiKey;
    }

    private final String streamUrl(GeminiModel model, String apiKey) {
        return "https://generativelanguage.googleapis.com/v1beta/models/" + model.getId-jY8-qq0() + ":streamGenerateContent?alt=sse&key=" + apiKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object listModels(@NotNull String apiKey, @NotNull Continuation<? super List<GeminiModel>> $completion) {
        if (!($completion instanceof listModels.1)) ** GOTO lbl-1000
        var22_3 = $completion;
        if ((var22_3.label & -2147483648) != 0) {
            var22_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeminiClientAPIImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.listModels(null, (Continuation<? super List<GeminiModel>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                now = System.currentTimeMillis();
                $this$withLock_u24default$iv = GeminiClientAPIImpl.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = apiKey;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.J$0 = now;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var23_5) {
                    return var23_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                now = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                apiKey = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                try {
                    $i$a$-withLock$default-GeminiClientAPIImpl$listModels$2 = false;
                    if (GeminiClientAPIImpl.cachedModels != null && now - GeminiClientAPIImpl.cacheTimestamp < GeminiClientAPIImpl.cacheDuration) {
                        v1 = GeminiClientAPIImpl.cachedModels;
                        Intrinsics.checkNotNull(v1);
                        var11_18 = v1;
                        return var11_18;
                    }
                    var9_20 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                v2 = PlatformHttpClient.client();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"client(...)");
                client = v2;
                request = PlatformHttpClient.requestBuilder((URI)new URI(this.listModelsUrl(apiKey))).build();
                response = PlatformHttpClient.checkResponse(client.send(request, HttpResponse.BodyHandlers.ofString()));
                v3 = (String)response.body();
                if (v3 == null) {
                    throw new IOException("Empty response body");
                }
                body = v3;
                list = (GeminiModelListResponse)GeminiClientAPIImplKt.getGeminiJson().decodeFromString((DeserializationStrategy)GeminiModelListResponse.Companion.serializer(), body);
                $this$map$iv = list.getModels();
                $i$f$map = false;
                var13_26 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_36 = (GeminiModelInfo)item$iv$iv;
                    var20_38 = destination$iv$iv;
                    $i$a$-map-GeminiClientAPIImpl$listModels$models$1 = false;
                    var20_38.add(new GeminiModel(LlmModelId.constructor-impl((String)it.getName()), null));
                }
                models = (List)destination$iv$iv;
                $this$withLock_u24default$iv = GeminiClientAPIImpl.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)apiKey);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)body);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)list);
                $continuation.L$6 = models;
                $continuation.L$7 = $this$withLock_u24default$iv;
                $continuation.J$0 = now;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 2;
                v4 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v4 == var23_5) {
                    return var23_5;
                }
                ** GOTO lbl101
            }
            case 2: {
                $i$f$withLock = $continuation.I$0;
                now = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$7;
                models = (List)$continuation.L$6;
                list = (GeminiModelListResponse)$continuation.L$5;
                body = (String)$continuation.L$4;
                response = (HttpResponse)$continuation.L$3;
                request = (HttpRequest)$continuation.L$2;
                client = (HttpClient)$continuation.L$1;
                apiKey = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl101:
                // 2 sources

                try {
                    $i$a$-withLock$default-GeminiClientAPIImpl$listModels$3 = false;
                    GeminiClientAPIImpl.cachedModels = models;
                    GeminiClientAPIImpl.cacheTimestamp = System.currentTimeMillis();
                    var15_33 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return models;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object chatCompletion(@NotNull String apiKey, @NotNull GeminiModel model, @NotNull String prompt, @NotNull Continuation<? super String> $completion) {
        GeminiGenerateContentRequest requestBody = new GeminiGenerateContentRequest(CollectionsKt.listOf((Object)new Content("user", CollectionsKt.listOf((Object)new Part(prompt)))), new GenerationConfig(Boxing.boxDouble((double)0.7), null, null, 6, null));
        String jsonBody = GeminiClientAPIImplKt.getGeminiJson().encodeToString((SerializationStrategy)GeminiGenerateContentRequest.Companion.serializer(), (Object)requestBody);
        HttpRequest httpRequest = PlatformHttpClient.requestBuilder((URI)new URI(this.generateUrl(model, apiKey))).header("Content-Type", "application/json").timeout(Duration.ofMillis(this.httpTimeoutMs)).POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpClient httpClient = PlatformHttpClient.client();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client(...)");
        HttpClient client = httpClient;
        HttpResponse response = PlatformHttpClient.checkResponse(client.send(httpRequest, HttpResponse.BodyHandlers.ofString()));
        String string = (String)response.body();
        if (string == null) {
            throw new IOException("Empty response body");
        }
        String body = string;
        GeminiGenerateContentResponse genResponse = (GeminiGenerateContentResponse)GeminiClientAPIImplKt.getGeminiJson().decodeFromString((DeserializationStrategy)GeminiGenerateContentResponse.Companion.serializer(), body);
        List<Candidate> list = genResponse.getCandidates();
        if (list == null || (list = (Candidate)CollectionsKt.firstOrNull(list)) == null || (list = ((Candidate)((Object)list)).getContent()) == null || (list = ((Content)((Object)list)).getParts()) == null || (list = (Part)CollectionsKt.firstOrNull(list)) == null || (list = ((Part)((Object)list)).getText()) == null) {
            throw new IOException("No content in response");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object streamingChatCompletion(@NotNull String apiKey, @NotNull GeminiModel model, @NotNull List<GeminiMessage> messages, @Nullable Double temperature, double topP, @Nullable Integer maxTokens, @NotNull Continuation<? super Flow<? extends ChatResponseEvent>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GeminiMessage geminiMessage = (GeminiMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Content(it.getRole(), CollectionsKt.listOf((Object)new Part(it.getContent()))));
        }
        List contents = (List)destination$iv$iv;
        GeminiGenerateContentRequest requestBody = new GeminiGenerateContentRequest(contents, new GenerationConfig(temperature, Boxing.boxDouble((double)topP), maxTokens));
        String jsonBody = GeminiClientAPIImplKt.getGeminiJson().encodeToString((SerializationStrategy)GeminiGenerateContentRequest.Companion.serializer(), (Object)requestBody);
        HttpRequest httpRequest = PlatformHttpClient.requestBuilder((URI)new URI(this.streamUrl(model, apiKey))).header("Content-Type", "application/json").timeout(Duration.ofMillis(this.httpTimeoutMs)).POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpClient httpClient = PlatformHttpClient.client();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"client(...)");
        HttpClient client = httpClient;
        return FlowKt.flowOn((Flow)FlowKt.channelFlow((Function2)((Function2)new Function2<ProducerScope<? super ChatResponseEvent>, Continuation<? super Unit>, Object>(this, client, httpRequest, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GeminiClientAPIImpl this$0;
            final /* synthetic */ HttpClient $client;
            final /* synthetic */ HttpRequest $httpRequest;
            {
                this.this$0 = $receiver;
                this.$client = $client;
                this.$httpRequest = $httpRequest;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                ProducerScope producerScope = (ProducerScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$channelFlow;
                        ResultKt.throwOnFailure((Object)$result);
                        HttpRequest httpRequest = this.$httpRequest;
                        Intrinsics.checkNotNull((Object)httpRequest);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$channelFlow);
                        this.label = 1;
                        Object object2 = GeminiClientAPIImpl.processStreamWithRetries$default(this.this$0, this.$client, httpRequest, (SendChannel)$this$channelFlow, 0, 0L, (Continuation)this, 24, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super ChatResponseEvent> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object processStreamWithRetries(HttpClient client, HttpRequest request, SendChannel<? super ChatResponseEvent> channel, int maxRetries, long initialDelayMs, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processStreamWithRetries.1)) ** GOTO lbl-1000
        var30_7 = $completion;
        if ((var30_7.label & -2147483648) != 0) {
            var30_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ GeminiClientAPIImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GeminiClientAPIImpl.access$processStreamWithRetries(this.this$0, null, null, null, 0, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var31_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                attempts = 0;
                lastError = null;
lbl14:
                // 4 sources

                while (attempts <= maxRetries) {
                    try {
                        response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                        $this$useLines$iv = new BufferedReader(new InputStreamReader(response.body(), StandardCharsets.UTF_8));
                        $i$f$useLines = false;
                        var13_18 /* !! */  = $this$useLines$iv;
                        var13_18 /* !! */  = (BufferedReader)var13_18 /* !! */ ;
                        var14_20 = null;
                        try {
                            it$iv = (BufferedReader)var13_18 /* !! */ ;
                            $i$a$-use-TextStreamsKt$useLines$1$iv = false;
                            lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            $i$a$-useLines-GeminiClientAPIImpl$processStreamWithRetries$2 = false;
                            var19_27 = lines.iterator();
                            while (var19_27.hasNext() && !Intrinsics.areEqual((Object)(line = StringsKt.trim((CharSequence)StringsKt.removePrefix((String)(raw = (String)var19_27.next()), (CharSequence)"data:")).toString()), (Object)"[DONE]")) {
                                if (StringsKt.isBlank((CharSequence)line) || (var24_32 = (CharSequence)(delta = (v0 = (chunk = (GeminiStreamChunk)GeminiClientAPIImplKt.getGeminiJson().decodeFromString((DeserializationStrategy)GeminiStreamChunk.Companion.serializer(), line)).getCandidates()) != null && (v0 = (Candidate)CollectionsKt.firstOrNull(v0)) != null && (v0 = v0.getContent()) != null && (v0 = v0.getParts()) != null && (v0 = (Part)CollectionsKt.firstOrNull(v0)) != null ? v0.getText() : null)) == null || var24_32.length() == 0) continue;
                                $this$onFailure_u2dWpGqRn0$iv = channel.trySend-JP2dKIU((Object)new ChatResponseEvent.PartialContentResponseEvent(delta));
                                $i$f$onFailure-WpGqRn0 = false;
                                if (!($this$onFailure_u2dWpGqRn0$iv instanceof ChannelResult.Failed)) continue;
                                it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure_u2dWpGqRn0$iv);
                                $i$a$-onFailure-WpGqRn0-GeminiClientAPIImpl$processStreamWithRetries$2$1 = false;
                                $i$f$logger = false;
                                v1 = Logger.getInstance(GeminiClientAPIImpl.class);
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                                v1.warn("Failed to emit chunk", it);
                            }
                            var15_21 = Unit.INSTANCE;
                        }
                        catch (Throwable var16_23) {
                            var14_20 = var16_23;
                            throw var16_23;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var13_18 /* !! */ , (Throwable)var14_20);
                        }
                        return Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        lastError = e;
                        if (++attempts > maxRetries) continue;
                        backoff = initialDelayMs * (long)(1 << attempts - 1);
                        $i$f$logger = false;
                        v2 = Logger.getInstance(GeminiClientAPIImpl.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.info("Retry " + attempts + "/" + maxRetries + " after " + e.getMessage() + ". Waiting " + backoff + " ms");
                        $continuation.L$0 = client;
                        $continuation.L$1 = request;
                        $continuation.L$2 = channel;
                        $continuation.L$3 = lastError;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)e);
                        $continuation.I$0 = maxRetries;
                        $continuation.J$0 = initialDelayMs;
                        $continuation.I$1 = attempts;
                        $continuation.J$1 = backoff;
                        $continuation.label = 1;
                        v3 = DelayKt.delay((long)backoff, (Continuation)$continuation);
                        if (v3 != var31_9) continue;
                        return var31_9;
                    }
                }
                break;
            }
            case 1: {
                backoff = $continuation.J$1;
                attempts = $continuation.I$1;
                initialDelayMs = $continuation.J$0;
                maxRetries = $continuation.I$0;
                e = (Exception)$continuation.L$4;
                lastError = (Exception)$continuation.L$3;
                channel = (SendChannel)$continuation.L$2;
                request = (HttpRequest)$continuation.L$1;
                client = (HttpClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
                ** GOTO lbl14
            }
        }
        $i$f$logger = false;
        v4 = Logger.getInstance(GeminiClientAPIImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
        v4.error("Streaming failed after " + maxRetries + " retries", (Throwable)lastError);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object processStreamWithRetries$default(GeminiClientAPIImpl geminiClientAPIImpl, HttpClient httpClient, HttpRequest httpRequest, SendChannel sendChannel, int n, long l, Continuation continuation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            l = 1000L;
        }
        return geminiClientAPIImpl.processStreamWithRetries(httpClient, httpRequest, (SendChannel<? super ChatResponseEvent>)sendChannel, n, l, (Continuation<? super Unit>)continuation);
    }

    public GeminiClientAPIImpl() {
        this(0L, 1, null);
    }

    public static final /* synthetic */ Object access$processStreamWithRetries(GeminiClientAPIImpl $this, HttpClient client, HttpRequest request, SendChannel channel, int maxRetries, long initialDelayMs, Continuation $completion) {
        return $this.processStreamWithRetries(client, request, (SendChannel<? super ChatResponseEvent>)channel, maxRetries, initialDelayMs, (Continuation<? super Unit>)$completion);
    }

    static {
        cacheDuration = 86400000L;
        cacheMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/aiplayground/gemini/GeminiClientAPIImpl$Companion;", "", "<init>", "()V", "BASE_URL", "", "API_VERSION", "cachedModels", "", "Lcom/intellij/aiplayground/gemini/GeminiModel;", "cacheTimestamp", "", "cacheDuration", "cacheMutex", "Lkotlinx/coroutines/sync/Mutex;", "intellij.aiplayground.gemini"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

