/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.components;

import com.intellij.docker.ui.utils.DockerConfigurablesUtil;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ui/components/JBTextFieldWithHint;", "Lcom/intellij/ui/components/JBTextField;", "<init>", "()V", "columns", "", "(I)V", "myHint", "", "paintComponent", "", "g", "Ljava/awt/Graphics;", "doPaintComponent", "getPreferredSize", "Ljava/awt/Dimension;", "setHint", "hint", "intellij.clouds.docker"})
public class JBTextFieldWithHint
extends JBTextField {
    @Nullable
    private String myHint;

    public JBTextFieldWithHint() {
    }

    public JBTextFieldWithHint(int columns) {
        super(columns);
    }

    protected final void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        String string = this.myHint;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Component component2 = (Component)((Object)this);
            char[] cArray = it.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            DockerConfigurablesUtil.paintHint(g, component2, cArray);
        }
        this.doPaintComponent(g);
    }

    protected void doPaintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
    }

    @NotNull
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = this.getText();
        Object object = this.myHint;
        if (object == null || (object = (String)object + StringsKt.repeat((CharSequence)" ", (int)10)) == null) {
            object = "";
        }
        int textWidth = fontMetrics.stringWidth(string + (String)object);
        Dimension size = super.getPreferredSize();
        size.width = RangesKt.coerceAtLeast((int)size.width, (int)textWidth);
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    public void setHint(@Nullable String hint) {
        this.myHint = hint;
        this.repaint();
    }
}

