/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.google.common.net.InetAddresses;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.ComposeScalarType;
import com.intellij.docker.ui.validation.UiValidationUtilsKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/composeFile/model/IPType;", "Lcom/intellij/docker/composeFile/model/ComposeScalarType;", "<init>", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "V4", "V6", "intellij.clouds.docker.compose"})
public class IPType
extends ComposeScalarType {
    public IPType() {
        super("docker-compose:IP");
    }

    @Override
    protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!InetAddresses.isInetAddress((String)scalarValue.getTextValue())) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("IPType.ip.value.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/composeFile/model/IPType$V4;", "Lcom/intellij/docker/composeFile/model/IPType;", "<init>", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.docker.compose"})
    public static final class V4
    extends IPType {
        @Override
        protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = scalarValue.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!UiValidationUtilsKt.isIPv4(string)) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("IPType.ipv4.value.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/composeFile/model/IPType$V6;", "Lcom/intellij/docker/composeFile/model/IPType;", "<init>", "()V", "doValidateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.docker.compose"})
    public static final class V6
    extends IPType {
        @Override
        protected void doValidateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = scalarValue.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!UiValidationUtilsKt.isIPv6(string)) {
                holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("IPType.ipv6.value.expected", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }
}

