/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTableWithRetainers;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.AggregatesTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapAggregatesView
implements ProfilingView<V8HeapTreeTable> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final V8MainTreeNavigator myContainmentNavigator;
    private final V8MainTableWithRetainers<AggregatesTableModel> myMainTableWithRetainers;

    public HeapAggregatesView(@NotNull Project project, @NotNull V8CachingReader reader, @NotNull V8MainTreeNavigator containmentNavigator, @NotNull Disposable disposable) {
        if (project == null) {
            HeapAggregatesView.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            HeapAggregatesView.$$$reportNull$$$0(1);
        }
        if (containmentNavigator == null) {
            HeapAggregatesView.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            HeapAggregatesView.$$$reportNull$$$0(3);
        }
        this.myContainmentNavigator = containmentNavigator;
        this.myReader = reader;
        this.myProject = project;
        this.myMainTableWithRetainers = new V8MainTableWithRetainers<AggregatesTableModel>(this.myProject, new AggregatesTableModel(this.myProject, this.myReader), this.myReader, this.myReader.getResourses(), disposable);
        this.myMainTableWithRetainers.setUseTreeSelectionForRetainers(false);
        this.myMainTableWithRetainers.setMainTreeNavigator(this.myContainmentNavigator);
    }

    @Override
    public JComponent getMainComponent() {
        return DataProviderPanel.wrap((JComponent)this.myMainTableWithRetainers.getMainSplitter(), sink -> {
            V8HeapEntry v8HeapEntry;
            V8HeapContainmentTreeTableModel.NamedEntry o;
            Object obj;
            sink.set(V8NavigateToMainTreeAction.MAIN_TREE_NAVIGATOR, (Object)this.myContainmentNavigator);
            TreePath path = this.myMainTableWithRetainers.getTable().getTree().getSelectionPath();
            Object object = obj = path == null ? null : path.getLastPathComponent();
            if (this.myMainTableWithRetainers.getTable().isFocusOwner() && obj instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                o = (V8HeapContainmentTreeTableModel.NamedEntry)obj;
                if (this.myMainTableWithRetainers.getRetainersTreeModel() != null && this.myMainTableWithRetainers.getRetainersTreeModel().getMain() != null && this.myMainTableWithRetainers.getRetainersTreeModel().getMain().equals(o.getEntry())) {
                    List<V8HeapContainmentTreeTableModel.NamedEntry> list = this.myMainTableWithRetainers.getRetainersTreeModel().getPathForSelectionInMainTree("Chain from root:");
                    sink.set(V8NavigateToMainTreeAction.TREE_PATH, (Object)(list == null ? null : new TreePath(ArrayUtil.toObjectArray(list))));
                }
            }
            if (obj instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                o = (V8HeapContainmentTreeTableModel.NamedEntry)obj;
                v8HeapEntry = o.getEntry();
            } else {
                v8HeapEntry = null;
            }
            sink.set(MarkUnmarkAction.SELECTED_NODE, v8HeapEntry);
            sink.set(MarkUnmarkAction.REVALIDATION, () -> {
                this.myMainTableWithRetainers.getTable().revalidate();
                this.myMainTableWithRetainers.getTable().repaint();
            });
        });
    }

    @Override
    public String getName() {
        return NodeJSBundle.message("profile.heap.summary.title", new Object[0]);
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new MarkUnmarkAction(this.myProject, this.myReader));
        group.add((AnAction)new V8NavigateToMainTreeAction());
        group.add((AnAction)new GoToSourceAction(this.myReader, this.myMainTableWithRetainers.getTable()));
        V8Utils.installHeapPopupMenu(this.myProject, this.myMainTableWithRetainers.getTable(), this.myReader, this.myContainmentNavigator);
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8HeapTreeTable getTreeTable() {
        return this.myMainTableWithRetainers.getTable();
    }

    @Override
    public void defaultExpand() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "containmentNavigator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/HeapAggregatesView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

