/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.util.List;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.FocusOwnerFinderStrategy;
import org.assertj.swing.core.HierarchyBasedFocusOwnerFinder;
import org.assertj.swing.core.ReflectionBasedFocusOwnerFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;

public final class FocusOwnerFinder {
    private static final List<FocusOwnerFinderStrategy> STRATEGIES = Lists.newArrayList();

    @VisibleForTesting
    static void initializeStrategies() {
        FocusOwnerFinder.replaceStrategiesWith(new ReflectionBasedFocusOwnerFinder(), new HierarchyBasedFocusOwnerFinder());
    }

    @VisibleForTesting
    static void replaceStrategiesWith(FocusOwnerFinderStrategy ... strategies) {
        STRATEGIES.clear();
        STRATEGIES.addAll(Lists.newArrayList((Object[])strategies));
    }

    @Nonnull
    @VisibleForTesting
    static List<FocusOwnerFinderStrategy> strategies() {
        return Lists.newArrayList(STRATEGIES);
    }

    @Nullable
    @RunsInEDT
    public static Component inEdtFocusOwner() {
        return GuiActionRunner.execute(() -> FocusOwnerFinder.focusOwner());
    }

    @Nullable
    @RunsInCurrentThread
    public static Component focusOwner() {
        for (FocusOwnerFinderStrategy strategy : STRATEGIES) {
            Component focusOwner = FocusOwnerFinder.focusOwnerFrom((FocusOwnerFinderStrategy)Preconditions.checkNotNull((Object)strategy));
            if (focusOwner == null) continue;
            return focusOwner;
        }
        return null;
    }

    @Nullable
    private static Component focusOwnerFrom(@Nonnull FocusOwnerFinderStrategy strategy) {
        try {
            return strategy.focusOwner();
        }
        catch (Exception e) {
            return null;
        }
    }

    private FocusOwnerFinder() {
    }

    static {
        FocusOwnerFinder.initializeStrategies();
    }
}

