/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.winpty;

import com.pty4j.util.LazyValue;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.platform.win32.VersionUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsVersion {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsVersion.class);
    private static final LazyValue<Version> myVersionValue = new LazyValue<Version>(WindowsVersion::doGetVersion);

    WindowsVersion() {
    }

    static void getVersion() {
        try {
            myVersionValue.getValue();
        }
        catch (Exception e) {
            LOG.warn("Cannot get Windows version", (Throwable)e);
        }
    }

    @NotNull
    private static Version doGetVersion() {
        try {
            VerRsrc.VS_FIXEDFILEINFO x = VersionUtil.getFileVersionInfo((String)"kernel32.dll");
            Version version = new Version(x.getProductVersionMajor(), x.getProductVersionMinor(), x.getProductVersionRevision());
            LOG.info("Windows version: {}", (Object)version);
            WindowsVersion.logSystemProperty("os.name");
            WindowsVersion.logSystemProperty("os.version");
            return version;
        }
        catch (Exception e) {
            LOG.info("Cannot get Windows version", (Throwable)e);
            return new Version(-1L, -1L, -1L);
        }
    }

    private static void logSystemProperty(@NotNull String name) {
        LOG.info("System property: {}={}", (Object)name, (Object)System.getProperty(name));
    }

    private static class Version {
        private final long myMajorVersion;
        private final long myMinorVersion;
        private final long myBuildNumber;

        Version(long majorVersion, long minorVersion, long buildNumber) {
            this.myMajorVersion = majorVersion;
            this.myMinorVersion = minorVersion;
            this.myBuildNumber = buildNumber;
        }

        public String toString() {
            return this.myMajorVersion + "." + this.myMinorVersion + "." + this.myBuildNumber;
        }
    }
}

