/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.ui.MessageType;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationsColorLayer
implements ColorLayer {
    private final GridMutator.DatabaseMutator<GridRow, GridColumn> myMutator;

    public MutationsColorLayer(@Nullable GridMutator.DatabaseMutator<GridRow, GridColumn> mutator) {
        this.myMutator = mutator;
    }

    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            MutationsColorLayer.$$$reportNull$$$0(0);
        }
        if (column == null) {
            MutationsColorLayer.$$$reportNull$$$0(1);
        }
        if (grid == null) {
            MutationsColorLayer.$$$reportNull$$$0(2);
        }
        if (this.myMutator == null) {
            return this.getColor(grid, null, color);
        }
        MutationData mutation = this.myMutator.getMutation(row, column);
        if (mutation != null && mutation.getValue() instanceof UnparsedValue) {
            return MutationsColorLayer.getFailedToInsertColor();
        }
        MutationType type = this.myMutator.getMutationType(row, column);
        return this.getColor(grid, type, color);
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<GridRow> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            MutationsColorLayer.$$$reportNull$$$0(3);
        }
        if (grid == null) {
            MutationsColorLayer.$$$reportNull$$$0(4);
        }
        if (this.myMutator != null && this.myMutator.hasUnparsedValues(row)) {
            return MutationsColorLayer.getFailedToInsertColor();
        }
        MutationType type = this.myMutator == null ? null : this.myMutator.getMutationType(row);
        return this.getColor(grid, type, color);
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            MutationsColorLayer.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            MutationsColorLayer.$$$reportNull$$$0(6);
        }
        return color;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Nullable
    private Color getColor(@NotNull DataGrid grid, @Nullable MutationType type, @Nullable Color oldColor) {
        if (grid == null) {
            MutationsColorLayer.$$$reportNull$$$0(7);
        }
        CellAttributesKey key = type != null ? GridUtil.getMutationCellAttributes(type) : null;
        CellAttributes attributes = key == null ? null : grid.getColorsScheme().getAttributes(key);
        Color bg = attributes == null ? null : attributes.getBackgroundColor();
        return this.maybeFailed(bg, oldColor);
    }

    @Nullable
    private Color maybeFailed(@Nullable Color newColor, @Nullable Color oldColor) {
        return newColor == null ? oldColor : (this.myMutator != null && this.myMutator.isFailed() ? MutationsColorLayer.getFailedToInsertColor() : newColor);
    }

    @NotNull
    private static Color getFailedToInsertColor() {
        Color color = MessageType.ERROR.getPopupBackground();
        if (color == null) {
            MutationsColorLayer.$$$reportNull$$$0(8);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/color/MutationsColorLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/color/MutationsColorLayer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedToInsertColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderBackground";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderBackground";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

