/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.intcaches;

import com.intellij.util.containers.intcaches.LinkedCustomIntObjectHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SLRUIntObjectMap<V> {
    private static final int QUEUES_SIZE_SCALING = Integer.getInteger("idea.slru.factor", 1);
    private final LinkedCustomIntObjectHashMap<V> protectedQueue;
    private final LinkedCustomIntObjectHashMap<V> probationalQueue;
    @NotNull
    private final EvictionCallback<? super V> evictionCallback;
    private final int protectedQueueSize;
    private final int probationalQueueSize;
    private int probationalHits;
    private int protectedHits;
    private int misses;

    public SLRUIntObjectMap(int protectedQueueSize, int probationalQueueSize, @NotNull EvictionCallback<? super V> evictionCallback) {
        if (evictionCallback == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(0);
        }
        this.protectedQueueSize = protectedQueueSize * QUEUES_SIZE_SCALING;
        this.probationalQueueSize = probationalQueueSize * QUEUES_SIZE_SCALING;
        this.evictionCallback = evictionCallback;
        this.probationalQueue = new LinkedCustomIntObjectHashMap<Object>((size, key, value) -> {
            if (size > this.probationalQueueSize) {
                this.onEvict(key, value);
                return true;
            }
            return false;
        });
        this.protectedQueue = new LinkedCustomIntObjectHashMap<Object>((size, key, value) -> {
            if (size > this.protectedQueueSize) {
                this.probationalQueue.put(key, value);
                return true;
            }
            return false;
        });
    }

    @Nullable
    public V get(int key) {
        V value = this.protectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.probationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.protectedQueue.put(key, value);
            return value;
        }
        ++this.misses;
        return null;
    }

    public void put(int key, @NotNull V value) {
        V oldValue;
        if (value == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(1);
        }
        if ((oldValue = this.protectedQueue.remove(key)) != null) {
            this.onEvict(key, oldValue);
        }
        if ((oldValue = this.probationalQueue.put(key, value)) != null) {
            this.onEvict(key, oldValue);
        }
    }

    private void onEvict(int key, @NotNull V value) {
        if (value == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(2);
        }
        this.evictionCallback.evicted(key, value);
    }

    public boolean remove(int key) {
        V value = this.protectedQueue.remove(key);
        if (value != null) {
            this.onEvict(key, value);
            return true;
        }
        value = this.probationalQueue.remove(key);
        if (value != null) {
            this.onEvict(key, value);
            return true;
        }
        return false;
    }

    public void iterateKeys(@NotNull Consumer<? super Integer> keyConsumer) {
        if (keyConsumer == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(3);
        }
        this.protectedQueue.keySet().forEach(keyConsumer);
        this.probationalQueue.keySet().forEach(keyConsumer);
    }

    @NotNull
    public Set<Map.Entry<Integer, V>> entrySet() {
        HashSet<Map.Entry<Integer, V>> set = new HashSet<Map.Entry<Integer, V>>(this.protectedQueue.entrySet());
        set.addAll(this.probationalQueue.entrySet());
        HashSet<Map.Entry<Integer, V>> hashSet = set;
        if (hashSet == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @NotNull
    public Set<V> values() {
        HashSet<V> set = new HashSet<V>(this.protectedQueue.values());
        set.addAll(this.probationalQueue.values());
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public void clear() {
        try {
            if (!this.protectedQueue.isEmpty()) {
                for (LinkedCustomIntObjectHashMap.Entry<V> entry : this.protectedQueue.entrySet()) {
                    this.onEvict(entry.key(), entry.getValue());
                }
            }
            if (!this.probationalQueue.isEmpty()) {
                for (LinkedCustomIntObjectHashMap.Entry<V> entry : this.probationalQueue.entrySet()) {
                    this.onEvict(entry.key(), entry.getValue());
                }
            }
        }
        finally {
            this.protectedQueue.clear();
            this.probationalQueue.clear();
        }
    }

    @NotNull
    public String dumpStats() {
        String string = "probational hits = " + this.probationalHits + ", protected hits = " + this.protectedHits + ", misses = " + this.misses;
        if (string == null) {
            SLRUIntObjectMap.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evictionCallback";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConsumer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/intcaches/SLRUIntObjectMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/intcaches/SLRUIntObjectMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onEvict";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "iterateKeys";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface EvictionCallback<V> {
        public void evicted(int var1, V var2);
    }
}

