# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._invoice_rendering_template import InvoiceRenderingTemplate
from stripe._list_object import ListObject
from stripe._request_options import RequestOptions
from stripe._stripe_service import StripeService
from stripe._util import sanitize_id
from typing import Optional, cast
from typing_extensions import TYPE_CHECKING

if TYPE_CHECKING:
    from stripe.params._invoice_rendering_template_archive_params import (
        InvoiceRenderingTemplateArchiveParams,
    )
    from stripe.params._invoice_rendering_template_list_params import (
        InvoiceRenderingTemplateListParams,
    )
    from stripe.params._invoice_rendering_template_retrieve_params import (
        InvoiceRenderingTemplateRetrieveParams,
    )
    from stripe.params._invoice_rendering_template_unarchive_params import (
        InvoiceRenderingTemplateUnarchiveParams,
    )


class InvoiceRenderingTemplateService(StripeService):
    def list(
        self,
        params: Optional["InvoiceRenderingTemplateListParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> ListObject[InvoiceRenderingTemplate]:
        """
        List all templates, ordered by creation date, with the most recently created template appearing first.
        """
        return cast(
            ListObject[InvoiceRenderingTemplate],
            self._request(
                "get",
                "/v1/invoice_rendering_templates",
                base_address="api",
                params=params,
                options=options,
            ),
        )

    async def list_async(
        self,
        params: Optional["InvoiceRenderingTemplateListParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> ListObject[InvoiceRenderingTemplate]:
        """
        List all templates, ordered by creation date, with the most recently created template appearing first.
        """
        return cast(
            ListObject[InvoiceRenderingTemplate],
            await self._request_async(
                "get",
                "/v1/invoice_rendering_templates",
                base_address="api",
                params=params,
                options=options,
            ),
        )

    def retrieve(
        self,
        template: str,
        params: Optional["InvoiceRenderingTemplateRetrieveParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> InvoiceRenderingTemplate:
        """
        Retrieves an invoice rendering template with the given ID. It by default returns the latest version of the template. Optionally, specify a version to see previous versions.
        """
        return cast(
            InvoiceRenderingTemplate,
            self._request(
                "get",
                "/v1/invoice_rendering_templates/{template}".format(
                    template=sanitize_id(template),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    async def retrieve_async(
        self,
        template: str,
        params: Optional["InvoiceRenderingTemplateRetrieveParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> InvoiceRenderingTemplate:
        """
        Retrieves an invoice rendering template with the given ID. It by default returns the latest version of the template. Optionally, specify a version to see previous versions.
        """
        return cast(
            InvoiceRenderingTemplate,
            await self._request_async(
                "get",
                "/v1/invoice_rendering_templates/{template}".format(
                    template=sanitize_id(template),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    def archive(
        self,
        template: str,
        params: Optional["InvoiceRenderingTemplateArchiveParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> InvoiceRenderingTemplate:
        """
        Updates the status of an invoice rendering template to ‘archived' so no new Stripe objects (customers, invoices, etc.) can reference it. The template can also no longer be updated. However, if the template is already set on a Stripe object, it will continue to be applied on invoices generated by it.
        """
        return cast(
            InvoiceRenderingTemplate,
            self._request(
                "post",
                "/v1/invoice_rendering_templates/{template}/archive".format(
                    template=sanitize_id(template),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    async def archive_async(
        self,
        template: str,
        params: Optional["InvoiceRenderingTemplateArchiveParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> InvoiceRenderingTemplate:
        """
        Updates the status of an invoice rendering template to ‘archived' so no new Stripe objects (customers, invoices, etc.) can reference it. The template can also no longer be updated. However, if the template is already set on a Stripe object, it will continue to be applied on invoices generated by it.
        """
        return cast(
            InvoiceRenderingTemplate,
            await self._request_async(
                "post",
                "/v1/invoice_rendering_templates/{template}/archive".format(
                    template=sanitize_id(template),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    def unarchive(
        self,
        template: str,
        params: Optional["InvoiceRenderingTemplateUnarchiveParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> InvoiceRenderingTemplate:
        """
        Unarchive an invoice rendering template so it can be used on new Stripe objects again.
        """
        return cast(
            InvoiceRenderingTemplate,
            self._request(
                "post",
                "/v1/invoice_rendering_templates/{template}/unarchive".format(
                    template=sanitize_id(template),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )

    async def unarchive_async(
        self,
        template: str,
        params: Optional["InvoiceRenderingTemplateUnarchiveParams"] = None,
        options: Optional[RequestOptions] = None,
    ) -> InvoiceRenderingTemplate:
        """
        Unarchive an invoice rendering template so it can be used on new Stripe objects again.
        """
        return cast(
            InvoiceRenderingTemplate,
            await self._request_async(
                "post",
                "/v1/invoice_rendering_templates/{template}/unarchive".format(
                    template=sanitize_id(template),
                ),
                base_address="api",
                params=params,
                options=options,
            ),
        )
