/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.anim.dom;

import java.util.HashMap;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMDocument;
import org.jetbrains.relocated.apache.batik.css.engine.CSSEngine;
import org.jetbrains.relocated.apache.batik.css.engine.CSSStyleSheetNode;
import org.jetbrains.relocated.apache.batik.css.engine.StyleSheet;
import org.jetbrains.relocated.apache.batik.dom.AbstractDocument;
import org.jetbrains.relocated.apache.batik.dom.StyleSheetFactory;
import org.jetbrains.relocated.apache.batik.dom.StyleSheetProcessingInstruction;
import org.jetbrains.relocated.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class SVGStyleSheetProcessingInstruction
extends StyleSheetProcessingInstruction
implements CSSStyleSheetNode {
    protected StyleSheet styleSheet;

    protected SVGStyleSheetProcessingInstruction() {
    }

    public SVGStyleSheetProcessingInstruction(String data2, AbstractDocument owner, StyleSheetFactory f) {
        super(data2, owner, f);
    }

    public String getStyleSheetURI() {
        SVGOMDocument svgDoc = (SVGOMDocument)this.getOwnerDocument();
        ParsedURL url = svgDoc.getParsedURL();
        String href2 = this.getPseudoAttributes().get("href");
        if (url != null) {
            return new ParsedURL(url, href2).toString();
        }
        return href2;
    }

    @Override
    public StyleSheet getCSSStyleSheet() {
        HashMap<String, String> attrs;
        String type;
        if (this.styleSheet == null && "text/css".equals(type = (attrs = this.getPseudoAttributes()).get("type"))) {
            String title = attrs.get("title");
            String media = attrs.get("media");
            String href2 = attrs.get("href");
            String alternate = attrs.get("alternate");
            SVGOMDocument doc = (SVGOMDocument)this.getOwnerDocument();
            ParsedURL durl = doc.getParsedURL();
            ParsedURL burl = new ParsedURL(durl, href2);
            CSSEngine e = doc.getCSSEngine();
            this.styleSheet = e.parseStyleSheet(burl, media);
            this.styleSheet.setAlternate("yes".equals(alternate));
            this.styleSheet.setTitle(title);
        }
        return this.styleSheet;
    }

    @Override
    public void setData(String data2) throws DOMException {
        super.setData(data2);
        this.styleSheet = null;
    }

    @Override
    protected Node newNode() {
        return new SVGStyleSheetProcessingInstruction();
    }
}

