/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfoKt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Url;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "name", "", "url", "Lcom/intellij/util/Url;", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;Lcom/intellij/util/Url;Ljavax/swing/Icon;)V", "childNameToInfo", "", "getChildNameToInfo", "()Ljava/util/Map;", "weight", "", "getWeight", "()I", "computeAndGetChildren", "", "hasChildren", "", "isFile", "()Z", "singleChild", "getSingleChild", "()Lcom/intellij/javascript/debugger/scripts/FileInfo;", "children", "", "getChildren$intellij_javascript_debugger", "()Ljava/util/List;", "getIcon", "addChild", "", "script", "Lorg/jetbrains/debugger/Script;", "removeChild", "intellij.javascript.debugger"})
public class ScriptDirectoryInfo
extends FileInfo {
    @NotNull
    private final Map<String, FileInfo> childNameToInfo;
    private final boolean isFile;

    public ScriptDirectoryInfo(@NotNull String name, @NotNull Url url, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        super(name, url, null, 4, null);
        this.childNameToInfo = new ConcurrentHashMap();
        this.set_icon$intellij_javascript_debugger(icon);
    }

    public /* synthetic */ ScriptDirectoryInfo(String string, Url url, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Icon icon2 = PlatformIcons.FOLDER_ICON;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FOLDER_ICON");
            icon = icon2;
        }
        this(string, url, icon);
    }

    @NotNull
    public final Map<String, FileInfo> getChildNameToInfo() {
        return this.childNameToInfo;
    }

    @Override
    public int getWeight() {
        return Intrinsics.areEqual((Object)this.get_icon$intellij_javascript_debugger(), (Object)PlatformIcons.FOLDER_ICON) ? 20 : 15;
    }

    @NotNull
    protected Map<String, FileInfo> computeAndGetChildren() {
        return this.childNameToInfo;
    }

    @Override
    public boolean hasChildren() {
        return !this.childNameToInfo.isEmpty();
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    @Nullable
    public FileInfo getSingleChild() {
        return this.childNameToInfo.size() == 1 ? this.childNameToInfo.values().iterator().next() : null;
    }

    @Override
    @NotNull
    public List<FileInfo> getChildren$intellij_javascript_debugger() {
        return CollectionsKt.toList((Iterable)this.computeAndGetChildren().values());
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.get_icon$intellij_javascript_debugger();
        Intrinsics.checkNotNull((Object)icon);
        return icon;
    }

    public void addChild(@NotNull Script script, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Object[] objectArray = new Script[]{script};
            this.childNameToInfo.put(string, new FileInfo(string2, url, CollectionsKt.mutableListOf((Object[])objectArray)));
        } else {
            ScriptDirectoryInfoKt.addEntry(script, url, this, null);
        }
    }

    public void removeChild(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            this.childNameToInfo.remove(url.getPath());
            return;
        }
        ScriptDirectoryInfoKt.access$removeEntry(url, this);
    }
}

