/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.PostgresExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.PostgresIntermediateFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PgJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern PG_VERSION_PATTERN = Pattern.compile("(\\d+(?:(?:alpha|beta|rc|devel)\\d*|\\.\\d+)(?:\\.\\d+)*)", 2);

    public PgJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("POSTGRES", version, connection, jdbcClassLoader);
    }

    public PgJdbcHelper() {
        this(null, null, null);
    }

    private PgJdbcHelper(@NotNull PgJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            PgJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            PgJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return PgJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new PgJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            PgJdbcHelper.$$$reportNull$$$0(2);
        }
        return new PostgresIntermediateFacade(ds, PostgresExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            PgJdbcHelper.$$$reportNull$$$0(3);
        }
        return new PgJdbcHelper(this, jdbcClassLoader);
    }

    @NotNull
    static PgJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) {
        String version = PgJdbcHelper.extractVersion(productVer);
        return new PgJdbcHelper(version, delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, PG_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/PgJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

