/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.parameterinfo;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.CssVersionDescriptorComparator;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.parameterinfo.CssParameterInfoValueDescriptorComparator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssParameterInfoHandler
implements ParameterInfoHandler<CssValueOwner, CssValueOwnerDescriptor> {
    public CssValueOwner findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        Collection<? extends CssElementDescriptor> descriptors;
        Collection<? extends CssElementDescriptor> filteredDescriptors;
        Set uniqueDescriptors;
        CssValueOwner element;
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((element = CssParameterInfoHandler.findElement(context.getFile(), context.getOffset())) instanceof CssDescriptorOwner && !(uniqueDescriptors = (Set)(filteredDescriptors = CssDescriptorsUtil.filterDescriptorsByContext(descriptors = ((CssDescriptorOwner)((Object)element)).getDescriptors(), element)).stream().filter(p -> p instanceof CssValueOwnerDescriptor).sorted(new CssVersionDescriptorComparator()).map(p -> (CssValueOwnerDescriptor)p).collect(Collectors.toCollection(() -> new TreeSet((o1, o2) -> Comparing.compare((Object)o1.getValueDescriptor(), (Object)o2.getValueDescriptor(), (Comparator)new CssParameterInfoValueDescriptorComparator()))))).isEmpty()) {
            context.setItemsToShow(ArrayUtil.toObjectArray((Collection)uniqueDescriptors));
        }
        return element;
    }

    public void showParameterInfo(@NotNull CssValueOwner element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextOffset() + 1, (ParameterInfoHandler)this);
    }

    public CssValueOwner findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        PsiElement declaration;
        CssValueOwner element;
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if ((element = CssParameterInfoHandler.findElement(context.getFile(), context.getOffset())) != null && ((declaration = context.getParameterOwner()) == null || declaration == element)) {
            return element;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull CssValueOwner valueOwner, @NotNull UpdateParameterInfoContext context) {
        if (valueOwner == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(5);
        }
        context.setParameterOwner((PsiElement)valueOwner);
        context.setCurrentParameter(context.getOffset());
    }

    public void updateUI(CssValueOwnerDescriptor elementDescriptor, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(6);
        }
        CssParameterInfoHandler.updateUIText(elementDescriptor, context);
    }

    @Nullable
    public static String updateUIText(CssValueOwnerDescriptor elementDescriptor, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(7);
        }
        PsiElement parameterOwner = context.getParameterOwner();
        CssValueDescriptor highlightingDescriptor = null;
        if (parameterOwner instanceof CssValueOwner) {
            CssValueMatchData deepestNotMatchedData;
            CssValueMatchData matchData;
            CssTermList valueElement = ((CssValueOwner)parameterOwner).getValue();
            if (valueElement != null && valueElement.isValid() && (highlightingDescriptor = CssParameterInfoHandler.findHighlightingDescriptor(context, valueElement, matchData = valueElement.matchWithValueDescriptor(elementDescriptor.getValueDescriptor()))) == null && (deepestNotMatchedData = matchData.findDeepestNotMatchedData()) != null) {
                highlightingDescriptor = deepestNotMatchedData.getDescriptor();
            }
            boolean strikeout = elementDescriptor.getValueDescriptor().getObsoleteVersion() != null;
            CssParameterInfoValueDescriptorsVisitor parameterInfoBuilder = new CssParameterInfoValueDescriptorsVisitor(highlightingDescriptor, false, false);
            elementDescriptor.getValueDescriptor().accept(parameterInfoBuilder);
            String parameterInfoString = parameterInfoBuilder.getParameterInfo();
            int highlightStartOffset = parameterInfoBuilder.getHighlightingStart();
            int highlightEndOffset = parameterInfoBuilder.getHighlightingEnd();
            return context.setupUIComponentPresentation(parameterInfoString, highlightStartOffset, highlightEndOffset, false, strikeout, false, context.getDefaultParameterColor());
        }
        return null;
    }

    @Nullable
    private static CssValueDescriptor findHighlightingDescriptor(@NotNull ParameterInfoUIContext context, @NotNull CssTermList valueElement, @NotNull CssValueMatchData matchData) {
        PsiElement prevVisibleLeaf;
        IElementType elementType;
        ASTNode nextVisibleLeafNode;
        PsiElement nextVisibleLeaf;
        if (context == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (valueElement == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if (matchData == null) {
            CssParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (context.getCurrentParameterIndex() < 0) {
            return null;
        }
        PsiElement elementAt = valueElement.getContainingFile().findElementAt(context.getCurrentParameterIndex());
        if (elementAt == null) {
            return null;
        }
        ASTNode node = elementAt.getNode();
        if (node == null) {
            return null;
        }
        if (elementAt instanceof PsiWhiteSpace && (nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)elementAt)) != null && (nextVisibleLeafNode = nextVisibleLeaf.getNode()) != null && !CssElementTypes.PUNCTUATION.contains(elementType = nextVisibleLeafNode.getElementType()) && (node = (elementAt = nextVisibleLeaf).getNode()) == null) {
            return null;
        }
        IElementType elementType2 = node.getElementType();
        if ((elementType2 == CssElementTypes.CSS_SEMICOLON || CssElementTypes.PUNCTUATION.contains(elementType2)) && (prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)elementAt)) != null && !CssElementTypes.PUNCTUATION.contains(prevVisibleLeaf.getNode().getElementType())) {
            elementAt = prevVisibleLeaf;
        }
        CssValueDescriptor result = null;
        while (elementAt != null && (result = matchData.findDeepestDescriptorForElement(elementAt)) == null) {
            elementAt = elementAt.getParent();
        }
        return result;
    }

    @Nullable
    private static CssValueOwner findElement(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            CssValueOwner valueOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssValueOwner.class);
            if (valueOwner == null && psiElement instanceof PsiWhiteSpace) {
                PsiElement prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)psiElement);
                return prevVisibleLeaf != null ? CssParameterInfoHandler.findElement(file, prevVisibleLeaf.getTextRange().getStartOffset()) : null;
            }
            if (valueOwner != null) {
                CssValueOwner parentOwner;
                if (!valueOwner.getValueTextRange().containsOffset(offset) && (parentOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)valueOwner, CssValueOwner.class)) != null) {
                    return parentOwner;
                }
                return valueOwner;
            }
            return (CssValueOwner)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psiElement, CssValueOwner.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUIText";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findHighlightingDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

