/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.backend;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.sql.dialects.redis.RedisDialect;
import com.intellij.sql.dialects.redis.psi.RedisUpsertStatement;
import com.intellij.sql.dialects.redis.psi.stubs.RedisDmlNameIndexConstants;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlResolveExtension;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SmartHashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class RedisResolveExtension
implements SqlResolveExtension {
    @Override
    public boolean process(@NotNull SqlReference reference, @NotNull SqlScopeProcessor processor) {
        if (reference == null) {
            RedisResolveExtension.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            RedisResolveExtension.$$$reportNull$$$0(1);
        }
        if ((processor.isResultEmpty() || processor.getReferenceName() == null) && processor.getDialect() instanceof RedisDialect) {
            PsiFile file = reference.getElement().getContainingFile().getOriginalFile();
            Project project = file.getProject();
            GlobalSearchScope searchScope = GlobalSearchScope.fileScope((PsiFile)file);
            ResolveState resolveState = ResolveState.initial();
            boolean isCompletion = processor.getReferenceName() == null;
            boolean isDumb = DumbService.getInstance((Project)project).isDumb();
            if (isDumb) {
                JBIterable statements2 = SqlImplUtil.sqlChildren((PsiElement)file).filter(RedisUpsertStatement.class);
                if (!isCompletion) {
                    statements2 = statements2.filter(s -> s.getName().equalsIgnoreCase(processor.getReferenceName()));
                }
                return RedisResolveExtension.processNoIndexes(processor, (JBIterable<RedisUpsertStatement>)statements2, resolveState);
            }
            if (isCompletion) {
                String name2;
                Iterator iterator = StubIndex.getInstance().getAllKeys(RedisDmlNameIndexConstants.KEY, project).iterator();
                while (iterator.hasNext() && RedisResolveExtension.process(name2 = (String)iterator.next(), processor, project, searchScope, resolveState)) {
                }
            } else if (processor.isResultEmpty() && RedisResolveExtension.process(processor.getReferenceName(), processor, project, searchScope, resolveState)) {
                return false;
            }
        }
        return true;
    }

    private static boolean process(@NotNull String name2, @NotNull SqlScopeProcessor processor, @NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull ResolveState resolveState) {
        if (name2 == null) {
            RedisResolveExtension.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            RedisResolveExtension.$$$reportNull$$$0(3);
        }
        if (project == null) {
            RedisResolveExtension.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RedisResolveExtension.$$$reportNull$$$0(5);
        }
        if (resolveState == null) {
            RedisResolveExtension.$$$reportNull$$$0(6);
        }
        SmartHashSet processedNames = new SmartHashSet();
        return StubIndex.getInstance().processElements(RedisDmlNameIndexConstants.KEY, (Object)name2, project, searchScope, RedisUpsertStatement.class, arg_0 -> RedisResolveExtension.lambda$process$1((Set)processedNames, processor, resolveState, arg_0));
    }

    private static boolean processNoIndexes(@NotNull SqlScopeProcessor processor, @NotNull JBIterable<RedisUpsertStatement> statements2, @NotNull ResolveState resolveState) {
        if (processor == null) {
            RedisResolveExtension.$$$reportNull$$$0(7);
        }
        if (statements2 == null) {
            RedisResolveExtension.$$$reportNull$$$0(8);
        }
        if (resolveState == null) {
            RedisResolveExtension.$$$reportNull$$$0(9);
        }
        SmartHashSet processedNames = new SmartHashSet();
        for (RedisUpsertStatement statement : statements2) {
            if (!processedNames.add(statement.getName())) {
                return true;
            }
            if (processor.executeTarget(statement, null, false, resolveState)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$process$1(Set processedNames, SqlScopeProcessor processor, ResolveState resolveState, RedisUpsertStatement statement) {
        if (!processedNames.add(statement.getName())) {
            return true;
        }
        return processor.executeTarget(statement, null, false, resolveState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/redis/backend/RedisResolveExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processNoIndexes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

