/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.refactoring.extractFunction.RefInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import com.intellij.sql.refactoring.extractFunction.SqlOriginalParameterInfo;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#\u00a8\u0006%"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "", "originalExpression", "Lcom/intellij/sql/psi/SqlExpression;", "container", "Lcom/intellij/sql/psi/SqlElement;", "<init>", "(Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlElement;)V", "getOriginalExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "getContainer", "()Lcom/intellij/sql/psi/SqlElement;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "parameterInfos", "", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "getParameterInfos", "()Ljava/util/Collection;", "virtualExpression", "getVirtualExpression", "detectArgumentDirection", "Lcom/intellij/database/model/ArgumentDirection;", "expression", "computeParameterKey", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "isTableFunction", "", "()Z", "isQuery", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExtractableCodeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExtractableCodeInfo.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,200:1\n382#2,7:201\n*S KotlinDebug\n*F\n+ 1 SqlExtractableCodeInfo.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo\n*L\n91#1:201,7\n*E\n"})
public final class SqlExtractableCodeInfo {
    @NotNull
    private final SqlExpression originalExpression;
    @NotNull
    private final SqlElement container;
    @NotNull
    private final Project project;
    @NotNull
    private final SqlLanguageDialectEx dialect;
    @NotNull
    private final Collection<SqlExtractableParameterInfo> parameterInfos;
    @NotNull
    private final SqlExpression virtualExpression;

    public SqlExtractableCodeInfo(@NotNull SqlExpression originalExpression, @NotNull SqlElement container) {
        Intrinsics.checkNotNullParameter((Object)originalExpression, (String)"originalExpression");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.originalExpression = originalExpression;
        this.container = container;
        Project project = this.container.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)this.container);
        SqlExtractableCodeInfoKt.access$processReferences(this.originalExpression, SqlExtractableCodeInfo::_init_$lambda$0);
        LinkedHashMap parameterInfos = new LinkedHashMap();
        HashSet usedNames = new HashSet();
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
        SqlPsiFacade psiFacade = sqlPsiFacade;
        SqlCodeFragment sqlCodeFragment = psiFacade.createExpressionFragment(this.dialect, null, null, "1", false, false);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createExpressionFragment(...)");
        SqlCodeFragment codeFragment = sqlCodeFragment;
        codeFragment.setContext((PsiElement)this.container);
        PsiElement psiElement = codeFragment.getFirstChild().replace((PsiElement)this.originalExpression);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlExpression");
        this.virtualExpression = (SqlExpression)psiElement;
        SqlExtractableCodeInfoKt.access$processReferences(this.virtualExpression, arg_0 -> SqlExtractableCodeInfo._init_$lambda$2(usedNames, this, parameterInfos, arg_0));
        Collection collection = parameterInfos.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        this.parameterInfos = CollectionsKt.toList((Iterable)collection);
    }

    @NotNull
    public final SqlExpression getOriginalExpression() {
        return this.originalExpression;
    }

    @NotNull
    public final SqlElement getContainer() {
        return this.container;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    @NotNull
    public final Collection<SqlExtractableParameterInfo> getParameterInfos() {
        return this.parameterInfos;
    }

    @NotNull
    public final SqlExpression getVirtualExpression() {
        return this.virtualExpression;
    }

    private final ArgumentDirection detectArgumentDirection(SqlExpression expression) {
        ArgumentDirection inDirection = ArgumentDirection.IN;
        if (!(expression instanceof SqlReferenceExpression)) {
            return inDirection;
        }
        PsiElement parent = ((SqlReferenceExpression)expression).getParent();
        if (!(parent instanceof SqlNamedParameterValueExpression) && !(parent instanceof SqlExpressionList)) {
            return inDirection;
        }
        DasArgument dasArgument = SqlPsiUtilCoreKt.findParameterDefinition(expression);
        Object object = dasArgument;
        if (object == null || (object = object.getArgumentDirection()) == null) {
            object = inDirection;
        }
        return object;
    }

    private final Object computeParameterKey(SqlReferenceExpression expression) {
        SqlExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null && !(qualifierExpression instanceof SqlReferenceExpression)) {
            return expression;
        }
        List<Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified(expression);
        Intrinsics.checkNotNullExpressionValue(list, (String)"resolveQualified(...)");
        return CollectionsKt.firstOrNull(list);
    }

    public final boolean isTableFunction() {
        return this.originalExpression.getDasType() instanceof SqlTableType;
    }

    public final boolean isQuery() {
        return this.originalExpression instanceof SqlQueryExpression || this.originalExpression instanceof SqlSetOperatorExpression;
    }

    private static final Unit _init_$lambda$0(SqlReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.resolve();
        PsiNamedElement psiNamedElement = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        if (psiNamedElement == null) {
            return Unit.INSTANCE;
        }
        PsiNamedElement target2 = psiNamedElement;
        if (target2.getName() == null) {
            return Unit.INSTANCE;
        }
        Key key2 = SqlExtractableCodeInfoKt.access$getREF_INFO$p();
        DasType dasType = it.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        it.putCopyableUserData(key2, new RefInfo(target2, it, dasType));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$2(HashSet $usedNames, SqlExtractableCodeInfo this$0, LinkedHashMap $parameterInfos, SqlReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RefInfo refInfo = (RefInfo)it.getCopyableUserData(SqlExtractableCodeInfoKt.access$getREF_INFO$p());
        if (refInfo == null) {
            return Unit.INSTANCE;
        }
        RefInfo refInfo2 = refInfo;
        it.putCopyableUserData(SqlExtractableCodeInfoKt.access$getREF_INFO$p(), null);
        String string = refInfo2.getDefinition().getName();
        if (string == null) {
            return Unit.INSTANCE;
        }
        String defName = string;
        String string2 = SqlNamesGenerator.suggestUniqueName(defName, $usedNames);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suggestUniqueName(...)");
        String paramName = string2;
        if (!this$0.isQuery() && Intrinsics.areEqual((Object)it.getReferenceElementType().getTargetKind(), (Object)ObjectKind.COLUMN) || !Intrinsics.areEqual((Object)it.resolve(), (Object)refInfo2.getDefinition())) {
            Object object;
            void $this$getOrPut$iv;
            Object object2 = this$0.computeParameterKey(refInfo2.getOriginalExpression());
            if (object2 == null) {
                return Unit.INSTANCE;
            }
            Object key2 = object2;
            ArgumentDirection direction = this$0.detectArgumentDirection(refInfo2.getOriginalExpression());
            Map map = $parameterInfos;
            Object key$iv = key2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                SqlExtractableParameterInfo answer$iv = new SqlOriginalParameterInfo(paramName, refInfo2.getDefinition(), refInfo2.getOriginalExpression(), refInfo2.getDasType(), direction);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            SqlExtractableParameterInfo paramInfo = (SqlExtractableParameterInfo)object;
            it.putCopyableUserData(SqlExtractableCodeInfoKt.access$getPARAM_OCCURRENCE$p(), paramInfo);
            ((Collection)$usedNames).add(paramName);
        }
        return Unit.INSTANCE;
    }
}

