/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import org.locationtech.jts.io.InStream;

public class ByteArrayInStream
implements InStream {
    private byte[] buffer;
    private int position;

    public ByteArrayInStream(byte[] buffer) {
        this.setBytes(buffer);
    }

    public void setBytes(byte[] buffer) {
        this.buffer = buffer;
        this.position = 0;
    }

    @Override
    public int read(byte[] buf) {
        int numToRead = buf.length;
        if (this.position + numToRead > this.buffer.length) {
            numToRead = this.buffer.length - this.position;
            System.arraycopy(this.buffer, this.position, buf, 0, numToRead);
            for (int i2 = numToRead; i2 < buf.length; ++i2) {
                buf[i2] = 0;
            }
        } else {
            System.arraycopy(this.buffer, this.position, buf, 0, numToRead);
        }
        this.position += numToRead;
        return numToRead;
    }
}

