/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseConfigValidator<T> {
    public static final ExtensionPointName<DatabaseConfigValidator<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.configValidator");
    private static final Logger LOG = Logger.getInstance(DatabaseConfigValidator.class);

    public static Set<DataSourceProblem> getProblems(@NotNull Project project, @NotNull String dataSourceName, @NotNull Object target, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(0);
        }
        if (dataSourceName == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(1);
        }
        if (target == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(2);
        }
        LinkedHashSet<DataSourceProblem> result = new LinkedHashSet<DataSourceProblem>();
        Consumer consumer = e -> result.add((DataSourceProblem)e);
        for (DatabaseConfigValidator extension : EP_NAME.getExtensionList()) {
            DatabaseConfigValidator.collectProblems(project, extension, dataSourceName, target, (Consumer<? super DataSourceProblem>)consumer, configInfoProvider);
        }
        return result;
    }

    private static <T> void collectProblems(@NotNull Project project, @NotNull DatabaseConfigValidator<T> extension, @NotNull String dataSourceName, @NotNull Object target, @NotNull Consumer<? super DataSourceProblem> consumer, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(3);
        }
        if (extension == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(4);
        }
        if (dataSourceName == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(5);
        }
        if (target == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            DatabaseConfigValidator.$$$reportNull$$$0(7);
        }
        try {
            Object t = ObjectUtils.tryCast((Object)target, extension.getTargetClass());
            if (t != null) {
                extension.collectProblems(project, t, consumer, configInfoProvider);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            String targetName = target.toString();
            String extensionName = extension.getClass().getName();
            String exceptionName = e.getClass().getName();
            String exceptionMessage = e.getMessage();
            String message = String.format("Error when validating data source \"%s\":\n\tfailed to check object \"%s\"\n\tusing extension class \"%s\",\n\tthe exception class: \"%s\",\n\tmessage: \"%s\".\n", dataSourceName, targetName, extensionName, exceptionName, exceptionMessage);
            LOG.error(message, (Throwable)e);
        }
    }

    public abstract Class<? extends T> getTargetClass();

    public abstract void collectProblems(@NotNull Project var1, @NotNull T var2, @NotNull Consumer<? super DataSourceProblem> var3, @Nullable ActualConfigInfoProvider var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseConfigValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProblems";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

