/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.cassandra.CassDdlParsing;
import com.intellij.sql.dialects.cassandra.CassDialect;
import com.intellij.sql.dialects.cassandra.CassDmlParsing;
import com.intellij.sql.dialects.cassandra.CassExpressionParsing;
import com.intellij.sql.dialects.cassandra.CassGeneratedParser;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public class CassParser
extends SqlParser {
    public CassParser() {
        super((SqlLanguageDialectEx)CassDialect.INSTANCE);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return CassGeneratedParser.statement(builder, level);
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    protected TokenSet[] getExtendsTokenSets() {
        return CassGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return CassDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return CassDdlParsing.type_element(builder, level);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, CassExpressionParsing::evaluable_expression);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return (root == CassTypes.CASS_BLOCK_STATEMENT || root == CassTypes.CASS_TABLE_ELEMENT_LIST) && CassGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = CassExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return CassDdlParsing.table_index_column_list(builder, level);
    }
}

