/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ImportHandler {
    public static final String DEFAULT_EXPORT_NAMESPACE = "default";
    private static final Key<ParameterizedCachedValue<ES6ExportCache, PsiElement>> CACHED_VALUE_KEY = Key.create((String)"es6.exported.names.cache");
    private static final ParameterizedCachedValueProvider<ES6ExportCache, PsiElement> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<ES6ExportCache, PsiElement>(){

        public CachedValueProvider.Result<ES6ExportCache> compute(PsiElement fileOrModule) {
            ES6ExportCache result2 = 1.calcExportSpecifiersAndDefaults(JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(fileOrModule));
            return new CachedValueProvider.Result((Object)result2, new Object[]{fileOrModule});
        }

        @NotNull
        private static ES6ExportCache calcExportSpecifiersAndDefaults(Stream<? extends PsiElement> fileElements) {
            HashSet<String> namedExports = new HashSet<String>();
            String exportDefault = null;
            String exportAssignment = null;
            boolean hasExportStatements = false;
            Iterator it = fileElements.iterator();
            while (it.hasNext()) {
                PsiElement psi = (PsiElement)it.next();
                if (psi instanceof ES6ExportDeclaration) {
                    hasExportStatements = true;
                    for (ES6ExportSpecifier exportSpecifier : ((ES6ExportDeclaration)psi).getExportSpecifiers()) {
                        String referenceName = exportSpecifier.getReferenceName();
                        ES6ExportSpecifierAlias alias = exportSpecifier.getAlias();
                        if (referenceName != null && alias == null) {
                            namedExports.add(referenceName);
                        }
                        if (referenceName == null || !exportSpecifier.isExportDefault()) continue;
                        exportDefault = referenceName;
                    }
                    continue;
                }
                if (!(psi instanceof JSExportAssignment)) continue;
                hasExportStatements = true;
                String initializerReference = ((JSExportAssignment)psi).getInitializerReference();
                if (initializerReference == null) continue;
                if (psi instanceof ES6ExportDefaultAssignment) {
                    exportDefault = initializerReference;
                    continue;
                }
                exportAssignment = initializerReference;
            }
            return new ES6ExportCache(exportDefault, exportAssignment, namedExports, hasExportStatements);
        }
    };

    public static boolean isExported(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(0);
        }
        return element2 instanceof JSElementBase ? ((JSElementBase)element2).isExported() : ES6ImportHandler.calculateIsExported(element2);
    }

    public static boolean isExportedWithNameOrDefault(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(1);
        }
        return ES6ImportHandler.isExported(element2) || ES6ImportHandler.isExportedWithDefault(element2);
    }

    public static boolean isExportedWithNameOrDefaultOrAssignment(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(2);
        }
        return ES6ImportHandler.isExported(element2) || ES6ImportHandler.calculateIsExportedWithDefaultOrAssignment(element2);
    }

    public static boolean checkExportedWithDefaultOrCalculate(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof JSElementBase) {
            return ((JSElementBase)element2).isExportedWithDefault();
        }
        return ES6ImportHandler.calculateIsExportedWithDefaultOrAssignment(element2);
    }

    public static boolean checkExportedOrCalculate(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof JSElementBase) {
            return ((JSElementBase)element2).isExported();
        }
        return ES6ImportHandler.calculateIsExported(element2);
    }

    public static boolean isExportedWithDefault(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(3);
        }
        if (element2.getContext() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element2, true, true);
    }

    public static boolean calculateIsExportedWithDefaultOrAssignment(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(4);
        }
        if (element2 instanceof JSField || element2 instanceof JSParameter || element2 instanceof JSProperty || element2 instanceof JSDefinitionExpression || element2 instanceof JSTypeDeclaration || element2 instanceof TypeScriptTypeMember) {
            return false;
        }
        if (element2.getContext() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (element2 instanceof JSExpression) {
            return false;
        }
        return ES6ImportHandler.isExportedViaStatement(element2, true, false);
    }

    public static boolean isExportedDirectly(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(5);
        }
        if (element2 instanceof JSField || element2 instanceof JSParameter || element2 instanceof JSExpression || element2 instanceof JSProperty || element2 instanceof JSTypeDeclaration || element2 instanceof TypeScriptTypeMember) {
            return false;
        }
        if (element2 instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element2).getAttributeList();
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                return true;
            }
            if (TypeScriptModule.isImplicitExportAvailable(element2)) {
                PsiElement parent = JSResolveUtil.findParent(element2);
                if (TypeScriptResolveHelper.isGlobalModuleAugmentation(element2)) {
                    return false;
                }
                if (TypeScriptPsiUtil.hasImplicitExportForDeclarations(parent)) {
                    return true;
                }
                if (parent instanceof JSFile) {
                    JSFile file = (JSFile)parent;
                    if (DialectDetector.isTypeScript(element2) && !file.isCommonJSModule()) {
                        return false;
                    }
                }
            }
        }
        return element2 instanceof ES6ExportSpecifierAlias || element2 instanceof ES6ExportedDefaultBinding;
    }

    public static boolean calculateIsExported(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(6);
        }
        return ES6ImportHandler.isExportedDirectly(element2) || ES6ImportHandler.isExportedViaStatement(element2, false, false);
    }

    public static boolean isExternalModuleExport(@NotNull JSElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(7);
        }
        if (!(element2 instanceof JSElementBase)) {
            return false;
        }
        if (!((JSElementBase)((Object)element2)).isExported()) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)element2)) {
            return ES6ImportHandler.isExported((PsiElement)element2);
        }
        if (element2 instanceof ES6ExportSpecifierAlias) {
            return true;
        }
        if (element2 instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element2).getAttributeList();
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                return true;
            }
            JSExecutionScope module = ES6ImportHandler.getOwnerExternalModule((PsiElement)element2);
            if (module instanceof TypeScriptModule) {
                return true;
            }
        }
        return ES6ImportHandler.isExportedViaStatement((PsiElement)element2, false, false);
    }

    public static JSExecutionScope getOwnerExternalModule(@NotNull PsiElement element2) {
        PsiElement parent;
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(8);
        }
        if ((parent = element2.getContext()) instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        return parent instanceof JSFile && ((JSFile)parent).isCommonJSModule() || parent instanceof TypeScriptModule && !((TypeScriptModule)parent).isInternal() ? (JSExecutionScope)parent : null;
    }

    private static boolean isExportedViaStatement(@NotNull PsiElement element2, boolean checkDefaultAndAssignment, boolean defaultOnly) {
        String name;
        ES6ExportCache exportedNames;
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(9);
        }
        ES6ExportCache eS6ExportCache = exportedNames = (name = ES6ImportHandler.getName(element2)) != null ? ES6ImportHandler.getExportedViaStatementCache(element2) : null;
        if (exportedNames == null) {
            return false;
        }
        if (checkDefaultAndAssignment) {
            if (name.equals(exportedNames.myExportDefault)) {
                return true;
            }
            if (defaultOnly) {
                return false;
            }
            return name.equals(exportedNames.myExportAssignment);
        }
        return exportedNames.myNamedExports.contains(name);
    }

    @Nullable
    private static String getName(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(10);
        }
        return element2 instanceof ES6ImportSpecifier ? ((ES6ImportSpecifier)element2).getReferenceName() : (element2 instanceof JSElement ? ((JSElement)element2).getName() : null);
    }

    @Nullable
    private static ES6ExportCache getExportedViaStatementCache(@NotNull PsiElement element2) {
        JSElement scope2;
        if (element2 == null) {
            ES6ImportHandler.$$$reportNull$$$0(11);
        }
        if ((scope2 = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)element2, (boolean)true, (Class[])new Class[]{JSExecutionScope.class, JSClass.class})) instanceof JSFunction || scope2 instanceof JSClass || scope2 == null) {
            return null;
        }
        Object fileOrModule = element2 instanceof JSFile ? element2 : ES6PsiUtil.getNonStrictExportScope((PsiElement)scope2);
        return ES6ImportHandler.getExportedCacheForModule(fileOrModule);
    }

    @Nullable
    public static ES6ExportCache getExportedCacheForModule(@Nullable PsiElement fileOrModule) {
        if (fileOrModule == null || !ES6PsiUtil.isExternalModule(fileOrModule)) {
            return null;
        }
        return (ES6ExportCache)CachedValuesManager.getManager((Project)fileOrModule.getProject()).getParameterizedCachedValue((UserDataHolder)fileOrModule, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)fileOrModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExported";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedWithNameOrDefault";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedWithNameOrDefaultOrAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedWithDefault";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateIsExportedWithDefaultOrAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedDirectly";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateIsExported";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isExternalModuleExport";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getOwnerExternalModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedViaStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getExportedViaStatementCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ES6ExportCache {
        @Nullable
        private final String myExportDefault;
        @Nullable
        private final String myExportAssignment;
        @NotNull
        private final Set<String> myNamedExports;
        private final boolean myHasExportStatements;

        private ES6ExportCache(@Nullable String exportDefault, @Nullable String exportAssignment, @NotNull Set<String> exports, boolean hasExportStatements) {
            if (exports == null) {
                ES6ExportCache.$$$reportNull$$$0(0);
            }
            this.myExportDefault = exportDefault;
            this.myExportAssignment = exportAssignment;
            this.myNamedExports = exports;
            this.myHasExportStatements = hasExportStatements;
        }

        public boolean hasExportStatements() {
            return this.myHasExportStatements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exports", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler$ES6ExportCache", "<init>"));
        }
    }
}

