# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit flag-o-matic toolchain-funcs

DESCRIPTION="Tool for recovering passwords and content from PDF-files"
HOMEPAGE="http://pdfcrack.sourceforge.net/"
SRC_URI="https://downloads.sourceforge.net/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~ppc ~x86"

PATCHES=(
	"${FILESDIR}/${PN}-0.14-cflags.patch"
)

src_prepare() {
	append-cflags -std=gnu17
	default
}

src_compile() {
	emake CC="$(tc-getCC)"
}

src_install() {
	dobin pdfcrack
	dodoc changelog README
}
