﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/timestream-influxdb/TimestreamInfluxDB_EXPORTS.h>
#include <aws/timestream-influxdb/model/ClusterDeploymentType.h>
#include <aws/timestream-influxdb/model/ClusterStatus.h>
#include <aws/timestream-influxdb/model/DbInstanceType.h>
#include <aws/timestream-influxdb/model/DbStorageType.h>
#include <aws/timestream-influxdb/model/EngineType.h>
#include <aws/timestream-influxdb/model/FailoverMode.h>
#include <aws/timestream-influxdb/model/LogDeliveryConfiguration.h>
#include <aws/timestream-influxdb/model/NetworkType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace TimestreamInfluxDB {
namespace Model {
class GetDbClusterResult {
 public:
  AWS_TIMESTREAMINFLUXDB_API GetDbClusterResult() = default;
  AWS_TIMESTREAMINFLUXDB_API GetDbClusterResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TIMESTREAMINFLUXDB_API GetDbClusterResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Service-generated unique identifier of the DB cluster to retrieve.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetDbClusterResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Customer-supplied name of the Timestream for InfluxDB cluster.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetDbClusterResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the DB cluster.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetDbClusterResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the DB cluster.</p>
   */
  inline ClusterStatus GetStatus() const { return m_status; }
  inline void SetStatus(ClusterStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetDbClusterResult& WithStatus(ClusterStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The endpoint used to connect to the Timestream for InfluxDB cluster for write
   * and read operations.</p>
   */
  inline const Aws::String& GetEndpoint() const { return m_endpoint; }
  template <typename EndpointT = Aws::String>
  void SetEndpoint(EndpointT&& value) {
    m_endpointHasBeenSet = true;
    m_endpoint = std::forward<EndpointT>(value);
  }
  template <typename EndpointT = Aws::String>
  GetDbClusterResult& WithEndpoint(EndpointT&& value) {
    SetEndpoint(std::forward<EndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The endpoint used to connect to the Timestream for InfluxDB cluster for
   * read-only operations.</p>
   */
  inline const Aws::String& GetReaderEndpoint() const { return m_readerEndpoint; }
  template <typename ReaderEndpointT = Aws::String>
  void SetReaderEndpoint(ReaderEndpointT&& value) {
    m_readerEndpointHasBeenSet = true;
    m_readerEndpoint = std::forward<ReaderEndpointT>(value);
  }
  template <typename ReaderEndpointT = Aws::String>
  GetDbClusterResult& WithReaderEndpoint(ReaderEndpointT&& value) {
    SetReaderEndpoint(std::forward<ReaderEndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The port number on which InfluxDB accepts connections.</p>
   */
  inline int GetPort() const { return m_port; }
  inline void SetPort(int value) {
    m_portHasBeenSet = true;
    m_port = value;
  }
  inline GetDbClusterResult& WithPort(int value) {
    SetPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Deployment type of the DB cluster.</p>
   */
  inline ClusterDeploymentType GetDeploymentType() const { return m_deploymentType; }
  inline void SetDeploymentType(ClusterDeploymentType value) {
    m_deploymentTypeHasBeenSet = true;
    m_deploymentType = value;
  }
  inline GetDbClusterResult& WithDeploymentType(ClusterDeploymentType value) {
    SetDeploymentType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Timestream for InfluxDB instance type that InfluxDB runs on.</p>
   */
  inline DbInstanceType GetDbInstanceType() const { return m_dbInstanceType; }
  inline void SetDbInstanceType(DbInstanceType value) {
    m_dbInstanceTypeHasBeenSet = true;
    m_dbInstanceType = value;
  }
  inline GetDbClusterResult& WithDbInstanceType(DbInstanceType value) {
    SetDbInstanceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the network type of the Timestream for InfluxDB cluster is
   * IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
   * communicate over both IPv4 and IPv6 protocols.</p>
   */
  inline NetworkType GetNetworkType() const { return m_networkType; }
  inline void SetNetworkType(NetworkType value) {
    m_networkTypeHasBeenSet = true;
    m_networkType = value;
  }
  inline GetDbClusterResult& WithNetworkType(NetworkType value) {
    SetNetworkType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Timestream for InfluxDB DB storage type that InfluxDB stores data on.</p>
   */
  inline DbStorageType GetDbStorageType() const { return m_dbStorageType; }
  inline void SetDbStorageType(DbStorageType value) {
    m_dbStorageTypeHasBeenSet = true;
    m_dbStorageType = value;
  }
  inline GetDbClusterResult& WithDbStorageType(DbStorageType value) {
    SetDbStorageType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The amount of storage allocated for your DB storage type (in gibibytes).</p>
   */
  inline int GetAllocatedStorage() const { return m_allocatedStorage; }
  inline void SetAllocatedStorage(int value) {
    m_allocatedStorageHasBeenSet = true;
    m_allocatedStorage = value;
  }
  inline GetDbClusterResult& WithAllocatedStorage(int value) {
    SetAllocatedStorage(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The engine type of your DB cluster.</p>
   */
  inline EngineType GetEngineType() const { return m_engineType; }
  inline void SetEngineType(EngineType value) {
    m_engineTypeHasBeenSet = true;
    m_engineType = value;
  }
  inline GetDbClusterResult& WithEngineType(EngineType value) {
    SetEngineType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates if the DB cluster has a public IP to facilitate access from outside
   * the VPC.</p>
   */
  inline bool GetPubliclyAccessible() const { return m_publiclyAccessible; }
  inline void SetPubliclyAccessible(bool value) {
    m_publiclyAccessibleHasBeenSet = true;
    m_publiclyAccessible = value;
  }
  inline GetDbClusterResult& WithPubliclyAccessible(bool value) {
    SetPubliclyAccessible(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the DB parameter group assigned to your DB cluster.</p>
   */
  inline const Aws::String& GetDbParameterGroupIdentifier() const { return m_dbParameterGroupIdentifier; }
  template <typename DbParameterGroupIdentifierT = Aws::String>
  void SetDbParameterGroupIdentifier(DbParameterGroupIdentifierT&& value) {
    m_dbParameterGroupIdentifierHasBeenSet = true;
    m_dbParameterGroupIdentifier = std::forward<DbParameterGroupIdentifierT>(value);
  }
  template <typename DbParameterGroupIdentifierT = Aws::String>
  GetDbClusterResult& WithDbParameterGroupIdentifier(DbParameterGroupIdentifierT&& value) {
    SetDbParameterGroupIdentifier(std::forward<DbParameterGroupIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Configuration for sending InfluxDB engine logs to send to specified S3
   * bucket.</p>
   */
  inline const LogDeliveryConfiguration& GetLogDeliveryConfiguration() const { return m_logDeliveryConfiguration; }
  template <typename LogDeliveryConfigurationT = LogDeliveryConfiguration>
  void SetLogDeliveryConfiguration(LogDeliveryConfigurationT&& value) {
    m_logDeliveryConfigurationHasBeenSet = true;
    m_logDeliveryConfiguration = std::forward<LogDeliveryConfigurationT>(value);
  }
  template <typename LogDeliveryConfigurationT = LogDeliveryConfiguration>
  GetDbClusterResult& WithLogDeliveryConfiguration(LogDeliveryConfigurationT&& value) {
    SetLogDeliveryConfiguration(std::forward<LogDeliveryConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Secrets Manager secret containing the
   * initial InfluxDB authorization parameters. The secret value is a JSON formatted
   * key-value pair holding InfluxDB authorization values: organization, bucket,
   * username, and password.</p>
   */
  inline const Aws::String& GetInfluxAuthParametersSecretArn() const { return m_influxAuthParametersSecretArn; }
  template <typename InfluxAuthParametersSecretArnT = Aws::String>
  void SetInfluxAuthParametersSecretArn(InfluxAuthParametersSecretArnT&& value) {
    m_influxAuthParametersSecretArnHasBeenSet = true;
    m_influxAuthParametersSecretArn = std::forward<InfluxAuthParametersSecretArnT>(value);
  }
  template <typename InfluxAuthParametersSecretArnT = Aws::String>
  GetDbClusterResult& WithInfluxAuthParametersSecretArn(InfluxAuthParametersSecretArnT&& value) {
    SetInfluxAuthParametersSecretArn(std::forward<InfluxAuthParametersSecretArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of VPC subnet IDs associated with the DB cluster.</p>
   */
  inline const Aws::Vector<Aws::String>& GetVpcSubnetIds() const { return m_vpcSubnetIds; }
  template <typename VpcSubnetIdsT = Aws::Vector<Aws::String>>
  void SetVpcSubnetIds(VpcSubnetIdsT&& value) {
    m_vpcSubnetIdsHasBeenSet = true;
    m_vpcSubnetIds = std::forward<VpcSubnetIdsT>(value);
  }
  template <typename VpcSubnetIdsT = Aws::Vector<Aws::String>>
  GetDbClusterResult& WithVpcSubnetIds(VpcSubnetIdsT&& value) {
    SetVpcSubnetIds(std::forward<VpcSubnetIdsT>(value));
    return *this;
  }
  template <typename VpcSubnetIdsT = Aws::String>
  GetDbClusterResult& AddVpcSubnetIds(VpcSubnetIdsT&& value) {
    m_vpcSubnetIdsHasBeenSet = true;
    m_vpcSubnetIds.emplace_back(std::forward<VpcSubnetIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of VPC security group IDs associated with the DB cluster.</p>
   */
  inline const Aws::Vector<Aws::String>& GetVpcSecurityGroupIds() const { return m_vpcSecurityGroupIds; }
  template <typename VpcSecurityGroupIdsT = Aws::Vector<Aws::String>>
  void SetVpcSecurityGroupIds(VpcSecurityGroupIdsT&& value) {
    m_vpcSecurityGroupIdsHasBeenSet = true;
    m_vpcSecurityGroupIds = std::forward<VpcSecurityGroupIdsT>(value);
  }
  template <typename VpcSecurityGroupIdsT = Aws::Vector<Aws::String>>
  GetDbClusterResult& WithVpcSecurityGroupIds(VpcSecurityGroupIdsT&& value) {
    SetVpcSecurityGroupIds(std::forward<VpcSecurityGroupIdsT>(value));
    return *this;
  }
  template <typename VpcSecurityGroupIdsT = Aws::String>
  GetDbClusterResult& AddVpcSecurityGroupIds(VpcSecurityGroupIdsT&& value) {
    m_vpcSecurityGroupIdsHasBeenSet = true;
    m_vpcSecurityGroupIds.emplace_back(std::forward<VpcSecurityGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configured failover mode for the DB cluster.</p>
   */
  inline FailoverMode GetFailoverMode() const { return m_failoverMode; }
  inline void SetFailoverMode(FailoverMode value) {
    m_failoverModeHasBeenSet = true;
    m_failoverMode = value;
  }
  inline GetDbClusterResult& WithFailoverMode(FailoverMode value) {
    SetFailoverMode(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetDbClusterResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_arn;

  ClusterStatus m_status{ClusterStatus::NOT_SET};

  Aws::String m_endpoint;

  Aws::String m_readerEndpoint;

  int m_port{0};

  ClusterDeploymentType m_deploymentType{ClusterDeploymentType::NOT_SET};

  DbInstanceType m_dbInstanceType{DbInstanceType::NOT_SET};

  NetworkType m_networkType{NetworkType::NOT_SET};

  DbStorageType m_dbStorageType{DbStorageType::NOT_SET};

  int m_allocatedStorage{0};

  EngineType m_engineType{EngineType::NOT_SET};

  bool m_publiclyAccessible{false};

  Aws::String m_dbParameterGroupIdentifier;

  LogDeliveryConfiguration m_logDeliveryConfiguration;

  Aws::String m_influxAuthParametersSecretArn;

  Aws::Vector<Aws::String> m_vpcSubnetIds;

  Aws::Vector<Aws::String> m_vpcSecurityGroupIds;

  FailoverMode m_failoverMode{FailoverMode::NOT_SET};

  Aws::String m_requestId;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_endpointHasBeenSet = false;
  bool m_readerEndpointHasBeenSet = false;
  bool m_portHasBeenSet = false;
  bool m_deploymentTypeHasBeenSet = false;
  bool m_dbInstanceTypeHasBeenSet = false;
  bool m_networkTypeHasBeenSet = false;
  bool m_dbStorageTypeHasBeenSet = false;
  bool m_allocatedStorageHasBeenSet = false;
  bool m_engineTypeHasBeenSet = false;
  bool m_publiclyAccessibleHasBeenSet = false;
  bool m_dbParameterGroupIdentifierHasBeenSet = false;
  bool m_logDeliveryConfigurationHasBeenSet = false;
  bool m_influxAuthParametersSecretArnHasBeenSet = false;
  bool m_vpcSubnetIdsHasBeenSet = false;
  bool m_vpcSecurityGroupIdsHasBeenSet = false;
  bool m_failoverModeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace TimestreamInfluxDB
}  // namespace Aws
