/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.types.CustomTypeParameter;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeImpl;", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/CustomTypeParameter;", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "<init>", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/types/SimpleType;)V", "assertionsDone", "", "runAssertions", "", "delegate", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "isTypeParameter", "()Z", "substitutionResult", "Lorg/jetbrains/kotlin/types/KotlinType;", "replacement", "replaceAttributes", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "newAttributes", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "render", "", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "options", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "toString", "makeNullableAsSpecified", "newNullability", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "Companion", "descriptors"})
@SourceDebugExtension(value={"SMAP\nflexibleTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypeImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class FlexibleTypeImpl
extends FlexibleType
implements CustomTypeParameter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean assertionsDone;
    @JvmField
    public static boolean RUN_SLOW_ASSERTIONS;

    public FlexibleTypeImpl(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        super(lowerBound, upperBound);
    }

    private final void runAssertions() {
        boolean bl;
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl2 = bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlexibleTypeImpl$runAssertions$52 = false;
            String $i$a$-assert-FlexibleTypeImpl$runAssertions$52 = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
            throw new AssertionError((Object)$i$a$-assert-FlexibleTypeImpl$runAssertions$52);
        }
        boolean bl3 = bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlexibleTypeImpl$runAssertions$62 = false;
            String $i$a$-assert-FlexibleTypeImpl$runAssertions$62 = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
            throw new AssertionError((Object)$i$a$-assert-FlexibleTypeImpl$runAssertions$62);
        }
        boolean bl4 = bl = !Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlexibleTypeImpl$runAssertions$72 = false;
            String $i$a$-assert-FlexibleTypeImpl$runAssertions$72 = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
            throw new AssertionError((Object)$i$a$-assert-FlexibleTypeImpl$runAssertions$72);
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string2 = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    public boolean isTypeParameter() {
        return this.getLowerBound().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)this.getLowerBound().getConstructor(), (Object)this.getUpperBound().getConstructor());
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        UnwrappedType unwrappedType;
        UnwrappedType unwrapped;
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        UnwrappedType unwrappedType2 = unwrapped = replacement.unwrap();
        if (unwrappedType2 instanceof FlexibleType) {
            unwrappedType = unwrapped;
        } else if (unwrappedType2 instanceof SimpleType) {
            unwrappedType = KotlinTypeFactory.flexibleType((SimpleType)unwrapped, ((SimpleType)unwrapped).makeNullableAsSpecified(true));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, unwrapped);
    }

    @Override
    @NotNull
    public UnwrappedType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return KotlinTypeFactory.flexibleType(this.getLowerBound().replaceAttributes(newAttributes), this.getUpperBound().replaceAttributes(newAttributes));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (options.getDebugMode()) {
            return '(' + renderer.renderType(this.getLowerBound()) + ".." + renderer.renderType(this.getUpperBound()) + ')';
        }
        return renderer.renderFlexibleType(renderer.renderType(this.getLowerBound()), renderer.renderType(this.getUpperBound()), TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    @NotNull
    public String toString() {
        return "" + '(' + this.getLowerBound() + ".." + this.getUpperBound() + ')';
    }

    @Override
    @NotNull
    public UnwrappedType makeNullableAsSpecified(boolean newNullability) {
        return KotlinTypeFactory.flexibleType(this.getLowerBound().makeNullableAsSpecified(newNullability), this.getUpperBound().makeNullableAsSpecified(newNullability));
    }

    @Override
    @TypeRefinement
    @NotNull
    public FlexibleType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getLowerBound());
        Intrinsics.checkNotNull((Object)kotlinType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        SimpleType simpleType2 = (SimpleType)kotlinType;
        KotlinType kotlinType2 = kotlinTypeRefiner.refineType(this.getUpperBound());
        Intrinsics.checkNotNull((Object)kotlinType2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return new FlexibleTypeImpl(simpleType2, (SimpleType)kotlinType2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeImpl$Companion;", "", "<init>", "()V", "RUN_SLOW_ASSERTIONS", "", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

