/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.CheckResult;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.NamingRule;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a'\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006\u001b"}, d2={"findRuleMessage", "", "checkString", "rules", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;)Ljava/lang/String;", "START_UPPER", "START_LOWER", "NO_UNDERSCORES", "NO_START_UPPER", "NO_START_UNDERSCORE", "NO_MIDDLE_UNDERSCORES", "NO_UNDERSCORES_IN_CAMEL_CASE", "NO_BAD_CHARACTERS", "NO_BAD_CHARACTERS_OR_UNDERSCORE", "NO_LOWER", "checkPackageDirective", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/CheckResult;", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "namingSettings", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionSettings;", "PART_RULES", "[Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingRule;", "checkQualifiedName", "qualifiedName", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nNamingConventionInspections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingConventionInspections.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,519:1\n1088#2,2:520\n1088#2,2:522\n1088#2,2:524\n1088#2,2:526\n*S KotlinDebug\n*F\n+ 1 NamingConventionInspections.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/NamingConventionInspectionsKt\n*L\n80#1:520,2\n84#1:522,2\n88#1:524,2\n92#1:526,2\n*E\n"})
public final class NamingConventionInspectionsKt {
    @NotNull
    private static final NamingRule START_UPPER = new NamingRule(KotlinBundle.message((String)"should.start.with.an.uppercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::START_UPPER$lambda$0));
    @NotNull
    private static final NamingRule START_LOWER = new NamingRule(KotlinBundle.message((String)"should.start.with.a.lowercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::START_LOWER$lambda$1));
    @NotNull
    private static final NamingRule NO_UNDERSCORES = new NamingRule(KotlinBundle.message((String)"should.not.contain.underscores", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_UNDERSCORES$lambda$2));
    @NotNull
    private static final NamingRule NO_START_UPPER = new NamingRule(KotlinBundle.message((String)"should.not.start.with.an.uppercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_START_UPPER$lambda$3));
    @NotNull
    private static final NamingRule NO_START_UNDERSCORE = new NamingRule(KotlinBundle.message((String)"should.not.start.with.an.underscore", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_START_UNDERSCORE$lambda$4));
    @NotNull
    private static final NamingRule NO_MIDDLE_UNDERSCORES = new NamingRule(KotlinBundle.message((String)"should.not.contain.underscores.in.the.middle.or.the.end", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_MIDDLE_UNDERSCORES$lambda$5));
    @NotNull
    private static final NamingRule NO_UNDERSCORES_IN_CAMEL_CASE = new NamingRule(KotlinBundle.message((String)"should.not.contain.underscores.with.camel.case", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_UNDERSCORES_IN_CAMEL_CASE$lambda$8));
    @NotNull
    private static final NamingRule NO_BAD_CHARACTERS = new NamingRule(KotlinBundle.message((String)"may.contain.only.letters.and.digits", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_BAD_CHARACTERS$lambda$10));
    @NotNull
    private static final NamingRule NO_BAD_CHARACTERS_OR_UNDERSCORE = new NamingRule(KotlinBundle.message((String)"may.contain.only.letters.digits.or.underscores", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_BAD_CHARACTERS_OR_UNDERSCORE$lambda$12));
    @NotNull
    private static final NamingRule NO_LOWER = new NamingRule(KotlinBundle.message((String)"should.not.contain.lowercase.letter", (Object[])new Object[0]), (Function1<? super String, Boolean>)((Function1)NamingConventionInspectionsKt::NO_LOWER$lambda$14));
    @NotNull
    private static final NamingRule[] PART_RULES;

    private static final String findRuleMessage(String checkString, NamingRule[] rules2) {
        for (NamingRule rule : rules2) {
            if (!((Boolean)rule.getMatcher().invoke((Object)checkString)).booleanValue()) continue;
            return rule.getMessage();
        }
        return null;
    }

    private static final CheckResult checkPackageDirective(KtPackageDirective directive, NamingConventionInspectionSettings namingSettings) {
        String string = directive.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        return NamingConventionInspectionsKt.checkQualifiedName(string, namingSettings);
    }

    private static final CheckResult checkQualifiedName(String qualifiedName, NamingConventionInspectionSettings namingSettings) {
        String string;
        block6: {
            block5: {
                if (((CharSequence)qualifiedName).length() == 0) break block5;
                Regex regex = namingSettings.getNameRegex();
                if (regex != null ? !regex.matches((CharSequence)qualifiedName) : false) break block6;
            }
            return null;
        }
        if (Intrinsics.areEqual((Object)namingSettings.getNamePattern(), (Object)namingSettings.getDefaultNamePattern())) {
            char[] cArray = new char[]{'.'};
            string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)qualifiedName, (char[])cArray, (boolean)false, (int)0, (int)6, null)), NamingConventionInspectionsKt::checkQualifiedName$lambda$15));
        } else {
            string = null;
        }
        String partErrorMessage = string;
        return partErrorMessage != null ? new CheckResult(partErrorMessage, true) : new CheckResult(namingSettings.getDefaultErrorMessage(), false);
    }

    private static final boolean START_UPPER$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Character c = StringsKt.getOrNull((CharSequence)it, (int)0);
        return c != null ? !Character.isUpperCase(c.charValue()) : false;
    }

    private static final boolean START_LOWER$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Character c = StringsKt.getOrNull((CharSequence)it, (int)0);
        return c != null ? !Character.isLowerCase(c.charValue()) : false;
    }

    private static final boolean NO_UNDERSCORES$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null);
    }

    private static final boolean NO_START_UPPER$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Character c = StringsKt.getOrNull((CharSequence)it, (int)0);
        return c != null ? Character.isUpperCase(c.charValue()) : false;
    }

    private static final boolean NO_START_UNDERSCORE$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null);
    }

    private static final boolean NO_MIDDLE_UNDERSCORES$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.contains$default((CharSequence)string, (char)'_', (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NO_UNDERSCORES_IN_CAMEL_CASE$lambda$8(String it) {
        char it2;
        char element$iv;
        int n;
        boolean $i$f$any;
        CharSequence $this$any$iv;
        block4: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!StringsKt.contains$default((CharSequence)it, (char)'_', (boolean)false, (int)2, null)) return false;
            $this$any$iv = it;
            $i$f$any = false;
            n = 0;
            while (n < $this$any$iv.length()) {
                it2 = element$iv = $this$any$iv.charAt(n);
                boolean bl = false;
                if (!Character.isUpperCase(it2)) {
                    ++n;
                    continue;
                }
                break block4;
            }
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        $this$any$iv = it;
        $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it2 = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (Character.isLowerCase(it2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NO_BAD_CHARACTERS$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence $this$any$iv = it;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char c = element$iv = $this$any$iv.charAt(n);
            boolean bl = false;
            if (!('a' <= c ? c < '{' : false)) {
                if (!('A' <= c ? c < '[' : false)) {
                    if ('0' > c) return true;
                    if (c >= ':') return true;
                    boolean bl2 = true;
                    if (!bl2) {
                        return true;
                    }
                }
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NO_BAD_CHARACTERS_OR_UNDERSCORE$lambda$12(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence $this$any$iv = it;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char c = element$iv = $this$any$iv.charAt(n);
            boolean bl = false;
            if (!('a' <= c ? c < '{' : false)) {
                if (!('A' <= c ? c < '[' : false)) {
                    if (!('0' <= c ? c < ':' : false) && c != '_') {
                        return true;
                    }
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean NO_LOWER$lambda$14(String it) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CharSequence $this$any$iv = it;
            boolean $i$f$any = false;
            for (int j = 0; j < $this$any$iv.length(); ++j) {
                char element$iv;
                char c = element$iv = $this$any$iv.charAt(j);
                boolean bl2 = false;
                if (!Character.isLowerCase(c)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String checkQualifiedName$lambda$15(String part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        return NamingConventionInspectionsKt.findRuleMessage(part, PART_RULES);
    }

    public static final /* synthetic */ String access$findRuleMessage(String checkString, NamingRule[] rules2) {
        return NamingConventionInspectionsKt.findRuleMessage(checkString, rules2);
    }

    public static final /* synthetic */ NamingRule access$getSTART_UPPER$p() {
        return START_UPPER;
    }

    public static final /* synthetic */ NamingRule access$getNO_UNDERSCORES$p() {
        return NO_UNDERSCORES;
    }

    public static final /* synthetic */ NamingRule access$getNO_BAD_CHARACTERS$p() {
        return NO_BAD_CHARACTERS;
    }

    public static final /* synthetic */ NamingRule access$getNO_START_UNDERSCORE$p() {
        return NO_START_UNDERSCORE;
    }

    public static final /* synthetic */ NamingRule access$getNO_BAD_CHARACTERS_OR_UNDERSCORE$p() {
        return NO_BAD_CHARACTERS_OR_UNDERSCORE;
    }

    public static final /* synthetic */ NamingRule access$getNO_UNDERSCORES_IN_CAMEL_CASE$p() {
        return NO_UNDERSCORES_IN_CAMEL_CASE;
    }

    public static final /* synthetic */ NamingRule access$getSTART_LOWER$p() {
        return START_LOWER;
    }

    public static final /* synthetic */ NamingRule access$getNO_MIDDLE_UNDERSCORES$p() {
        return NO_MIDDLE_UNDERSCORES;
    }

    public static final /* synthetic */ NamingRule access$getNO_START_UPPER$p() {
        return NO_START_UPPER;
    }

    public static final /* synthetic */ NamingRule access$getNO_LOWER$p() {
        return NO_LOWER;
    }

    public static final /* synthetic */ CheckResult access$checkPackageDirective(KtPackageDirective directive, NamingConventionInspectionSettings namingSettings) {
        return NamingConventionInspectionsKt.checkPackageDirective(directive, namingSettings);
    }

    public static final /* synthetic */ CheckResult access$checkQualifiedName(String qualifiedName, NamingConventionInspectionSettings namingSettings) {
        return NamingConventionInspectionsKt.checkQualifiedName(qualifiedName, namingSettings);
    }

    static {
        NamingRule[] namingRuleArray = new NamingRule[]{NO_BAD_CHARACTERS_OR_UNDERSCORE, NO_START_UPPER};
        PART_RULES = namingRuleArray;
    }
}

