/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.references.ReferenceAccess;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/references/SyntheticPropertyAccessorReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "expression", "getter", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;Z)V", "getGetter", "()Z", "isAccessorName", "name", "", "canBeReferenceTo", "candidateTarget", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "canRename", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "kt-references"})
public abstract class SyntheticPropertyAccessorReference
extends KtSimpleReference<KtNameReferenceExpression> {
    private final boolean getter;

    public SyntheticPropertyAccessorReference(@NotNull KtNameReferenceExpression expression, boolean getter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((KtReferenceExpression)expression);
        this.getter = getter;
    }

    public final boolean getGetter() {
        return this.getter;
    }

    protected final boolean isAccessorName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.getter) {
            return StringsKt.startsWith$default((String)name2, (String)"get", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"is", (boolean)false, (int)2, null);
        }
        return StringsKt.startsWith$default((String)name2, (String)"set", (boolean)false, (int)2, null);
    }

    @Override
    protected boolean canBeReferenceTo(@NotNull PsiElement candidateTarget) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)candidateTarget, (String)"candidateTarget");
                if (!(candidateTarget instanceof PsiMethod)) break block4;
                String string = ((PsiMethod)candidateTarget).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (this.isAccessorName(string)) break block5;
            }
            return false;
        }
        if (this.getter && !LightClassUtilsKt.getCanHaveSyntheticGetter((PsiMethod)candidateTarget) || !this.getter && !LightClassUtilsKt.getCanHaveSyntheticSetter((PsiMethod)candidateTarget)) {
            return false;
        }
        return this.getter || ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)this.getExpression(), true) != ReferenceAccess.READ;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, ((KtNameReferenceExpression)this.getExpression()).getTextLength());
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return CollectionsKt.listOf((Object)((KtNameReferenceExpression)this.getElement()).getReferencedNameAsName());
    }
}

