/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.csv.ui.preview.TextCsvFormatPreview;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.FormatExtractorFactory;
import com.intellij.database.run.actions.ChoosePasteFormatAction;
import com.intellij.database.settings.CsvFormatsComponent;
import com.intellij.database.settings.CsvSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowCsvFormatsAction
extends DumbAwareAction {
    private static final String ID = "Console.TableResult.Copy.Csv.Settings";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowCsvFormatsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowCsvFormatsAction.$$$reportNull$$$0(1);
        }
        Pair<CsvFormatsComponent, Disposable> pair = ShowCsvFormatsAction.getFormatsEditorAndDisposable(e);
        final CsvFormatsComponent component = (CsvFormatsComponent)pair.first;
        Disposable disposable = (Disposable)pair.second;
        DialogBuilder builder = new DialogBuilder(ShowCsvFormatsAction.getEventProject((AnActionEvent)e)).title(DataGridBundle.message((String)"dialog.title.csv.formats", (Object[])new Object[0])).dimensionKey(((Object)((Object)this)).getClass().getName()).centerPanel(component.getComponent());
        builder.setHelpId("Data_Extractors_dialog");
        builder.addDisposable(disposable);
        CsvSettings settings = CsvSettings.getSettings();
        String curName = this.getSelectedFormatName(e);
        UiNotifyConnector.Once.installOn((Component)component.getComponent(), (Activatable)new Activatable(){
            final /* synthetic */ CsvFormatsSettings val$settings;
            final /* synthetic */ String val$curName;
            {
                this.val$settings = csvFormatsSettings;
                this.val$curName = string;
            }

            public void showNotify() {
                component.reset(this.val$settings, this.val$curName);
            }
        });
        if (builder.show() == 0) {
            component.apply((CsvFormatsSettings)settings);
            settings.fireChanged();
        }
    }

    @Nullable
    String getSelectedFormatName(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowCsvFormatsAction.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    public static AnAction getInstance() {
        return ActionManager.getInstance().getAction(ID);
    }

    @NotNull
    private static Pair<CsvFormatsComponent, Disposable> getFormatsEditorAndDisposable(AnActionEvent e) {
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null || grid.isEmpty()) {
            CsvFormatsComponent c2 = new CsvFormatsComponent();
            Pair pair = Pair.create((Object)c2, (Object)c2);
            if (pair == null) {
                ShowCsvFormatsAction.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Disposable disposable = Disposer.newDisposable();
        boolean selectionOnly = grid.getSelectionModel().getSelectedRowCount() > 1 || grid.getSelectionModel().getSelectedColumnCount() > 1;
        CsvFormatsComponent c3 = new CsvFormatsComponent(new TextCsvFormatPreview(grid, disposable, selectionOnly));
        Disposer.register((Disposable)disposable, (Disposable)c3);
        Pair pair = Pair.create((Object)c3, (Object)disposable);
        if (pair == null) {
            ShowCsvFormatsAction.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ShowCsvFormatsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ShowCsvFormatsAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatsEditorAndDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFormatName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class ForExport
    extends ShowCsvFormatsAction {
        public ForExport() {
            ActionUtil.copyFrom((AnAction)this, (String)ShowCsvFormatsAction.ID);
        }

        @Override
        @Nullable
        String getSelectedFormatName(@NotNull AnActionEvent e) {
            DataExtractorFactory factory;
            if (e == null) {
                ForExport.$$$reportNull$$$0(0);
            }
            return (factory = DataExtractorProperties.getCurrentExtractorFactory((Project)e.getProject(), GridUtil::suggestPlugin, (CsvFormatsSettings)CsvSettings.getSettings())) instanceof FormatExtractorFactory ? factory.getName() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ShowCsvFormatsAction$ForExport", "getSelectedFormatName"));
        }
    }

    public static class ForImport
    extends ShowCsvFormatsAction {
        public ForImport() {
            ActionUtil.copyFrom((AnAction)this, (String)ShowCsvFormatsAction.ID);
        }

        @Override
        @Nullable
        String getSelectedFormatName(@NotNull AnActionEvent e) {
            CsvFormat currentFormat;
            if (e == null) {
                ForImport.$$$reportNull$$$0(0);
            }
            return (currentFormat = ChoosePasteFormatAction.PasteType.get().getFormat()) == null ? null : currentFormat.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ShowCsvFormatsAction$ForImport", "getSelectedFormatName"));
        }
    }
}

