/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpIntersection;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class RegExpSimplifiableInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RegExpSimplifiableInspection.$$$reportNull$$$0(0);
        }
        return new RegExpSimplifiableVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RegExpSimplifiableInspection", "buildVisitor"));
    }

    private static class RegExpSimplifiableVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RegExpSimplifiableVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                RegExpSimplifiableVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            RegExpClassElement[] elements;
            super.visitRegExpClass(regExpClass);
            for (RegExpClassElement element : elements = regExpClass.getElements()) {
                if (!(element instanceof RegExpCharRange)) continue;
                RegExpCharRange range = (RegExpCharRange)element;
                int from = range.getFrom().getValue();
                RegExpChar to = range.getTo();
                if (from == -1 || to == null || from != to.getValue()) continue;
                this.registerProblem(range, to.getUnescapedText());
            }
            if (regExpClass.isNegated()) {
                RegExpSimpleClass simpleClass;
                String text;
                if (elements.length == 1 && (element = elements[0]) instanceof RegExpSimpleClass && (text = RegExpSimplifiableVisitor.getInverseSimpleClassText(simpleClass = (RegExpSimpleClass)element)) != null) {
                    this.registerProblem(regExpClass, text);
                }
            } else if (elements.length == 1) {
                element = elements[0];
                if (element instanceof RegExpPosixBracketExpression) {
                    return;
                }
                if (!(element instanceof RegExpCharRange || element instanceof RegExpIntersection || element instanceof RegExpChar && "{}().*+?|$".contains(element.getText()))) {
                    this.registerProblem(regExpClass, element.getUnescapedText());
                }
            }
        }

        @Override
        public void visitRegExpClosure(RegExpClosure closure) {
            super.visitRegExpClosure(closure);
            ASTNode token = closure.getQuantifier().getToken();
            if (token == null || token.getElementType() != RegExpTT.STAR) {
                return;
            }
            PsiElement sibling = closure.getPrevSibling();
            RegExpAtom atom = closure.getAtom();
            if (sibling instanceof RegExpElement && atom.getClass() == sibling.getClass() && sibling.textMatches((PsiElement)atom) && !RegExpSimplifiableVisitor.containsGroup(atom)) {
                String text = atom.getUnescapedText() + "+";
                this.myHolder.registerProblem(closure.getParent(), TextRange.from((int)sibling.getStartOffsetInParent(), (int)(sibling.getTextLength() + closure.getTextLength())), RegExpBundle.message("inspection.warning.can.be.simplified", text), new LocalQuickFix[]{new RegExpSimplifiableFix(text)});
            }
        }

        @Override
        public void visitRegExpProperty(RegExpProperty property) {
            String category;
            super.visitRegExpProperty(property);
            ASTNode categoryNode = property.getCategoryNode();
            if (categoryNode == null) {
                return;
            }
            switch (category = categoryNode.getText()) {
                case "Digit": 
                case "IsDigit": {
                    this.registerProblem(property, property.isNegated() ? "\\D" : "\\d");
                    break;
                }
                case "Blank": 
                case "IsBlank": {
                    this.registerProblem(property, property.isNegated() ? "[^ \\t]" : "[ \\t]");
                    break;
                }
                case "Space": 
                case "IsSpace": 
                case "IsWhite_Space": 
                case "IsWhiteSpace": {
                    this.registerProblem(property, property.isNegated() ? "\\S" : "\\s");
                }
            }
        }

        @Override
        public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
            String max;
            if (!quantifier.isCounted() || quantifier.getLastChild() instanceof PsiErrorElement) {
                return;
            }
            RegExpNumber minElement = quantifier.getMin();
            String min = minElement == null ? "" : minElement.getText();
            RegExpNumber maxElement = quantifier.getMax();
            String string = max = maxElement == null ? "" : maxElement.getText();
            if (!max.isEmpty() && max.equals(min)) {
                if ("1".equals(max)) {
                    this.myHolder.registerProblem((PsiElement)quantifier, RegExpBundle.message("inspection.warning.can.be.removed", new Object[0]), new LocalQuickFix[]{new RegExpSimplifiableFix(quantifier.getText(), true)});
                } else {
                    ASTNode node = quantifier.getNode();
                    if (node.findChildByType(RegExpTT.COMMA) != null) {
                        this.registerProblem(quantifier, "{" + max + "}");
                    }
                }
            } else if (("0".equals(min) || min.isEmpty()) && "1".equals(max)) {
                this.registerProblem(quantifier, "?");
            } else if (("0".equals(min) || min.isEmpty()) && max.isEmpty()) {
                this.registerProblem(quantifier, "*");
            } else if ("1".equals(min) && max.isEmpty()) {
                this.registerProblem(quantifier, "+");
            }
        }

        private void registerProblem(RegExpElement element, String replacement) {
            this.myHolder.registerProblem((PsiElement)element, RegExpBundle.message("inspection.warning.can.be.simplified", replacement), new LocalQuickFix[]{new RegExpSimplifiableFix(replacement)});
        }

        private static boolean containsGroup(RegExpAtom atom) {
            return atom instanceof RegExpGroup || PsiTreeUtil.findChildOfType((PsiElement)atom, RegExpGroup.class) != null;
        }

        private static String getInverseSimpleClassText(RegExpSimpleClass simpleClass) {
            return switch (simpleClass.getKind()) {
                case RegExpSimpleClass.Kind.DIGIT -> "\\D";
                case RegExpSimpleClass.Kind.NON_DIGIT -> "\\d";
                case RegExpSimpleClass.Kind.WORD -> "\\W";
                case RegExpSimpleClass.Kind.NON_WORD -> "\\w";
                case RegExpSimpleClass.Kind.SPACE -> "\\S";
                case RegExpSimpleClass.Kind.NON_SPACE -> "\\s";
                case RegExpSimpleClass.Kind.HORIZONTAL_SPACE -> "\\H";
                case RegExpSimpleClass.Kind.NON_HORIZONTAL_SPACE -> "\\h";
                case RegExpSimpleClass.Kind.VERTICAL_SPACE -> "\\V";
                case RegExpSimpleClass.Kind.NON_VERTICAL_SPACE -> "\\v";
                case RegExpSimpleClass.Kind.XML_NAME_START -> "\\I";
                case RegExpSimpleClass.Kind.NON_XML_NAME_START -> "\\i";
                case RegExpSimpleClass.Kind.XML_NAME_PART -> "\\C";
                case RegExpSimpleClass.Kind.NON_XML_NAME_PART -> "\\c";
                default -> null;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RegExpSimplifiableInspection$RegExpSimplifiableVisitor", "<init>"));
        }

        private static class RegExpSimplifiableFix
        extends ModCommandQuickFix {
            private final String myExpression;
            private final boolean myDelete;

            RegExpSimplifiableFix(String newExpression) {
                this(newExpression, false);
            }

            RegExpSimplifiableFix(String expression, boolean delete) {
                this.myExpression = expression;
                this.myDelete = delete;
            }

            @NotNull
            public String getFamilyName() {
                String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
                if (string == null) {
                    RegExpSimplifiableFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getName() {
                String string = this.myDelete ? CommonQuickFixBundle.message((String)"fix.remove", (Object[])new Object[]{this.myExpression}) : CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myExpression});
                if (string == null) {
                    RegExpSimplifiableFix.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project == null) {
                    RegExpSimplifiableFix.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    RegExpSimplifiableFix.$$$reportNull$$$0(3);
                }
                if (!((element = descriptor.getPsiElement()) instanceof RegExpElement)) {
                    ModCommand modCommand = ModCommand.nop();
                    if (modCommand == null) {
                        RegExpSimplifiableFix.$$$reportNull$$$0(4);
                    }
                    return modCommand;
                }
                ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, e -> RegExpReplacementUtil.replaceInContext(e, this.myDelete ? "" : this.myExpression, descriptor.getTextRangeInElement()));
                if (modCommand == null) {
                    RegExpSimplifiableFix.$$$reportNull$$$0(5);
                }
                return modCommand;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/inspection/RegExpSimplifiableInspection$RegExpSimplifiableVisitor$RegExpSimplifiableFix";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/inspection/RegExpSimplifiableInspection$RegExpSimplifiableVisitor$RegExpSimplifiableFix";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "perform";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "perform";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

