/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.testDiscovery.instrumentation.DefaultConstructorDetectionVisitor;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsFilter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumentationUtils;
import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumenter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class InstrumentedMethodsCollector
extends ClassVisitor {
    private final TestDiscoveryInstrumenter instrumenter;
    private final List<String> instrumentedMethods;
    private final InstrumentedMethodsFilter methodsFilter;
    private int defaultConstructorIndex = -1;

    /*
     * WARNING - void declaration
     */
    InstrumentedMethodsCollector(int api, ClassVisitor cv, TestDiscoveryInstrumenter instrumenter, String className) {
        super((int)var1_1, (ClassVisitor)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.instrumenter = var3_3;
        this.methodsFilter = new InstrumentedMethodsFilter(className);
        this.instrumentedMethods = new ArrayList<String>();
    }

    String[] instrumentedMethods() {
        return this.instrumentedMethods.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.methodsFilter.visit(version, access, name, signature, superName, interfaces);
        this.instrumenter.myClassVersion = version;
        super.visit((int)var1_1, (int)var2_2, (String)var3_3, signature, superName, interfaces);
    }

    /*
     * WARNING - void declaration
     */
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        InstrumentedMethodsFilter.Decision decision = this.methodsFilter.shouldVisitMethod(access, name, desc, signature, exceptions, this.instrumenter.myInstrumentConstructors);
        if (decision == InstrumentedMethodsFilter.Decision.YES) {
            this.instrumentedMethods.add(TestDiscoveryInstrumentationUtils.getMethodId(name, desc));
            if ("<init>".equals(name) && !this.instrumenter.myInstrumentConstructors) {
                this.instrumentAllConstructors();
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (decision == InstrumentedMethodsFilter.Decision.NO) {
            return null;
        }
        assert (decision == InstrumentedMethodsFilter.Decision.CHECK_IS_CONSTRUCTOR_DEFAULT);
        assert ("<init>".equals(name));
        InstrumentedMethodsCollector instrumentedMethodsCollector = this;
        return new DefaultConstructorDetectionVisitor(instrumentedMethodsCollector, instrumentedMethodsCollector.api, super.visitMethod((int)var1_1, (String)var2_2, desc, signature, exceptions), (String)var3_3){
            final /* synthetic */ String val$desc;
            final /* synthetic */ InstrumentedMethodsCollector this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$desc = string;
                super((int)var2_2, (MethodVisitor)var3_3);
            }

            void onDecisionDone(boolean isDefault) {
                if (!isDefault) {
                    this.this$0.instrumentAllConstructors();
                    this.this$0.instrumentedMethods.add(TestDiscoveryInstrumentationUtils.getMethodId("<init>", this.val$desc));
                    return;
                }
                InstrumentedMethodsCollector.access$202(this.this$0, this.this$0.instrumentedMethods.size());
            }
        };
    }

    private void instrumentAllConstructors() {
        this.instrumenter.myInstrumentConstructors = true;
        if (this.defaultConstructorIndex != -1) {
            this.instrumentedMethods.add(this.defaultConstructorIndex, TestDiscoveryInstrumentationUtils.getMethodId("<init>", "()V"));
            this.defaultConstructorIndex = -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$202(InstrumentedMethodsCollector x0, int x1) {
        void var1_1;
        x0.defaultConstructorIndex = var1_1;
        return x0.defaultConstructorIndex;
    }
}

