/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import org.apache.lucene.analysis.ja.JapaneseCompletionAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseCompletionFilter;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.opensearch.index.analysis.KuromojiCompletionFilterFactory;
import org.opensearch.index.analysis.KuromojiTokenizerFactory;

public class KuromojiCompletionAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JapaneseCompletionAnalyzer> {
    private final JapaneseCompletionAnalyzer analyzer;

    public KuromojiCompletionAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        JapaneseCompletionFilter.Mode mode = KuromojiCompletionFilterFactory.getMode(settings);
        UserDictionary userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.analyzer = new JapaneseCompletionAnalyzer(userDictionary, mode);
    }

    public JapaneseCompletionAnalyzer get() {
        return this.analyzer;
    }
}

