/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregationCollectMode;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregationExecutionHint;
import org.opensearch.client.opensearch._types.aggregations.TermsExclude;
import org.opensearch.client.opensearch._types.aggregations.TermsInclude;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TermsAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, TermsAggregation> {
    @Nullable
    private final TermsAggregationCollectMode collectMode;
    @Nullable
    private final TermsExclude exclude;
    @Nullable
    private final TermsAggregationExecutionHint executionHint;
    @Nullable
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final TermsInclude include;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final FieldValue missing;
    @Nonnull
    private final List<Map<String, SortOrder>> order;
    @Nullable
    private final Script script;
    @Nullable
    private final Integer shardMinDocCount;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Boolean showTermDocCountError;
    @Nullable
    private final Integer size;
    @Nullable
    private final String valueType;
    public static final JsonpDeserializer<TermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsAggregation::setupTermsAggregationDeserializer);

    private TermsAggregation(Builder builder) {
        super(builder);
        this.collectMode = builder.collectMode;
        this.exclude = builder.exclude;
        this.executionHint = builder.executionHint;
        this.field = builder.field;
        this.format = builder.format;
        this.include = builder.include;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.order = ApiTypeHelper.unmodifiable(builder.order);
        this.script = builder.script;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.shardSize = builder.shardSize;
        this.showTermDocCountError = builder.showTermDocCountError;
        this.size = builder.size;
        this.valueType = builder.valueType;
    }

    public static TermsAggregation of(Function<Builder, ObjectBuilder<TermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Terms;
    }

    @Nullable
    public final TermsAggregationCollectMode collectMode() {
        return this.collectMode;
    }

    @Nullable
    public final TermsExclude exclude() {
        return this.exclude;
    }

    @Nullable
    public final TermsAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final TermsInclude include() {
        return this.include;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nonnull
    public final List<Map<String, SortOrder>> order() {
        return this.order;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Integer shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String valueType() {
        return this.valueType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.collectMode != null) {
            generator.writeKey("collect_mode");
            this.collectMode.serialize(generator, mapper);
        }
        if (this.exclude != null) {
            generator.writeKey("exclude");
            this.exclude.serialize(generator, mapper);
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (Map<String, SortOrder> item0 : this.order) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, SortOrder> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.showTermDocCountError != null) {
            generator.writeKey("show_term_doc_count_error");
            generator.write(this.showTermDocCountError.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            generator.write(this.valueType);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        TermsAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::collectMode, TermsAggregationCollectMode._DESERIALIZER, "collect_mode");
        op.add(Builder::exclude, TermsExclude._DESERIALIZER, "exclude");
        op.add(Builder::executionHint, TermsAggregationExecutionHint._DESERIALIZER, "execution_hint");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::include, TermsInclude._DESERIALIZER, "include");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(SortOrder._DESERIALIZER)), "order");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::shardMinDocCount, JsonpDeserializer.integerDeserializer(), "shard_min_doc_count");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::showTermDocCountError, JsonpDeserializer.booleanDeserializer(), "show_term_doc_count_error");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::valueType, JsonpDeserializer.stringDeserializer(), "value_type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.collectMode);
        result = 31 * result + Objects.hashCode(this.exclude);
        result = 31 * result + Objects.hashCode(this.executionHint);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.include);
        result = 31 * result + Objects.hashCode(this.minDocCount);
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.shardMinDocCount);
        result = 31 * result + Objects.hashCode(this.shardSize);
        result = 31 * result + Objects.hashCode(this.showTermDocCountError);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.valueType);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermsAggregation other = (TermsAggregation)o;
        return Objects.equals(this.collectMode, other.collectMode) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.executionHint, other.executionHint) && Objects.equals(this.field, other.field) && Objects.equals(this.format, other.format) && Objects.equals(this.include, other.include) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.missing, other.missing) && Objects.equals(this.order, other.order) && Objects.equals(this.script, other.script) && Objects.equals(this.shardMinDocCount, other.shardMinDocCount) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.showTermDocCountError, other.showTermDocCountError) && Objects.equals(this.size, other.size) && Objects.equals(this.valueType, other.valueType);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TermsAggregation> {
        @Nullable
        private TermsAggregationCollectMode collectMode;
        @Nullable
        private TermsExclude exclude;
        @Nullable
        private TermsAggregationExecutionHint executionHint;
        @Nullable
        private String field;
        @Nullable
        private String format;
        @Nullable
        private TermsInclude include;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private FieldValue missing;
        @Nullable
        private List<Map<String, SortOrder>> order;
        @Nullable
        private Script script;
        @Nullable
        private Integer shardMinDocCount;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Boolean showTermDocCountError;
        @Nullable
        private Integer size;
        @Nullable
        private String valueType;

        public Builder() {
        }

        private Builder(TermsAggregation o) {
            super(o);
            this.collectMode = o.collectMode;
            this.exclude = o.exclude;
            this.executionHint = o.executionHint;
            this.field = o.field;
            this.format = o.format;
            this.include = o.include;
            this.minDocCount = o.minDocCount;
            this.missing = o.missing;
            this.order = Builder._listCopy(o.order);
            this.script = o.script;
            this.shardMinDocCount = o.shardMinDocCount;
            this.shardSize = o.shardSize;
            this.showTermDocCountError = o.showTermDocCountError;
            this.size = o.size;
            this.valueType = o.valueType;
        }

        private Builder(Builder o) {
            super(o);
            this.collectMode = o.collectMode;
            this.exclude = o.exclude;
            this.executionHint = o.executionHint;
            this.field = o.field;
            this.format = o.format;
            this.include = o.include;
            this.minDocCount = o.minDocCount;
            this.missing = o.missing;
            this.order = Builder._listCopy(o.order);
            this.script = o.script;
            this.shardMinDocCount = o.shardMinDocCount;
            this.shardSize = o.shardSize;
            this.showTermDocCountError = o.showTermDocCountError;
            this.size = o.size;
            this.valueType = o.valueType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder collectMode(@Nullable TermsAggregationCollectMode value) {
            this.collectMode = value;
            return this;
        }

        @Nonnull
        public final Builder exclude(@Nullable TermsExclude value) {
            this.exclude = value;
            return this;
        }

        @Nonnull
        public final Builder exclude(Function<TermsExclude.Builder, ObjectBuilder<TermsExclude>> fn) {
            return this.exclude(fn.apply(new TermsExclude.Builder()).build());
        }

        @Nonnull
        public final Builder executionHint(@Nullable TermsAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Nonnull
        public final Builder include(@Nullable TermsInclude value) {
            this.include = value;
            return this;
        }

        @Nonnull
        public final Builder include(Function<TermsInclude.Builder, ObjectBuilder<TermsInclude>> fn) {
            return this.include(fn.apply(new TermsInclude.Builder()).build());
        }

        @Nonnull
        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        @Nonnull
        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        @Nonnull
        public final Builder order(List<Map<String, SortOrder>> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        @Nonnull
        public final Builder order(Map<String, SortOrder> value, Map<String, SortOrder> ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Nonnull
        public final Builder shardMinDocCount(@Nullable Integer value) {
            this.shardMinDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Nonnull
        public final Builder showTermDocCountError(@Nullable Boolean value) {
            this.showTermDocCountError = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder valueType(@Nullable String value) {
            this.valueType = value;
            return this;
        }

        @Override
        @Nonnull
        public TermsAggregation build() {
            this._checkSingleUse();
            return new TermsAggregation(this);
        }
    }
}

