/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.util;

import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public final class MapUtils {
    public static int calculateInitialCapacity(int expectedSize) {
        return (int)Math.ceil((double)expectedSize / 0.75);
    }

    public static <K, V> @Nullable V computeIfAbsent(Map<K, V> map, K key, Function<K, @Nullable V> mappingFunction) {
        V value = map.get(key);
        return value != null ? value : map.computeIfAbsent(key, mappingFunction);
    }

    private MapUtils() {
    }
}

