/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.io.IOException;
import java.security.PrivateKey;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.StreamException;
import org.cryptacular.bean.FactoryBean;
import org.cryptacular.io.Resource;
import org.cryptacular.util.KeyPairUtil;

public class ResourceBasedPrivateKeyFactoryBean
implements FactoryBean<PrivateKey> {
    private final Resource resource;
    private final String password;

    public ResourceBasedPrivateKeyFactoryBean(Resource resource) {
        this(resource, null);
    }

    public ResourceBasedPrivateKeyFactoryBean(Resource resource, String decryptionPassword) {
        this.resource = CryptUtil.assertNotNullArg(resource, "Resource cannot be null");
        this.password = decryptionPassword;
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public PrivateKey newInstance() throws EncodingException, StreamException {
        try {
            if (this.password != null) {
                return KeyPairUtil.readPrivateKey(this.resource.getInputStream(), this.password.toCharArray());
            }
            return KeyPairUtil.readPrivateKey(this.resource.getInputStream());
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }
}

