﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf-regional/WAFRegionalRequest.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WAFRegional {
namespace Model {

/**
 */
class DeleteByteMatchSetRequest : public WAFRegionalRequest {
 public:
  AWS_WAFREGIONAL_API DeleteByteMatchSetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteByteMatchSet"; }

  AWS_WAFREGIONAL_API Aws::String SerializePayload() const override;

  AWS_WAFREGIONAL_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to
   * delete. <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and
   * by <a>ListByteMatchSets</a>.</p>
   */
  inline const Aws::String& GetByteMatchSetId() const { return m_byteMatchSetId; }
  inline bool ByteMatchSetIdHasBeenSet() const { return m_byteMatchSetIdHasBeenSet; }
  template <typename ByteMatchSetIdT = Aws::String>
  void SetByteMatchSetId(ByteMatchSetIdT&& value) {
    m_byteMatchSetIdHasBeenSet = true;
    m_byteMatchSetId = std::forward<ByteMatchSetIdT>(value);
  }
  template <typename ByteMatchSetIdT = Aws::String>
  DeleteByteMatchSetRequest& WithByteMatchSetId(ByteMatchSetIdT&& value) {
    SetByteMatchSetId(std::forward<ByteMatchSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
   */
  inline const Aws::String& GetChangeToken() const { return m_changeToken; }
  inline bool ChangeTokenHasBeenSet() const { return m_changeTokenHasBeenSet; }
  template <typename ChangeTokenT = Aws::String>
  void SetChangeToken(ChangeTokenT&& value) {
    m_changeTokenHasBeenSet = true;
    m_changeToken = std::forward<ChangeTokenT>(value);
  }
  template <typename ChangeTokenT = Aws::String>
  DeleteByteMatchSetRequest& WithChangeToken(ChangeTokenT&& value) {
    SetChangeToken(std::forward<ChangeTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_byteMatchSetId;

  Aws::String m_changeToken;
  bool m_byteMatchSetIdHasBeenSet = false;
  bool m_changeTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
