/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DataSourceHandlerUtils {
    public static boolean resolveSharedCredentials(DBPDataSourceContainer dataSource, @Nullable DBRProgressListener onFinish) {
        block7: {
            if (dataSource.isSharedCredentials() && !dataSource.isSharedCredentialsSelected()) {
                try {
                    List sharedCredentials = dataSource.listSharedCredentials();
                    if (sharedCredentials.size() == 1) {
                        dataSource.setSelectedSharedCredentials((DBSSecretValue)sharedCredentials.get(0));
                        break block7;
                    }
                    if (sharedCredentials.isEmpty()) break block7;
                    DBSSecretValue selectedCredentials = DataSourceHandlerUtils.selectSharedCredentials(dataSource, sharedCredentials);
                    if (selectedCredentials != null) {
                        dataSource.setSelectedSharedCredentials(selectedCredentials);
                        break block7;
                    }
                    if (onFinish != null) {
                        onFinish.onTaskFinished(Status.CANCEL_STATUS);
                    }
                    return false;
                }
                catch (DBException e) {
                    dataSource.resetAllSecrets();
                    if (onFinish != null) {
                        onFinish.onTaskFinished(GeneralUtils.makeExceptionStatus((Throwable)e));
                    }
                    DBWorkbench.getPlatformUI().showError(dataSource.getName(), e.getMessage(), (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private static DBSSecretValue selectSharedCredentials(final DBPDataSourceContainer dataSource, final List<DBSSecretValue> credentials) {
        return (DBSSecretValue)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<DBSSecretValue>(){

            public DBSSecretValue runWithResult() {
                CredentialsSelectorDialog dialog = new CredentialsSelectorDialog(dataSource, credentials);
                if (dialog.open() == 0) {
                    return dialog.selected;
                }
                return null;
            }
        });
    }

    static class CredentialsSelectorDialog
    extends BaseDialog {
        private final DBPDataSourceContainer dataSource;
        private final List<DBSSecretValue> credentials;
        private DBSSecretValue selected;

        public CredentialsSelectorDialog(DBPDataSourceContainer dataSource, List<DBSSecretValue> credentials) {
            super(UIUtils.getActiveShell(), "'" + dataSource.getName() + "' credentials", dataSource.getDriver().getIcon());
            this.dataSource = dataSource;
            this.credentials = credentials;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            UIUtils.createInfoLabel((Composite)composite, (String)"There are multiple credentials available for authentication.\nPlease choose credentials you want to use:");
            Table credsTable = new Table(composite, 67588);
            GridData gd = new GridData(1808);
            credsTable.setLayoutData((Object)gd);
            for (DBSSecretValue sv : this.credentials) {
                TableItem item = new TableItem(credsTable, 0);
                item.setText(sv.getDisplayName());
                item.setData((Object)sv);
            }
            credsTable.setSelection(0);
            this.selected = this.credentials.get(0);
            credsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    selected = (DBSSecretValue)e.item.getData();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (selected != null) {
                        this.okPressed();
                    }
                }
            });
            return composite;
        }
    }
}

