/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.Tooltip;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.BoxLayout;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.opengl.GL2ES2;
import jogamp.graph.ui.TreeTool;

public class TooltipShape
extends Tooltip {
    public static DestroyCallback NoOpDtor = new DestroyCallback(){

        @Override
        public void destroy(TooltipShape tooltipShape, GL2ES2 gL2ES2, RegionRenderer regionRenderer, Shape shape) {
        }
    };
    private final Shape clientShape;
    private final Vec2f scale;
    private final float borderThickness;
    private final Padding padding;
    private final DestroyCallback dtorCallback;

    public TooltipShape(Vec2f vec2f, long l, int n, Shape shape) {
        this(null, null, 0.0f, null, vec2f, l, n, shape, null);
    }

    public TooltipShape(Vec4f vec4f, Vec4f vec4f2, float f, Padding padding, Vec2f vec2f, long l, int n, Shape shape, DestroyCallback destroyCallback) {
        super(vec4f, vec4f2, l, n);
        this.clientShape = shape;
        this.scale = vec2f;
        this.borderThickness = f;
        this.padding = padding;
        this.dtorCallback = destroyCallback;
    }

    public Shape getClientShape() {
        return this.clientShape;
    }

    @Override
    public Shape createTip(Scene scene, AABBox aABBox) {
        float f = scene.getZEpsilon(16);
        float f2 = aABBox.getWidth() * this.scale.x();
        float f3 = aABBox.getHeight() * this.scale.y();
        Group group = new Group("TTS.wrapper", null, null, this.clientShape);
        if (null != this.padding) {
            group.setPaddding(this.padding);
        }
        Group group2 = new Group(new BoxLayout(f2, f3, Alignment.FillCenter));
        group2.addShape(new Rectangle(this.renderModes, 1.0f * f2 / f3, 1.0f, 0.0f).setColor(this.backColor).setBorder(this.borderThickness).setBorderColor(this.frontColor).setName("TTS.frame").move(0.0f, 0.0f, -f));
        group2.setName("TTS.group");
        group2.addShape(group);
        group2.setInteractive(false);
        Vec2f vec2f = this.getTipMvPosition(scene, aABBox, f2, f3);
        group2.moveTo(vec2f.x(), vec2f.y(), 100.0f * f);
        return group2;
    }

    public Shape removeTip(Shape shape2) {
        Group group;
        Group group2;
        Shape shape3 = this.clientShape;
        if (null != shape3 && null == (group2 = (Group)(group = (Group)shape2).getShapeByIdx(1)).removeShape(shape3)) {
            System.err.println("TooltipShape.destroyTip: Warning: ClientShape " + shape3.getName() + " not contained in " + group2.getName() + "; Internal Group: ");
            TreeTool.forAll(group, shape -> {
                System.err.println("- " + shape.getName());
                return false;
            });
        }
        return shape3;
    }

    @Override
    public void destroyTip(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Shape shape) {
        if (null != this.dtorCallback) {
            Shape shape2 = this.removeTip(shape);
            shape.destroy(gL2ES2, regionRenderer);
            this.dtorCallback.destroy(this, gL2ES2, regionRenderer, shape2);
        } else {
            super.destroyTip(gL2ES2, regionRenderer, shape);
        }
    }

    public static interface DestroyCallback {
        public void destroy(TooltipShape var1, GL2ES2 var2, RegionRenderer var3, Shape var4);
    }
}

