/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import jogamp.graph.curve.tess.GraphVertex;

public class HEdge {
    public static final int BOUNDARY = 3;
    public static final int INNER = 1;
    public static final int HOLE = 2;
    private GraphVertex vert;
    private HEdge prev;
    private HEdge next;
    private HEdge sibling;
    private int type;
    private Triangle triangle;

    public HEdge(GraphVertex graphVertex, int n) {
        this(graphVertex, null, null, null, n, null);
    }

    public HEdge(GraphVertex graphVertex, HEdge hEdge, HEdge hEdge2, HEdge hEdge3, int n) {
        this(graphVertex, hEdge, hEdge2, hEdge3, n, null);
    }

    public HEdge(GraphVertex graphVertex, HEdge hEdge, HEdge hEdge2, HEdge hEdge3, int n, Triangle triangle) {
        this.vert = graphVertex;
        this.prev = hEdge;
        this.next = hEdge2;
        this.sibling = hEdge3;
        this.type = n;
        this.triangle = triangle;
    }

    public String toString() {
        String string = this.prev != null ? Integer.toHexString(this.prev.hashCode()) : "nil";
        String string2 = this.next != null ? Integer.toHexString(this.next.hashCode()) : "nil";
        return "HEdge{this " + Integer.toHexString(this.hashCode()) + ", prev " + string + ", next " + string2 + "}";
    }

    public void printChain() {
        int n = 0;
        HEdge hEdge = this;
        HEdge hEdge2 = this.getNext();
        System.err.println("HEdge[" + n + "]: root " + Integer.toHexString(this.hashCode()));
        do {
            System.err.println("HEdge[" + n + "]: current " + Integer.toHexString(hEdge.hashCode()) + ", next " + Integer.toHexString(hEdge2.hashCode()));
            ++n;
            hEdge = hEdge2;
            hEdge2 = hEdge.getNext();
        } while (hEdge != this);
    }

    public GraphVertex getGraphPoint() {
        return this.vert;
    }

    public void setVert(GraphVertex graphVertex) {
        this.vert = graphVertex;
    }

    public HEdge getPrev() {
        return this.prev;
    }

    public void setPrev(HEdge hEdge) {
        this.prev = hEdge;
    }

    public HEdge getNext() {
        return this.next;
    }

    public void setNext(HEdge hEdge) {
        this.next = hEdge;
    }

    public HEdge getSibling() {
        return this.sibling;
    }

    public void setSibling(HEdge hEdge) {
        this.sibling = hEdge;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Triangle getTriangle() {
        return this.triangle;
    }

    public void setTriangle(Triangle triangle) {
        this.triangle = triangle;
    }

    public static <T extends Vertex> void connect(HEdge hEdge, HEdge hEdge2) {
        hEdge.setNext(hEdge2);
        hEdge2.setPrev(hEdge);
    }

    public static <T extends Vertex> void makeSiblings(HEdge hEdge, HEdge hEdge2) {
        hEdge.setSibling(hEdge2);
        hEdge2.setSibling(hEdge);
    }

    public boolean vertexOnCurveVertex() {
        return this.vert.getPoint().isOnCurve();
    }
}

