/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.FunctionTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FunctionTableStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_FUNCTION_TABLES";
    private int sizeOfHeader;
    private int sizeOfEntry;
    private int sizeOfNativeDescriptor;
    private int sizeOfFunctionEntry;
    private int numberOfDescriptors;
    private int sizeOfAlignPad;
    private FunctionTable[] descriptors;
    private DumpFileReader reader;
    private long index;

    FunctionTableStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSizeOfHeader(this.reader.readNextInt());
        this.setSizeOfEntry(this.reader.readNextInt());
        this.setSizeOfNativeDescriptor(this.reader.readNextInt());
        this.setSizeOfFunctionEntry(this.reader.readNextInt());
        this.setNumberOfDescriptors(this.reader.readNextInt());
        this.setSizeOfAlignPad(this.reader.readNextInt());
        this.descriptors = new FunctionTable[this.numberOfDescriptors];
        for (int i = 0; i < this.numberOfDescriptors; ++i) {
            this.setDescriptors(new FunctionTable(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "SizeOfHeader", null);
        struct.add(DWORD, 4, "SizeOfDescriptor", null);
        struct.add(DWORD, 4, "SizeOfNativeDescriptor", null);
        struct.add(DWORD, 4, "SizeOfFunctionEntry", null);
        struct.add(DWORD, 4, "NumberOfDescriptors", null);
        struct.add(DWORD, 4, "SizeOfAlignPad", null);
        DataType t = this.descriptors[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfDescriptors, t.getLength());
        struct.add((DataType)a, a.getLength(), "Descriptors", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getSizeOfHeader() {
        return this.sizeOfHeader;
    }

    public void setSizeOfHeader(int sizeOfHeader) {
        this.sizeOfHeader = sizeOfHeader;
    }

    public int getSizeOfEntry() {
        return this.sizeOfEntry;
    }

    public void setSizeOfEntry(int sizeOfEntry) {
        this.sizeOfEntry = sizeOfEntry;
    }

    public int getSizeOfNativeDescriptor() {
        return this.sizeOfNativeDescriptor;
    }

    public void setSizeOfNativeDescriptor(int sizeOfNativeDescriptor) {
        this.sizeOfNativeDescriptor = sizeOfNativeDescriptor;
    }

    public int getSizeOfFunctionEntry() {
        return this.sizeOfFunctionEntry;
    }

    public void setSizeOfFunctionEntry(int sizeOfFunctionEntry) {
        this.sizeOfFunctionEntry = sizeOfFunctionEntry;
    }

    public int getNumberOfDescriptors() {
        return this.numberOfDescriptors;
    }

    public void setNumberOfDescriptors(int numberOfDescriptors) {
        this.numberOfDescriptors = numberOfDescriptors;
    }

    public FunctionTable getDescriptors(int idx) {
        return this.descriptors[idx];
    }

    public void setDescriptors(FunctionTable descriptor, int index) {
        this.descriptors[index] = descriptor;
    }

    public void setSizeOfAlignPad(int sizeOfAlignPad) {
        this.sizeOfAlignPad = sizeOfAlignPad;
    }

    public int getSizeOfAlignPad() {
        return this.sizeOfAlignPad;
    }
}

