/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.naming.MDQualifier;

public class MDQualification
extends MDParsableItem
implements Iterable<MDQualifier> {
    private List<MDQualifier> quals = new ArrayList<MDQualifier>();

    public MDQualification(MDMang dmang) {
        super(dmang);
    }

    public boolean hasContent() {
        return this.quals.size() > 0;
    }

    @Override
    public void insert(StringBuilder builder) {
        this.dmang.insert(builder, this);
    }

    public void insert_MdVersion(StringBuilder builder) {
        boolean isInterface = false;
        for (MDQualifier qual : this.quals) {
            if (isInterface) {
                this.dmang.insertString(builder, "[");
            }
            if (isInterface = qual.isInterface()) {
                this.dmang.insertString(builder, "]");
            }
            qual.insert(builder);
            if (this.quals.indexOf(qual) == this.quals.size() - 1) continue;
            this.dmang.insertString(builder, "::");
        }
        if (isInterface) {
            this.dmang.insertString(builder, "[");
        }
    }

    public void insert_VSAll(StringBuilder builder) {
        boolean isInterface = false;
        for (MDQualifier qual : this.quals) {
            if (isInterface) {
                this.dmang.insertString(builder, "[");
            }
            if (isInterface = qual.isInterface()) {
                this.dmang.insertString(builder, "]");
            }
            qual.insert(builder);
            if (this.quals.indexOf(qual) == this.quals.size() - 1) continue;
            this.dmang.insertString(builder, "::");
        }
    }

    public void insertHeadQualifier(StringBuilder builder) {
        if (this.quals.size() != 0) {
            this.quals.get(0).insert(builder);
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        while (this.dmang.peek() != '\uffff' && this.dmang.peek() != '@') {
            int loc = this.dmang.getIndex();
            MDQualifier qual = new MDQualifier(this.dmang);
            qual.parse();
            if (this.dmang.getIndex() == loc) break;
            this.quals.add(qual);
        }
        if (this.dmang.peek() == '@') {
            this.dmang.increment();
        }
    }

    @Override
    public Iterator<MDQualifier> iterator() {
        return this.quals.iterator();
    }
}

