/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.formats;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.MachHeaderFileTypes;
import ghidra.app.util.bin.format.macho.MachHeaderFlags;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class MachoBinaryAnalysisCommand
extends FlatProgramAPI
implements BinaryAnalysisCommand,
AnalysisWorker {
    private MessageLog messages = new MessageLog();
    private Address address;
    private boolean isRelativeToAddress;
    private ProgramModule module;

    public MachoBinaryAnalysisCommand() {
    }

    public MachoBinaryAnalysisCommand(Address address, ProgramModule module) {
        this(address, true, module);
    }

    public MachoBinaryAnalysisCommand(Address address, boolean isRelativeToAddress, ProgramModule module) {
        this.address = address;
        this.isRelativeToAddress = isRelativeToAddress;
        this.module = module;
    }

    @Override
    public boolean canApply(Program program) {
        try {
            if (!"Raw Binary".equals(program.getExecutableFormat())) {
                return false;
            }
            Memory memory = program.getMemory();
            Address address = this.getAddress(program);
            int magic = memory.getInt(address);
            return MachConstants.isMagic(magic);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Address getAddress(Program program) {
        return this.address == null ? program.getAddressFactory().getDefaultAddressSpace().getAddress(0L) : this.address;
    }

    @Override
    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
        try {
            MachHeader header = new MachHeader(provider, this.getAddress(program).getOffset(), this.isRelativeToAddress);
            header.parse();
            Address machAddress = this.getAddress(program);
            DataType headerDT = header.toDataType();
            this.createData(machAddress, headerDT);
            this.setHeaderComment(header, machAddress);
            int commandStartIndex = headerDT.getLength();
            Address commandAddress = machAddress.add((long)commandStartIndex);
            this.createFragment(this.module, headerDT.getDisplayName(), machAddress, commandStartIndex);
            List<LoadCommand> commands = header.getLoadCommands();
            for (LoadCommand command : commands) {
                command.markupRawBinary(header, this, this.getAddress(program), this.module, monitor, this.messages);
                commandAddress = commandAddress.add((long)command.getCommandSize());
                if (!(command instanceof UnsupportedLoadCommand)) continue;
                bookmarkManager.setBookmark(machAddress.add(command.getStartIndex()), "Warning", "Load commands", command.getCommandName());
            }
            return true;
        }
        catch (MachException e) {
            this.messages.appendMsg("Not a binary Mach-O program: Mach header not found.");
            return false;
        }
    }

    @Override
    public String getWorkerName() {
        return this.getName();
    }

    @Override
    public boolean applyTo(Program program, TaskMonitor monitor) throws Exception {
        this.set(program, monitor);
        if (this.module == null) {
            this.module = program.getListing().getDefaultRootModule();
        }
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(program);
        return aam.scheduleWorker(this, null, false, monitor);
    }

    @Override
    public String getName() {
        return "Mach-O Header Annotation";
    }

    @Override
    public MessageLog getMessages() {
        return this.messages;
    }

    private void setHeaderComment(MachHeader header, Address machAddress) {
        StringBuffer comments = new StringBuffer();
        comments.append("File type: ");
        comments.append(MachHeaderFileTypes.getFileTypeName(header.getFileType()));
        comments.append('\n');
        comments.append('\t');
        comments.append(MachHeaderFileTypes.getFileTypeDescription(header.getFileType()));
        comments.append('\n');
        comments.append('\n');
        comments.append("Flags:");
        List<String> flags = MachHeaderFlags.getFlags(header.getFlags());
        for (String flag : flags) {
            comments.append('\t');
            comments.append(flag);
            comments.append('\n');
        }
        this.setPlateComment(machAddress, comments.toString());
    }
}

