/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class FloatArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_SIZE = 4;
    float[] floats = new float[4];
    int lastNonZeroIndex = -1;

    public void put(int index, float value) {
        if (value == 0.0f) {
            this.remove(index);
            return;
        }
        if (index >= this.floats.length) {
            this.adjustArray(Math.max(index + 1, this.floats.length * 2));
        }
        this.floats[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.floats.length) {
            return;
        }
        this.floats[index] = 0.0f;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.floats.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.floats[i] == 0.0f) continue;
            return i;
        }
        return -1;
    }

    public float get(int index) {
        if (index < this.floats.length) {
            return this.floats[index];
        }
        return 0.0f;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        float[] newfloats = new float[size];
        int len = Math.min(size, this.floats.length);
        System.arraycopy(this.floats, 0, newfloats, 0, len);
        this.floats = newfloats;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putFloat(toIndex, toCol, this.get(index));
    }
}

