/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.DefaultGroupTestEventReporter;
import org.gradle.api.internal.tasks.testing.DefaultTestEventReporter;
import org.gradle.api.internal.tasks.testing.GroupTestEventReporterInternal;
import org.gradle.api.internal.tasks.testing.LifecycleTrackingTestEventReporter;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.tasks.testing.GroupTestEventReporter;
import org.gradle.api.tasks.testing.TestEventReporter;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.jspecify.annotations.NullMarked;

@NullMarked
class LifecycleTrackingGroupTestEventReporter
extends LifecycleTrackingTestEventReporter<DefaultGroupTestEventReporter>
implements GroupTestEventReporterInternal {
    private final Set<LifecycleTrackingTestEventReporter<?>> children = new HashSet();

    LifecycleTrackingGroupTestEventReporter(DefaultGroupTestEventReporter delegate) {
        super(delegate);
    }

    @Override
    protected void markCompleted() {
        for (LifecycleTrackingTestEventReporter<?> child : this.children) {
            if (child.isCompleted()) continue;
            throw new IllegalStateException(String.format("Group was completed before tests (%s).", child));
        }
        super.markCompleted();
    }

    @Override
    public void close() {
        super.close();
        CompositeStoppable.stoppable(this.children).stop();
        this.children.clear();
    }

    @Override
    public TestEventReporter reportTest(String name, String displayName) {
        LifecycleTrackingTestEventReporter<DefaultTestEventReporter> child = new LifecycleTrackingTestEventReporter<DefaultTestEventReporter>(((DefaultGroupTestEventReporter)this.delegate).reportTest(name, displayName));
        this.children.add(child);
        return child;
    }

    @Override
    public TestEventReporter reportTestDirectly(TestDescriptorInternal testDescriptor) {
        LifecycleTrackingTestEventReporter<DefaultTestEventReporter> child = new LifecycleTrackingTestEventReporter<DefaultTestEventReporter>(((DefaultGroupTestEventReporter)this.delegate).reportTestDirectly(testDescriptor));
        this.children.add(child);
        return child;
    }

    @Override
    public GroupTestEventReporter reportTestGroup(String name) {
        LifecycleTrackingGroupTestEventReporter child = new LifecycleTrackingGroupTestEventReporter(((DefaultGroupTestEventReporter)this.delegate).reportTestGroup(name));
        this.children.add(child);
        return child;
    }

    @Override
    public GroupTestEventReporter reportTestGroupDirectly(TestDescriptorInternal testDescriptor) {
        LifecycleTrackingGroupTestEventReporter child = new LifecycleTrackingGroupTestEventReporter(((DefaultGroupTestEventReporter)this.delegate).reportTestGroupDirectly(testDescriptor));
        this.children.add(child);
        return child;
    }
}

