/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.values;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.debugger.values.CannotRetrieveColumnDataException;
import com.jetbrains.python.debugger.values.DataFrameDebugValue;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000b\u0010\u0010\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0011H\u0007\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u001a\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u000b\u0010\u0014\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0011H\u0002\"\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"completeDataFrameColumns", "", "", "treeColumns", "Lcom/jetbrains/python/debugger/values/DataFrameDebugValue$ColumnNode;", "columnsBefore", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MULTI_INDEX_DATA_REGEX", "Lkotlin/text/Regex;", "MULTI_INDEX_COLUMN_GROUP_REGEX", "COLUMN_NAMES_REGEX", "getInformationColumns", "Lcom/jetbrains/python/debugger/values/DataFrameDebugValue$InformationColumns;", "value", "Lcom/intellij/openapi/util/NlsSafe;", "getDataWithColumnsNames", "getMultiIndexData", "columnData", "intellij.python.pydev"})
@SourceDebugExtension(value={"SMAP\nDataFrameDebugValueUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameDebugValueUtil.kt\ncom/jetbrains/python/debugger/values/DataFrameDebugValueUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,103:1\n1#2:104\n158#3,6:105\n*S KotlinDebug\n*F\n+ 1 DataFrameDebugValueUtil.kt\ncom/jetbrains/python/debugger/values/DataFrameDebugValueUtilKt\n*L\n70#1:105,6\n*E\n"})
public final class DataFrameDebugValueUtilKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex MULTI_INDEX_DATA_REGEX;
    @NotNull
    private static final Regex MULTI_INDEX_COLUMN_GROUP_REGEX;
    @NotNull
    private static final Regex COLUMN_NAMES_REGEX;

    @Nullable
    public static final Set<String> completeDataFrameColumns(@NotNull DataFrameDebugValue.ColumnNode treeColumns, @NotNull List<String> columnsBefore) {
        Set<String> set;
        Intrinsics.checkNotNullParameter((Object)treeColumns, (String)"treeColumns");
        Intrinsics.checkNotNullParameter(columnsBefore, (String)"columnsBefore");
        if (!((Collection)columnsBefore).isEmpty()) {
            Object object = treeColumns.children;
            if (object == null || (object = (DataFrameDebugValue.ColumnNode)object.get((Object)columnsBefore.get(0))) == null) {
                return SetsKt.emptySet();
            }
            Object node = object;
            int n = columnsBefore.size();
            for (int i = 1; i < n; ++i) {
                String string = columnsBefore.get(i);
                Intrinsics.checkNotNull((Object)string);
                node = ((DataFrameDebugValue.ColumnNode)node).getChildIfExist(string);
                if (node != null) continue;
                return SetsKt.emptySet();
            }
            set = ((DataFrameDebugValue.ColumnNode)node).getChildrenName();
        } else {
            set = treeColumns.getChildrenName();
        }
        return set;
    }

    @ApiStatus.Internal
    @Nullable
    public static final DataFrameDebugValue.InformationColumns getInformationColumns(@NotNull String value) throws CannotRetrieveColumnDataException {
        DataFrameDebugValue.InformationColumns informationColumns;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = DataFrameDebugValueUtilKt.getDataWithColumnsNames(value);
        if (string == null) {
            throw new CannotRetrieveColumnDataException("Can't retrieve column data");
        }
        String columnsNames = string;
        DataFrameDebugValue.InformationColumns informationColumns2 = DataFrameDebugValueUtilKt.getMultiIndexData(columnsNames);
        if (informationColumns2 != null) {
            DataFrameDebugValue.InformationColumns it = informationColumns2;
            boolean bl = false;
            return it;
        }
        List columns = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)COLUMN_NAMES_REGEX, (CharSequence)columnsNames, (int)0, (int)2, null), DataFrameDebugValueUtilKt::getInformationColumns$lambda$1));
        if (!((Collection)columns).isEmpty()) {
            DataFrameDebugValue.InformationColumns informationColumns3;
            DataFrameDebugValue.InformationColumns $this$getInformationColumns_u24lambda_u242 = informationColumns3 = new DataFrameDebugValue.InformationColumns();
            boolean bl = false;
            $this$getInformationColumns_u24lambda_u242.isMultiIndex = false;
            $this$getInformationColumns_u24lambda_u242.columns = columns;
            informationColumns = informationColumns3;
        } else {
            informationColumns = null;
        }
        return informationColumns;
    }

    private static final String getDataWithColumnsNames(String value) {
        String string;
        int n;
        block5: {
            boolean escaped = false;
            boolean inSingleQuotes = false;
            boolean inDoubleQuotes = false;
            CharSequence $this$indexOfFirst$iv = value;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char c = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                inSingleQuotes = inSingleQuotes ^ (c == '\'' && !escaped) && !inDoubleQuotes;
                inDoubleQuotes = inDoubleQuotes ^ (c == '\"' && !escaped) && !inSingleQuotes;
                escaped = !escaped && c == '\\';
                if (!(!inSingleQuotes && !inDoubleQuotes && c == ']')) continue;
                n = index$iv;
                break block5;
            }
            n = -1;
        }
        int index = n;
        if (index != -1) {
            String string2 = value.substring(0, index + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (StringsKt.endsWith$default((String)value, (String)"...", (boolean)false, (int)2, null)) {
            String string3 = value.substring(0, value.length() - 3);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    private static final DataFrameDebugValue.InformationColumns getMultiIndexData(String columnData) {
        DataFrameDebugValue.InformationColumns informationColumns;
        Object object = Regex.find$default((Regex)MULTI_INDEX_DATA_REGEX, (CharSequence)columnData, (int)0, (int)2, null);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(0)) == null || (object = object.getValue()) == null) {
            return null;
        }
        List columns = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)MULTI_INDEX_COLUMN_GROUP_REGEX, (CharSequence)columnData, (int)0, (int)2, null), DataFrameDebugValueUtilKt::getMultiIndexData$lambda$0));
        if (!((Collection)columns).isEmpty()) {
            DataFrameDebugValue.InformationColumns informationColumns2;
            DataFrameDebugValue.InformationColumns $this$getMultiIndexData_u24lambda_u241 = informationColumns2 = new DataFrameDebugValue.InformationColumns();
            boolean bl = false;
            $this$getMultiIndexData_u24lambda_u241.isMultiIndex = true;
            $this$getMultiIndexData_u24lambda_u241.columns = columns;
            informationColumns = informationColumns2;
        } else {
            informationColumns = null;
        }
        return informationColumns;
    }

    private static final List getInformationColumns$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.listOf((Object)((MatchGroup)CollectionsKt.last((List)CollectionsKt.filterNotNull((Iterable)((Iterable)it.getGroups())))).getValue());
    }

    private static final List getMultiIndexData$lambda$0(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)COLUMN_NAMES_REGEX, (CharSequence)result.getValue(), (int)0, (int)2, null), DataFrameDebugValueUtilKt::getMultiIndexData$lambda$0$0));
    }

    private static final String getMultiIndexData$lambda$0$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((MatchGroup)CollectionsKt.last((List)CollectionsKt.filterNotNull((Iterable)((Iterable)it.getGroups())))).getValue();
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        MULTI_INDEX_DATA_REGEX = new Regex("\\[(\\(.*?(?=\\)).*?)+]");
        MULTI_INDEX_COLUMN_GROUP_REGEX = new Regex("\\((.*?(?=\\).*?))\\)");
        COLUMN_NAMES_REGEX = new Regex("'(.*?(?<!\\\\))'|\"(.*?(?<!\\\\))\"");
    }
}

