/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.terminal.completion.ShellCommandSpecsManager;
import com.intellij.terminal.completion.spec.ShellCommandSpec;
import com.intellij.util.containers.MultiMap;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.completion.ShellCommandSpecsManagerImpl;
import org.jetbrains.plugins.terminal.block.completion.TerminalCompletionScopeKt;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecConflictStrategy;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecInfo;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellCommandSpecsProvider;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellMergedCommandSpec;
import org.jetbrains.plugins.terminal.block.completion.spec.json.ShellJsonBasedCommandSpec;
import org.jetbrains.plugins.terminal.block.completion.spec.json.ShellJsonCommandSpecsProvider;
import org.jetbrains.plugins.terminal.block.completion.spec.json.ShellJsonCommandSpecsUtil;
import org.jetbrains.terminal.completion.ShellCommand;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\nJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0016\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0002J\u001e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0002J\u0018\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\r2\u0006\u0010%\u001a\u00020\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl;", "Lcom/intellij/terminal/completion/ShellCommandSpecsManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "tracer", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "lightSpecsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "jsonBasedSpecProviders", "Lorg/jetbrains/plugins/terminal/block/completion/spec/json/ShellJsonCommandSpecsProvider;", "fullSpecsCache", "Lorg/jetbrains/plugins/terminal/block/completion/spec/json/ShellJsonBasedCommandSpec;", "getCommandSpec", "commandName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFullCommandSpec", "spec", "(Lcom/intellij/terminal/completion/spec/ShellCommandSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLightCommandSpec", "getJsonCommandSpecProvider", "loadCommandSpecsIfNeeded", "", "loadCommandSpecs", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl$ShellCommandSpecData;", "clearCaches", "resolveSpecsConflict", "specs", "", "conflictMessage", "strategy", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecConflictStrategy;", "loadFullCommandSpec", "specRef", "getSpecPath", "provider", "ShellCommandSpecData", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nShellCommandSpecsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandSpecsManagerImpl.kt\norg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,274:1\n1#2:275\n1563#3:276\n1634#3,3:277\n774#3:306\n865#3,2:307\n774#3:309\n865#3,2:310\n774#3:312\n865#3,2:313\n1563#3:315\n1634#3,3:316\n27#4:280\n87#4,2:281\n28#4,2:283\n27#4:285\n87#4,2:286\n28#4,3:288\n98#4:291\n90#4,6:292\n98#4:298\n30#4:299\n90#4,6:300\n13#5:319\n*S KotlinDebug\n*F\n+ 1 ShellCommandSpecsManagerImpl.kt\norg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl\n*L\n113#1:276\n113#1:277,3\n193#1:306\n193#1:307,2\n201#1:309\n201#1:310,2\n207#1:312\n207#1:313,2\n212#1:315\n212#1:316,3\n170#1:280\n170#1:281,2\n170#1:283,2\n173#1:285\n173#1:286,2\n173#1:288,3\n173#1:291\n173#1:292,6\n170#1:298\n170#1:299\n170#1:300,6\n271#1:319\n*E\n"})
public final class ShellCommandSpecsManagerImpl
implements ShellCommandSpecsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IJTracer tracer;
    @NotNull
    private final Cache<String, ShellCommandSpec> lightSpecsCache;
    @NotNull
    private final Cache<String, ShellJsonCommandSpecsProvider> jsonBasedSpecProviders;
    @NotNull
    private final Cache<String, ShellJsonBasedCommandSpec> fullSpecsCache;
    @NotNull
    private static final Logger LOG;

    public ShellCommandSpecsManagerImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.tracer = TelemetryManager.Companion.getTracer(TerminalCompletionScopeKt.TerminalCompletionScope);
        Cache cache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).scheduler(Scheduler.systemScheduler()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.lightSpecsCache = cache;
        Cache cache2 = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).scheduler(Scheduler.systemScheduler()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.jsonBasedSpecProviders = cache2;
        Cache cache3 = Caffeine.newBuilder().maximumSize(10L).expireAfterAccess(Duration.ofMinutes(5L)).scheduler(Scheduler.systemScheduler()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.fullSpecsCache = cache3;
        ShellCommandSpecsProvider.Companion.getEP_NAME().addExtensionPointListener(coroutineScope, (ExtensionPointListener)new ExtensionPointListener<ShellCommandSpecsProvider>(){

            public void extensionAdded(ShellCommandSpecsProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.clearCaches();
            }

            public void extensionRemoved(ShellCommandSpecsProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.clearCaches();
            }
        });
    }

    @Override
    @Nullable
    public Object getCommandSpec(@NotNull String commandName, @NotNull Continuation<? super ShellCommandSpec> $completion) {
        ShellCommandSpec shellCommandSpec = this.getLightCommandSpec(commandName);
        if (shellCommandSpec == null) {
            return null;
        }
        ShellCommandSpec spec = shellCommandSpec;
        return this.getFullCommandSpec(spec, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getFullCommandSpec(@NotNull ShellCommandSpec spec, @NotNull Continuation<? super ShellCommandSpec> $completion) {
        block15: {
            block16: {
                if (!($completion instanceof getFullCommandSpec.1)) ** GOTO lbl-1000
                var16_3 = $completion;
                if ((var16_3.label & -2147483648) != 0) {
                    var16_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        Object L$8;
                        int I$0;
                        int I$1;
                        int I$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ ShellCommandSpecsManagerImpl this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getFullCommandSpec(null, (Continuation<? super ShellCommandSpec>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(spec instanceof ShellMergedCommandSpec)) break block15;
                        v0 = ((ShellMergedCommandSpec)spec).getBaseSpec();
                        if (v0 == null) break;
                        it = v0;
                        $i$a$-let-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullBaseSpec$1 = 0;
                        $continuation.L$0 = spec;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$a$-let-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullBaseSpec$1;
                        $continuation.label = 1;
                        v1 = this.getFullCommandSpec(it, (Continuation<? super ShellCommandSpec>)$continuation);
                        if (v1 == var17_5) {
                            return var17_5;
                        }
                        ** GOTO lbl31
                    }
                    case 1: {
                        $i$a$-let-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullBaseSpec$1 = $continuation.I$0;
                        it = (ShellCommandSpec)$continuation.L$1;
                        spec = (ShellCommandSpec)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl31:
                        // 2 sources

                        v2 = (ShellCommandSpec)v1;
                        break block16;
                    }
                }
                v2 = null;
            }
            fullBaseSpec = v2;
            $this$map$iv = ((ShellMergedCommandSpec)spec).getOverridingSpecs();
            $i$f$map = 0;
            $i$a$-let-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullBaseSpec$1 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = 0;
            var10_19 = $this$mapTo$iv$iv.iterator();
lbl42:
            // 2 sources

            while (var10_19.hasNext()) {
                item$iv$iv = var10_19.next();
                var12_21 = (ShellCommandSpec)item$iv$iv;
                var14_23 = destination$iv$iv;
                $i$a$-map-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullOverrideSpecs$1 = 0;
                $continuation.L$0 = spec;
                $continuation.L$1 = fullBaseSpec;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$map$iv);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$mapTo$iv$iv);
                $continuation.L$4 = destination$iv$iv;
                $continuation.L$5 = var10_19;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)item$iv$iv);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                $continuation.L$8 = var14_23;
                $continuation.I$0 = $i$f$map;
                $continuation.I$1 = $i$f$mapTo;
                $continuation.I$2 = $i$a$-map-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullOverrideSpecs$1;
                $continuation.label = 2;
                v3 = this.getFullCommandSpec(it, (Continuation<? super ShellCommandSpec>)$continuation);
                if (v3 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl80
            }
            {
                break;
                case 2: {
                    $i$a$-map-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullOverrideSpecs$1 = $continuation.I$2;
                    $i$f$mapTo = $continuation.I$1;
                    $i$f$map = $continuation.I$0;
                    var14_23 = (Collection)$continuation.L$8;
                    it = (ShellCommandSpec)$continuation.L$7;
                    item$iv$iv = $continuation.L$6;
                    var10_19 = (Iterator<T>)$continuation.L$5;
                    destination$iv$iv = (Collection)$continuation.L$4;
                    $this$mapTo$iv$iv = (Iterable)$continuation.L$3;
                    $this$map$iv = (Iterable)$continuation.L$2;
                    fullBaseSpec = (ShellCommandSpec)$continuation.L$1;
                    spec = (ShellCommandSpec)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl80:
                    // 2 sources

                    var14_23.add((ShellCommandSpec)v3);
                    ** GOTO lbl42
                }
            }
            fullOverrideSpecs = (List)destination$iv$iv;
            return new ShellMergedCommandSpec(fullBaseSpec, fullOverrideSpecs, ((ShellMergedCommandSpec)spec).getParentNames());
        }
        if (!(spec instanceof ShellJsonBasedCommandSpec) || ((ShellJsonBasedCommandSpec)spec).getFullSpecRef() == null) {
            return spec;
        }
        v4 = ((ShellJsonBasedCommandSpec)spec).getFullSpecRef();
        Intrinsics.checkNotNull((Object)v4);
        specRef = v4;
        v5 = (ShellJsonBasedCommandSpec)this.fullSpecsCache.getIfPresent((Object)specRef);
        if (v5 != null) {
            it = v5;
            $i$a$-let-ShellCommandSpecsManagerImpl$getFullCommandSpec$2 = false;
            return it;
        }
        $continuation.L$0 = spec;
        $continuation.L$1 = specRef;
        $continuation.label = 3;
        v6 = this.loadFullCommandSpec(specRef, (Continuation<? super ShellJsonBasedCommandSpec>)$continuation);
        if (v6 == var17_5) {
            return var17_5;
        }
        ** GOTO lbl108
        {
            case 3: {
                specRef = (String)$continuation.L$1;
                spec = (ShellCommandSpec)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl108:
                // 2 sources

                v7 = (ShellJsonBasedCommandSpec)v6;
                if (v7 == null) {
                    $this$getFullCommandSpec_u24lambda_u243 = this;
                    $i$a$-run-ShellCommandSpecsManagerImpl$getFullCommandSpec$fullSpec$1 = false;
                    ShellCommandSpecsManagerImpl.LOG.error("Failed to load full command spec '" + specRef + "'");
                    return spec;
                }
                fullSpec = v7;
                this.fullSpecsCache.put((Object)specRef, (Object)fullSpec);
                return fullSpec;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final ShellCommandSpec getLightCommandSpec(@NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        this.loadCommandSpecsIfNeeded();
        return (ShellCommandSpec)this.lightSpecsCache.getIfPresent((Object)commandName);
    }

    private final ShellJsonCommandSpecsProvider getJsonCommandSpecProvider(String commandName) {
        this.loadCommandSpecsIfNeeded();
        return (ShellJsonCommandSpecsProvider)this.jsonBasedSpecProviders.getIfPresent((Object)commandName);
    }

    private final void loadCommandSpecsIfNeeded() {
        if (this.lightSpecsCache.estimatedSize() != 0L && this.jsonBasedSpecProviders.estimatedSize() != 0L) {
            return;
        }
        MultiMap<String, ShellCommandSpecData> specsDataMap = this.loadCommandSpecs();
        for (Map.Entry entry : specsDataMap.entrySet()) {
            ShellCommandSpecData jsonSpecData;
            Object v1;
            String name;
            block5: {
                ShellCommandSpecData shellCommandSpecData;
                Intrinsics.checkNotNull((Object)entry);
                name = (String)entry.getKey();
                Collection specs = (Collection)entry.getValue();
                if (specs.size() > 1) {
                    Intrinsics.checkNotNull((Object)specs);
                    shellCommandSpecData = this.resolveSpecsConflict(specs);
                } else {
                    Intrinsics.checkNotNull((Object)specs);
                    shellCommandSpecData = (ShellCommandSpecData)CollectionsKt.first((Iterable)specs);
                }
                ShellCommandSpecData specData = shellCommandSpecData;
                this.lightSpecsCache.put((Object)name, (Object)specData.getSpec());
                Iterable iterable = specs;
                for (Object t : iterable) {
                    ShellCommandSpecData it = (ShellCommandSpecData)t;
                    boolean bl = false;
                    if (!(it.getSpec() instanceof ShellJsonBasedCommandSpec)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            if ((jsonSpecData = (ShellCommandSpecData)v1) == null) continue;
            ShellCommandSpecsProvider shellCommandSpecsProvider = jsonSpecData.getProvider();
            Intrinsics.checkNotNull((Object)shellCommandSpecsProvider, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.block.completion.spec.json.ShellJsonCommandSpecsProvider");
            this.jsonBasedSpecProviders.put((Object)name, (Object)((ShellJsonCommandSpecsProvider)shellCommandSpecsProvider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MultiMap<String, ShellCommandSpecData> loadCommandSpecs() {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("terminal-load-command-specs");
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            MultiMap multiMap;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                MultiMap specsDataMap = new MultiMap();
                for (ShellCommandSpecsProvider provider : ShellCommandSpecsProvider.Companion.getEP_NAME().getExtensionList()) {
                    Span $this$useWithoutActiveScope$iv$iv2;
                    SpanBuilder $this$use$iv2;
                    Intrinsics.checkNotNullExpressionValue((Object)this.tracer.spanBuilder(provider.getClass().getName()), (String)"spanBuilder(...)");
                    boolean $i$f$use2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$use$iv2.startSpan(), (String)"startSpan(...)");
                    boolean $i$f$useWithoutActiveScope2 = false;
                    try {
                        Unit unit;
                        Span span$iv2 = $this$useWithoutActiveScope$iv$iv2;
                        $i$a$-useWithoutActiveScope-TraceKt$use$1$iv = false;
                        AutoCloseable autoCloseable2 = (AutoCloseable)span$iv2.makeCurrent();
                        Throwable throwable2 = null;
                        try {
                            Scope it$iv2 = (Scope)autoCloseable2;
                            $i$a$-use-TraceKt$use$1$1$iv = false;
                            Span it2 = span$iv2;
                            boolean bl4 = false;
                            List<ShellCommandSpecInfo> specInfos = provider.getCommandSpecs();
                            for (ShellCommandSpecInfo specInfo : specInfos) {
                                ShellCommandSpecData specData = new ShellCommandSpecData(specInfo.getSpec(), specInfo.getConflictStrategy(), provider);
                                specsDataMap.putValue((Object)specData.getSpec().getName(), (Object)specData);
                            }
                            unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                        }
                        Unit unit2 = unit;
                    }
                    catch (CancellationException e$iv$iv) {
                        throw e$iv$iv;
                    }
                    catch (Throwable e$iv$iv) {
                        $this$useWithoutActiveScope$iv$iv2.setStatus(StatusCode.ERROR);
                        throw e$iv$iv;
                    }
                    finally {
                        $this$useWithoutActiveScope$iv$iv2.end();
                    }
                }
                multiMap = specsDataMap;
            }
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                        throw throwable5;
                    }
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            MultiMap multiMap2 = multiMap;
            return multiMap2;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
    }

    private final void clearCaches() {
        this.lightSpecsCache.invalidateAll();
        this.jsonBasedSpecProviders.invalidateAll();
        this.fullSpecsCache.invalidateAll();
    }

    /*
     * WARNING - void declaration
     */
    private final ShellCommandSpecData resolveSpecsConflict(Collection<ShellCommandSpecData> specs) {
        ShellCommandSpecData shellCommandSpecData;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        boolean bl;
        boolean bl2 = bl = specs.size() > 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$filter$iv = specs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            ShellCommandSpecData it = (ShellCommandSpecData)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getConflictStrategy() == ShellCommandSpecConflictStrategy.REPLACE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List replaceSpecs = (List)destination$iv$iv;
        if (!((Collection)replaceSpecs).isEmpty()) {
            if (replaceSpecs.size() > 1) {
                LOG.warn(this.conflictMessage(ShellCommandSpecConflictStrategy.REPLACE, specs));
            }
            return (ShellCommandSpecData)CollectionsKt.first((List)replaceSpecs);
        }
        Iterable $this$filter$iv2 = specs;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ShellCommandSpecData it = (ShellCommandSpecData)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getConflictStrategy() == ShellCommandSpecConflictStrategy.DEFAULT)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List baseSpecs = (List)destination$iv$iv2;
        if (baseSpecs.size() > 1) {
            LOG.warn(this.conflictMessage(ShellCommandSpecConflictStrategy.DEFAULT, baseSpecs));
        }
        ShellCommandSpecData baseSpecData = (ShellCommandSpecData)CollectionsKt.firstOrNull((List)baseSpecs);
        Iterable $this$filter$iv3 = specs;
        boolean $i$f$filter32 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShellCommandSpecData it = (ShellCommandSpecData)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getConflictStrategy() == ShellCommandSpecConflictStrategy.OVERRIDE)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List overrideSpecs = (List)destination$iv$iv3;
        if (overrideSpecs.size() == 1 && baseSpecData == null) {
            shellCommandSpecData = (ShellCommandSpecData)CollectionsKt.single((List)overrideSpecs);
        } else if (!((Collection)overrideSpecs).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ShellCommandSpecData shellCommandSpecData2 = baseSpecData;
            Iterable $i$f$filter32 = overrideSpecs;
            ShellCommandSpec shellCommandSpec = shellCommandSpecData2 != null ? shellCommandSpecData2.getSpec() : null;
            boolean $i$f$map = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ShellCommandSpecData bl5 = (ShellCommandSpecData)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl6 = false;
                collection.add(it.getSpec());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            List list = null;
            List list2 = (List)destination$iv$iv4;
            ShellCommandSpec shellCommandSpec2 = shellCommandSpec;
            ShellMergedCommandSpec mergedSpec = new ShellMergedCommandSpec(shellCommandSpec2, list2, list, n, defaultConstructorMarker);
            Object object = baseSpecData;
            if (object == null || (object = ((ShellCommandSpecData)object).getProvider()) == null) {
                object = ((ShellCommandSpecData)CollectionsKt.first((List)overrideSpecs)).getProvider();
            }
            Object provider = object;
            shellCommandSpecData = new ShellCommandSpecData(mergedSpec, ShellCommandSpecConflictStrategy.OVERRIDE, (ShellCommandSpecsProvider)provider);
        } else {
            ShellCommandSpecData shellCommandSpecData3 = baseSpecData;
            shellCommandSpecData = shellCommandSpecData3;
            Intrinsics.checkNotNull((Object)shellCommandSpecData3);
        }
        return shellCommandSpecData;
    }

    private final String conflictMessage(ShellCommandSpecConflictStrategy strategy, Collection<ShellCommandSpecData> specs) {
        return "There are more than one shell command spec with " + strategy.name() + " conflict strategy for the same command: " + specs + "\nTaking only the first one.";
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadFullCommandSpec(String specRef, Continuation<? super ShellJsonBasedCommandSpec> $completion) {
        if (!($completion instanceof loadFullCommandSpec.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ShellCommandSpecsManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ShellCommandSpecsManagerImpl.access$loadFullCommandSpec(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                mainCommand = StringsKt.contains$default((CharSequence)specRef, (char)'/', (boolean)false, (int)2, null) != false ? StringsKt.substringBefore$default((String)specRef, (char)'/', null, (int)2, null) : null;
                v0 = mainCommand;
                if (v0 == null) {
                    v0 = specRef;
                }
                v1 = this.getJsonCommandSpecProvider(v0);
                if (v1 == null) {
                    return null;
                }
                specProvider = v1;
                path = this.getSpecPath(specProvider, specRef);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)specRef);
                $continuation.L$1 = mainCommand;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)specProvider);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)path);
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ShellCommand>, Object>(path, specProvider, null){
                    int label;
                    final /* synthetic */ String $path;
                    final /* synthetic */ ShellJsonCommandSpecsProvider $specProvider;
                    {
                        this.$path = $path;
                        this.$specProvider = $specProvider;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object;
                                void path$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                ShellJsonCommandSpecsUtil shellJsonCommandSpecsUtil = ShellJsonCommandSpecsUtil.INSTANCE;
                                String string = this.$path;
                                ClassLoader classLoader = this.$specProvider.getClass().getClassLoader();
                                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                                ClassLoader classLoader$iv = classLoader;
                                boolean $i$f$loadAndParseJson = false;
                                URL url$iv = classLoader$iv.getResource((String)path$iv);
                                if (url$iv == null) {
                                    void $this$thisLogger$iv$iv = this_$iv;
                                    boolean $i$f$thisLogger = false;
                                    Logger logger = Logger.getInstance(ShellJsonCommandSpecsUtil.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                    logger.warn("Failed to find resource for path: " + (String)path$iv + " with classLoader: " + classLoader$iv);
                                    object = null;
                                } else {
                                    Object object2;
                                    try {
                                        void this_$iv$iv;
                                        URL $i$f$thisLogger = url$iv;
                                        Charset charset = Charsets.UTF_8;
                                        byte[] byArray = TextStreamsKt.readBytes((URL)$i$f$thisLogger);
                                        String resultJson$iv = new String(byArray, charset);
                                        $i$f$thisLogger = ShellJsonCommandSpecsUtil.access$getJson((ShellJsonCommandSpecsUtil)this_$iv);
                                        String string$iv$iv = resultJson$iv;
                                        boolean $i$f$decodeFromString = false;
                                        this_$iv$iv.getSerializersModule();
                                        object2 = this_$iv$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)ShellCommand.Companion.serializer()), string$iv$iv);
                                    }
                                    catch (IOException ex$iv) {
                                        void $this$thisLogger$iv$iv = this_$iv;
                                        boolean $i$f$thisLogger = false;
                                        Logger logger = Logger.getInstance(ShellJsonCommandSpecsUtil.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                        logger.warn("Failed to load resource by URL: " + url$iv, (Throwable)ex$iv);
                                        object2 = null;
                                    }
                                    catch (Throwable t$iv) {
                                        void $this$thisLogger$iv$iv = this_$iv;
                                        boolean $i$f$thisLogger = false;
                                        Logger logger = Logger.getInstance(ShellJsonCommandSpecsUtil.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                        logger.warn("Failed to parse resource loaded from URL: " + url$iv, t$iv);
                                        object2 = null;
                                    }
                                    object = object2;
                                }
                                return object;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ShellCommand> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                path = (String)$continuation.L$3;
                specProvider = (ShellJsonCommandSpecsProvider)$continuation.L$2;
                mainCommand = (String)$continuation.L$1;
                specRef = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl37:
                // 2 sources

                v3 = (ShellCommand)v2;
                if (v3 == null) {
                    return null;
                }
                command = v3;
                v4 = (String)CollectionsKt.first((List)command.getNames());
                v5 = command;
                v6 = mainCommand;
                if (v6 == null) ** GOTO lbl56
                var7_12 = v6;
                var10_13 = v5;
                var9_14 = v4;
                $i$a$-let-ShellCommandSpecsManagerImpl$loadFullCommandSpec$2 = false;
                var11_16 = CollectionsKt.listOf((Object)it);
                v4 = var9_14;
                v5 = var10_13;
                v7 = var11_16;
                v6 = v7;
                if (v7 != null) ** GOTO lbl57
lbl56:
                // 2 sources

                v6 = CollectionsKt.emptyList();
lbl57:
                // 2 sources

                var14_17 = v6;
                var15_18 = v5;
                var16_19 = v4;
                return new ShellJsonBasedCommandSpec(var16_19, var15_18, (List<String>)var14_17);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getSpecPath(ShellJsonCommandSpecsProvider provider, String specRef) {
        String it = provider.getCommandSpecsPath();
        boolean bl = false;
        String basePath = ((CharSequence)it).length() == 0 || StringsKt.endsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? it : it + "/";
        return basePath + specRef + ".json";
    }

    @JvmStatic
    @NotNull
    public static final ShellCommandSpecsManagerImpl getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Object access$loadFullCommandSpec(ShellCommandSpecsManagerImpl $this, String specRef, Continuation $completion) {
        return $this.loadFullCommandSpec(specRef, (Continuation<? super ShellJsonBasedCommandSpec>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandSpecsManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandSpecsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandSpecsManagerImpl.kt\norg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,274:1\n42#2,3:275\n*S KotlinDebug\n*F\n+ 1 ShellCommandSpecsManagerImpl.kt\norg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl$Companion\n*L\n269#1:275,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ShellCommandSpecsManagerImpl getInstance() {
            boolean $i$f$service = false;
            Class<ShellCommandSpecsManagerImpl> serviceClass$iv = ShellCommandSpecsManagerImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ShellCommandSpecsManagerImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/ShellCommandSpecsManagerImpl$ShellCommandSpecData;", "", "spec", "Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "conflictStrategy", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecConflictStrategy;", "provider", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecsProvider;", "<init>", "(Lcom/intellij/terminal/completion/spec/ShellCommandSpec;Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecConflictStrategy;Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecsProvider;)V", "getSpec", "()Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "getConflictStrategy", "()Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecConflictStrategy;", "getProvider", "()Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellCommandSpecsProvider;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal"})
    private static final class ShellCommandSpecData {
        @NotNull
        private final ShellCommandSpec spec;
        @NotNull
        private final ShellCommandSpecConflictStrategy conflictStrategy;
        @NotNull
        private final ShellCommandSpecsProvider provider;

        public ShellCommandSpecData(@NotNull ShellCommandSpec spec, @NotNull ShellCommandSpecConflictStrategy conflictStrategy, @NotNull ShellCommandSpecsProvider provider) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)((Object)conflictStrategy), (String)"conflictStrategy");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.spec = spec;
            this.conflictStrategy = conflictStrategy;
            this.provider = provider;
        }

        @NotNull
        public final ShellCommandSpec getSpec() {
            return this.spec;
        }

        @NotNull
        public final ShellCommandSpecConflictStrategy getConflictStrategy() {
            return this.conflictStrategy;
        }

        @NotNull
        public final ShellCommandSpecsProvider getProvider() {
            return this.provider;
        }

        @NotNull
        public final ShellCommandSpec component1() {
            return this.spec;
        }

        @NotNull
        public final ShellCommandSpecConflictStrategy component2() {
            return this.conflictStrategy;
        }

        @NotNull
        public final ShellCommandSpecsProvider component3() {
            return this.provider;
        }

        @NotNull
        public final ShellCommandSpecData copy(@NotNull ShellCommandSpec spec, @NotNull ShellCommandSpecConflictStrategy conflictStrategy, @NotNull ShellCommandSpecsProvider provider) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)((Object)conflictStrategy), (String)"conflictStrategy");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new ShellCommandSpecData(spec, conflictStrategy, provider);
        }

        public static /* synthetic */ ShellCommandSpecData copy$default(ShellCommandSpecData shellCommandSpecData, ShellCommandSpec shellCommandSpec, ShellCommandSpecConflictStrategy shellCommandSpecConflictStrategy, ShellCommandSpecsProvider shellCommandSpecsProvider, int n, Object object) {
            if ((n & 1) != 0) {
                shellCommandSpec = shellCommandSpecData.spec;
            }
            if ((n & 2) != 0) {
                shellCommandSpecConflictStrategy = shellCommandSpecData.conflictStrategy;
            }
            if ((n & 4) != 0) {
                shellCommandSpecsProvider = shellCommandSpecData.provider;
            }
            return shellCommandSpecData.copy(shellCommandSpec, shellCommandSpecConflictStrategy, shellCommandSpecsProvider);
        }

        @NotNull
        public String toString() {
            return "ShellCommandSpecData(spec=" + this.spec + ", conflictStrategy=" + this.conflictStrategy + ", provider=" + this.provider + ")";
        }

        public int hashCode() {
            int result2 = this.spec.hashCode();
            result2 = result2 * 31 + this.conflictStrategy.hashCode();
            result2 = result2 * 31 + this.provider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShellCommandSpecData)) {
                return false;
            }
            ShellCommandSpecData shellCommandSpecData = (ShellCommandSpecData)other;
            if (!Intrinsics.areEqual((Object)this.spec, (Object)shellCommandSpecData.spec)) {
                return false;
            }
            if (this.conflictStrategy != shellCommandSpecData.conflictStrategy) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.provider, (Object)shellCommandSpecData.provider);
        }
    }
}

