#  Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

from typing import Any

from .. import util

class RefCollection(util.MemoizedSlots):
    ref: Any

class _empty_collection:
    def append(self, element) -> None: ...
    def extend(self, other) -> None: ...
    def remove(self, element) -> None: ...
    def __iter__(self): ...
    def clear(self) -> None: ...

class _ClsLevelDispatch(RefCollection):
    name: Any
    clsname: Any
    arg_names: Any
    has_kw: Any
    legacy_signatures: Any
    def __init__(self, parent_dispatch_cls, fn): ...
    def insert(self, event_key, propagate) -> None: ...
    def append(self, event_key, propagate) -> None: ...
    def update_subclass(self, target) -> None: ...
    def remove(self, event_key) -> None: ...
    def clear(self) -> None: ...
    def for_modify(self, obj): ...

class _InstanceLevelDispatch(RefCollection): ...

class _EmptyListener(_InstanceLevelDispatch):
    propagate: Any
    listeners: Any
    parent: Any
    parent_listeners: Any
    name: Any
    def __init__(self, parent, target_cls) -> None: ...
    def for_modify(self, obj): ...
    exec_once: Any
    exec_once_unless_exception: Any
    insert: Any
    append: Any
    remove: Any
    clear: Any
    def __call__(self, *args, **kw) -> None: ...
    def __len__(self): ...
    def __iter__(self): ...
    def __bool__(self): ...
    __nonzero__: Any

class _CompoundListener(_InstanceLevelDispatch):
    def exec_once(self, *args, **kw) -> None: ...
    def exec_once_unless_exception(self, *args, **kw) -> None: ...
    def __call__(self, *args, **kw) -> None: ...
    def __len__(self): ...
    def __iter__(self): ...
    def __bool__(self): ...
    __nonzero__: Any

class _ListenerCollection(_CompoundListener):
    parent_listeners: Any
    parent: Any
    name: Any
    listeners: Any
    propagate: Any
    def __init__(self, parent, target_cls) -> None: ...
    def for_modify(self, obj): ...
    def insert(self, event_key, propagate) -> None: ...
    def append(self, event_key, propagate) -> None: ...
    def remove(self, event_key) -> None: ...
    def clear(self) -> None: ...

class _JoinedListener(_CompoundListener):
    parent: Any
    name: Any
    local: Any
    parent_listeners: Any
    def __init__(self, parent, name, local) -> None: ...
    @property
    def listeners(self): ...
    def for_modify(self, obj): ...
    def insert(self, event_key, propagate) -> None: ...
    def append(self, event_key, propagate) -> None: ...
    def remove(self, event_key) -> None: ...
    def clear(self) -> None: ...
