# This file is based upon the 14 core AFM files provided by Adobe/Macromedia at
# https://download.macromedia.com/pub/developer/opentype/tech-notes/Core14_AFMs.zip
# The original copyright follows:
#
# -----------------------------------------------------------------------------------------------
# Core 14 AFM Files - ReadMe
#
# This file and the 14 PostScript(R) AFM files it accompanies may be used, copied, and
# distributed for any purpose and without charge, with or without modification, provided that all
# copyright notices are retained; that the AFM files are not distributed without this file; that
# all modifications to this file or any of the AFM files are prominently noted in the modified
# file(s); and that this paragraph is not modified. Adobe Systems has no responsibility or
# obligation to support the use of the AFM files.
# -----------------------------------------------------------------------------------------------


from pypdf._font import CoreFontMetrics, FontDescriptor

CORE_FONT_METRICS: dict[str, CoreFontMetrics] = {
    # Generated from Courier.afm
    # Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights
    # Reserved.
    "Courier": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Courier",
            family="Courier",
            weight="Medium",
            ascent=629,
            descent=-157,
            cap_height=562,
            x_height=426,
            italic_angle=0,
            flags=33,
            bbox=(-23.0, -250.0, 715.0, 805.0),
        ),
        character_widths={
            " ": 600,
            "default": 600,
            "!": 600,
            '"': 600,
            "#": 600,
            "$": 600,
            "%": 600,
            "&": 600,
            "\u2019": 600,
            "(": 600,
            ")": 600,
            "*": 600,
            "+": 600,
            ",": 600,
            "-": 600,
            ".": 600,
            "/": 600,
            "0": 600,
            "1": 600,
            "2": 600,
            "3": 600,
            "4": 600,
            "5": 600,
            "6": 600,
            "7": 600,
            "8": 600,
            "9": 600,
            ":": 600,
            ";": 600,
            "<": 600,
            "=": 600,
            ">": 600,
            "?": 600,
            "@": 600,
            "A": 600,
            "B": 600,
            "C": 600,
            "D": 600,
            "E": 600,
            "F": 600,
            "G": 600,
            "H": 600,
            "I": 600,
            "J": 600,
            "K": 600,
            "L": 600,
            "M": 600,
            "N": 600,
            "O": 600,
            "P": 600,
            "Q": 600,
            "R": 600,
            "S": 600,
            "T": 600,
            "U": 600,
            "V": 600,
            "W": 600,
            "X": 600,
            "Y": 600,
            "Z": 600,
            "[": 600,
            "\\": 600,
            "]": 600,
            "^": 600,
            "_": 600,
            "\u2018": 600,
            "a": 600,
            "b": 600,
            "c": 600,
            "d": 600,
            "e": 600,
            "f": 600,
            "g": 600,
            "h": 600,
            "i": 600,
            "j": 600,
            "k": 600,
            "l": 600,
            "m": 600,
            "n": 600,
            "o": 600,
            "p": 600,
            "q": 600,
            "r": 600,
            "s": 600,
            "t": 600,
            "u": 600,
            "v": 600,
            "w": 600,
            "x": 600,
            "y": 600,
            "z": 600,
            "{": 600,
            "|": 600,
            "}": 600,
            "~": 600,
            "\xa1": 600,
            "\xa2": 600,
            "\xa3": 600,
            "\u2044": 600,
            "\xa5": 600,
            "\u0192": 600,
            "\xa7": 600,
            "\xa4": 600,
            "'": 600,
            "\u201c": 600,
            "\xab": 600,
            "\u2039": 600,
            "\u203a": 600,
            "\ufb01": 600,
            "\ufb02": 600,
            "\u2013": 600,
            "\u2020": 600,
            "\u2021": 600,
            "\xb7": 600,
            "\xb6": 600,
            "\u2022": 600,
            "\u201a": 600,
            "\u201e": 600,
            "\u201d": 600,
            "\xbb": 600,
            "\u2026": 600,
            "\u2030": 600,
            "\xbf": 600,
            "`": 600,
            "\xb4": 600,
            "\u02c6": 600,
            "\u02dc": 600,
            "\xaf": 600,
            "\u02d8": 600,
            "\u02d9": 600,
            "\xa8": 600,
            "\u02da": 600,
            "\xb8": 600,
            "\u02dd": 600,
            "\u02db": 600,
            "\u02c7": 600,
            "\u2014": 600,
            "\xc6": 600,
            "\xaa": 600,
            "\u0141": 600,
            "\xd8": 600,
            "\u0152": 600,
            "\xba": 600,
            "\xe6": 600,
            "\u0131": 600,
            "\u0142": 600,
            "\xf8": 600,
            "\u0153": 600,
            "\xdf": 600,
            "\xcf": 600,
            "\xe9": 600,
            "\u0103": 600,
            "\u0171": 600,
            "\u011b": 600,
            "\u0178": 600,
            "\xf7": 600,
            "\xdd": 600,
            "\xc2": 600,
            "\xe1": 600,
            "\xdb": 600,
            "\xfd": 600,
            "\u0219": 600,
            "\xea": 600,
            "\u016e": 600,
            "\xdc": 600,
            "\u0105": 600,
            "\xda": 600,
            "\u0173": 600,
            "\xcb": 600,
            "\u0110": 600,
            "\uf6c3": 600,
            "\xa9": 600,
            "\u0112": 600,
            "\u010d": 600,
            "\xe5": 600,
            "\u0145": 600,
            "\u013a": 600,
            "\xe0": 600,
            "\u0162": 600,
            "\u0106": 600,
            "\xe3": 600,
            "\u0116": 600,
            "\u0161": 600,
            "\u015f": 600,
            "\xed": 600,
            "\u25ca": 600,
            "\u0158": 600,
            "\u0122": 600,
            "\xfb": 600,
            "\xe2": 600,
            "\u0100": 600,
            "\u0159": 600,
            "\xe7": 600,
            "\u017b": 600,
            "\xde": 600,
            "\u014c": 600,
            "\u0154": 600,
            "\u015a": 600,
            "\u010f": 600,
            "\u016a": 600,
            "\u016f": 600,
            "\xb3": 600,
            "\xd2": 600,
            "\xc0": 600,
            "\u0102": 600,
            "\xd7": 600,
            "\xfa": 600,
            "\u0164": 600,
            "\u2202": 600,
            "\xff": 600,
            "\u0143": 600,
            "\xee": 600,
            "\xca": 600,
            "\xe4": 600,
            "\xeb": 600,
            "\u0107": 600,
            "\u0144": 600,
            "\u016b": 600,
            "\u0147": 600,
            "\xcd": 600,
            "\xb1": 600,
            "\xa6": 600,
            "\xae": 600,
            "\u011e": 600,
            "\u0130": 600,
            "\u2211": 600,
            "\xc8": 600,
            "\u0155": 600,
            "\u014d": 600,
            "\u0179": 600,
            "\u017d": 600,
            "\u2265": 600,
            "\xd0": 600,
            "\xc7": 600,
            "\u013c": 600,
            "\u0165": 600,
            "\u0119": 600,
            "\u0172": 600,
            "\xc1": 600,
            "\xc4": 600,
            "\xe8": 600,
            "\u017a": 600,
            "\u012f": 600,
            "\xd3": 600,
            "\xf3": 600,
            "\u0101": 600,
            "\u015b": 600,
            "\xef": 600,
            "\xd4": 600,
            "\xd9": 600,
            "\u2206": 600,
            "\xfe": 600,
            "\xb2": 600,
            "\xd6": 600,
            "\xb5": 600,
            "\xec": 600,
            "\u0151": 600,
            "\u0118": 600,
            "\u0111": 600,
            "\xbe": 600,
            "\u015e": 600,
            "\u013e": 600,
            "\u0136": 600,
            "\u0139": 600,
            "\u2122": 600,
            "\u0117": 600,
            "\xcc": 600,
            "\u012a": 600,
            "\u013d": 600,
            "\xbd": 600,
            "\u2264": 600,
            "\xf4": 600,
            "\xf1": 600,
            "\u0170": 600,
            "\xc9": 600,
            "\u0113": 600,
            "\u011f": 600,
            "\xbc": 600,
            "\u0160": 600,
            "\u0218": 600,
            "\u0150": 600,
            "\xb0": 600,
            "\xf2": 600,
            "\u010c": 600,
            "\xf9": 600,
            "\u221a": 600,
            "\u010e": 600,
            "\u0157": 600,
            "\xd1": 600,
            "\xf5": 600,
            "\u0156": 600,
            "\u013b": 600,
            "\xc3": 600,
            "\u0104": 600,
            "\xc5": 600,
            "\xd5": 600,
            "\u017c": 600,
            "\u011a": 600,
            "\u012e": 600,
            "\u0137": 600,
            "\u2212": 600,
            "\xce": 600,
            "\u0148": 600,
            "\u0163": 600,
            "\xac": 600,
            "\xf6": 600,
            "\xfc": 600,
            "\u2260": 600,
            "\u0123": 600,
            "\xf0": 600,
            "\u017e": 600,
            "\u0146": 600,
            "\xb9": 600,
            "\u012b": 600,
            "\u20ac": 600,
        },
    ),
    # Generated from Courier-Bold.afm
    # Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
    "Courier-Bold": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Courier-Bold",
            family="Courier",
            weight="Bold",
            ascent=629,
            descent=-157,
            cap_height=562,
            x_height=439,
            italic_angle=0,
            flags=33,
            bbox=(-113.0, -250.0, 749.0, 801.0),
        ),
        character_widths={
            " ": 600,
            "default": 600,
            "!": 600,
            '"': 600,
            "#": 600,
            "$": 600,
            "%": 600,
            "&": 600,
            "\u2019": 600,
            "(": 600,
            ")": 600,
            "*": 600,
            "+": 600,
            ",": 600,
            "-": 600,
            ".": 600,
            "/": 600,
            "0": 600,
            "1": 600,
            "2": 600,
            "3": 600,
            "4": 600,
            "5": 600,
            "6": 600,
            "7": 600,
            "8": 600,
            "9": 600,
            ":": 600,
            ";": 600,
            "<": 600,
            "=": 600,
            ">": 600,
            "?": 600,
            "@": 600,
            "A": 600,
            "B": 600,
            "C": 600,
            "D": 600,
            "E": 600,
            "F": 600,
            "G": 600,
            "H": 600,
            "I": 600,
            "J": 600,
            "K": 600,
            "L": 600,
            "M": 600,
            "N": 600,
            "O": 600,
            "P": 600,
            "Q": 600,
            "R": 600,
            "S": 600,
            "T": 600,
            "U": 600,
            "V": 600,
            "W": 600,
            "X": 600,
            "Y": 600,
            "Z": 600,
            "[": 600,
            "\\": 600,
            "]": 600,
            "^": 600,
            "_": 600,
            "\u2018": 600,
            "a": 600,
            "b": 600,
            "c": 600,
            "d": 600,
            "e": 600,
            "f": 600,
            "g": 600,
            "h": 600,
            "i": 600,
            "j": 600,
            "k": 600,
            "l": 600,
            "m": 600,
            "n": 600,
            "o": 600,
            "p": 600,
            "q": 600,
            "r": 600,
            "s": 600,
            "t": 600,
            "u": 600,
            "v": 600,
            "w": 600,
            "x": 600,
            "y": 600,
            "z": 600,
            "{": 600,
            "|": 600,
            "}": 600,
            "~": 600,
            "\xa1": 600,
            "\xa2": 600,
            "\xa3": 600,
            "\u2044": 600,
            "\xa5": 600,
            "\u0192": 600,
            "\xa7": 600,
            "\xa4": 600,
            "'": 600,
            "\u201c": 600,
            "\xab": 600,
            "\u2039": 600,
            "\u203a": 600,
            "\ufb01": 600,
            "\ufb02": 600,
            "\u2013": 600,
            "\u2020": 600,
            "\u2021": 600,
            "\xb7": 600,
            "\xb6": 600,
            "\u2022": 600,
            "\u201a": 600,
            "\u201e": 600,
            "\u201d": 600,
            "\xbb": 600,
            "\u2026": 600,
            "\u2030": 600,
            "\xbf": 600,
            "`": 600,
            "\xb4": 600,
            "\u02c6": 600,
            "\u02dc": 600,
            "\xaf": 600,
            "\u02d8": 600,
            "\u02d9": 600,
            "\xa8": 600,
            "\u02da": 600,
            "\xb8": 600,
            "\u02dd": 600,
            "\u02db": 600,
            "\u02c7": 600,
            "\u2014": 600,
            "\xc6": 600,
            "\xaa": 600,
            "\u0141": 600,
            "\xd8": 600,
            "\u0152": 600,
            "\xba": 600,
            "\xe6": 600,
            "\u0131": 600,
            "\u0142": 600,
            "\xf8": 600,
            "\u0153": 600,
            "\xdf": 600,
            "\xcf": 600,
            "\xe9": 600,
            "\u0103": 600,
            "\u0171": 600,
            "\u011b": 600,
            "\u0178": 600,
            "\xf7": 600,
            "\xdd": 600,
            "\xc2": 600,
            "\xe1": 600,
            "\xdb": 600,
            "\xfd": 600,
            "\u0219": 600,
            "\xea": 600,
            "\u016e": 600,
            "\xdc": 600,
            "\u0105": 600,
            "\xda": 600,
            "\u0173": 600,
            "\xcb": 600,
            "\u0110": 600,
            "\uf6c3": 600,
            "\xa9": 600,
            "\u0112": 600,
            "\u010d": 600,
            "\xe5": 600,
            "\u0145": 600,
            "\u013a": 600,
            "\xe0": 600,
            "\u0162": 600,
            "\u0106": 600,
            "\xe3": 600,
            "\u0116": 600,
            "\u0161": 600,
            "\u015f": 600,
            "\xed": 600,
            "\u25ca": 600,
            "\u0158": 600,
            "\u0122": 600,
            "\xfb": 600,
            "\xe2": 600,
            "\u0100": 600,
            "\u0159": 600,
            "\xe7": 600,
            "\u017b": 600,
            "\xde": 600,
            "\u014c": 600,
            "\u0154": 600,
            "\u015a": 600,
            "\u010f": 600,
            "\u016a": 600,
            "\u016f": 600,
            "\xb3": 600,
            "\xd2": 600,
            "\xc0": 600,
            "\u0102": 600,
            "\xd7": 600,
            "\xfa": 600,
            "\u0164": 600,
            "\u2202": 600,
            "\xff": 600,
            "\u0143": 600,
            "\xee": 600,
            "\xca": 600,
            "\xe4": 600,
            "\xeb": 600,
            "\u0107": 600,
            "\u0144": 600,
            "\u016b": 600,
            "\u0147": 600,
            "\xcd": 600,
            "\xb1": 600,
            "\xa6": 600,
            "\xae": 600,
            "\u011e": 600,
            "\u0130": 600,
            "\u2211": 600,
            "\xc8": 600,
            "\u0155": 600,
            "\u014d": 600,
            "\u0179": 600,
            "\u017d": 600,
            "\u2265": 600,
            "\xd0": 600,
            "\xc7": 600,
            "\u013c": 600,
            "\u0165": 600,
            "\u0119": 600,
            "\u0172": 600,
            "\xc1": 600,
            "\xc4": 600,
            "\xe8": 600,
            "\u017a": 600,
            "\u012f": 600,
            "\xd3": 600,
            "\xf3": 600,
            "\u0101": 600,
            "\u015b": 600,
            "\xef": 600,
            "\xd4": 600,
            "\xd9": 600,
            "\u2206": 600,
            "\xfe": 600,
            "\xb2": 600,
            "\xd6": 600,
            "\xb5": 600,
            "\xec": 600,
            "\u0151": 600,
            "\u0118": 600,
            "\u0111": 600,
            "\xbe": 600,
            "\u015e": 600,
            "\u013e": 600,
            "\u0136": 600,
            "\u0139": 600,
            "\u2122": 600,
            "\u0117": 600,
            "\xcc": 600,
            "\u012a": 600,
            "\u013d": 600,
            "\xbd": 600,
            "\u2264": 600,
            "\xf4": 600,
            "\xf1": 600,
            "\u0170": 600,
            "\xc9": 600,
            "\u0113": 600,
            "\u011f": 600,
            "\xbc": 600,
            "\u0160": 600,
            "\u0218": 600,
            "\u0150": 600,
            "\xb0": 600,
            "\xf2": 600,
            "\u010c": 600,
            "\xf9": 600,
            "\u221a": 600,
            "\u010e": 600,
            "\u0157": 600,
            "\xd1": 600,
            "\xf5": 600,
            "\u0156": 600,
            "\u013b": 600,
            "\xc3": 600,
            "\u0104": 600,
            "\xc5": 600,
            "\xd5": 600,
            "\u017c": 600,
            "\u011a": 600,
            "\u012e": 600,
            "\u0137": 600,
            "\u2212": 600,
            "\xce": 600,
            "\u0148": 600,
            "\u0163": 600,
            "\xac": 600,
            "\xf6": 600,
            "\xfc": 600,
            "\u2260": 600,
            "\u0123": 600,
            "\xf0": 600,
            "\u017e": 600,
            "\u0146": 600,
            "\xb9": 600,
            "\u012b": 600,
            "\u20ac": 600,
        },
    ),
    # Generated from Courier-BoldOblique.afm
    # Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
    "Courier-BoldOblique": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Courier-BoldOblique",
            family="Courier",
            weight="Bold",
            ascent=629,
            descent=-157,
            cap_height=562,
            x_height=439,
            italic_angle=-12,
            flags=97,
            bbox=(-57.0, -250.0, 869.0, 801.0),
        ),
        character_widths={
            " ": 600,
            "default": 600,
            "!": 600,
            '"': 600,
            "#": 600,
            "$": 600,
            "%": 600,
            "&": 600,
            "\u2019": 600,
            "(": 600,
            ")": 600,
            "*": 600,
            "+": 600,
            ",": 600,
            "-": 600,
            ".": 600,
            "/": 600,
            "0": 600,
            "1": 600,
            "2": 600,
            "3": 600,
            "4": 600,
            "5": 600,
            "6": 600,
            "7": 600,
            "8": 600,
            "9": 600,
            ":": 600,
            ";": 600,
            "<": 600,
            "=": 600,
            ">": 600,
            "?": 600,
            "@": 600,
            "A": 600,
            "B": 600,
            "C": 600,
            "D": 600,
            "E": 600,
            "F": 600,
            "G": 600,
            "H": 600,
            "I": 600,
            "J": 600,
            "K": 600,
            "L": 600,
            "M": 600,
            "N": 600,
            "O": 600,
            "P": 600,
            "Q": 600,
            "R": 600,
            "S": 600,
            "T": 600,
            "U": 600,
            "V": 600,
            "W": 600,
            "X": 600,
            "Y": 600,
            "Z": 600,
            "[": 600,
            "\\": 600,
            "]": 600,
            "^": 600,
            "_": 600,
            "\u2018": 600,
            "a": 600,
            "b": 600,
            "c": 600,
            "d": 600,
            "e": 600,
            "f": 600,
            "g": 600,
            "h": 600,
            "i": 600,
            "j": 600,
            "k": 600,
            "l": 600,
            "m": 600,
            "n": 600,
            "o": 600,
            "p": 600,
            "q": 600,
            "r": 600,
            "s": 600,
            "t": 600,
            "u": 600,
            "v": 600,
            "w": 600,
            "x": 600,
            "y": 600,
            "z": 600,
            "{": 600,
            "|": 600,
            "}": 600,
            "~": 600,
            "\xa1": 600,
            "\xa2": 600,
            "\xa3": 600,
            "\u2044": 600,
            "\xa5": 600,
            "\u0192": 600,
            "\xa7": 600,
            "\xa4": 600,
            "'": 600,
            "\u201c": 600,
            "\xab": 600,
            "\u2039": 600,
            "\u203a": 600,
            "\ufb01": 600,
            "\ufb02": 600,
            "\u2013": 600,
            "\u2020": 600,
            "\u2021": 600,
            "\xb7": 600,
            "\xb6": 600,
            "\u2022": 600,
            "\u201a": 600,
            "\u201e": 600,
            "\u201d": 600,
            "\xbb": 600,
            "\u2026": 600,
            "\u2030": 600,
            "\xbf": 600,
            "`": 600,
            "\xb4": 600,
            "\u02c6": 600,
            "\u02dc": 600,
            "\xaf": 600,
            "\u02d8": 600,
            "\u02d9": 600,
            "\xa8": 600,
            "\u02da": 600,
            "\xb8": 600,
            "\u02dd": 600,
            "\u02db": 600,
            "\u02c7": 600,
            "\u2014": 600,
            "\xc6": 600,
            "\xaa": 600,
            "\u0141": 600,
            "\xd8": 600,
            "\u0152": 600,
            "\xba": 600,
            "\xe6": 600,
            "\u0131": 600,
            "\u0142": 600,
            "\xf8": 600,
            "\u0153": 600,
            "\xdf": 600,
            "\xcf": 600,
            "\xe9": 600,
            "\u0103": 600,
            "\u0171": 600,
            "\u011b": 600,
            "\u0178": 600,
            "\xf7": 600,
            "\xdd": 600,
            "\xc2": 600,
            "\xe1": 600,
            "\xdb": 600,
            "\xfd": 600,
            "\u0219": 600,
            "\xea": 600,
            "\u016e": 600,
            "\xdc": 600,
            "\u0105": 600,
            "\xda": 600,
            "\u0173": 600,
            "\xcb": 600,
            "\u0110": 600,
            "\uf6c3": 600,
            "\xa9": 600,
            "\u0112": 600,
            "\u010d": 600,
            "\xe5": 600,
            "\u0145": 600,
            "\u013a": 600,
            "\xe0": 600,
            "\u0162": 600,
            "\u0106": 600,
            "\xe3": 600,
            "\u0116": 600,
            "\u0161": 600,
            "\u015f": 600,
            "\xed": 600,
            "\u25ca": 600,
            "\u0158": 600,
            "\u0122": 600,
            "\xfb": 600,
            "\xe2": 600,
            "\u0100": 600,
            "\u0159": 600,
            "\xe7": 600,
            "\u017b": 600,
            "\xde": 600,
            "\u014c": 600,
            "\u0154": 600,
            "\u015a": 600,
            "\u010f": 600,
            "\u016a": 600,
            "\u016f": 600,
            "\xb3": 600,
            "\xd2": 600,
            "\xc0": 600,
            "\u0102": 600,
            "\xd7": 600,
            "\xfa": 600,
            "\u0164": 600,
            "\u2202": 600,
            "\xff": 600,
            "\u0143": 600,
            "\xee": 600,
            "\xca": 600,
            "\xe4": 600,
            "\xeb": 600,
            "\u0107": 600,
            "\u0144": 600,
            "\u016b": 600,
            "\u0147": 600,
            "\xcd": 600,
            "\xb1": 600,
            "\xa6": 600,
            "\xae": 600,
            "\u011e": 600,
            "\u0130": 600,
            "\u2211": 600,
            "\xc8": 600,
            "\u0155": 600,
            "\u014d": 600,
            "\u0179": 600,
            "\u017d": 600,
            "\u2265": 600,
            "\xd0": 600,
            "\xc7": 600,
            "\u013c": 600,
            "\u0165": 600,
            "\u0119": 600,
            "\u0172": 600,
            "\xc1": 600,
            "\xc4": 600,
            "\xe8": 600,
            "\u017a": 600,
            "\u012f": 600,
            "\xd3": 600,
            "\xf3": 600,
            "\u0101": 600,
            "\u015b": 600,
            "\xef": 600,
            "\xd4": 600,
            "\xd9": 600,
            "\u2206": 600,
            "\xfe": 600,
            "\xb2": 600,
            "\xd6": 600,
            "\xb5": 600,
            "\xec": 600,
            "\u0151": 600,
            "\u0118": 600,
            "\u0111": 600,
            "\xbe": 600,
            "\u015e": 600,
            "\u013e": 600,
            "\u0136": 600,
            "\u0139": 600,
            "\u2122": 600,
            "\u0117": 600,
            "\xcc": 600,
            "\u012a": 600,
            "\u013d": 600,
            "\xbd": 600,
            "\u2264": 600,
            "\xf4": 600,
            "\xf1": 600,
            "\u0170": 600,
            "\xc9": 600,
            "\u0113": 600,
            "\u011f": 600,
            "\xbc": 600,
            "\u0160": 600,
            "\u0218": 600,
            "\u0150": 600,
            "\xb0": 600,
            "\xf2": 600,
            "\u010c": 600,
            "\xf9": 600,
            "\u221a": 600,
            "\u010e": 600,
            "\u0157": 600,
            "\xd1": 600,
            "\xf5": 600,
            "\u0156": 600,
            "\u013b": 600,
            "\xc3": 600,
            "\u0104": 600,
            "\xc5": 600,
            "\xd5": 600,
            "\u017c": 600,
            "\u011a": 600,
            "\u012e": 600,
            "\u0137": 600,
            "\u2212": 600,
            "\xce": 600,
            "\u0148": 600,
            "\u0163": 600,
            "\xac": 600,
            "\xf6": 600,
            "\xfc": 600,
            "\u2260": 600,
            "\u0123": 600,
            "\xf0": 600,
            "\u017e": 600,
            "\u0146": 600,
            "\xb9": 600,
            "\u012b": 600,
            "\u20ac": 600,
        },
    ),
    # Generated from Courier-Oblique.afm
    # Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights
    # Reserved.
    "Courier-Oblique": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Courier-Oblique",
            family="Courier",
            weight="Medium",
            ascent=629,
            descent=-157,
            cap_height=562,
            x_height=426,
            italic_angle=-12,
            flags=97,
            bbox=(-27.0, -250.0, 849.0, 805.0),
        ),
        character_widths={
            " ": 600,
            "default": 600,
            "!": 600,
            '"': 600,
            "#": 600,
            "$": 600,
            "%": 600,
            "&": 600,
            "\u2019": 600,
            "(": 600,
            ")": 600,
            "*": 600,
            "+": 600,
            ",": 600,
            "-": 600,
            ".": 600,
            "/": 600,
            "0": 600,
            "1": 600,
            "2": 600,
            "3": 600,
            "4": 600,
            "5": 600,
            "6": 600,
            "7": 600,
            "8": 600,
            "9": 600,
            ":": 600,
            ";": 600,
            "<": 600,
            "=": 600,
            ">": 600,
            "?": 600,
            "@": 600,
            "A": 600,
            "B": 600,
            "C": 600,
            "D": 600,
            "E": 600,
            "F": 600,
            "G": 600,
            "H": 600,
            "I": 600,
            "J": 600,
            "K": 600,
            "L": 600,
            "M": 600,
            "N": 600,
            "O": 600,
            "P": 600,
            "Q": 600,
            "R": 600,
            "S": 600,
            "T": 600,
            "U": 600,
            "V": 600,
            "W": 600,
            "X": 600,
            "Y": 600,
            "Z": 600,
            "[": 600,
            "\\": 600,
            "]": 600,
            "^": 600,
            "_": 600,
            "\u2018": 600,
            "a": 600,
            "b": 600,
            "c": 600,
            "d": 600,
            "e": 600,
            "f": 600,
            "g": 600,
            "h": 600,
            "i": 600,
            "j": 600,
            "k": 600,
            "l": 600,
            "m": 600,
            "n": 600,
            "o": 600,
            "p": 600,
            "q": 600,
            "r": 600,
            "s": 600,
            "t": 600,
            "u": 600,
            "v": 600,
            "w": 600,
            "x": 600,
            "y": 600,
            "z": 600,
            "{": 600,
            "|": 600,
            "}": 600,
            "~": 600,
            "\xa1": 600,
            "\xa2": 600,
            "\xa3": 600,
            "\u2044": 600,
            "\xa5": 600,
            "\u0192": 600,
            "\xa7": 600,
            "\xa4": 600,
            "'": 600,
            "\u201c": 600,
            "\xab": 600,
            "\u2039": 600,
            "\u203a": 600,
            "\ufb01": 600,
            "\ufb02": 600,
            "\u2013": 600,
            "\u2020": 600,
            "\u2021": 600,
            "\xb7": 600,
            "\xb6": 600,
            "\u2022": 600,
            "\u201a": 600,
            "\u201e": 600,
            "\u201d": 600,
            "\xbb": 600,
            "\u2026": 600,
            "\u2030": 600,
            "\xbf": 600,
            "`": 600,
            "\xb4": 600,
            "\u02c6": 600,
            "\u02dc": 600,
            "\xaf": 600,
            "\u02d8": 600,
            "\u02d9": 600,
            "\xa8": 600,
            "\u02da": 600,
            "\xb8": 600,
            "\u02dd": 600,
            "\u02db": 600,
            "\u02c7": 600,
            "\u2014": 600,
            "\xc6": 600,
            "\xaa": 600,
            "\u0141": 600,
            "\xd8": 600,
            "\u0152": 600,
            "\xba": 600,
            "\xe6": 600,
            "\u0131": 600,
            "\u0142": 600,
            "\xf8": 600,
            "\u0153": 600,
            "\xdf": 600,
            "\xcf": 600,
            "\xe9": 600,
            "\u0103": 600,
            "\u0171": 600,
            "\u011b": 600,
            "\u0178": 600,
            "\xf7": 600,
            "\xdd": 600,
            "\xc2": 600,
            "\xe1": 600,
            "\xdb": 600,
            "\xfd": 600,
            "\u0219": 600,
            "\xea": 600,
            "\u016e": 600,
            "\xdc": 600,
            "\u0105": 600,
            "\xda": 600,
            "\u0173": 600,
            "\xcb": 600,
            "\u0110": 600,
            "\uf6c3": 600,
            "\xa9": 600,
            "\u0112": 600,
            "\u010d": 600,
            "\xe5": 600,
            "\u0145": 600,
            "\u013a": 600,
            "\xe0": 600,
            "\u0162": 600,
            "\u0106": 600,
            "\xe3": 600,
            "\u0116": 600,
            "\u0161": 600,
            "\u015f": 600,
            "\xed": 600,
            "\u25ca": 600,
            "\u0158": 600,
            "\u0122": 600,
            "\xfb": 600,
            "\xe2": 600,
            "\u0100": 600,
            "\u0159": 600,
            "\xe7": 600,
            "\u017b": 600,
            "\xde": 600,
            "\u014c": 600,
            "\u0154": 600,
            "\u015a": 600,
            "\u010f": 600,
            "\u016a": 600,
            "\u016f": 600,
            "\xb3": 600,
            "\xd2": 600,
            "\xc0": 600,
            "\u0102": 600,
            "\xd7": 600,
            "\xfa": 600,
            "\u0164": 600,
            "\u2202": 600,
            "\xff": 600,
            "\u0143": 600,
            "\xee": 600,
            "\xca": 600,
            "\xe4": 600,
            "\xeb": 600,
            "\u0107": 600,
            "\u0144": 600,
            "\u016b": 600,
            "\u0147": 600,
            "\xcd": 600,
            "\xb1": 600,
            "\xa6": 600,
            "\xae": 600,
            "\u011e": 600,
            "\u0130": 600,
            "\u2211": 600,
            "\xc8": 600,
            "\u0155": 600,
            "\u014d": 600,
            "\u0179": 600,
            "\u017d": 600,
            "\u2265": 600,
            "\xd0": 600,
            "\xc7": 600,
            "\u013c": 600,
            "\u0165": 600,
            "\u0119": 600,
            "\u0172": 600,
            "\xc1": 600,
            "\xc4": 600,
            "\xe8": 600,
            "\u017a": 600,
            "\u012f": 600,
            "\xd3": 600,
            "\xf3": 600,
            "\u0101": 600,
            "\u015b": 600,
            "\xef": 600,
            "\xd4": 600,
            "\xd9": 600,
            "\u2206": 600,
            "\xfe": 600,
            "\xb2": 600,
            "\xd6": 600,
            "\xb5": 600,
            "\xec": 600,
            "\u0151": 600,
            "\u0118": 600,
            "\u0111": 600,
            "\xbe": 600,
            "\u015e": 600,
            "\u013e": 600,
            "\u0136": 600,
            "\u0139": 600,
            "\u2122": 600,
            "\u0117": 600,
            "\xcc": 600,
            "\u012a": 600,
            "\u013d": 600,
            "\xbd": 600,
            "\u2264": 600,
            "\xf4": 600,
            "\xf1": 600,
            "\u0170": 600,
            "\xc9": 600,
            "\u0113": 600,
            "\u011f": 600,
            "\xbc": 600,
            "\u0160": 600,
            "\u0218": 600,
            "\u0150": 600,
            "\xb0": 600,
            "\xf2": 600,
            "\u010c": 600,
            "\xf9": 600,
            "\u221a": 600,
            "\u010e": 600,
            "\u0157": 600,
            "\xd1": 600,
            "\xf5": 600,
            "\u0156": 600,
            "\u013b": 600,
            "\xc3": 600,
            "\u0104": 600,
            "\xc5": 600,
            "\xd5": 600,
            "\u017c": 600,
            "\u011a": 600,
            "\u012e": 600,
            "\u0137": 600,
            "\u2212": 600,
            "\xce": 600,
            "\u0148": 600,
            "\u0163": 600,
            "\xac": 600,
            "\xf6": 600,
            "\xfc": 600,
            "\u2260": 600,
            "\u0123": 600,
            "\xf0": 600,
            "\u017e": 600,
            "\u0146": 600,
            "\xb9": 600,
            "\u012b": 600,
            "\u20ac": 600,
        },
    ),
    # Generated from Helvetica.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
    # Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Helvetica": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Helvetica",
            family="Helvetica",
            weight="Medium",
            ascent=718,
            descent=-207,
            cap_height=718,
            x_height=523,
            italic_angle=0,
            flags=32,
            bbox=(-166.0, -225.0, 1000.0, 931.0),
        ),
        character_widths={
            " ": 278,
            "default": 556,
            "!": 278,
            '"': 355,
            "#": 556,
            "$": 556,
            "%": 889,
            "&": 667,
            "\u2019": 222,
            "(": 333,
            ")": 333,
            "*": 389,
            "+": 584,
            ",": 278,
            "-": 333,
            ".": 278,
            "/": 278,
            "0": 556,
            "1": 556,
            "2": 556,
            "3": 556,
            "4": 556,
            "5": 556,
            "6": 556,
            "7": 556,
            "8": 556,
            "9": 556,
            ":": 278,
            ";": 278,
            "<": 584,
            "=": 584,
            ">": 584,
            "?": 556,
            "@": 1015,
            "A": 667,
            "B": 667,
            "C": 722,
            "D": 722,
            "E": 667,
            "F": 611,
            "G": 778,
            "H": 722,
            "I": 278,
            "J": 500,
            "K": 667,
            "L": 556,
            "M": 833,
            "N": 722,
            "O": 778,
            "P": 667,
            "Q": 778,
            "R": 722,
            "S": 667,
            "T": 611,
            "U": 722,
            "V": 667,
            "W": 944,
            "X": 667,
            "Y": 667,
            "Z": 611,
            "[": 278,
            "\\": 278,
            "]": 278,
            "^": 469,
            "_": 556,
            "\u2018": 222,
            "a": 556,
            "b": 556,
            "c": 500,
            "d": 556,
            "e": 556,
            "f": 278,
            "g": 556,
            "h": 556,
            "i": 222,
            "j": 222,
            "k": 500,
            "l": 222,
            "m": 833,
            "n": 556,
            "o": 556,
            "p": 556,
            "q": 556,
            "r": 333,
            "s": 500,
            "t": 278,
            "u": 556,
            "v": 500,
            "w": 722,
            "x": 500,
            "y": 500,
            "z": 500,
            "{": 334,
            "|": 260,
            "}": 334,
            "~": 584,
            "\xa1": 333,
            "\xa2": 556,
            "\xa3": 556,
            "\u2044": 167,
            "\xa5": 556,
            "\u0192": 556,
            "\xa7": 556,
            "\xa4": 556,
            "'": 191,
            "\u201c": 333,
            "\xab": 556,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 500,
            "\ufb02": 500,
            "\u2013": 556,
            "\u2020": 556,
            "\u2021": 556,
            "\xb7": 278,
            "\xb6": 537,
            "\u2022": 350,
            "\u201a": 222,
            "\u201e": 333,
            "\u201d": 333,
            "\xbb": 556,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 611,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 1000,
            "\xaa": 370,
            "\u0141": 556,
            "\xd8": 778,
            "\u0152": 1000,
            "\xba": 365,
            "\xe6": 889,
            "\u0131": 278,
            "\u0142": 222,
            "\xf8": 611,
            "\u0153": 944,
            "\xdf": 611,
            "\xcf": 278,
            "\xe9": 556,
            "\u0103": 556,
            "\u0171": 556,
            "\u011b": 556,
            "\u0178": 667,
            "\xf7": 584,
            "\xdd": 667,
            "\xc2": 667,
            "\xe1": 556,
            "\xdb": 722,
            "\xfd": 500,
            "\u0219": 500,
            "\xea": 556,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 556,
            "\xda": 722,
            "\u0173": 556,
            "\xcb": 667,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 737,
            "\u0112": 667,
            "\u010d": 500,
            "\xe5": 556,
            "\u0145": 722,
            "\u013a": 222,
            "\xe0": 556,
            "\u0162": 611,
            "\u0106": 722,
            "\xe3": 556,
            "\u0116": 667,
            "\u0161": 500,
            "\u015f": 500,
            "\xed": 278,
            "\u25ca": 471,
            "\u0158": 722,
            "\u0122": 778,
            "\xfb": 556,
            "\xe2": 556,
            "\u0100": 667,
            "\u0159": 333,
            "\xe7": 500,
            "\u017b": 611,
            "\xde": 667,
            "\u014c": 778,
            "\u0154": 722,
            "\u015a": 667,
            "\u010f": 643,
            "\u016a": 722,
            "\u016f": 556,
            "\xb3": 333,
            "\xd2": 778,
            "\xc0": 667,
            "\u0102": 667,
            "\xd7": 584,
            "\xfa": 556,
            "\u0164": 611,
            "\u2202": 476,
            "\xff": 500,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 667,
            "\xe4": 556,
            "\xeb": 556,
            "\u0107": 500,
            "\u0144": 556,
            "\u016b": 556,
            "\u0147": 722,
            "\xcd": 278,
            "\xb1": 584,
            "\xa6": 260,
            "\xae": 737,
            "\u011e": 778,
            "\u0130": 278,
            "\u2211": 600,
            "\xc8": 667,
            "\u0155": 333,
            "\u014d": 556,
            "\u0179": 611,
            "\u017d": 611,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 722,
            "\u013c": 222,
            "\u0165": 317,
            "\u0119": 556,
            "\u0172": 722,
            "\xc1": 667,
            "\xc4": 667,
            "\xe8": 556,
            "\u017a": 500,
            "\u012f": 222,
            "\xd3": 778,
            "\xf3": 556,
            "\u0101": 556,
            "\u015b": 500,
            "\xef": 278,
            "\xd4": 778,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 556,
            "\xb2": 333,
            "\xd6": 778,
            "\xb5": 556,
            "\xec": 278,
            "\u0151": 556,
            "\u0118": 667,
            "\u0111": 556,
            "\xbe": 834,
            "\u015e": 667,
            "\u013e": 299,
            "\u0136": 667,
            "\u0139": 556,
            "\u2122": 1000,
            "\u0117": 556,
            "\xcc": 278,
            "\u012a": 278,
            "\u013d": 556,
            "\xbd": 834,
            "\u2264": 549,
            "\xf4": 556,
            "\xf1": 556,
            "\u0170": 722,
            "\xc9": 667,
            "\u0113": 556,
            "\u011f": 556,
            "\xbc": 834,
            "\u0160": 667,
            "\u0218": 667,
            "\u0150": 778,
            "\xb0": 400,
            "\xf2": 556,
            "\u010c": 722,
            "\xf9": 556,
            "\u221a": 453,
            "\u010e": 722,
            "\u0157": 333,
            "\xd1": 722,
            "\xf5": 556,
            "\u0156": 722,
            "\u013b": 556,
            "\xc3": 667,
            "\u0104": 667,
            "\xc5": 667,
            "\xd5": 778,
            "\u017c": 500,
            "\u011a": 667,
            "\u012e": 278,
            "\u0137": 500,
            "\u2212": 584,
            "\xce": 278,
            "\u0148": 556,
            "\u0163": 278,
            "\xac": 584,
            "\xf6": 556,
            "\xfc": 556,
            "\u2260": 549,
            "\u0123": 556,
            "\xf0": 556,
            "\u017e": 500,
            "\u0146": 556,
            "\xb9": 333,
            "\u012b": 278,
            "\u20ac": 556,
        },
    ),
    # Generated from Helvetica-Bold.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
    # Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Helvetica-Bold": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Helvetica-Bold",
            family="Helvetica",
            weight="Bold",
            ascent=718,
            descent=-207,
            cap_height=718,
            x_height=532,
            italic_angle=0,
            flags=32,
            bbox=(-170.0, -228.0, 1003.0, 962.0),
        ),
        character_widths={
            " ": 278,
            "default": 556,
            "!": 333,
            '"': 474,
            "#": 556,
            "$": 556,
            "%": 889,
            "&": 722,
            "\u2019": 278,
            "(": 333,
            ")": 333,
            "*": 389,
            "+": 584,
            ",": 278,
            "-": 333,
            ".": 278,
            "/": 278,
            "0": 556,
            "1": 556,
            "2": 556,
            "3": 556,
            "4": 556,
            "5": 556,
            "6": 556,
            "7": 556,
            "8": 556,
            "9": 556,
            ":": 333,
            ";": 333,
            "<": 584,
            "=": 584,
            ">": 584,
            "?": 611,
            "@": 975,
            "A": 722,
            "B": 722,
            "C": 722,
            "D": 722,
            "E": 667,
            "F": 611,
            "G": 778,
            "H": 722,
            "I": 278,
            "J": 556,
            "K": 722,
            "L": 611,
            "M": 833,
            "N": 722,
            "O": 778,
            "P": 667,
            "Q": 778,
            "R": 722,
            "S": 667,
            "T": 611,
            "U": 722,
            "V": 667,
            "W": 944,
            "X": 667,
            "Y": 667,
            "Z": 611,
            "[": 333,
            "\\": 278,
            "]": 333,
            "^": 584,
            "_": 556,
            "\u2018": 278,
            "a": 556,
            "b": 611,
            "c": 556,
            "d": 611,
            "e": 556,
            "f": 333,
            "g": 611,
            "h": 611,
            "i": 278,
            "j": 278,
            "k": 556,
            "l": 278,
            "m": 889,
            "n": 611,
            "o": 611,
            "p": 611,
            "q": 611,
            "r": 389,
            "s": 556,
            "t": 333,
            "u": 611,
            "v": 556,
            "w": 778,
            "x": 556,
            "y": 556,
            "z": 500,
            "{": 389,
            "|": 280,
            "}": 389,
            "~": 584,
            "\xa1": 333,
            "\xa2": 556,
            "\xa3": 556,
            "\u2044": 167,
            "\xa5": 556,
            "\u0192": 556,
            "\xa7": 556,
            "\xa4": 556,
            "'": 238,
            "\u201c": 500,
            "\xab": 556,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 611,
            "\ufb02": 611,
            "\u2013": 556,
            "\u2020": 556,
            "\u2021": 556,
            "\xb7": 278,
            "\xb6": 556,
            "\u2022": 350,
            "\u201a": 278,
            "\u201e": 500,
            "\u201d": 500,
            "\xbb": 556,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 611,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 1000,
            "\xaa": 370,
            "\u0141": 611,
            "\xd8": 778,
            "\u0152": 1000,
            "\xba": 365,
            "\xe6": 889,
            "\u0131": 278,
            "\u0142": 278,
            "\xf8": 611,
            "\u0153": 944,
            "\xdf": 611,
            "\xcf": 278,
            "\xe9": 556,
            "\u0103": 556,
            "\u0171": 611,
            "\u011b": 556,
            "\u0178": 667,
            "\xf7": 584,
            "\xdd": 667,
            "\xc2": 722,
            "\xe1": 556,
            "\xdb": 722,
            "\xfd": 556,
            "\u0219": 556,
            "\xea": 556,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 556,
            "\xda": 722,
            "\u0173": 611,
            "\xcb": 667,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 737,
            "\u0112": 667,
            "\u010d": 556,
            "\xe5": 556,
            "\u0145": 722,
            "\u013a": 278,
            "\xe0": 556,
            "\u0162": 611,
            "\u0106": 722,
            "\xe3": 556,
            "\u0116": 667,
            "\u0161": 556,
            "\u015f": 556,
            "\xed": 278,
            "\u25ca": 494,
            "\u0158": 722,
            "\u0122": 778,
            "\xfb": 611,
            "\xe2": 556,
            "\u0100": 722,
            "\u0159": 389,
            "\xe7": 556,
            "\u017b": 611,
            "\xde": 667,
            "\u014c": 778,
            "\u0154": 722,
            "\u015a": 667,
            "\u010f": 743,
            "\u016a": 722,
            "\u016f": 611,
            "\xb3": 333,
            "\xd2": 778,
            "\xc0": 722,
            "\u0102": 722,
            "\xd7": 584,
            "\xfa": 611,
            "\u0164": 611,
            "\u2202": 494,
            "\xff": 556,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 667,
            "\xe4": 556,
            "\xeb": 556,
            "\u0107": 556,
            "\u0144": 611,
            "\u016b": 611,
            "\u0147": 722,
            "\xcd": 278,
            "\xb1": 584,
            "\xa6": 280,
            "\xae": 737,
            "\u011e": 778,
            "\u0130": 278,
            "\u2211": 600,
            "\xc8": 667,
            "\u0155": 389,
            "\u014d": 611,
            "\u0179": 611,
            "\u017d": 611,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 722,
            "\u013c": 278,
            "\u0165": 389,
            "\u0119": 556,
            "\u0172": 722,
            "\xc1": 722,
            "\xc4": 722,
            "\xe8": 556,
            "\u017a": 500,
            "\u012f": 278,
            "\xd3": 778,
            "\xf3": 611,
            "\u0101": 556,
            "\u015b": 556,
            "\xef": 278,
            "\xd4": 778,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 611,
            "\xb2": 333,
            "\xd6": 778,
            "\xb5": 611,
            "\xec": 278,
            "\u0151": 611,
            "\u0118": 667,
            "\u0111": 611,
            "\xbe": 834,
            "\u015e": 667,
            "\u013e": 400,
            "\u0136": 722,
            "\u0139": 611,
            "\u2122": 1000,
            "\u0117": 556,
            "\xcc": 278,
            "\u012a": 278,
            "\u013d": 611,
            "\xbd": 834,
            "\u2264": 549,
            "\xf4": 611,
            "\xf1": 611,
            "\u0170": 722,
            "\xc9": 667,
            "\u0113": 556,
            "\u011f": 611,
            "\xbc": 834,
            "\u0160": 667,
            "\u0218": 667,
            "\u0150": 778,
            "\xb0": 400,
            "\xf2": 611,
            "\u010c": 722,
            "\xf9": 611,
            "\u221a": 549,
            "\u010e": 722,
            "\u0157": 389,
            "\xd1": 722,
            "\xf5": 611,
            "\u0156": 722,
            "\u013b": 611,
            "\xc3": 722,
            "\u0104": 722,
            "\xc5": 722,
            "\xd5": 778,
            "\u017c": 500,
            "\u011a": 667,
            "\u012e": 278,
            "\u0137": 556,
            "\u2212": 584,
            "\xce": 278,
            "\u0148": 611,
            "\u0163": 333,
            "\xac": 584,
            "\xf6": 611,
            "\xfc": 611,
            "\u2260": 549,
            "\u0123": 611,
            "\xf0": 611,
            "\u017e": 500,
            "\u0146": 611,
            "\xb9": 333,
            "\u012b": 278,
            "\u20ac": 556,
        },
    ),
    # Generated from Helvetica-BoldOblique.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
    # Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Helvetica-BoldOblique": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Helvetica-BoldOblique",
            family="Helvetica",
            weight="Bold",
            ascent=718,
            descent=-207,
            cap_height=718,
            x_height=532,
            italic_angle=-12,
            flags=96,
            bbox=(-174.0, -228.0, 1114.0, 962.0),
        ),
        character_widths={
            " ": 278,
            "default": 556,
            "!": 333,
            '"': 474,
            "#": 556,
            "$": 556,
            "%": 889,
            "&": 722,
            "\u2019": 278,
            "(": 333,
            ")": 333,
            "*": 389,
            "+": 584,
            ",": 278,
            "-": 333,
            ".": 278,
            "/": 278,
            "0": 556,
            "1": 556,
            "2": 556,
            "3": 556,
            "4": 556,
            "5": 556,
            "6": 556,
            "7": 556,
            "8": 556,
            "9": 556,
            ":": 333,
            ";": 333,
            "<": 584,
            "=": 584,
            ">": 584,
            "?": 611,
            "@": 975,
            "A": 722,
            "B": 722,
            "C": 722,
            "D": 722,
            "E": 667,
            "F": 611,
            "G": 778,
            "H": 722,
            "I": 278,
            "J": 556,
            "K": 722,
            "L": 611,
            "M": 833,
            "N": 722,
            "O": 778,
            "P": 667,
            "Q": 778,
            "R": 722,
            "S": 667,
            "T": 611,
            "U": 722,
            "V": 667,
            "W": 944,
            "X": 667,
            "Y": 667,
            "Z": 611,
            "[": 333,
            "\\": 278,
            "]": 333,
            "^": 584,
            "_": 556,
            "\u2018": 278,
            "a": 556,
            "b": 611,
            "c": 556,
            "d": 611,
            "e": 556,
            "f": 333,
            "g": 611,
            "h": 611,
            "i": 278,
            "j": 278,
            "k": 556,
            "l": 278,
            "m": 889,
            "n": 611,
            "o": 611,
            "p": 611,
            "q": 611,
            "r": 389,
            "s": 556,
            "t": 333,
            "u": 611,
            "v": 556,
            "w": 778,
            "x": 556,
            "y": 556,
            "z": 500,
            "{": 389,
            "|": 280,
            "}": 389,
            "~": 584,
            "\xa1": 333,
            "\xa2": 556,
            "\xa3": 556,
            "\u2044": 167,
            "\xa5": 556,
            "\u0192": 556,
            "\xa7": 556,
            "\xa4": 556,
            "'": 238,
            "\u201c": 500,
            "\xab": 556,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 611,
            "\ufb02": 611,
            "\u2013": 556,
            "\u2020": 556,
            "\u2021": 556,
            "\xb7": 278,
            "\xb6": 556,
            "\u2022": 350,
            "\u201a": 278,
            "\u201e": 500,
            "\u201d": 500,
            "\xbb": 556,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 611,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 1000,
            "\xaa": 370,
            "\u0141": 611,
            "\xd8": 778,
            "\u0152": 1000,
            "\xba": 365,
            "\xe6": 889,
            "\u0131": 278,
            "\u0142": 278,
            "\xf8": 611,
            "\u0153": 944,
            "\xdf": 611,
            "\xcf": 278,
            "\xe9": 556,
            "\u0103": 556,
            "\u0171": 611,
            "\u011b": 556,
            "\u0178": 667,
            "\xf7": 584,
            "\xdd": 667,
            "\xc2": 722,
            "\xe1": 556,
            "\xdb": 722,
            "\xfd": 556,
            "\u0219": 556,
            "\xea": 556,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 556,
            "\xda": 722,
            "\u0173": 611,
            "\xcb": 667,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 737,
            "\u0112": 667,
            "\u010d": 556,
            "\xe5": 556,
            "\u0145": 722,
            "\u013a": 278,
            "\xe0": 556,
            "\u0162": 611,
            "\u0106": 722,
            "\xe3": 556,
            "\u0116": 667,
            "\u0161": 556,
            "\u015f": 556,
            "\xed": 278,
            "\u25ca": 494,
            "\u0158": 722,
            "\u0122": 778,
            "\xfb": 611,
            "\xe2": 556,
            "\u0100": 722,
            "\u0159": 389,
            "\xe7": 556,
            "\u017b": 611,
            "\xde": 667,
            "\u014c": 778,
            "\u0154": 722,
            "\u015a": 667,
            "\u010f": 743,
            "\u016a": 722,
            "\u016f": 611,
            "\xb3": 333,
            "\xd2": 778,
            "\xc0": 722,
            "\u0102": 722,
            "\xd7": 584,
            "\xfa": 611,
            "\u0164": 611,
            "\u2202": 494,
            "\xff": 556,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 667,
            "\xe4": 556,
            "\xeb": 556,
            "\u0107": 556,
            "\u0144": 611,
            "\u016b": 611,
            "\u0147": 722,
            "\xcd": 278,
            "\xb1": 584,
            "\xa6": 280,
            "\xae": 737,
            "\u011e": 778,
            "\u0130": 278,
            "\u2211": 600,
            "\xc8": 667,
            "\u0155": 389,
            "\u014d": 611,
            "\u0179": 611,
            "\u017d": 611,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 722,
            "\u013c": 278,
            "\u0165": 389,
            "\u0119": 556,
            "\u0172": 722,
            "\xc1": 722,
            "\xc4": 722,
            "\xe8": 556,
            "\u017a": 500,
            "\u012f": 278,
            "\xd3": 778,
            "\xf3": 611,
            "\u0101": 556,
            "\u015b": 556,
            "\xef": 278,
            "\xd4": 778,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 611,
            "\xb2": 333,
            "\xd6": 778,
            "\xb5": 611,
            "\xec": 278,
            "\u0151": 611,
            "\u0118": 667,
            "\u0111": 611,
            "\xbe": 834,
            "\u015e": 667,
            "\u013e": 400,
            "\u0136": 722,
            "\u0139": 611,
            "\u2122": 1000,
            "\u0117": 556,
            "\xcc": 278,
            "\u012a": 278,
            "\u013d": 611,
            "\xbd": 834,
            "\u2264": 549,
            "\xf4": 611,
            "\xf1": 611,
            "\u0170": 722,
            "\xc9": 667,
            "\u0113": 556,
            "\u011f": 611,
            "\xbc": 834,
            "\u0160": 667,
            "\u0218": 667,
            "\u0150": 778,
            "\xb0": 400,
            "\xf2": 611,
            "\u010c": 722,
            "\xf9": 611,
            "\u221a": 549,
            "\u010e": 722,
            "\u0157": 389,
            "\xd1": 722,
            "\xf5": 611,
            "\u0156": 722,
            "\u013b": 611,
            "\xc3": 722,
            "\u0104": 722,
            "\xc5": 722,
            "\xd5": 778,
            "\u017c": 500,
            "\u011a": 667,
            "\u012e": 278,
            "\u0137": 556,
            "\u2212": 584,
            "\xce": 278,
            "\u0148": 611,
            "\u0163": 333,
            "\xac": 584,
            "\xf6": 611,
            "\xfc": 611,
            "\u2260": 549,
            "\u0123": 611,
            "\xf0": 611,
            "\u017e": 500,
            "\u0146": 611,
            "\xb9": 333,
            "\u012b": 278,
            "\u20ac": 556,
        },
    ),
    # Generated from Helvetica-Oblique.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
    # Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Helvetica-Oblique": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Helvetica-Oblique",
            family="Helvetica",
            weight="Medium",
            ascent=718,
            descent=-207,
            cap_height=718,
            x_height=523,
            italic_angle=-12,
            flags=96,
            bbox=(-170.0, -225.0, 1116.0, 931.0),
        ),
        character_widths={
            " ": 278,
            "default": 556,
            "!": 278,
            '"': 355,
            "#": 556,
            "$": 556,
            "%": 889,
            "&": 667,
            "\u2019": 222,
            "(": 333,
            ")": 333,
            "*": 389,
            "+": 584,
            ",": 278,
            "-": 333,
            ".": 278,
            "/": 278,
            "0": 556,
            "1": 556,
            "2": 556,
            "3": 556,
            "4": 556,
            "5": 556,
            "6": 556,
            "7": 556,
            "8": 556,
            "9": 556,
            ":": 278,
            ";": 278,
            "<": 584,
            "=": 584,
            ">": 584,
            "?": 556,
            "@": 1015,
            "A": 667,
            "B": 667,
            "C": 722,
            "D": 722,
            "E": 667,
            "F": 611,
            "G": 778,
            "H": 722,
            "I": 278,
            "J": 500,
            "K": 667,
            "L": 556,
            "M": 833,
            "N": 722,
            "O": 778,
            "P": 667,
            "Q": 778,
            "R": 722,
            "S": 667,
            "T": 611,
            "U": 722,
            "V": 667,
            "W": 944,
            "X": 667,
            "Y": 667,
            "Z": 611,
            "[": 278,
            "\\": 278,
            "]": 278,
            "^": 469,
            "_": 556,
            "\u2018": 222,
            "a": 556,
            "b": 556,
            "c": 500,
            "d": 556,
            "e": 556,
            "f": 278,
            "g": 556,
            "h": 556,
            "i": 222,
            "j": 222,
            "k": 500,
            "l": 222,
            "m": 833,
            "n": 556,
            "o": 556,
            "p": 556,
            "q": 556,
            "r": 333,
            "s": 500,
            "t": 278,
            "u": 556,
            "v": 500,
            "w": 722,
            "x": 500,
            "y": 500,
            "z": 500,
            "{": 334,
            "|": 260,
            "}": 334,
            "~": 584,
            "\xa1": 333,
            "\xa2": 556,
            "\xa3": 556,
            "\u2044": 167,
            "\xa5": 556,
            "\u0192": 556,
            "\xa7": 556,
            "\xa4": 556,
            "'": 191,
            "\u201c": 333,
            "\xab": 556,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 500,
            "\ufb02": 500,
            "\u2013": 556,
            "\u2020": 556,
            "\u2021": 556,
            "\xb7": 278,
            "\xb6": 537,
            "\u2022": 350,
            "\u201a": 222,
            "\u201e": 333,
            "\u201d": 333,
            "\xbb": 556,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 611,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 1000,
            "\xaa": 370,
            "\u0141": 556,
            "\xd8": 778,
            "\u0152": 1000,
            "\xba": 365,
            "\xe6": 889,
            "\u0131": 278,
            "\u0142": 222,
            "\xf8": 611,
            "\u0153": 944,
            "\xdf": 611,
            "\xcf": 278,
            "\xe9": 556,
            "\u0103": 556,
            "\u0171": 556,
            "\u011b": 556,
            "\u0178": 667,
            "\xf7": 584,
            "\xdd": 667,
            "\xc2": 667,
            "\xe1": 556,
            "\xdb": 722,
            "\xfd": 500,
            "\u0219": 500,
            "\xea": 556,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 556,
            "\xda": 722,
            "\u0173": 556,
            "\xcb": 667,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 737,
            "\u0112": 667,
            "\u010d": 500,
            "\xe5": 556,
            "\u0145": 722,
            "\u013a": 222,
            "\xe0": 556,
            "\u0162": 611,
            "\u0106": 722,
            "\xe3": 556,
            "\u0116": 667,
            "\u0161": 500,
            "\u015f": 500,
            "\xed": 278,
            "\u25ca": 471,
            "\u0158": 722,
            "\u0122": 778,
            "\xfb": 556,
            "\xe2": 556,
            "\u0100": 667,
            "\u0159": 333,
            "\xe7": 500,
            "\u017b": 611,
            "\xde": 667,
            "\u014c": 778,
            "\u0154": 722,
            "\u015a": 667,
            "\u010f": 643,
            "\u016a": 722,
            "\u016f": 556,
            "\xb3": 333,
            "\xd2": 778,
            "\xc0": 667,
            "\u0102": 667,
            "\xd7": 584,
            "\xfa": 556,
            "\u0164": 611,
            "\u2202": 476,
            "\xff": 500,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 667,
            "\xe4": 556,
            "\xeb": 556,
            "\u0107": 500,
            "\u0144": 556,
            "\u016b": 556,
            "\u0147": 722,
            "\xcd": 278,
            "\xb1": 584,
            "\xa6": 260,
            "\xae": 737,
            "\u011e": 778,
            "\u0130": 278,
            "\u2211": 600,
            "\xc8": 667,
            "\u0155": 333,
            "\u014d": 556,
            "\u0179": 611,
            "\u017d": 611,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 722,
            "\u013c": 222,
            "\u0165": 317,
            "\u0119": 556,
            "\u0172": 722,
            "\xc1": 667,
            "\xc4": 667,
            "\xe8": 556,
            "\u017a": 500,
            "\u012f": 222,
            "\xd3": 778,
            "\xf3": 556,
            "\u0101": 556,
            "\u015b": 500,
            "\xef": 278,
            "\xd4": 778,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 556,
            "\xb2": 333,
            "\xd6": 778,
            "\xb5": 556,
            "\xec": 278,
            "\u0151": 556,
            "\u0118": 667,
            "\u0111": 556,
            "\xbe": 834,
            "\u015e": 667,
            "\u013e": 299,
            "\u0136": 667,
            "\u0139": 556,
            "\u2122": 1000,
            "\u0117": 556,
            "\xcc": 278,
            "\u012a": 278,
            "\u013d": 556,
            "\xbd": 834,
            "\u2264": 549,
            "\xf4": 556,
            "\xf1": 556,
            "\u0170": 722,
            "\xc9": 667,
            "\u0113": 556,
            "\u011f": 556,
            "\xbc": 834,
            "\u0160": 667,
            "\u0218": 667,
            "\u0150": 778,
            "\xb0": 400,
            "\xf2": 556,
            "\u010c": 722,
            "\xf9": 556,
            "\u221a": 453,
            "\u010e": 722,
            "\u0157": 333,
            "\xd1": 722,
            "\xf5": 556,
            "\u0156": 722,
            "\u013b": 556,
            "\xc3": 667,
            "\u0104": 667,
            "\xc5": 667,
            "\xd5": 778,
            "\u017c": 500,
            "\u011a": 667,
            "\u012e": 278,
            "\u0137": 500,
            "\u2212": 584,
            "\xce": 278,
            "\u0148": 556,
            "\u0163": 278,
            "\xac": 584,
            "\xf6": 556,
            "\xfc": 556,
            "\u2260": 549,
            "\u0123": 556,
            "\xf0": 556,
            "\u017e": 500,
            "\u0146": 556,
            "\xb9": 333,
            "\u012b": 278,
            "\u20ac": 556,
        },
    ),
    # Generated from Symbol.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated. All rights reserved.
    "Symbol": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Symbol",
            family="Symbol",
            weight="Medium",
            ascent=0.0,
            descent=0.0,
            cap_height=0.0,
            x_height=0.0,
            italic_angle=0,
            flags=4,
            bbox=(-180.0, -293.0, 1090.0, 1010.0),
        ),
        character_widths={
            " ": 250,
            "default": 500,
            "!": 333,
            "\u2200": 713,
            "#": 500,
            "\u2203": 549,
            "%": 833,
            "&": 778,
            "\u220b": 439,
            "(": 333,
            ")": 333,
            "\u2217": 500,
            "+": 549,
            ",": 250,
            "\u2212": 549,
            ".": 250,
            "/": 278,
            "0": 500,
            "1": 500,
            "2": 500,
            "3": 500,
            "4": 500,
            "5": 500,
            "6": 500,
            "7": 500,
            "8": 500,
            "9": 500,
            ":": 278,
            ";": 278,
            "<": 549,
            "=": 549,
            ">": 549,
            "?": 444,
            "\u2245": 549,
            "\u0391": 722,
            "\u0392": 667,
            "\u03a7": 722,
            "\u2206": 612,
            "\u0395": 611,
            "\u03a6": 763,
            "\u0393": 603,
            "\u0397": 722,
            "\u0399": 333,
            "\u03d1": 631,
            "\u039a": 722,
            "\u039b": 686,
            "\u039c": 889,
            "\u039d": 722,
            "\u039f": 722,
            "\u03a0": 768,
            "\u0398": 741,
            "\u03a1": 556,
            "\u03a3": 592,
            "\u03a4": 611,
            "\u03a5": 690,
            "\u03c2": 439,
            "\u2126": 768,
            "\u039e": 645,
            "\u03a8": 795,
            "\u0396": 611,
            "[": 333,
            "\u2234": 863,
            "]": 333,
            "\u22a5": 658,
            "_": 500,
            "\uf8e5": 500,
            "\u03b1": 631,
            "\u03b2": 549,
            "\u03c7": 549,
            "\u03b4": 494,
            "\u03b5": 439,
            "\u03c6": 521,
            "\u03b3": 411,
            "\u03b7": 603,
            "\u03b9": 329,
            "\u03d5": 603,
            "\u03ba": 549,
            "\u03bb": 549,
            "\xb5": 576,
            "\u03bd": 521,
            "\u03bf": 549,
            "\u03c0": 549,
            "\u03b8": 521,
            "\u03c1": 549,
            "\u03c3": 603,
            "\u03c4": 439,
            "\u03c5": 576,
            "\u03d6": 713,
            "\u03c9": 686,
            "\u03be": 493,
            "\u03c8": 686,
            "\u03b6": 494,
            "{": 480,
            "|": 200,
            "}": 480,
            "\u223c": 549,
            "\u20ac": 750,
            "\u03d2": 620,
            "\u2032": 247,
            "\u2264": 549,
            "\u2044": 167,
            "\u221e": 713,
            "\u0192": 500,
            "\u2663": 753,
            "\u2666": 753,
            "\u2665": 753,
            "\u2660": 753,
            "\u2194": 1042,
            "\u2190": 987,
            "\u2191": 603,
            "\u2192": 987,
            "\u2193": 603,
            "\xb0": 400,
            "\xb1": 549,
            "\u2033": 411,
            "\u2265": 549,
            "\xd7": 549,
            "\u221d": 713,
            "\u2202": 494,
            "\u2022": 460,
            "\xf7": 549,
            "\u2260": 549,
            "\u2261": 549,
            "\u2248": 549,
            "\u2026": 1000,
            "\uf8e6": 603,
            "\uf8e7": 1000,
            "\u21b5": 658,
            "\u2135": 823,
            "\u2111": 686,
            "\u211c": 795,
            "\u2118": 987,
            "\u2297": 768,
            "\u2295": 768,
            "\u2205": 823,
            "\u2229": 768,
            "\u222a": 768,
            "\u2283": 713,
            "\u2287": 713,
            "\u2284": 713,
            "\u2282": 713,
            "\u2286": 713,
            "\u2208": 713,
            "\u2209": 713,
            "\u2220": 768,
            "\u2207": 713,
            "\uf6da": 790,
            "\uf6d9": 790,
            "\uf6db": 890,
            "\u220f": 823,
            "\u221a": 549,
            "\u22c5": 250,
            "\xac": 713,
            "\u2227": 603,
            "\u2228": 603,
            "\u21d4": 1042,
            "\u21d0": 987,
            "\u21d1": 603,
            "\u21d2": 987,
            "\u21d3": 603,
            "\u25ca": 494,
            "\u2329": 329,
            "\uf8e8": 790,
            "\uf8e9": 790,
            "\uf8ea": 786,
            "\u2211": 713,
            "\uf8eb": 384,
            "\uf8ec": 384,
            "\uf8ed": 384,
            "\uf8ee": 384,
            "\uf8ef": 384,
            "\uf8f0": 384,
            "\uf8f1": 494,
            "\uf8f2": 494,
            "\uf8f3": 494,
            "\uf8f4": 494,
            "\u232a": 329,
            "\u222b": 274,
            "\u2320": 686,
            "\uf8f5": 686,
            "\u2321": 686,
            "\uf8f6": 384,
            "\uf8f7": 384,
            "\uf8f8": 384,
            "\uf8f9": 384,
            "\uf8fa": 384,
            "\uf8fb": 384,
            "\uf8fc": 494,
            "\uf8fd": 494,
            "\uf8fe": 494,
            "\uf8ff": 790,
        },
    ),
    # Generated from Times-Bold.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights
    # Reserved.  Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Times-Bold": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Times-Bold",
            family="Times",
            weight="Bold",
            ascent=683,
            descent=-217,
            cap_height=676,
            x_height=461,
            italic_angle=0,
            flags=34,
            bbox=(-168.0, -218.0, 1000.0, 935.0),
        ),
        character_widths={
            " ": 250,
            "default": 500,
            "!": 333,
            '"': 555,
            "#": 500,
            "$": 500,
            "%": 1000,
            "&": 833,
            "\u2019": 333,
            "(": 333,
            ")": 333,
            "*": 500,
            "+": 570,
            ",": 250,
            "-": 333,
            ".": 250,
            "/": 278,
            "0": 500,
            "1": 500,
            "2": 500,
            "3": 500,
            "4": 500,
            "5": 500,
            "6": 500,
            "7": 500,
            "8": 500,
            "9": 500,
            ":": 333,
            ";": 333,
            "<": 570,
            "=": 570,
            ">": 570,
            "?": 500,
            "@": 930,
            "A": 722,
            "B": 667,
            "C": 722,
            "D": 722,
            "E": 667,
            "F": 611,
            "G": 778,
            "H": 778,
            "I": 389,
            "J": 500,
            "K": 778,
            "L": 667,
            "M": 944,
            "N": 722,
            "O": 778,
            "P": 611,
            "Q": 778,
            "R": 722,
            "S": 556,
            "T": 667,
            "U": 722,
            "V": 722,
            "W": 1000,
            "X": 722,
            "Y": 722,
            "Z": 667,
            "[": 333,
            "\\": 278,
            "]": 333,
            "^": 581,
            "_": 500,
            "\u2018": 333,
            "a": 500,
            "b": 556,
            "c": 444,
            "d": 556,
            "e": 444,
            "f": 333,
            "g": 500,
            "h": 556,
            "i": 278,
            "j": 333,
            "k": 556,
            "l": 278,
            "m": 833,
            "n": 556,
            "o": 500,
            "p": 556,
            "q": 556,
            "r": 444,
            "s": 389,
            "t": 333,
            "u": 556,
            "v": 500,
            "w": 722,
            "x": 500,
            "y": 500,
            "z": 444,
            "{": 394,
            "|": 220,
            "}": 394,
            "~": 520,
            "\xa1": 333,
            "\xa2": 500,
            "\xa3": 500,
            "\u2044": 167,
            "\xa5": 500,
            "\u0192": 500,
            "\xa7": 500,
            "\xa4": 500,
            "'": 278,
            "\u201c": 500,
            "\xab": 500,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 556,
            "\ufb02": 556,
            "\u2013": 500,
            "\u2020": 500,
            "\u2021": 500,
            "\xb7": 250,
            "\xb6": 540,
            "\u2022": 350,
            "\u201a": 333,
            "\u201e": 500,
            "\u201d": 500,
            "\xbb": 500,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 500,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 1000,
            "\xaa": 300,
            "\u0141": 667,
            "\xd8": 778,
            "\u0152": 1000,
            "\xba": 330,
            "\xe6": 722,
            "\u0131": 278,
            "\u0142": 278,
            "\xf8": 500,
            "\u0153": 722,
            "\xdf": 556,
            "\xcf": 389,
            "\xe9": 444,
            "\u0103": 500,
            "\u0171": 556,
            "\u011b": 444,
            "\u0178": 722,
            "\xf7": 570,
            "\xdd": 722,
            "\xc2": 722,
            "\xe1": 500,
            "\xdb": 722,
            "\xfd": 500,
            "\u0219": 389,
            "\xea": 444,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 500,
            "\xda": 722,
            "\u0173": 556,
            "\xcb": 667,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 747,
            "\u0112": 667,
            "\u010d": 444,
            "\xe5": 500,
            "\u0145": 722,
            "\u013a": 278,
            "\xe0": 500,
            "\u0162": 667,
            "\u0106": 722,
            "\xe3": 500,
            "\u0116": 667,
            "\u0161": 389,
            "\u015f": 389,
            "\xed": 278,
            "\u25ca": 494,
            "\u0158": 722,
            "\u0122": 778,
            "\xfb": 556,
            "\xe2": 500,
            "\u0100": 722,
            "\u0159": 444,
            "\xe7": 444,
            "\u017b": 667,
            "\xde": 611,
            "\u014c": 778,
            "\u0154": 722,
            "\u015a": 556,
            "\u010f": 672,
            "\u016a": 722,
            "\u016f": 556,
            "\xb3": 300,
            "\xd2": 778,
            "\xc0": 722,
            "\u0102": 722,
            "\xd7": 570,
            "\xfa": 556,
            "\u0164": 667,
            "\u2202": 494,
            "\xff": 500,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 667,
            "\xe4": 500,
            "\xeb": 444,
            "\u0107": 444,
            "\u0144": 556,
            "\u016b": 556,
            "\u0147": 722,
            "\xcd": 389,
            "\xb1": 570,
            "\xa6": 220,
            "\xae": 747,
            "\u011e": 778,
            "\u0130": 389,
            "\u2211": 600,
            "\xc8": 667,
            "\u0155": 444,
            "\u014d": 500,
            "\u0179": 667,
            "\u017d": 667,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 722,
            "\u013c": 278,
            "\u0165": 416,
            "\u0119": 444,
            "\u0172": 722,
            "\xc1": 722,
            "\xc4": 722,
            "\xe8": 444,
            "\u017a": 444,
            "\u012f": 278,
            "\xd3": 778,
            "\xf3": 500,
            "\u0101": 500,
            "\u015b": 389,
            "\xef": 278,
            "\xd4": 778,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 556,
            "\xb2": 300,
            "\xd6": 778,
            "\xb5": 556,
            "\xec": 278,
            "\u0151": 500,
            "\u0118": 667,
            "\u0111": 556,
            "\xbe": 750,
            "\u015e": 556,
            "\u013e": 394,
            "\u0136": 778,
            "\u0139": 667,
            "\u2122": 1000,
            "\u0117": 444,
            "\xcc": 389,
            "\u012a": 389,
            "\u013d": 667,
            "\xbd": 750,
            "\u2264": 549,
            "\xf4": 500,
            "\xf1": 556,
            "\u0170": 722,
            "\xc9": 667,
            "\u0113": 444,
            "\u011f": 500,
            "\xbc": 750,
            "\u0160": 556,
            "\u0218": 556,
            "\u0150": 778,
            "\xb0": 400,
            "\xf2": 500,
            "\u010c": 722,
            "\xf9": 556,
            "\u221a": 549,
            "\u010e": 722,
            "\u0157": 444,
            "\xd1": 722,
            "\xf5": 500,
            "\u0156": 722,
            "\u013b": 667,
            "\xc3": 722,
            "\u0104": 722,
            "\xc5": 722,
            "\xd5": 778,
            "\u017c": 444,
            "\u011a": 667,
            "\u012e": 389,
            "\u0137": 556,
            "\u2212": 570,
            "\xce": 389,
            "\u0148": 556,
            "\u0163": 333,
            "\xac": 570,
            "\xf6": 500,
            "\xfc": 556,
            "\u2260": 549,
            "\u0123": 500,
            "\xf0": 500,
            "\u017e": 444,
            "\u0146": 556,
            "\xb9": 300,
            "\u012b": 278,
            "\u20ac": 500,
        },
    ),
    # Generated from Times-BoldItalic.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights
    # Reserved.  Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Times-BoldItalic": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Times-BoldItalic",
            family="Times",
            weight="Bold",
            ascent=683,
            descent=-217,
            cap_height=669,
            x_height=462,
            italic_angle=-15,
            flags=98,
            bbox=(-200.0, -218.0, 996.0, 921.0),
        ),
        character_widths={
            " ": 250,
            "default": 500,
            "!": 389,
            '"': 555,
            "#": 500,
            "$": 500,
            "%": 833,
            "&": 778,
            "\u2019": 333,
            "(": 333,
            ")": 333,
            "*": 500,
            "+": 570,
            ",": 250,
            "-": 333,
            ".": 250,
            "/": 278,
            "0": 500,
            "1": 500,
            "2": 500,
            "3": 500,
            "4": 500,
            "5": 500,
            "6": 500,
            "7": 500,
            "8": 500,
            "9": 500,
            ":": 333,
            ";": 333,
            "<": 570,
            "=": 570,
            ">": 570,
            "?": 500,
            "@": 832,
            "A": 667,
            "B": 667,
            "C": 667,
            "D": 722,
            "E": 667,
            "F": 667,
            "G": 722,
            "H": 778,
            "I": 389,
            "J": 500,
            "K": 667,
            "L": 611,
            "M": 889,
            "N": 722,
            "O": 722,
            "P": 611,
            "Q": 722,
            "R": 667,
            "S": 556,
            "T": 611,
            "U": 722,
            "V": 667,
            "W": 889,
            "X": 667,
            "Y": 611,
            "Z": 611,
            "[": 333,
            "\\": 278,
            "]": 333,
            "^": 570,
            "_": 500,
            "\u2018": 333,
            "a": 500,
            "b": 500,
            "c": 444,
            "d": 500,
            "e": 444,
            "f": 333,
            "g": 500,
            "h": 556,
            "i": 278,
            "j": 278,
            "k": 500,
            "l": 278,
            "m": 778,
            "n": 556,
            "o": 500,
            "p": 500,
            "q": 500,
            "r": 389,
            "s": 389,
            "t": 278,
            "u": 556,
            "v": 444,
            "w": 667,
            "x": 500,
            "y": 444,
            "z": 389,
            "{": 348,
            "|": 220,
            "}": 348,
            "~": 570,
            "\xa1": 389,
            "\xa2": 500,
            "\xa3": 500,
            "\u2044": 167,
            "\xa5": 500,
            "\u0192": 500,
            "\xa7": 500,
            "\xa4": 500,
            "'": 278,
            "\u201c": 500,
            "\xab": 500,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 556,
            "\ufb02": 556,
            "\u2013": 500,
            "\u2020": 500,
            "\u2021": 500,
            "\xb7": 250,
            "\xb6": 500,
            "\u2022": 350,
            "\u201a": 333,
            "\u201e": 500,
            "\u201d": 500,
            "\xbb": 500,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 500,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 944,
            "\xaa": 266,
            "\u0141": 611,
            "\xd8": 722,
            "\u0152": 944,
            "\xba": 300,
            "\xe6": 722,
            "\u0131": 278,
            "\u0142": 278,
            "\xf8": 500,
            "\u0153": 722,
            "\xdf": 500,
            "\xcf": 389,
            "\xe9": 444,
            "\u0103": 500,
            "\u0171": 556,
            "\u011b": 444,
            "\u0178": 611,
            "\xf7": 570,
            "\xdd": 611,
            "\xc2": 667,
            "\xe1": 500,
            "\xdb": 722,
            "\xfd": 444,
            "\u0219": 389,
            "\xea": 444,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 500,
            "\xda": 722,
            "\u0173": 556,
            "\xcb": 667,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 747,
            "\u0112": 667,
            "\u010d": 444,
            "\xe5": 500,
            "\u0145": 722,
            "\u013a": 278,
            "\xe0": 500,
            "\u0162": 611,
            "\u0106": 667,
            "\xe3": 500,
            "\u0116": 667,
            "\u0161": 389,
            "\u015f": 389,
            "\xed": 278,
            "\u25ca": 494,
            "\u0158": 667,
            "\u0122": 722,
            "\xfb": 556,
            "\xe2": 500,
            "\u0100": 667,
            "\u0159": 389,
            "\xe7": 444,
            "\u017b": 611,
            "\xde": 611,
            "\u014c": 722,
            "\u0154": 667,
            "\u015a": 556,
            "\u010f": 608,
            "\u016a": 722,
            "\u016f": 556,
            "\xb3": 300,
            "\xd2": 722,
            "\xc0": 667,
            "\u0102": 667,
            "\xd7": 570,
            "\xfa": 556,
            "\u0164": 611,
            "\u2202": 494,
            "\xff": 444,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 667,
            "\xe4": 500,
            "\xeb": 444,
            "\u0107": 444,
            "\u0144": 556,
            "\u016b": 556,
            "\u0147": 722,
            "\xcd": 389,
            "\xb1": 570,
            "\xa6": 220,
            "\xae": 747,
            "\u011e": 722,
            "\u0130": 389,
            "\u2211": 600,
            "\xc8": 667,
            "\u0155": 389,
            "\u014d": 500,
            "\u0179": 611,
            "\u017d": 611,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 667,
            "\u013c": 278,
            "\u0165": 366,
            "\u0119": 444,
            "\u0172": 722,
            "\xc1": 667,
            "\xc4": 667,
            "\xe8": 444,
            "\u017a": 389,
            "\u012f": 278,
            "\xd3": 722,
            "\xf3": 500,
            "\u0101": 500,
            "\u015b": 389,
            "\xef": 278,
            "\xd4": 722,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 500,
            "\xb2": 300,
            "\xd6": 722,
            "\xb5": 576,
            "\xec": 278,
            "\u0151": 500,
            "\u0118": 667,
            "\u0111": 500,
            "\xbe": 750,
            "\u015e": 556,
            "\u013e": 382,
            "\u0136": 667,
            "\u0139": 611,
            "\u2122": 1000,
            "\u0117": 444,
            "\xcc": 389,
            "\u012a": 389,
            "\u013d": 611,
            "\xbd": 750,
            "\u2264": 549,
            "\xf4": 500,
            "\xf1": 556,
            "\u0170": 722,
            "\xc9": 667,
            "\u0113": 444,
            "\u011f": 500,
            "\xbc": 750,
            "\u0160": 556,
            "\u0218": 556,
            "\u0150": 722,
            "\xb0": 400,
            "\xf2": 500,
            "\u010c": 667,
            "\xf9": 556,
            "\u221a": 549,
            "\u010e": 722,
            "\u0157": 389,
            "\xd1": 722,
            "\xf5": 500,
            "\u0156": 667,
            "\u013b": 611,
            "\xc3": 667,
            "\u0104": 667,
            "\xc5": 667,
            "\xd5": 722,
            "\u017c": 389,
            "\u011a": 667,
            "\u012e": 389,
            "\u0137": 500,
            "\u2212": 606,
            "\xce": 389,
            "\u0148": 556,
            "\u0163": 278,
            "\xac": 606,
            "\xf6": 500,
            "\xfc": 556,
            "\u2260": 549,
            "\u0123": 500,
            "\xf0": 500,
            "\u017e": 389,
            "\u0146": 556,
            "\xb9": 300,
            "\u012b": 278,
            "\u20ac": 500,
        },
    ),
    # Generated from Times-Italic.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights
    # Reserved.  Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Times-Italic": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Times-Italic",
            family="Times",
            weight="Medium",
            ascent=683,
            descent=-217,
            cap_height=653,
            x_height=441,
            italic_angle=-15.5,
            flags=98,
            bbox=(-169.0, -217.0, 1010.0, 883.0),
        ),
        character_widths={
            " ": 250,
            "default": 500,
            "!": 333,
            '"': 420,
            "#": 500,
            "$": 500,
            "%": 833,
            "&": 778,
            "\u2019": 333,
            "(": 333,
            ")": 333,
            "*": 500,
            "+": 675,
            ",": 250,
            "-": 333,
            ".": 250,
            "/": 278,
            "0": 500,
            "1": 500,
            "2": 500,
            "3": 500,
            "4": 500,
            "5": 500,
            "6": 500,
            "7": 500,
            "8": 500,
            "9": 500,
            ":": 333,
            ";": 333,
            "<": 675,
            "=": 675,
            ">": 675,
            "?": 500,
            "@": 920,
            "A": 611,
            "B": 611,
            "C": 667,
            "D": 722,
            "E": 611,
            "F": 611,
            "G": 722,
            "H": 722,
            "I": 333,
            "J": 444,
            "K": 667,
            "L": 556,
            "M": 833,
            "N": 667,
            "O": 722,
            "P": 611,
            "Q": 722,
            "R": 611,
            "S": 500,
            "T": 556,
            "U": 722,
            "V": 611,
            "W": 833,
            "X": 611,
            "Y": 556,
            "Z": 556,
            "[": 389,
            "\\": 278,
            "]": 389,
            "^": 422,
            "_": 500,
            "\u2018": 333,
            "a": 500,
            "b": 500,
            "c": 444,
            "d": 500,
            "e": 444,
            "f": 278,
            "g": 500,
            "h": 500,
            "i": 278,
            "j": 278,
            "k": 444,
            "l": 278,
            "m": 722,
            "n": 500,
            "o": 500,
            "p": 500,
            "q": 500,
            "r": 389,
            "s": 389,
            "t": 278,
            "u": 500,
            "v": 444,
            "w": 667,
            "x": 444,
            "y": 444,
            "z": 389,
            "{": 400,
            "|": 275,
            "}": 400,
            "~": 541,
            "\xa1": 389,
            "\xa2": 500,
            "\xa3": 500,
            "\u2044": 167,
            "\xa5": 500,
            "\u0192": 500,
            "\xa7": 500,
            "\xa4": 500,
            "'": 214,
            "\u201c": 556,
            "\xab": 500,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 500,
            "\ufb02": 500,
            "\u2013": 500,
            "\u2020": 500,
            "\u2021": 500,
            "\xb7": 250,
            "\xb6": 523,
            "\u2022": 350,
            "\u201a": 333,
            "\u201e": 556,
            "\u201d": 556,
            "\xbb": 500,
            "\u2026": 889,
            "\u2030": 1000,
            "\xbf": 500,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 889,
            "\xc6": 889,
            "\xaa": 276,
            "\u0141": 556,
            "\xd8": 722,
            "\u0152": 944,
            "\xba": 310,
            "\xe6": 667,
            "\u0131": 278,
            "\u0142": 278,
            "\xf8": 500,
            "\u0153": 667,
            "\xdf": 500,
            "\xcf": 333,
            "\xe9": 444,
            "\u0103": 500,
            "\u0171": 500,
            "\u011b": 444,
            "\u0178": 556,
            "\xf7": 675,
            "\xdd": 556,
            "\xc2": 611,
            "\xe1": 500,
            "\xdb": 722,
            "\xfd": 444,
            "\u0219": 389,
            "\xea": 444,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 500,
            "\xda": 722,
            "\u0173": 500,
            "\xcb": 611,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 760,
            "\u0112": 611,
            "\u010d": 444,
            "\xe5": 500,
            "\u0145": 667,
            "\u013a": 278,
            "\xe0": 500,
            "\u0162": 556,
            "\u0106": 667,
            "\xe3": 500,
            "\u0116": 611,
            "\u0161": 389,
            "\u015f": 389,
            "\xed": 278,
            "\u25ca": 471,
            "\u0158": 611,
            "\u0122": 722,
            "\xfb": 500,
            "\xe2": 500,
            "\u0100": 611,
            "\u0159": 389,
            "\xe7": 444,
            "\u017b": 556,
            "\xde": 611,
            "\u014c": 722,
            "\u0154": 611,
            "\u015a": 500,
            "\u010f": 544,
            "\u016a": 722,
            "\u016f": 500,
            "\xb3": 300,
            "\xd2": 722,
            "\xc0": 611,
            "\u0102": 611,
            "\xd7": 675,
            "\xfa": 500,
            "\u0164": 556,
            "\u2202": 476,
            "\xff": 444,
            "\u0143": 667,
            "\xee": 278,
            "\xca": 611,
            "\xe4": 500,
            "\xeb": 444,
            "\u0107": 444,
            "\u0144": 500,
            "\u016b": 500,
            "\u0147": 667,
            "\xcd": 333,
            "\xb1": 675,
            "\xa6": 275,
            "\xae": 760,
            "\u011e": 722,
            "\u0130": 333,
            "\u2211": 600,
            "\xc8": 611,
            "\u0155": 389,
            "\u014d": 500,
            "\u0179": 556,
            "\u017d": 556,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 667,
            "\u013c": 278,
            "\u0165": 300,
            "\u0119": 444,
            "\u0172": 722,
            "\xc1": 611,
            "\xc4": 611,
            "\xe8": 444,
            "\u017a": 389,
            "\u012f": 278,
            "\xd3": 722,
            "\xf3": 500,
            "\u0101": 500,
            "\u015b": 389,
            "\xef": 278,
            "\xd4": 722,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 500,
            "\xb2": 300,
            "\xd6": 722,
            "\xb5": 500,
            "\xec": 278,
            "\u0151": 500,
            "\u0118": 611,
            "\u0111": 500,
            "\xbe": 750,
            "\u015e": 500,
            "\u013e": 300,
            "\u0136": 667,
            "\u0139": 556,
            "\u2122": 980,
            "\u0117": 444,
            "\xcc": 333,
            "\u012a": 333,
            "\u013d": 611,
            "\xbd": 750,
            "\u2264": 549,
            "\xf4": 500,
            "\xf1": 500,
            "\u0170": 722,
            "\xc9": 611,
            "\u0113": 444,
            "\u011f": 500,
            "\xbc": 750,
            "\u0160": 500,
            "\u0218": 500,
            "\u0150": 722,
            "\xb0": 400,
            "\xf2": 500,
            "\u010c": 667,
            "\xf9": 500,
            "\u221a": 453,
            "\u010e": 722,
            "\u0157": 389,
            "\xd1": 667,
            "\xf5": 500,
            "\u0156": 611,
            "\u013b": 556,
            "\xc3": 611,
            "\u0104": 611,
            "\xc5": 611,
            "\xd5": 722,
            "\u017c": 389,
            "\u011a": 611,
            "\u012e": 333,
            "\u0137": 444,
            "\u2212": 675,
            "\xce": 333,
            "\u0148": 500,
            "\u0163": 278,
            "\xac": 675,
            "\xf6": 500,
            "\xfc": 500,
            "\u2260": 549,
            "\u0123": 500,
            "\xf0": 500,
            "\u017e": 389,
            "\u0146": 500,
            "\xb9": 300,
            "\u012b": 278,
            "\u20ac": 500,
        },
    ),
    # Generated from Times-Roman.afm
    # Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights
    # Reserved.  Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
    "Times-Roman": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="Times-Roman",
            family="Times",
            weight="Roman",
            ascent=683,
            descent=-217,
            cap_height=662,
            x_height=450,
            italic_angle=0,
            flags=34,
            bbox=(-168.0, -218.0, 1000.0, 898.0),
        ),
        character_widths={
            " ": 250,
            "default": 500,
            "!": 333,
            '"': 408,
            "#": 500,
            "$": 500,
            "%": 833,
            "&": 778,
            "\u2019": 333,
            "(": 333,
            ")": 333,
            "*": 500,
            "+": 564,
            ",": 250,
            "-": 333,
            ".": 250,
            "/": 278,
            "0": 500,
            "1": 500,
            "2": 500,
            "3": 500,
            "4": 500,
            "5": 500,
            "6": 500,
            "7": 500,
            "8": 500,
            "9": 500,
            ":": 278,
            ";": 278,
            "<": 564,
            "=": 564,
            ">": 564,
            "?": 444,
            "@": 921,
            "A": 722,
            "B": 667,
            "C": 667,
            "D": 722,
            "E": 611,
            "F": 556,
            "G": 722,
            "H": 722,
            "I": 333,
            "J": 389,
            "K": 722,
            "L": 611,
            "M": 889,
            "N": 722,
            "O": 722,
            "P": 556,
            "Q": 722,
            "R": 667,
            "S": 556,
            "T": 611,
            "U": 722,
            "V": 722,
            "W": 944,
            "X": 722,
            "Y": 722,
            "Z": 611,
            "[": 333,
            "\\": 278,
            "]": 333,
            "^": 469,
            "_": 500,
            "\u2018": 333,
            "a": 444,
            "b": 500,
            "c": 444,
            "d": 500,
            "e": 444,
            "f": 333,
            "g": 500,
            "h": 500,
            "i": 278,
            "j": 278,
            "k": 500,
            "l": 278,
            "m": 778,
            "n": 500,
            "o": 500,
            "p": 500,
            "q": 500,
            "r": 333,
            "s": 389,
            "t": 278,
            "u": 500,
            "v": 500,
            "w": 722,
            "x": 500,
            "y": 500,
            "z": 444,
            "{": 480,
            "|": 200,
            "}": 480,
            "~": 541,
            "\xa1": 333,
            "\xa2": 500,
            "\xa3": 500,
            "\u2044": 167,
            "\xa5": 500,
            "\u0192": 500,
            "\xa7": 500,
            "\xa4": 500,
            "'": 180,
            "\u201c": 444,
            "\xab": 500,
            "\u2039": 333,
            "\u203a": 333,
            "\ufb01": 556,
            "\ufb02": 556,
            "\u2013": 500,
            "\u2020": 500,
            "\u2021": 500,
            "\xb7": 250,
            "\xb6": 453,
            "\u2022": 350,
            "\u201a": 333,
            "\u201e": 444,
            "\u201d": 444,
            "\xbb": 500,
            "\u2026": 1000,
            "\u2030": 1000,
            "\xbf": 444,
            "`": 333,
            "\xb4": 333,
            "\u02c6": 333,
            "\u02dc": 333,
            "\xaf": 333,
            "\u02d8": 333,
            "\u02d9": 333,
            "\xa8": 333,
            "\u02da": 333,
            "\xb8": 333,
            "\u02dd": 333,
            "\u02db": 333,
            "\u02c7": 333,
            "\u2014": 1000,
            "\xc6": 889,
            "\xaa": 276,
            "\u0141": 611,
            "\xd8": 722,
            "\u0152": 889,
            "\xba": 310,
            "\xe6": 667,
            "\u0131": 278,
            "\u0142": 278,
            "\xf8": 500,
            "\u0153": 722,
            "\xdf": 500,
            "\xcf": 333,
            "\xe9": 444,
            "\u0103": 444,
            "\u0171": 500,
            "\u011b": 444,
            "\u0178": 722,
            "\xf7": 564,
            "\xdd": 722,
            "\xc2": 722,
            "\xe1": 444,
            "\xdb": 722,
            "\xfd": 500,
            "\u0219": 389,
            "\xea": 444,
            "\u016e": 722,
            "\xdc": 722,
            "\u0105": 444,
            "\xda": 722,
            "\u0173": 500,
            "\xcb": 611,
            "\u0110": 722,
            "\uf6c3": 250,
            "\xa9": 760,
            "\u0112": 611,
            "\u010d": 444,
            "\xe5": 444,
            "\u0145": 722,
            "\u013a": 278,
            "\xe0": 444,
            "\u0162": 611,
            "\u0106": 667,
            "\xe3": 444,
            "\u0116": 611,
            "\u0161": 389,
            "\u015f": 389,
            "\xed": 278,
            "\u25ca": 471,
            "\u0158": 667,
            "\u0122": 722,
            "\xfb": 500,
            "\xe2": 444,
            "\u0100": 722,
            "\u0159": 333,
            "\xe7": 444,
            "\u017b": 611,
            "\xde": 556,
            "\u014c": 722,
            "\u0154": 667,
            "\u015a": 556,
            "\u010f": 588,
            "\u016a": 722,
            "\u016f": 500,
            "\xb3": 300,
            "\xd2": 722,
            "\xc0": 722,
            "\u0102": 722,
            "\xd7": 564,
            "\xfa": 500,
            "\u0164": 611,
            "\u2202": 476,
            "\xff": 500,
            "\u0143": 722,
            "\xee": 278,
            "\xca": 611,
            "\xe4": 444,
            "\xeb": 444,
            "\u0107": 444,
            "\u0144": 500,
            "\u016b": 500,
            "\u0147": 722,
            "\xcd": 333,
            "\xb1": 564,
            "\xa6": 200,
            "\xae": 760,
            "\u011e": 722,
            "\u0130": 333,
            "\u2211": 600,
            "\xc8": 611,
            "\u0155": 333,
            "\u014d": 500,
            "\u0179": 611,
            "\u017d": 611,
            "\u2265": 549,
            "\xd0": 722,
            "\xc7": 667,
            "\u013c": 278,
            "\u0165": 326,
            "\u0119": 444,
            "\u0172": 722,
            "\xc1": 722,
            "\xc4": 722,
            "\xe8": 444,
            "\u017a": 444,
            "\u012f": 278,
            "\xd3": 722,
            "\xf3": 500,
            "\u0101": 444,
            "\u015b": 389,
            "\xef": 278,
            "\xd4": 722,
            "\xd9": 722,
            "\u2206": 612,
            "\xfe": 500,
            "\xb2": 300,
            "\xd6": 722,
            "\xb5": 500,
            "\xec": 278,
            "\u0151": 500,
            "\u0118": 611,
            "\u0111": 500,
            "\xbe": 750,
            "\u015e": 556,
            "\u013e": 344,
            "\u0136": 722,
            "\u0139": 611,
            "\u2122": 980,
            "\u0117": 444,
            "\xcc": 333,
            "\u012a": 333,
            "\u013d": 611,
            "\xbd": 750,
            "\u2264": 549,
            "\xf4": 500,
            "\xf1": 500,
            "\u0170": 722,
            "\xc9": 611,
            "\u0113": 444,
            "\u011f": 500,
            "\xbc": 750,
            "\u0160": 556,
            "\u0218": 556,
            "\u0150": 722,
            "\xb0": 400,
            "\xf2": 500,
            "\u010c": 667,
            "\xf9": 500,
            "\u221a": 453,
            "\u010e": 722,
            "\u0157": 333,
            "\xd1": 722,
            "\xf5": 500,
            "\u0156": 667,
            "\u013b": 611,
            "\xc3": 722,
            "\u0104": 722,
            "\xc5": 722,
            "\xd5": 722,
            "\u017c": 444,
            "\u011a": 611,
            "\u012e": 333,
            "\u0137": 500,
            "\u2212": 564,
            "\xce": 333,
            "\u0148": 500,
            "\u0163": 278,
            "\xac": 564,
            "\xf6": 500,
            "\xfc": 500,
            "\u2260": 549,
            "\u0123": 500,
            "\xf0": 500,
            "\u017e": 444,
            "\u0146": 500,
            "\xb9": 300,
            "\u012b": 278,
            "\u20ac": 500,
        },
    ),
    # Generated from ZapfDingbats.afm
    # Copyright (c) 1985, 1987, 1988, 1989, 1997 Adobe Systems Incorporated. All Rights Reserved.
    # ITC Zapf Dingbats is a registered trademark of International Typeface Corporation.
    "ZapfDingbats": CoreFontMetrics(
        font_descriptor=FontDescriptor(
            name="ZapfDingbats",
            family="ZapfDingbats",
            weight="Medium",
            ascent=0.0,
            descent=0.0,
            cap_height=0.0,
            x_height=0.0,
            italic_angle=0,
            flags=4,
            bbox=(-1.0, -143.0, 981.0, 820.0),
        ),
        character_widths={
            " ": 790,
            "default": 1580,
            "\x01": 974,
            "\x02": 961,
            "\xca": 974,
            "\x03": 980,
            "\x04": 719,
            "\x05": 789,
            "w": 790,
            "v": 791,
            "u": 690,
            "\x0b": 960,
            "\x0c": 939,
            "\r": 549,
            "\x0e": 855,
            "\x0f": 911,
            "\x10": 933,
            "i": 911,
            "\x11": 945,
            "\x12": 974,
            "\x13": 755,
            "\x14": 846,
            "\x15": 762,
            "\x16": 761,
            "\x17": 571,
            "\x18": 677,
            "\x19": 763,
            "\x1a": 760,
            "\x1b": 759,
            "\x1c": 754,
            "\x06": 494,
            "\x07": 552,
            "\x08": 537,
            "\t": 577,
            "\n": 692,
            "\x1d": 786,
            "\x1e": 788,
            "\x1f": 788,
            "!": 793,
            '"': 794,
            "#": 816,
            "$": 823,
            "%": 789,
            "&": 841,
            "'": 823,
            "(": 833,
            ")": 816,
            "*": 831,
            "+": 923,
            ",": 744,
            "-": 723,
            ".": 749,
            "/": 790,
            "0": 792,
            "1": 695,
            "2": 776,
            "3": 768,
            "4": 792,
            "5": 759,
            "6": 707,
            "7": 708,
            "8": 682,
            "9": 701,
            ":": 826,
            ";": 815,
            "<": 789,
            "=": 789,
            ">": 707,
            "?": 687,
            "@": 696,
            "A": 689,
            "B": 786,
            "C": 787,
            "D": 713,
            "E": 791,
            "F": 785,
            "G": 791,
            "H": 873,
            "I": 761,
            "J": 762,
            "\xcb": 762,
            "K": 759,
            "\xcc": 759,
            "L": 892,
            "M": 892,
            "N": 788,
            "O": 784,
            "Q": 438,
            "R": 138,
            "S": 277,
            "T": 415,
            "a": 392,
            "b": 392,
            "c": 668,
            "d": 668,
            "Y": 390,
            "Z": 390,
            "]": 317,
            "^": 317,
            "[": 276,
            "\\": 276,
            "\xcd": 509,
            "U": 509,
            "\xce": 410,
            "V": 410,
            "W": 234,
            "X": 234,
            "_": 334,
            "`": 334,
            "e": 732,
            "f": 544,
            "g": 544,
            "h": 910,
            "j": 667,
            "k": 760,
            "l": 760,
            "p": 776,
            "o": 595,
            "n": 694,
            "m": 626,
            "x": 788,
            "y": 788,
            "z": 788,
            "{": 788,
            "|": 788,
            "}": 788,
            "~": 788,
            "\x7f": 788,
            "\x80": 788,
            "\x81": 788,
            "\x82": 788,
            "\x83": 788,
            "\x84": 788,
            "\x85": 788,
            "\x86": 788,
            "\x87": 788,
            "\x88": 788,
            "\x89": 788,
            "\x8a": 788,
            "\x8b": 788,
            "\x8c": 788,
            "\x8d": 788,
            "\x8e": 788,
            "\x8f": 788,
            "\x90": 788,
            "\x91": 788,
            "\x92": 788,
            "\x93": 788,
            "\x94": 788,
            "\x95": 788,
            "\x96": 788,
            "\x97": 788,
            "\x98": 788,
            "\x99": 788,
            "\x9a": 788,
            "\x9b": 788,
            "\x9c": 788,
            "\x9d": 788,
            "\x9e": 788,
            "\x9f": 788,
            "\xa0": 894,
            "\xa1": 838,
            "\xa3": 1016,
            "\xa4": 458,
            "\xc4": 748,
            "\xa5": 924,
            "\xc0": 748,
            "\xa6": 918,
            "\xa7": 927,
            "\xa8": 928,
            "\xa9": 928,
            "\xaa": 834,
            "\xab": 873,
            "\xac": 828,
            "\xad": 924,
            "\xa2": 924,
            "\xae": 917,
            "\xaf": 930,
            "\xb0": 931,
            "\xb1": 463,
            "\xb2": 883,
            "\xb3": 836,
            "\xc1": 836,
            "\xb4": 867,
            "\xc7": 867,
            "\xb5": 696,
            "\xc8": 696,
            "\xb6": 874,
            "\xc9": 874,
            "\xb7": 760,
            "\xb8": 946,
            "\xc5": 771,
            "\xb9": 865,
            "\xc2": 771,
            "\xc6": 888,
            "\xba": 967,
            "\xc3": 888,
            "\xbb": 831,
            "\xbc": 873,
            "\xbd": 927,
            "\xbe": 970,
            "\xbf": 918,
        },
    ),
}


# Add aliases per table H.3 on pp. 1109-1110 of the PDF 1.7 reference
CORE_FONT_METRICS["Arial"] = CORE_FONT_METRICS["Helvetica"]
CORE_FONT_METRICS["Arial,Italic"] = CORE_FONT_METRICS["Helvetica-Oblique"]
CORE_FONT_METRICS["Arial,Bold"] = CORE_FONT_METRICS["Helvetica-Bold"]
CORE_FONT_METRICS["Arial,BoldItalic"] = CORE_FONT_METRICS["Helvetica-BoldOblique"]
CORE_FONT_METRICS["CourierNew"] = CORE_FONT_METRICS["Courier"]
CORE_FONT_METRICS["CourierNew,Italic"] = CORE_FONT_METRICS["Courier-Oblique"]
CORE_FONT_METRICS["CourierNew,Bold"] = CORE_FONT_METRICS["Courier-Bold"]
CORE_FONT_METRICS["CourierNew,BoldItalic"] = CORE_FONT_METRICS["Courier-BoldOblique"]
CORE_FONT_METRICS["TimesNewRoman"] = CORE_FONT_METRICS["Times-Roman"]
CORE_FONT_METRICS["TimesNewRoman,Italic"] = CORE_FONT_METRICS["Times-Italic"]
CORE_FONT_METRICS["TimesNewRoman,Bold"] = CORE_FONT_METRICS["Times-Bold"]
CORE_FONT_METRICS["TimesNewRoman,BoldItalic"] = CORE_FONT_METRICS["Times-BoldItalic"]
